/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.GenericBean;
import com.sibvisions.rad.server.ILifeCycleObject;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SessionContextImpl;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.IObjectAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.SessionContext;
import javax.rad.server.event.ISessionListener;
import javax.rad.type.bean.Bean;

public class DefaultObjectProvider
extends AbstractObjectProvider
implements ISessionListener {
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private Hashtable<String, Map> htApplicationObjects = null;
    private Hashtable<Long, Map> htSessionObjects = null;
    private IObjectAccessController oaController = null;

    protected DefaultObjectProvider(Server server) {
        super(server);
        server.getSessionManager().addSessionListener(this);
        try {
            String string = Configuration.getServerZone().getProperty("/server/objectprovider/accesscontroller");
            if (string != null) {
                this.oaController = (IObjectAccessController)Reflective.construct(string, new Object[0]);
                this.log.debug("Use ", string, " as ObjectAccessController");
            }
        }
        catch (Throwable throwable) {
            this.log.debug("Can't use configured ObjectAccessController!", throwable);
            this.oaController = null;
        }
    }

    public void sessionCreated(ISession iSession) {
    }

    public void sessionDestroyed(ISession iSession) {
        this.destroySession(iSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(ISession iSession, String string) throws Throwable {
        ISession iSession2 = iSession;
        synchronized (iSession2) {
            Map map = this.getSessionObject(iSession);
            if (string == null || string.trim().length() == 0) {
                if (map == null) {
                    throw new RuntimeException("Unknown object '" + iSession.getLifeCycleName() + "'");
                }
                return map;
            }
            ArrayUtil<String> arrayUtil = StringUtil.separateList(string, ".", true);
            Object object = map;
            StringBuilder stringBuilder = new StringBuilder();
            SessionContextImpl sessionContextImpl = (SessionContextImpl)SessionContext.getCurrentInstance();
            String string2 = sessionContextImpl.getMethodName();
            sessionContextImpl.setMethodName(null);
            IObjectAccessController iObjectAccessController = this.getObjectAccessController();
            int n = arrayUtil.size();
            for (int i = 0; i < n; ++i) {
                String string3 = arrayUtil.get(i);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(string3);
                sessionContextImpl.setObjectName(stringBuilder.toString());
                if (i == n - 1) {
                    sessionContextImpl.setMethodName(string2);
                }
                if (object == null) {
                    throw new RuntimeException("Unknown object '" + stringBuilder.toString() + "'");
                }
                try {
                    object = Reflective.call(object, StringUtil.formatMethodName("get", string3), new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (object instanceof Map) {
                        Object v = object.get(string3);
                        if (v == null && !((Map)object).containsKey(string3)) {
                            throw new RuntimeException("Unknown object '" + string3 + "'");
                        }
                        object = v;
                    }
                    throw new RuntimeException("Unknown object '" + string3 + "'", noSuchMethodException);
                }
                if (iObjectAccessController == null || iObjectAccessController.isObjectAccessAllowed(this, iSession, map, stringBuilder.toString(), object)) continue;
                throw new SecurityException("Access to '" + string3 + "' is denied!");
            }
            return object;
        }
    }

    public Object putObject(ISession iSession, String string, Object object) throws Throwable {
        if (string == null) {
            return null;
        }
        ISession iSession2 = iSession;
        synchronized (iSession2) {
            String string2;
            Object object2;
            int n = string.lastIndexOf(".");
            if (n > 0) {
                SessionContextImpl sessionContextImpl = (SessionContextImpl)SessionContext.getCurrentInstance();
                String string3 = sessionContextImpl.getMethodName();
                sessionContextImpl.setMethodName(null);
                object2 = this.getObject(iSession, string.substring(0, n));
                sessionContextImpl.setMethodName(string3);
                string2 = string.substring(n + 1);
            } else {
                object2 = this.getSessionObject(iSession);
                string2 = string;
            }
            try {
                return Reflective.call(object2, StringUtil.formatMethodName("set", string2), object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (object2 instanceof Map) {
                    return object2.put(string2, object);
                }
                throw new RuntimeException("Can't set object '" + string + "'", noSuchMethodException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ISession iSession, String string, String string2, Object ... objectArray) throws Throwable {
        Object object;
        block7: {
            object = this.getObject(iSession, string);
            try {
                if (object == null) {
                    throw new RuntimeException("The Object '" + string + "' is known but 'null' was returned!");
                }
                IObjectAccessController iObjectAccessController = this.getObjectAccessController();
                if (iObjectAccessController != null && !iObjectAccessController.isMethodInvocationAllowed(this, iSession, string, object, string2, objectArray)) {
                    throw new SecurityException("Invocation of '" + string2 + "' is not allowed!");
                }
                if (!(object instanceof GenericBean)) break block7;
                Object object2 = ((GenericBean)object).invoke(string2, objectArray);
                Object var9_9 = null;
                if (!this.getServer().getSessionManager().isAvailable(iSession)) {
                    this.destroySession(iSession);
                }
                return object2;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var9_11 = null;
                    if (this.getServer().getSessionManager().isAvailable(iSession)) break block8;
                    this.destroySession(iSession);
                }
                throw throwable;
            }
        }
        Object object3 = Reflective.call(object, string2, objectArray);
        Object var9_10 = null;
        if (!this.getServer().getSessionManager().isAvailable(iSession)) {
            this.destroySession(iSession);
        }
        return object3;
    }

    public Server getServer() {
        return (Server)super.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getSessionObject(ISession iSession) throws Exception {
        ISession iSession2 = iSession;
        synchronized (iSession2) {
            Map map = null;
            AbstractSession abstractSession = (AbstractSession)iSession;
            if (this.htSessionObjects != null) {
                map = this.htSessionObjects.get(abstractSession.getObjectId());
            }
            if (map == null) {
                map = this.initSessionObject(abstractSession);
            } else {
                this.updateSessionObject(abstractSession, map);
            }
            return map;
        }
    }

    protected Map getSessionObjectInternal(ISession iSession) {
        if (this.htSessionObjects != null) {
            return this.htSessionObjects.get(((AbstractSession)iSession).getObjectId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map initSessionObject(AbstractSession abstractSession) throws Exception {
        AbstractSession abstractSession2 = abstractSession;
        synchronized (abstractSession2) {
            if (abstractSession instanceof SubSession) {
                Object object;
                MasterSession masterSession = ((SubSession)abstractSession).getMasterSession();
                Map map = null;
                if (!AbstractSession.isIsolated(abstractSession)) {
                    object = masterSession;
                    synchronized (object) {
                        if (this.htSessionObjects != null) {
                            map = this.htSessionObjects.get(masterSession.getObjectId());
                        }
                        if (map == null) {
                            SessionContext sessionContext = masterSession.createSessionContext(null, null);
                            try {
                                map = this.initSessionObject(masterSession);
                                Object var8_9 = null;
                                sessionContext.release();
                            }
                            catch (Throwable throwable) {
                                Object var8_10 = null;
                                sessionContext.release();
                                throw throwable;
                            }
                        }
                    }
                }
                object = this.createInstance(null, abstractSession, abstractSession.getLifeCycleName(), map);
                if (this.htSessionObjects == null) {
                    this.htSessionObjects = new Hashtable();
                }
                this.htSessionObjects.put(abstractSession.getObjectId(), (Map)object);
                this.injectObjects(abstractSession, (Map)object);
                return object;
            }
            Map map = AbstractSession.isIsolated(abstractSession) ? null : this.getApplicationObject(abstractSession);
            Map map2 = this.createInstance(null, abstractSession, abstractSession.getLifeCycleName(), map);
            if (this.htSessionObjects == null) {
                this.htSessionObjects = new Hashtable();
            }
            this.htSessionObjects.put(abstractSession.getObjectId(), map2);
            this.injectObjects(abstractSession, map2);
            return map2;
        }
    }

    private void updateSessionObject(AbstractSession abstractSession, Map map) throws Exception {
        List<Map.Entry<String, InjectObject>> list = abstractSession.getChangedInjectObjects();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Map.Entry<String, InjectObject> entry = list.get(i);
                InjectObject injectObject = entry.getValue();
                if (injectObject == null) {
                    map.remove(entry.getKey());
                    continue;
                }
                map.put(injectObject.getName(), injectObject.getObject());
            }
        }
    }

    protected synchronized Map getApplicationObject(AbstractSession abstractSession) throws Exception {
        Map map = null;
        String string = abstractSession.getApplicationName();
        if (this.htApplicationObjects != null) {
            map = this.htApplicationObjects.get(string);
        }
        if (map == null) {
            map = this.initApplicationObject(abstractSession);
        }
        return map;
    }

    private Map initApplicationObject(AbstractSession abstractSession) throws Exception {
        String string = abstractSession.getApplicationZone().getProperty("/application/lifecycle/application");
        if (string != null && string.trim().length() > 0) {
            try {
                Map map = this.createInstance(null, abstractSession, string, null);
                if (this.htApplicationObjects == null) {
                    this.htApplicationObjects = new Hashtable();
                }
                this.htApplicationObjects.put(abstractSession.getApplicationName(), map);
                return map;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error("Application object '" + string + "' was not found!", classNotFoundException);
                return null;
            }
        }
        return null;
    }

    protected Map createInstance(ClassLoader classLoader, AbstractSession abstractSession, String string, Map map) throws Exception {
        if (string != null) {
            Object obj = classLoader == null ? Class.forName(string).newInstance() : Class.forName(string, true, classLoader).newInstance();
            if (!(obj instanceof Map)) {
                throw new RuntimeException("The lifecycle object '" + string + "' has to be a Map!");
            }
            Map map2 = (Map)obj;
            if (map != null) {
                if (map2 instanceof GenericBean && map instanceof Bean) {
                    ((GenericBean)map2).setParent((Bean)map);
                } else {
                    this.log.error("Can't set parent for: ", string, " because the life-cycle object is not instance of GenericBean");
                }
            }
            return map2;
        }
        throw new ClassNotFoundException("Missing instance name");
    }

    private void injectObjects(AbstractSession abstractSession, Map map) throws Exception {
        Enumeration<InjectObject> enumeration = abstractSession.getInjectObjects();
        while (enumeration.hasMoreElements()) {
            InjectObject injectObject = enumeration.nextElement();
            String string = injectObject.getName();
            map.put(string, injectObject.getObject());
        }
    }

    public void setObjectAccessController(IObjectAccessController iObjectAccessController) {
        this.oaController = iObjectAccessController;
    }

    public IObjectAccessController getObjectAccessController() {
        return this.oaController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySession(ISession iSession) {
        Map map;
        if (this.htSessionObjects != null && (map = this.htSessionObjects.remove(((AbstractSession)iSession).getObjectId())) instanceof ILifeCycleObject) {
            boolean bl;
            SessionContext sessionContext = SessionContext.getCurrentInstance();
            if (sessionContext == null) {
                sessionContext = ((AbstractSession)iSession).createSessionContext(null, "destroy");
                bl = true;
            } else {
                bl = false;
            }
            try {
                try {
                    ((ILifeCycleObject)((Object)map)).destroy();
                }
                catch (Throwable throwable) {
                    this.log.debug(throwable);
                    Object var7_6 = null;
                    if (bl) {
                        sessionContext.release();
                    }
                }
                Object var7_5 = null;
                if (bl) {
                    sessionContext.release();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (bl) {
                    sessionContext.release();
                }
                throw throwable;
            }
        }
    }
}

