/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.rad.type.bean.BeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanTypeSerializer
extends AbstractSizedSerializer
implements ITypeSerializer<BeanType> {
    private static final int TYPE_BEAN_TYPE_MIN = 48;
    private static final int TYPE_BEAN_TYPE_MAX = 52;

    @Override
    public Class<BeanType> getTypeClass() {
        return BeanType.class;
    }

    @Override
    public int getMinValue() {
        return 48;
    }

    @Override
    public int getMaxValue() {
        return 52;
    }

    @Override
    public BeanType read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        BeanType beanType;
        int n2 = this.readSize(dataInputStream, n, 48, 52);
        if (n2 == 0) {
            beanType = typeCache.get(dataInputStream.readUnsignedByte());
        } else if (n2 == 1) {
            beanType = typeCache.get(dataInputStream.readUnsignedShort());
        } else {
            String string = (String)universalSerializer.read(dataInputStream);
            String[] stringArray = new String[n2 - 2];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((String)universalSerializer.read(dataInputStream)).intern();
            }
            beanType = new BeanType(string, stringArray);
            typeCache.put(beanType);
        }
        return beanType;
    }

    @Override
    public synchronized void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, BeanType beanType, TypeCache typeCache) throws Exception {
        Integer n = typeCache.indexOf(beanType);
        if (n == null) {
            String[] stringArray = beanType.getPropertyNames();
            this.writeSize(dataOutputStream, stringArray.length + 2, 48, 52);
            universalSerializer.write(dataOutputStream, beanType.getClassName());
            for (int i = 0; i < stringArray.length; ++i) {
                universalSerializer.write(dataOutputStream, stringArray[i]);
            }
            typeCache.put(beanType);
        } else {
            int n2 = n;
            if (n2 < 256) {
                this.writeSize(dataOutputStream, 0, 48, 52);
                dataOutputStream.writeByte(n2);
            } else {
                this.writeSize(dataOutputStream, 1, 48, 52);
                dataOutputStream.writeShort(n2);
            }
        }
    }
}

