/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.persist.DataSourceException;
import org.postgresql.util.PGobject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLDBAccess
extends DBAccess {
    public static final int TYPE_ENUM = -900;

    public PostgreSQLDBAccess() {
        this.setDriver("org.postgresql.Driver");
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NO WAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertPostgres(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    public Map<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toLowerCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    public SQLException formatSQLException(SQLException sQLException) {
        return this.formatSQLException(sQLException, sQLException.getMessage(), sQLException.getSQLState());
    }

    private Object[] insertPostgres(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(" RETURNING ");
        int[] nArray = serverMetaData.getPrimaryKeyColumnIndices();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(serverMetaData.getServerColumnMetaData(nArray[i]).getColumnName().getQuotedName());
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            String string4 = this.translateQuotes(stringBuffer.toString());
            PostgreSQLDBAccess.debug("executeSQL->", string4);
            statement = this.getConnection().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray2 = serverMetaData.getWritableColumnIndices();
            if (string3 == null) {
                this.setColumnsToStore((PreparedStatement)statement, serverColumnMetaDataArray, nArray2, objectArray, null);
            } else {
                for (n = 0; n < serverColumnMetaDataArray.length; ++n) {
                    if (!serverColumnMetaDataArray[n].getColumnName().getQuotedName().equals(string3)) continue;
                    statement.setObject(1, null, serverColumnMetaDataArray[n].getSQLType());
                    break;
                }
            }
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                for (n = 0; nArray != null && n < nArray.length; ++n) {
                    objectArray[nArray[n]] = resultSet.getObject(n + 1);
                }
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Insert failed! - " + stringBuffer, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    protected int setColumnsToStore(PreparedStatement preparedStatement, ServerColumnMetaData[] serverColumnMetaDataArray, int[] nArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if ((objectArray2 != null || objectArray[n2] == null) && (objectArray2 == null || serverColumnMetaDataArray[n2].getDataType().compareTo(objectArray[n2], objectArray2[n2]) == 0)) continue;
            try {
                preparedStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]), serverColumnMetaDataArray[n2].getSQLType());
                ++n;
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
        return --n;
    }

    @Override
    public boolean isAutoQuote(String string) {
        StringUtil.CaseSensitiveType caseSensitiveType = StringUtil.getCaseSensitiveType(string);
        return caseSensitiveType != StringUtil.CaseSensitiveType.LowerCase;
    }

    @Override
    public void setUsername(String string) {
        String string2 = string;
        if (string != null) {
            string2 = string2.equals(DBAccess.removeQuotes(string)) ? string2.toLowerCase() : DBAccess.removeQuotes(string);
        }
        super.setUsername(string2);
    }

    @Override
    protected ServerColumnMetaData[] getColumnMetaDataIntern(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray = super.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            if (serverColumnMetaDataArray[i].getSQLType() != 1111 || !this.isEnum(serverColumnMetaDataArray[i])) continue;
            serverColumnMetaDataArray[i].setDetectedType(-900);
            try {
                List<Object> list = this.executeSql("select e.enumlabel from pg_enum e, pg_type t where e.enumtypid = t.oid and t.typtype = 'e' and t.typname = ?", serverColumnMetaDataArray[i].getSQLTypeName());
                if (list == null) continue;
                serverColumnMetaDataArray[i].setAllowedValues(list.toArray());
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Create enum link reference to '" + serverColumnMetaDataArray[i].getName() + "' failed!", sQLException);
            }
        }
        return serverColumnMetaDataArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected TableInfo getTableInfoIntern(String var1_1) throws DataSourceException {
        block33: {
            block31: {
                block32: {
                    var2_2 = super.getTableInfoIntern(var1_1);
                    var3_3 = DBAccess.removeQuotes(var2_2.getTable());
                    if (var2_2.getSchema() != null) {
                        var4_4 = var2_2.getSchema();
                        var5_5 = DBAccess.removeQuotes((String)var4_4);
                        var4_4 = var5_5.equals(var4_4) != false ? var4_4.toLowerCase() : var5_5;
                        var6_6 = this.checkTablesAndViews((String)var4_4, var3_3);
                        if (var6_6.size() == 0) {
                            var6_6 = this.checkTablesAndViews(DBAccess.removeQuotes((String)var4_4), var3_3.toLowerCase());
                        }
                        if (var6_6.size() == 1) {
                            return new TableInfo(var2_2.getCatalog(), ((Name)var6_6.get(0)[0]).getRealName(), ((Name)var6_6.get(0)[1]).getRealName());
                        }
                    }
                    var4_4 = null;
                    var5_5 = null;
                    var6_7 = System.currentTimeMillis();
                    try {
                        var4_4 = this.getPreparedStatement("SHOW search_path", false);
                        var5_5 = var4_4.executeQuery();
                        if (!var5_5.next()) ** GOTO lbl71
                        var8_8 = var5_5.getString(1);
                        var9_10 = StringUtil.separateList((String)var8_8, ",", true);
                        var10_13 = 0;
lbl22:
                        // 2 sources

                        while (var10_13 < var9_10.size()) {
                            var11_14 = var9_10.get(var10_13);
                            if (var11_14.contains("$user")) {
                                var11_14 = this.getUsername();
                            }
                            if ((var12_15 = this.checkTablesAndViews(DBAccess.removeQuotes(var11_14), var3_3)).size() == 0) {
                                var12_15 = this.checkTablesAndViews(DBAccess.removeQuotes(var11_14), var3_3.toLowerCase());
                            }
                            if (var12_15.size() == 1) {
                                var13_16 = new TableInfo(var2_2.getCatalog(), ((Name)var12_15.get(0)[0]).getRealName(), ((Name)var12_15.get(0)[1]).getRealName());
                                if (var5_5 == null) break block31;
                                break block32;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl71
                    }
                    catch (SQLException var8_9) {
                        try {
                            throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var8_9));
                        }
                        catch (Throwable var15_19) {
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (SQLException var16_20) {
                                    // empty catch block
                                }
                            }
                            if (var4_4 != null) {
                                try {
                                    var4_4.close();
                                }
                                catch (SQLException var16_21) {
                                    // empty catch block
                                }
                            }
                            if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                                PostgreSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
                            }
                            throw var15_19;
                        }
                    }
                }
                try {
                    var5_5.close();
                }
                catch (SQLException var14_17) {
                    // empty catch block
                }
            }
            if (var4_4 != null) {
                try {
                    var4_4.close();
                }
                catch (SQLException var14_18) {
                    // empty catch block
                }
            }
            if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                PostgreSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
            }
            return var13_16;
lbl-1000:
            // 1 sources

            {
                ++var10_13;
                ** GOTO lbl22
lbl71:
                // 2 sources

                var8_8 = var2_2;
                if (var5_5 == null) break block33;
            }
            try {
                var5_5.close();
            }
            catch (SQLException var9_11) {
                // empty catch block
            }
        }
        if (var4_4 != null) {
            try {
                var4_4.close();
            }
            catch (SQLException var9_12) {
                // empty catch block
            }
        }
        if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            PostgreSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
        }
        return var8_8;
    }

    @Override
    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        if (object instanceof PGobject) {
            return ((PGobject)object).getValue();
        }
        return object;
    }

    @Override
    protected boolean setDatabaseSpecificType(ResultSetMetaData resultSetMetaData, int n, ServerColumnMetaData serverColumnMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnType(n);
        if (n2 == 1111) {
            serverColumnMetaData.setDataType(12);
            serverColumnMetaData.setPrecision(Integer.MAX_VALUE);
            return true;
        }
        return super.setDatabaseSpecificType(resultSetMetaData, n, serverColumnMetaData);
    }

    @Override
    protected String createWhereParam(ServerMetaData serverMetaData, CompareCondition compareCondition) {
        try {
            ServerColumnMetaData serverColumnMetaData = serverMetaData.getServerColumnMetaData(compareCondition.getColumnName());
            if (serverColumnMetaData.getDetectedType() == -900) {
                return "cast(? as " + serverColumnMetaData.getSQLTypeName() + ")";
            }
            Object object = compareCondition.getValue();
            if (compareCondition instanceof Equals && !this.isTypeEqual(serverColumnMetaData, compareCondition) && !(object instanceof String) || compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase || compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) {
                return "cast(? as varchar)";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return super.createWhereParam(serverMetaData, compareCondition);
    }

    @Override
    protected String createWhereColumn(ServerMetaData serverMetaData, CompareCondition compareCondition, String string) {
        try {
            ServerColumnMetaData serverColumnMetaData = serverMetaData.getServerColumnMetaData(compareCondition.getColumnName());
            IDataType iDataType = serverColumnMetaData.getDataType();
            if (compareCondition instanceof Equals && !this.isTypeEqual(serverColumnMetaData, compareCondition) && !(iDataType instanceof StringDataType) || compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase || compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) {
                return "cast(" + string + " as varchar)";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return super.createWhereColumn(serverMetaData, compareCondition, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        ArrayUtil<Object[]> arrayUtil;
        long l;
        block12: {
            l = System.currentTimeMillis();
            ResultSet resultSet = null;
            try {
                resultSet = this.getConnection().getMetaData().getTables(this.getConnection().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
                ArrayUtil<Object[]> arrayUtil2 = new ArrayUtil<Object[]>();
                while (resultSet.next()) {
                    arrayUtil2.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME"))), resultSet.getString("TABLE_TYPE"), resultSet.getString("REMARKS")});
                }
                arrayUtil = arrayUtil2;
                if (resultSet == null) break block12;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                    if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                        PostgreSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
                    }
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (PostgreSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            PostgreSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
        }
        return arrayUtil;
    }

    protected boolean isEnum(ServerColumnMetaData serverColumnMetaData) throws DataSourceException {
        if (serverColumnMetaData.getSQLType() == 1111) {
            String string = serverColumnMetaData.getSQLTypeName();
            try {
                List<Object> list = this.executeSql("select oid from pg_type where typname = ? and typtype = 'e'", string);
                return list.size() == 1;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Enum detection failed", this.formatSQLException(sQLException));
            }
        }
        return false;
    }
}

