/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDBAccess
extends DBAccess {
    public static final int TYPE_ENUM = -900;
    public static final int TYPE_SET = -901;

    public MySQLDBAccess() {
        this.setDriver("com.mysql.jdbc.Driver");
        this.setQuoteCharacters("", "");
    }

    @Override
    public void open() throws DataSourceException {
        this.setDBProperty("zeroDateTimeBehavior", "convertToNull");
        this.setDBProperty("useOldAliasMetadataBehavior", "true");
        super.open();
    }

    @Override
    public boolean isAutoQuote(String string) {
        return false;
    }

    @Override
    protected ServerColumnMetaData[] getColumnMetaDataIntern(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray = super.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
        Hashtable<String, ColumnInfo> hashtable = null;
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            ColumnInfo columnInfo;
            int n = serverColumnMetaDataArray[i].getSQLType();
            if (n == -1) {
                columnInfo = null;
                if (hashtable == null) {
                    hashtable = this.getColumnInfo(string);
                }
                if (hashtable != null && (columnInfo = hashtable.get(serverColumnMetaDataArray[i].getColumnName().getRealName())) != null) {
                    serverColumnMetaDataArray[i].setSQLTypeName(columnInfo.type);
                }
                if (columnInfo != null) continue;
                int n2 = serverColumnMetaDataArray[i].getPrecision();
                if (n2 > 0xFFFFFF && n2 <= Integer.MAX_VALUE) {
                    serverColumnMetaDataArray[i].setSQLTypeName("LONGTEXT");
                    continue;
                }
                if (n2 > 65535 && n2 <= 0xFFFFFF) {
                    serverColumnMetaDataArray[i].setSQLTypeName("MEDIUMTEXT");
                    continue;
                }
                if (n2 > 255 && n2 <= 65535) {
                    serverColumnMetaDataArray[i].setSQLTypeName("TEXT");
                    continue;
                }
                serverColumnMetaDataArray[i].setSQLTypeName("TINYTEXT");
                continue;
            }
            if (n != 1) continue;
            columnInfo = null;
            if (hashtable == null) {
                hashtable = this.getColumnInfo(string);
            }
            if (hashtable == null || (columnInfo = hashtable.get(serverColumnMetaDataArray[i].getColumnName().getRealName())) == null) continue;
            String string5 = columnInfo.type.toLowerCase();
            if (string5.startsWith("enum")) {
                serverColumnMetaDataArray[i].setDetectedType(-900);
                serverColumnMetaDataArray[i].setSQLTypeName(columnInfo.type);
            } else if (string5.startsWith("set")) {
                serverColumnMetaDataArray[i].setDetectedType(-901);
                serverColumnMetaDataArray[i].setSQLTypeName(columnInfo.type);
            }
            if (serverColumnMetaDataArray[i].getDetectedType() != -900 && serverColumnMetaDataArray[i].getDetectedType() != -901) continue;
            serverColumnMetaDataArray[i].setAllowedValues(this.extractValues(serverColumnMetaDataArray[i].getSQLTypeName()));
        }
        return serverColumnMetaDataArray;
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string2 = tableInfo.getTable();
        if (string2 != null && string2.contains(".")) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        return new TableInfo(null, tableInfo.getCatalog(), string2);
    }

    @Override
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getPrimaryKeyIntern(string2, null, string3);
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        List<ForeignKey> list = super.getForeignKeysIntern(string2, null, string3);
        for (int i = 0; i < list.size(); ++i) {
            ForeignKey foreignKey = list.get(i);
            foreignKey.setPKSchema(foreignKey.getPKCatalog());
            foreignKey.setPKCatalog(null);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        ArrayUtil<Key> arrayUtil;
        ResultSet resultSet = null;
        try {
            Object object;
            ArrayUtil<Key> arrayUtil2 = new ArrayUtil<Key>();
            arrayUtil = new ArrayUtil<Key>();
            long l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(MySQLDBAccess.removeQuotes(string2), null, MySQLDBAccess.removeQuotes(string3), true, false);
            if (!resultSet.next()) {
                resultSet.close();
                ArrayUtil<Key> arrayUtil3 = arrayUtil2;
                return arrayUtil3;
            }
            String string4 = null;
            do {
                if (resultSet.getString("COLUMN_NAME") == null) continue;
                if (string4 != null && !resultSet.getString("INDEX_NAME").equals(string4)) {
                    object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    arrayUtil2.add((Key)object);
                    arrayUtil.clear();
                }
                string4 = resultSet.getString("INDEX_NAME");
                arrayUtil.add((Key)((Object)new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME")))));
            } while (resultSet.next());
            if (arrayUtil.size() > 0) {
                object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                arrayUtil2.add((Key)object);
            }
            if (arrayUtil2.size() > 0 && (object = this.getPrimaryKey(string, string2, string3)) != null) {
                for (int i = arrayUtil2.size() - 1; i >= 0; --i) {
                    Name[] nameArray = arrayUtil2.get(i).getColumns();
                    if (!ArrayUtil.containsAll(nameArray, ((Key)object).getColumns()) || nameArray.length != ((Key)object).getColumns().length) continue;
                    arrayUtil2.remove(i);
                }
            }
            if (MySQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                MySQLDBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil2;
            return object;
        }
        catch (SQLException sQLException) {
            MySQLDBAccess.error("Unique Keys couldn't determined from database! - ", string3, sQLException);
            arrayUtil = null;
            return arrayUtil;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
        }
    }

    @Override
    public Map<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string2, null, string3);
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable<String, ColumnInfo> getColumnInfo(String string) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnection().createStatement();
            resultSet = statement.executeQuery("show columns from " + string);
            Hashtable<String, ColumnInfo> hashtable = new Hashtable<String, ColumnInfo>();
            while (resultSet.next()) {
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.type = resultSet.getString("Type");
                columnInfo.nullable = resultSet.getString("Null");
                columnInfo.key = resultSet.getString("Key");
                columnInfo.defaultvalue = resultSet.getString("Default");
                hashtable.put(resultSet.getString("Field"), columnInfo);
            }
            Hashtable<String, ColumnInfo> hashtable2 = hashtable;
            return hashtable2;
        }
        catch (SQLException sQLException) {
            MySQLDBAccess.debug(sQLException);
            Hashtable<String, ColumnInfo> hashtable = new Hashtable<String, ColumnInfo>();
            return hashtable;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String[] extractValues(String string) {
        int n = string.indexOf(40);
        String string2 = string.substring(n + 1, string.lastIndexOf(41));
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("null")) {
                stringArray[i] = null;
                continue;
            }
            stringArray[i] = StringUtil.removeQuotes(stringArray[i].trim(), "'");
            if (stringArray[i].length() != 0) continue;
            stringArray[i] = null;
        }
        return stringArray;
    }

    private static class ColumnInfo {
        private String field;
        private String type;
        private String nullable;
        private String key;
        private String defaultvalue;

        private ColumnInfo() {
        }
    }
}

