/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDBAccess
extends DBAccess {
    private static String sCheckSelect = "SELECT cu.TABLE_NAME, cu.COLUMN_NAME, c.CHECK_CLAUSE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS t, INFORMATION_SCHEMA.CHECK_CONSTRAINTS c, INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE cu WHERE t.CONSTRAINT_TYPE = 'CHECK' AND t.CONSTRAINT_SCHEMA = c.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = c.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = c.CONSTRAINT_NAME AND t.TABLE_NAME = ? AND t.TABLE_NAME = cu.TABLE_NAME AND t.TABLE_CATALOG = cu.TABLE_CATALOG AND t.TABLE_SCHEMA = cu.TABLE_SCHEMA AND t.CONSTRAINT_SCHEMA = cu.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = cu.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = cu.CONSTRAINT_NAME";
    private static String sSynonymSelect = "SELECT name, base_object_name FROM sys.synonyms t WHERE t.name = ?";

    public MSSQLDBAccess() {
        this.setDriver("net.sourceforge.jtds.jdbc.Driver");
        this.setQuoteCharacters("[", "]");
    }

    private String addMSSQLSpecificAutoIncSupport(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) {
        int[] nArray = serverMetaData.getAutoIncrementColumnIndices();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if ((objectArray != null || objectArray2[nArray[i]] == null) && (objectArray == null || objectArray2[nArray[i]] == null || objectArray2[nArray[i]].equals(objectArray[nArray[i]]))) continue;
            return "SET IDENTITY_INSERT " + this.translateQuotes(string) + " ON " + string2 + " SET IDENTITY_INSERT " + this.translateQuotes(string) + " OFF";
        }
        return string2;
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        string2 = this.addMSSQLSpecificAutoIncSupport(string, string2, serverMetaData, null, objectArray);
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        String string3 = StringUtil.removeQuotes(string2, "('", "')");
        string3 = StringUtil.removeQuotes(string3, "((", "))");
        string3 = StringUtil.removeQuotes(string3, "(", ")");
        return super.translateDefaultValue(string, n, string3);
    }

    @Override
    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Object[]> hashtable = new Hashtable();
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            preparedStatement = this.getPreparedStatement(sCheckSelect, false);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(3), hashtable2, false);
            }
            hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashtable;
    }

    @Override
    public boolean isAutoQuote(String string) {
        return false;
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected TableInfo getTableInfoIntern(String var1_1) throws DataSourceException {
        block45: {
            block39: {
                block44: {
                    block42: {
                        block43: {
                            block40: {
                                block41: {
                                    var2_2 = super.getTableInfoIntern(var1_1);
                                    var3_3 = DBAccess.removeQuotes(var2_2.getTable());
                                    if (var2_2.getSchema() != null && (var7_8 = this.checkTablesAndViews((String)(var4_4 = (var5_5 = DBAccess.removeQuotes((String)(var4_4 = var2_2.getSchema()))).equals(var4_4) != false ? var4_4.toLowerCase() : var5_5), var3_3 = (var6_6 = this.splitSchemaTable(var3_3))[1])).size() == 1) {
                                        return new TableInfo(var2_2.getCatalog(), ((Name)var7_8.get(0)[0]).getRealName(), var2_2.getTable());
                                    }
                                    var4_4 = null;
                                    var5_5 = null;
                                    var6_7 = System.currentTimeMillis();
                                    if (this.getConnection().getMetaData().getDatabaseMajorVersion() <= 8) ** GOTO lbl36
                                    var4_4 = this.getPreparedStatement("SELECT default_schema_name FROM sys.database_principals WHERE type = 'S' AND name = ?", false);
                                    var4_4.setString(1, this.getUsername());
                                    var5_5 = var4_4.executeQuery();
                                    if (!var5_5.next()) break block39;
                                    var8_9 = var5_5.getString(1);
                                    if (var8_9 == null || (var9_11 = this.checkTablesAndViews((String)var8_9, var3_3)).size() != 1) break block40;
                                    var10_16 = new TableInfo(var2_2.getCatalog(), ((Name)var9_11.get(0)[0]).getRealName(), var2_2.getTable());
                                    if (var5_5 == null) break block41;
                                    try {
                                        var5_5.close();
                                    }
                                    catch (SQLException var11_21) {
                                        // empty catch block
                                    }
                                }
                                if (var4_4 != null) {
                                    try {
                                        var4_4.close();
                                    }
                                    catch (SQLException var11_22) {
                                        // empty catch block
                                    }
                                }
                                if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                                    MSSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
                                }
                                return var10_16;
                            }
                            break block39;
lbl36:
                            // 1 sources

                            var8_9 = this.getDefaultSchema();
                            if (var8_9 == null) break block42;
                            var9_12 = new TableInfo(var2_2.getCatalog(), (String)var8_9, var2_2.getTable());
                            if (var5_5 == null) break block43;
                            try {
                                var5_5.close();
                            }
                            catch (SQLException var10_17) {
                                // empty catch block
                            }
                        }
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (SQLException var10_18) {
                                // empty catch block
                            }
                        }
                        if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                            MSSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
                        }
                        return var9_12;
                    }
                    var9_13 = new TableInfo(var2_2.getCatalog(), "dbo", var2_2.getTable());
                    if (var5_5 == null) break block44;
                    try {
                        var5_5.close();
                    }
                    catch (SQLException var10_19) {
                        // empty catch block
                    }
                }
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (SQLException var10_20) {
                        // empty catch block
                    }
                }
                if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                    MSSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
                }
                return var9_13;
            }
            var8_9 = var2_2;
            if (var5_5 == null) break block45;
            try {
                var5_5.close();
            }
            catch (SQLException var9_14) {
                // empty catch block
            }
        }
        if (var4_4 != null) {
            try {
                var4_4.close();
            }
            catch (SQLException var9_15) {
                // empty catch block
            }
        }
        if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            MSSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
        }
        return var8_9;
        catch (SQLException var8_10) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var8_10));
            }
            catch (Throwable var12_23) {
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (SQLException var13_24) {
                        // empty catch block
                    }
                }
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (SQLException var13_25) {
                        // empty catch block
                    }
                }
                if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                    MSSQLDBAccess.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - var6_7});
                }
                throw var12_23;
            }
        }
    }

    @Override
    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        String string2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect, false);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                preparedStatement.close();
                String string3 = string;
                return string3;
            }
            String string4 = resultSet.getString("BASE_OBJECT_NAME");
            if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                MSSQLDBAccess.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string2 = string4;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        Object object;
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().getMetaData().getTables(this.getConnection().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            while (resultSet.next()) {
                object = resultSet.getString("TABLE_SCHEM");
                if (((String)object).equals("sys") || ((String)object).equals("INFORMATION_SCHEMA")) continue;
                arrayUtil.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME")))});
            }
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) throw throwable;
                    MSSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
                    throw throwable;
                }
                catch (SQLException sQLException2) {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException2));
                }
            }
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (!MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) return object;
            MSSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
        }
    }
}

