/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.type.StringUtil;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDBAccess
extends DBAccess {
    public DerbyDBAccess() {
        this.setDriver("org.apache.derby.jdbc.ClientDriver");
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public Map<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    protected String createReplace(String string, String string2, String string3) {
        return string;
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string2 = tableInfo.getTable();
        if (string2 != null && !string2.startsWith("`") && !string2.endsWith("`")) {
            string2 = string2.toUpperCase();
        }
        return new TableInfo(tableInfo.getCatalog(), tableInfo.getSchema(), string2);
    }
}

