/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.DataBookCSVExporter;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.BeanUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.Filter;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.util.TranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStorage
extends AbstractCachedStorage {
    public static final String SUBSTORAGE_PREFIX = ".subStorages.";
    private static final String AUTOMATICLINKREFERENCE_PREFIX = ".FK.";
    private ServerMetaData mdServerMetaData = new ServerMetaData();
    private HashMap<String, DBStorage> hmpSubStorages = new HashMap();
    private ArrayUtil<StorageReferenceDefinition> auManualLinkReferences = new ArrayUtil();
    private ArrayUtil<StorageReferenceDefinition> auAutomaticLinkReferences = new ArrayUtil();
    private boolean bIsOpen = false;
    private boolean bRefetch = true;
    private DBAccess dbAccess;
    private String sFromClause;
    private String sFromClauseBeforeOpen;
    private String[] saQueryColumns;
    private String[] saQueryColumnsBeforeOpen;
    private String sBeforeQueryColumns;
    private String sWhereClause;
    private String sAfterWhereClause;
    private String[] saWritebackColumns;
    private String sWritebackTable;
    private String sSchema;
    private String sCatalog;
    private SortDefinition sdDefaultSort;
    private ICondition cRestrictCondition;
    private Boolean bAutoLinkReference;
    private static boolean bDefaultAutoLinkReference = true;
    private Boolean bDefaultValue;
    private static boolean bDefaultDefaultValue = true;
    private Boolean bAllowedValues;
    private static boolean bDefaultAllowedValues = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCSV(OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-15");
        try {
            int n;
            if (this.cRestrictCondition != null) {
                iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
            }
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            }
            if (stringArray == null) {
                stringArray = this.mdServerMetaData.getColumnNames();
            }
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = this.mdServerMetaData.getServerColumnMetaData(stringArray[n]).getLabel();
                    if (stringArray2[n] != null) continue;
                    stringArray2[n] = ColumnMetaData.getDefaultLabel(stringArray[n]);
                }
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (n > 0) {
                    outputStreamWriter.write(string);
                }
                outputStreamWriter.write(StringUtil.quote(stringArray2[n], '\"'));
            }
            outputStreamWriter.write("\n");
            IDataType[] iDataTypeArray = new IDataType[stringArray.length];
            int[] nArray = new int[stringArray.length];
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                iDataTypeArray[i] = ColumnMetaData.createDataType(this.mdServerMetaData.getServerColumnMetaData(stringArray[i]).getColumnMetaData());
                nArray[i] = this.mdServerMetaData.getServerColumnMetaDataIndex(stringArray[i]);
            }
            int n3 = 0;
            boolean bl = false;
            String string2 = this.getFromClauseIntern();
            while (!bl) {
                List<Object[]> list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, string2, iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, n3, 1000);
                n3 += list.size();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    Object[] objectArray = list.get(i);
                    if (objectArray != null) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (j > 0) {
                                outputStreamWriter.write(string);
                            }
                            DataBookCSVExporter.writeQuoted(outputStreamWriter, iDataTypeArray[j], objectArray[nArray[j]], string);
                        }
                        outputStreamWriter.write("\n");
                        continue;
                    }
                    bl = true;
                }
            }
            outputStreamWriter.flush();
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStreamWriter.close();
        }
        catch (Exception exception) {}
    }

    @Override
    public MetaData getMetaData() throws DataSourceException {
        return this.mdServerMetaData.getMetaData();
    }

    @Override
    public int getEstimatedRowCount(ICondition iCondition) throws DataSourceException {
        List<Object[]> list;
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, new String[]{"COUNT(*)"}, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 1)) != null && list.size() >= 1 && list.get(0).length > 0) {
            Object object = list.get(0)[0];
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            throw new DataSourceException("countRows() result data typ not supported! - " + object.getClass().getName());
        }
        return 0;
    }

    @Override
    protected List<Object[]> executeFetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if (sortDefinition == null) {
            sortDefinition = this.sdDefaultSort;
        }
        return this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, n, n2);
    }

    @Override
    protected Object[] executeRefetchRow(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        return this.refetchRow(objectArray, true);
    }

    @Override
    protected Object[] executeInsert(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        Object[] objectArray3 = this.dbAccess.insert(this.getWritebackTable(), this.mdServerMetaData, objectArray);
        if (this.isRefetch() && (objectArray2 = this.refetchRow(objectArray3, false)) != null) {
            return objectArray2;
        }
        return objectArray3;
    }

    @Override
    protected Object[] executeUpdate(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        Object[] objectArray3 = this.dbAccess.update(this.getWritebackTable(), this.mdServerMetaData, objectArray, objectArray2);
        if (this.isRefetch()) {
            return this.refetchRow(objectArray3, false);
        }
        return objectArray3;
    }

    @Override
    protected void executeDelete(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return;
        }
        this.dbAccess.delete(this.getWritebackTable(), this.mdServerMetaData, objectArray);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsOpen()=");
        stringBuffer.append(this.bIsOpen);
        stringBuffer.append("\n");
        stringBuffer.append(this.dbAccess);
        stringBuffer.append("\n");
        stringBuffer.append(this.sBeforeQueryColumns);
        stringBuffer.append(" ");
        for (n = 0; this.saQueryColumns != null && n < this.saQueryColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saQueryColumns[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.sFromClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sAfterWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append("Writeback:\n");
        stringBuffer.append(this.getWritebackTable());
        stringBuffer.append("\n");
        for (n = 0; this.saWritebackColumns != null && n < this.saWritebackColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saWritebackColumns[n]);
        }
        return stringBuffer.toString();
    }

    public void setMetaData(MetaData metaData) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        this.mdServerMetaData.setMetaData(metaData);
    }

    public void open() throws DataSourceException {
        this.sFromClauseBeforeOpen = this.getFromClause();
        String[] stringArray = this.getQueryColumns();
        this.saQueryColumnsBeforeOpen = stringArray != null ? stringArray : null;
        this.openInternal(false);
    }

    protected void openInternal(boolean bl) throws DataSourceException {
        if (this.dbAccess == null) {
            throw new DataSourceException("DBAccess isn't set!");
        }
        this.createMetaData(this.getBeforeQueryColumns(), this.getQueryColumns(), this.getFromClause(), this.getWhereClause(), this.getAfterWhereClause(), this.getWritebackTable(), this.getWritebackColumns(), this.isAutoLinkReference(), bl);
        this.bIsOpen = true;
    }

    protected void refreshMetaData() throws DataSourceException {
        this.hmpSubStorages.clear();
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.openInternal(false);
    }

    private String putSubStorage(DBStorage dBStorage) {
        String string = this.createSubStorageName(dBStorage);
        this.hmpSubStorages.put(string, dBStorage);
        return SUBSTORAGE_PREFIX + string;
    }

    private DBStorage getSubStorage(String string) {
        if (string.startsWith(SUBSTORAGE_PREFIX)) {
            return this.hmpSubStorages.get(string.substring(SUBSTORAGE_PREFIX.length()));
        }
        return null;
    }

    public void createAutomaticLinkReference(String[] stringArray, String string, String[] stringArray2) throws DataSourceException {
        if (this.isOpen()) {
            StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(stringArray, string, stringArray2);
            this.createAutomaticLinkStorage(storageReferenceDefinition, this.mdServerMetaData.getWritableColumnNames());
            this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
        } else {
            this.auManualLinkReferences.add(new StorageReferenceDefinition(stringArray, string, stringArray2));
        }
    }

    public void createAutomaticLinkReference(String[] stringArray, DBStorage dBStorage, String[] stringArray2) throws DataSourceException {
        String string = this.putSubStorage(dBStorage);
        StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(stringArray, string, stringArray2);
        if (this.isOpen()) {
            this.installAutomaticLinkReferenceIntern(storageReferenceDefinition);
        } else {
            this.auManualLinkReferences.add(new StorageReferenceDefinition(stringArray, string, stringArray2));
        }
    }

    private void addAutomaticLinkReferenceIntern(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) {
        String[] stringArray2 = ArrayUtil.intersect(storageReferenceDefinition.getColumnNames(), stringArray);
        int n = this.auAutomaticLinkReferences.size();
        for (int i = 0; i < n; ++i) {
            StorageReferenceDefinition storageReferenceDefinition2 = this.auAutomaticLinkReferences.get(i);
            String[] stringArray3 = ArrayUtil.intersect(storageReferenceDefinition2.getColumnNames(), stringArray);
            if (stringArray3.length > stringArray2.length) {
                this.auAutomaticLinkReferences.add(i, storageReferenceDefinition);
                return;
            }
            if (stringArray3.length != stringArray2.length || !ArrayUtil.containsAll(stringArray3, stringArray2)) continue;
            this.auAutomaticLinkReferences.set(i, storageReferenceDefinition);
            return;
        }
        this.auAutomaticLinkReferences.add(storageReferenceDefinition);
    }

    private List<StorageReferenceDefinition> getSubAutomaticLinkReferences(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) {
        String[] stringArray2 = ArrayUtil.intersect(storageReferenceDefinition.getColumnNames(), stringArray);
        ArrayUtil<StorageReferenceDefinition> arrayUtil = new ArrayUtil<StorageReferenceDefinition>();
        for (StorageReferenceDefinition storageReferenceDefinition2 : this.auAutomaticLinkReferences) {
            String[] stringArray3 = ArrayUtil.intersect(storageReferenceDefinition2.getColumnNames(), stringArray);
            if (stringArray3.length >= stringArray2.length) {
                return arrayUtil;
            }
            if (!ArrayUtil.containsAll(stringArray2, stringArray3)) continue;
            arrayUtil.add(storageReferenceDefinition2);
        }
        return arrayUtil;
    }

    protected void installAutomaticLinkReferenceIntern(StorageReferenceDefinition storageReferenceDefinition) throws DataSourceException {
        String[] stringArray = this.mdServerMetaData.getWritableColumnNames();
        this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray);
        if (this.isAutoLinkReference()) {
            String[] stringArray2 = storageReferenceDefinition.getColumnNames();
            List<StorageReferenceDefinition> list = this.getSubAutomaticLinkReferences(storageReferenceDefinition, stringArray);
            for (StorageReferenceDefinition storageReferenceDefinition2 : list) {
                stringArray2 = ArrayUtil.removeAll(stringArray2, storageReferenceDefinition2.getColumnNames());
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                try {
                    this.mdServerMetaData.getServerColumnMetaData(stringArray2[i]).setLinkReference(storageReferenceDefinition);
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException(modelException.getMessage());
                }
            }
        }
    }

    protected String createSubStorageName(DBStorage dBStorage) {
        String string;
        if (dBStorage.getName() != null) {
            string = dBStorage.getName();
        } else {
            DBStorage dBStorage2 = dBStorage;
            string = dBStorage2.getWritebackTable() != null ? dBStorage2.getWritebackTable() : dBStorage2.getFromClause();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string = StringUtil.convertToMemberName(string);
        }
        return string;
    }

    protected void createAutomaticLinkStorage(StorageReferenceDefinition storageReferenceDefinition, String[] stringArray) throws DataSourceException {
        String string;
        String[] stringArray2;
        TranslationMap translationMap = DBAccess.getAutomaticLinkColumnNameTranslation();
        String string2 = storageReferenceDefinition.getReferencedStorage();
        String[] stringArray3 = storageReferenceDefinition.getColumnNames();
        String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
        String[] stringArray5 = ArrayUtil.intersect(stringArray3, stringArray);
        boolean bl = string2.startsWith(AUTOMATICLINKREFERENCE_PREFIX);
        if (bl) {
            string2 = string2.substring(AUTOMATICLINKREFERENCE_PREFIX.length());
        }
        DBStorage dBStorage = new DBStorage();
        dBStorage.setDBAccess(this.dbAccess);
        dBStorage.setWritebackTable(string2);
        dBStorage.setAutoLinkReference(false);
        List<StorageReferenceDefinition> list = this.getSubAutomaticLinkReferences(storageReferenceDefinition, stringArray);
        if (list.size() > 0) {
            for (StorageReferenceDefinition object : list) {
                stringArray2 = object.getColumnNames();
                String[] i = object.getReferencedColumnNames();
                string = object.getReferencedStorage();
                String[] stringArray6 = new String[stringArray2.length];
                for (int j = 0; j < stringArray6.length; ++j) {
                    int n = ArrayUtil.indexOf(stringArray3, stringArray2[j]);
                    if (n < 0) {
                        String string3 = stringArray2[j];
                        int n2 = stringArray2[j].indexOf(95);
                        if (n2 >= 0) {
                            String string4 = string3.substring(0, n2);
                            String string5 = null;
                            for (int k = 0; string5 == null && k < stringArray3.length; ++k) {
                                if (!string4.equals(translationMap.translate(stringArray3[k]))) continue;
                                string5 = translationMap.translate(stringArray4[k]);
                            }
                            if (string5 != null) {
                                string3 = string5 + string3.substring(string4.length());
                            }
                        }
                        stringArray6[j] = string3;
                        stringArray3 = ArrayUtil.add(stringArray3, stringArray2[j]);
                        stringArray4 = ArrayUtil.add(stringArray4, stringArray6[j]);
                        continue;
                    }
                    stringArray6[j] = stringArray4[n];
                    stringArray5 = ArrayUtil.remove(stringArray5, stringArray2[j]);
                }
                dBStorage.createAutomaticLinkReference(stringArray6, this.getSubStorage(string), i);
            }
        }
        dBStorage.openInternal(false);
        if (bl) {
            int n = this.dbAccess.getMaxColumnLength();
            String string6 = translationMap.translate(stringArray5[0]) + "_";
            stringArray2 = dBStorage.getMetaData().getRepresentationColumnNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (ArrayUtil.contains(stringArray4, stringArray2[i])) continue;
                string = string6 + stringArray2[i];
                if (string.length() > n) {
                    string = string.substring(0, n);
                }
                stringArray3 = ArrayUtil.add(stringArray3, string);
                stringArray4 = ArrayUtil.add(stringArray4, stringArray2[i]);
            }
        }
        String string6 = this.putSubStorage(dBStorage);
        storageReferenceDefinition.setColumnNames(stringArray3);
        storageReferenceDefinition.setReferencedColumnNames(stringArray4);
        storageReferenceDefinition.setReferencedStorage(string6);
    }

    protected boolean isAutomaticLinkNullable(String[] stringArray, ServerColumnMetaData[] serverColumnMetaDataArray) {
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            ServerColumnMetaData serverColumnMetaData = serverColumnMetaDataArray[i];
            if (!ArrayUtil.contains(stringArray, serverColumnMetaData.getName()) || !serverColumnMetaData.isWritable() || !serverColumnMetaData.isNullable()) continue;
            return true;
        }
        return false;
    }

    private String getFromClause(String string, ServerColumnMetaData[] serverColumnMetaDataArray) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" m ");
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil.add(serverColumnMetaDataArray[i].getName());
        }
        String[] stringArray = arrayUtil.toArray(new String[arrayUtil.size()]);
        int n = 0;
        for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
            String[] stringArray2 = arrayUtil.toArray(new String[arrayUtil.size()]);
            String[] stringArray3 = storageReferenceDefinition.getColumnNames();
            String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray5 = ArrayUtil.removeAll(stringArray3, stringArray2);
            if (stringArray5.length <= 0) continue;
            ++n;
            if (this.isAutomaticLinkNullable(stringArray3, serverColumnMetaDataArray)) {
                stringBuilder.append("LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("INNER JOIN ");
            }
            DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
            stringBuilder.append(dBStorage.getWritebackTable());
            stringBuilder.append(" l");
            stringBuilder.append(n);
            stringBuilder.append(" ON ");
            boolean bl = true;
            for (int i = 0; i < stringArray3.length; ++i) {
                int n2 = ArrayUtil.indexOf(stringArray, stringArray3[i]);
                if (n2 < 0) continue;
                ServerColumnMetaData serverColumnMetaData = serverColumnMetaDataArray[n2];
                if (!bl) {
                    stringBuilder.append(" AND ");
                }
                bl = false;
                stringBuilder.append("m.");
                stringBuilder.append(serverColumnMetaData.getColumnName().getQuotedName());
                stringBuilder.append(" = ");
                stringBuilder.append("l");
                stringBuilder.append(n);
                stringBuilder.append('.');
                try {
                    stringBuilder.append(dBStorage.mdServerMetaData.getServerColumnMetaData(stringArray4[i]).getColumnName().getQuotedName());
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException(modelException.getMessage());
                }
            }
            stringBuilder.append("\n");
            arrayUtil.addAll(stringArray5);
        }
        return stringBuilder.toString();
    }

    private String[] getQueryColumns(ServerColumnMetaData[] serverColumnMetaDataArray) throws DataSourceException {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            arrayUtil.add("m." + serverColumnMetaDataArray[i].getColumnName().getQuotedName());
            arrayUtil2.add(serverColumnMetaDataArray[i].getName());
        }
        String[] stringArray = arrayUtil2.toArray(new String[arrayUtil2.size()]);
        int n = 0;
        for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
            int n2;
            String[] stringArray2 = arrayUtil2.toArray(new String[arrayUtil2.size()]);
            String[] stringArray3 = storageReferenceDefinition.getColumnNames();
            String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
            String[] stringArray5 = ArrayUtil.removeAll(stringArray3, stringArray2);
            if (stringArray5.length <= 0) continue;
            ++n;
            DBStorage dBStorage = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
            String[] stringArray6 = ArrayUtil.intersect(stringArray3, stringArray);
            int n3 = -1;
            for (int i = 0; i < stringArray6.length; ++i) {
                n2 = arrayUtil2.indexOf(stringArray6[i]);
                if (n2 <= n3) continue;
                n3 = n2;
            }
            String[] stringArray7 = new String[stringArray5.length];
            for (n2 = 0; n2 < stringArray5.length; ++n2) {
                String string = stringArray4[ArrayUtil.indexOf(stringArray3, stringArray5[n2])];
                try {
                    stringArray7[n2] = "l" + n + "." + dBStorage.mdServerMetaData.getServerColumnMetaData(string).getColumnName().getQuotedName() + " " + stringArray5[n2];
                    continue;
                }
                catch (ModelException modelException) {
                    throw new DataSourceException(modelException.getMessage());
                }
            }
            arrayUtil.addAll(n3 + 1, stringArray7);
            arrayUtil2.addAll(n3 + 1, stringArray5);
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    protected ServerMetaData createMetaData(String string, String[] objectArray, String string2, String string3, String string4, String string5, String[] stringArray, boolean bl, boolean bl2) throws DataSourceException {
        Object object3;
        int n;
        int n2;
        Object object2;
        ServerColumnMetaData[] serverColumnMetaDataArray;
        boolean bl3;
        Key key = null;
        List<Key> list = null;
        Map<String, Object> map = null;
        Map<String, Object[]> map2 = null;
        Object[] objectArray2 = null;
        String[] stringArray2 = null;
        MetaData metaData = this.mdServerMetaData.getMetaData();
        boolean bl4 = metaData.getPrimaryKeyColumnNames() != null;
        boolean bl5 = bl3 = metaData.getRepresentationColumnNames() != null;
        if (string5 != null) {
            String string6;
            Object[] objectArray3;
            serverColumnMetaDataArray = this.dbAccess.getTableForSynonym(string5);
            object2 = this.dbAccess.getTableInfo((String)serverColumnMetaDataArray);
            objectArray2 = this.dbAccess.getColumnMetaData((String)serverColumnMetaDataArray, null, null, null, null);
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i].setWritable(true);
            }
            stringArray2 = BeanUtil.toArray(objectArray2, new String[objectArray2.length], "name");
            this.sCatalog = ((TableInfo)object2).getCatalog();
            this.sSchema = ((TableInfo)object2).getSchema();
            this.debug("WritebackTable Schema=", this.sSchema, ",Catalog=", this.sCatalog);
            String string7 = ((TableInfo)object2).getTable();
            if (this.isDefaultValue()) {
                map = this.dbAccess.getDefaultValues(this.sCatalog, this.sSchema, string7);
            }
            if (this.isAllowedValues()) {
                map2 = this.dbAccess.getAllowedValues(this.sCatalog, this.sSchema, string7);
                n2 = objectArray2.length;
                for (n = 0; n < n2; ++n) {
                    if (map2 != null && map2.get(((ServerColumnMetaData)objectArray2[n]).getName()) != null || (objectArray3 = this.dbAccess.getDefaultAllowedValues(this.sCatalog, this.sSchema, string7, (ServerColumnMetaData)objectArray2[n])) == null) continue;
                    if (map2 == null) {
                        map2 = new Hashtable<String, Object[]>();
                    }
                    map2.put(((ServerColumnMetaData)objectArray2[n]).getName(), objectArray3);
                }
            }
            if (!bl4) {
                key = this.dbAccess.getPrimaryKey(this.sCatalog, this.sSchema, string7);
            }
            if (!bl3) {
                list = this.dbAccess.getUniqueKeys(this.sCatalog, this.sSchema, string7);
            }
            if (bl) {
                objectArray3 = this.dbAccess.getForeignKeys(this.sCatalog, this.sSchema, string7);
                String string8 = null;
                if (this.dbAccess instanceof DBAccess) {
                    string8 = this.dbAccess.getDefaultSchema();
                }
                for (Object object3 : objectArray3) {
                    String string9 = ((ForeignKey)object3).getPKTable().getQuotedName();
                    String string10 = string6 = ((ForeignKey)object3).getPKSchema() == null ? null : ((ForeignKey)object3).getPKSchema().getQuotedName();
                    if (string8 == null && string6 != null || string8 != null && !string8.equals(string6)) {
                        string9 = string6 + "." + string9;
                    }
                    StorageReferenceDefinition storageReferenceDefinition = new StorageReferenceDefinition(BeanUtil.toArray(((ForeignKey)object3).getFKColumns(), new String[((ForeignKey)object3).getFKColumns().length], "name"), AUTOMATICLINKREFERENCE_PREFIX + string9, BeanUtil.toArray(((ForeignKey)object3).getPKColumns(), new String[((ForeignKey)object3).getPKColumns().length], "name"));
                    this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray2);
                }
            }
            for (StorageReferenceDefinition storageReferenceDefinition : this.auManualLinkReferences) {
                this.addAutomaticLinkReferenceIntern(storageReferenceDefinition, stringArray2);
            }
            for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                String string11 = storageReferenceDefinition.getReferencedStorage();
                if (string11.startsWith(SUBSTORAGE_PREFIX)) continue;
                this.createAutomaticLinkStorage(storageReferenceDefinition, stringArray2);
            }
            if (this.auAutomaticLinkReferences.size() > 0 && string2 == null) {
                objectArray3 = this.getQueryColumns((ServerColumnMetaData[])objectArray2);
                if (objectArray == null) {
                    objectArray = objectArray3;
                } else {
                    for (n = 0; n < objectArray.length; ++n) {
                        String string12 = ((String)objectArray[n]).toLowerCase();
                        if (string12.contains(".") || StringUtil.containsWhitespace(string12)) continue;
                        object3 = null;
                        for (int i = 0; object3 == null && i < objectArray3.length; ++i) {
                            string6 = ((String)objectArray3[i]).toLowerCase();
                            int n3 = string6.length() - string12.length() - 1;
                            if (!string6.endsWith(string12) || n3 >= 0 && !Character.isWhitespace(string6.charAt(n3)) && string6.charAt(n3) != '.') continue;
                            object3 = objectArray3[i];
                        }
                        objectArray[n] = object3;
                    }
                }
                this.setQueryColumns((String[])objectArray);
                string2 = this.getFromClause(string5, (ServerColumnMetaData[])objectArray2);
                this.setFromClause(string2);
            }
            if (string2 == null) {
                string2 = string5;
            }
        }
        if (string5 == null) {
            metaData.removeFeature(MetaData.Feature.WriteBack);
        }
        serverColumnMetaDataArray = this.dbAccess.getColumnMetaData(string2, (String[])objectArray, string, string3, string4);
        this.mdServerMetaData.setServerColumnMetaData(serverColumnMetaDataArray);
        object2 = new ArrayUtil();
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            int n4;
            Object[] objectArray4;
            if (serverColumnMetaDataArray[i].isAutoIncrement()) {
                ((ArrayUtil)object2).add(serverColumnMetaDataArray[i].getColumnName());
            }
            if (map != null) {
                serverColumnMetaDataArray[i].setDefaultValue(map.get(serverColumnMetaDataArray[i].getName()));
            }
            if (map2 != null && (objectArray4 = (Object[])map2.get(serverColumnMetaDataArray[i].getName())) != null && objectArray4.length > 0) {
                serverColumnMetaDataArray[i].setAllowedValues(objectArray4);
            }
            if (objectArray2 == null || (n4 = ServerMetaData.getServerColumnMetaDataIndex((ServerColumnMetaData[])objectArray2, serverColumnMetaDataArray[i].getName())) < 0) continue;
            serverColumnMetaDataArray[i].setDetectedType(((ServerColumnMetaData)objectArray2[n4]).getDetectedType());
            serverColumnMetaDataArray[i].setSQLTypeName(((ServerColumnMetaData)objectArray2[n4]).getSQLTypeName());
            if (serverColumnMetaDataArray[i].getAllowedValues() == null && ((ServerColumnMetaData)objectArray2[n4]).getAllowedValues() != null) {
                serverColumnMetaDataArray[i].setAllowedValues(((ServerColumnMetaData)objectArray2[n4]).getAllowedValues());
            }
            serverColumnMetaDataArray[i].setNullable(((ServerColumnMetaData)objectArray2[n4]).isNullable());
            serverColumnMetaDataArray[i].setWritable(true);
        }
        if (!((ArrayUtil)object2).isEmpty()) {
            this.mdServerMetaData.setAutoIncrementColumnNames(((ArrayUtil)object2).toArray(new Name[((ArrayUtil)object2).size()]));
        }
        if (string5 != null) {
            if (!bl4) {
                if (key != null && key.getColumns() != null && key.getColumns().length > 0) {
                    this.mdServerMetaData.setPrimaryKeyColumnNames(key.getColumns());
                    this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.PrimaryKeyColumns);
                } else if (list != null && list.size() > 0) {
                    this.mdServerMetaData.setPrimaryKeyColumnNames(((Key)list.get(0)).getColumns());
                    this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.UniqueKeyColumns);
                } else {
                    String[] stringArray3 = ArrayUtil.intersect(this.mdServerMetaData.getColumnNames(), stringArray2);
                    ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
                    for (n = 0; n < stringArray3.length; ++n) {
                        try {
                            ServerColumnMetaData serverColumnMetaData = this.mdServerMetaData.getServerColumnMetaData(stringArray3[n]);
                            if (serverColumnMetaData.getColumnMetaData().getTypeIdentifier() == -2) continue;
                            arrayUtil.add(serverColumnMetaData.getColumnName());
                            continue;
                        }
                        catch (ModelException modelException) {
                            // empty catch block
                        }
                    }
                    if (arrayUtil.size() > 0) {
                        this.mdServerMetaData.setPrimaryKeyColumnNames(arrayUtil.toArray(new Name[arrayUtil.size()]));
                        this.mdServerMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.AllColumns);
                    }
                }
            }
            if (!bl3 && list != null && list.size() > 0) {
                ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
                for (int i = 0; i < list.size(); ++i) {
                    Name[] nameArray = ((Key)list.get(i)).getColumns();
                    for (n2 = 0; n2 < nameArray.length; ++n2) {
                        if (arrayUtil.indexOf(nameArray[n2]) >= 0) continue;
                        arrayUtil.add(nameArray[n2]);
                    }
                }
                if (arrayUtil.size() > 0) {
                    Name[] nameArray = new Name[arrayUtil.size()];
                    arrayUtil.toArray(nameArray);
                    this.mdServerMetaData.setRepresentationColumnNames(nameArray);
                }
            }
            if (bl) {
                for (StorageReferenceDefinition storageReferenceDefinition : this.auAutomaticLinkReferences) {
                    int n5;
                    Object[] objectArray5 = storageReferenceDefinition.getColumnNames();
                    String[] stringArray4 = storageReferenceDefinition.getReferencedColumnNames();
                    object3 = this.getSubStorage(storageReferenceDefinition.getReferencedStorage());
                    Object[] objectArray6 = ArrayUtil.intersect(objectArray5, this.mdServerMetaData.getColumnNames());
                    if (!Arrays.equals(objectArray5, objectArray6)) {
                        String[] stringArray5 = new String[objectArray6.length];
                        for (n5 = 0; n5 < stringArray5.length; ++n5) {
                            stringArray5[n5] = stringArray4[ArrayUtil.indexOf(objectArray5, objectArray6[n5])];
                        }
                        objectArray5 = objectArray6;
                        stringArray4 = stringArray5;
                        storageReferenceDefinition.setColumnNames((String[])objectArray5);
                        storageReferenceDefinition.setReferencedColumnNames(stringArray4);
                    }
                    try {
                        boolean bl6 = this.isAutomaticLinkNullable((String[])objectArray5, (ServerColumnMetaData[])objectArray2);
                        for (n5 = 0; n5 < objectArray5.length; ++n5) {
                            ServerColumnMetaData serverColumnMetaData = this.mdServerMetaData.getServerColumnMetaData((String)objectArray5[n5]);
                            if (serverColumnMetaData.getLinkReference() != null) continue;
                            if (!serverColumnMetaData.isWritable()) {
                                serverColumnMetaData.setLabel(((DBStorage)object3).getMetaData().getColumnMetaData(stringArray4[n5]).getLabel());
                                serverColumnMetaData.setNullable(bl6);
                            }
                            serverColumnMetaData.setLinkReference(storageReferenceDefinition);
                        }
                    }
                    catch (ModelException modelException) {
                        this.debug(Arrays.toString(this.mdServerMetaData.getColumnNames()));
                        this.debug(modelException);
                    }
                }
            }
        }
        if (!bl3 && this.mdServerMetaData.getRepresentationColumnNames() != null) {
            String[] stringArray6 = this.mdServerMetaData.getRepresentationColumnNames();
            String[] stringArray7 = null;
            for (n = 0; stringArray7 == null && n < stringArray6.length; ++n) {
                try {
                    if (this.mdServerMetaData.getMetaData().getColumnMetaData(stringArray6[n]).getTypeIdentifier() != 12) continue;
                    stringArray7 = new String[]{stringArray6[n]};
                    continue;
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            if (stringArray7 != null) {
                this.mdServerMetaData.setRepresentationColumnNames(stringArray7);
            }
        }
        if (!bl3 && this.mdServerMetaData.getRepresentationColumnNames() == null) {
            Name name = null;
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            for (n2 = 0; name == null && n2 < serverColumnMetaDataArray.length; ++n2) {
                if (!ArrayUtil.contains(this.mdServerMetaData.getPrimaryKeyColumnNames(), serverColumnMetaDataArray[n2].getName()) && !RowDefinition.isColumnIgnored(serverColumnMetaDataArray[n2].getName())) {
                    if (serverColumnMetaDataArray[n2].getColumnMetaData().getTypeIdentifier() == 12) {
                        name = serverColumnMetaDataArray[n2].getColumnName();
                    }
                    if (serverColumnMetaDataArray[n2].getColumnMetaData().getTypeIdentifier() != -2) {
                        arrayUtil.add(serverColumnMetaDataArray[n2].getColumnName());
                    }
                }
                if (serverColumnMetaDataArray[n2].getColumnMetaData().getTypeIdentifier() == -2) continue;
                arrayUtil2.add(serverColumnMetaDataArray[n2].getColumnName());
            }
            if (name != null) {
                this.mdServerMetaData.setRepresentationColumnNames(new Name[]{name});
            } else if (arrayUtil.size() > 0) {
                this.mdServerMetaData.setRepresentationColumnNames(arrayUtil.toArray(new Name[arrayUtil.size()]));
            } else {
                this.mdServerMetaData.setRepresentationColumnNames(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
            }
        }
        return this.mdServerMetaData;
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    public void close() {
        this.bIsOpen = false;
    }

    public void setDBAccess(IDBAccess iDBAccess) {
        this.dbAccess = (DBAccess)iDBAccess;
    }

    public IDBAccess getDBAccess() {
        return this.dbAccess;
    }

    public String getFromClause() {
        return this.sFromClause;
    }

    private String getFromClauseIntern() {
        if (this.sFromClause == null) {
            return this.sWritebackTable;
        }
        return this.sFromClause;
    }

    public void setFromClause(String string) {
        this.sFromClause = string;
    }

    public String[] getQueryColumns() {
        return this.saQueryColumns;
    }

    public void setQueryColumns(String[] stringArray) {
        this.saQueryColumns = stringArray;
    }

    public String getBeforeQueryColumns() {
        return this.sBeforeQueryColumns;
    }

    public void setBeforeQueryColumns(String string) {
        this.sBeforeQueryColumns = string;
    }

    public String getWhereClause() {
        return this.sWhereClause;
    }

    public void setWhereClause(String string) {
        this.sWhereClause = string;
    }

    public String getAfterWhereClause() {
        return this.sAfterWhereClause;
    }

    public void setAfterWhereClause(String string) {
        this.sAfterWhereClause = string;
    }

    public String[] getWritebackColumns() {
        return this.saWritebackColumns;
    }

    public void setWritebackColumns(String[] stringArray) {
        this.saWritebackColumns = stringArray;
    }

    public String getWritebackTable() {
        return this.sWritebackTable;
    }

    public void setWritebackTable(String string) {
        this.sWritebackTable = string;
    }

    public SortDefinition getDefaultSort() {
        return this.sdDefaultSort;
    }

    public void setDefaultSort(SortDefinition sortDefinition) {
        this.sdDefaultSort = sortDefinition;
    }

    public ICondition getRestrictCondition() {
        return this.cRestrictCondition;
    }

    public void setRestrictCondition(ICondition iCondition) {
        this.cRestrictCondition = iCondition;
    }

    public boolean isRefetch() {
        return this.bRefetch;
    }

    public void setRefetch(boolean bl) {
        this.bRefetch = bl;
    }

    public void setAutoLinkReference(boolean bl) {
        this.bAutoLinkReference = bl;
    }

    public boolean isAutoLinkReference() {
        if (this.bAutoLinkReference == null) {
            return bDefaultAutoLinkReference;
        }
        return this.bAutoLinkReference;
    }

    public static void setDefaultAutoLinkReference(boolean bl) {
        bDefaultAutoLinkReference = bl;
    }

    public static boolean isDefaultAutoLinkReference() {
        return bDefaultAutoLinkReference;
    }

    public void setDefaultValue(boolean bl) {
        this.bDefaultValue = bl;
    }

    public boolean isDefaultValue() {
        if (this.bDefaultValue == null) {
            return bDefaultDefaultValue;
        }
        return this.bDefaultValue;
    }

    public static void setDefaultDefaultValue(boolean bl) {
        bDefaultDefaultValue = bl;
    }

    public static boolean isDefaultDefaultValue() {
        return bDefaultDefaultValue;
    }

    public void setAllowedValues(boolean bl) {
        this.bAllowedValues = bl;
    }

    public boolean isAllowedValues() {
        if (this.bAllowedValues == null) {
            return bDefaultAllowedValues;
        }
        return this.bAllowedValues;
    }

    public static void setDefaultAllowedValues(boolean bl) {
        bDefaultAllowedValues = bl;
    }

    public static boolean isDefaultAllowedValues() {
        return bDefaultAllowedValues;
    }

    protected String getWritebackTableCatalog() {
        return this.sCatalog;
    }

    protected String getWritebackTableSchema() {
        return this.sSchema;
    }

    protected Object[] refetchRow(Object[] objectArray, boolean bl) throws DataSourceException {
        List<Object[]> list;
        if (objectArray == null) {
            return null;
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        ICondition iCondition = Filter.createEqualsFilter(this.mdServerMetaData.getPrimaryKeyColumnNames(), objectArray, this.mdServerMetaData.getMetaData().getColumnMetaData());
        if (bl) {
            this.dbAccess.lockRow(this.getFromClauseIntern(), this.mdServerMetaData, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 2)) != null && list.size() == 2 && list.get(1) == null) {
            return list.get(0);
        }
        return null;
    }

    public Map<String, DBStorage> getSubStorages() {
        return this.hmpSubStorages;
    }
}

