/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.remote;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.rad.model.remote.RemoteDataPage;
import com.sibvisions.rad.model.remote.RemoteDataSource;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UILinkedCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.IDataSource;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.remote.AbstractConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDataBook
extends MemDataBook {
    private static ILogger logger = LoggerFactory.getInstance(RemoteDataBook.class);
    private static Hashtable<String, Boolean> htCachingStorage = new Hashtable();
    private String[] saMetaDataColumnNames;
    private String[] saBlockFetchColumnNames;
    private String[] saBlockFetchReferencedColumnNames;
    private Hashtable<Object, Integer> htFetchedRowsForBlock = null;
    private MetaData mdMetaData;
    private int[] iaFetchColumnIndexes;
    private int[] iaMasterColumnIndexes;
    private boolean bCachingStorage = true;
    private boolean bMetaDataCacheEnabled = true;

    public RemoteDataBook() {
        this.setMemSort(false);
        this.setMemFilter(false);
        this.setDeleteCascade(false);
        this.setWritebackEnabled(true);
    }

    @Override
    protected boolean isDataPageRefetchPossible() {
        return this.saBlockFetchColumnNames == null;
    }

    @Override
    protected MemDataPage createDataPage(IDataRow iDataRow) {
        return new RemoteDataPage(this, iDataRow);
    }

    @Override
    public void setDataSource(IDataSource iDataSource) throws ModelException {
        if (!(iDataSource instanceof RemoteDataSource)) {
            throw new ModelException("It's not an RemoteDataSource! -> it have to be one!");
        }
        super.setDataSource(iDataSource);
    }

    @Override
    public RemoteDataSource getDataSource() {
        return (RemoteDataSource)super.getDataSource();
    }

    @Override
    public void open() throws ModelException {
        if (!this.isOpen()) {
            int n;
            Object object;
            Object[] objectArray;
            block33: {
                if (this.getConnection() == null) {
                    throw new ModelException("The remote connection to the server IStorage is null!");
                }
                if (this.getName() == null) {
                    throw new ModelException("DataBook Name is null!");
                }
                try {
                    this.initServerMetaData();
                }
                catch (DataSourceException dataSourceException) {
                    if (this.rdRowDefinition != null && this.rdRowDefinition.getColumnCount() != 0) break block33;
                    throw new ModelException("RowDefintion can't init with meta data from storage!", dataSourceException);
                }
            }
            if (this.mdMetaData != null) {
                int n2;
                if (!this.mdMetaData.isSupported(MetaData.Feature.Filter)) {
                    this.setMemFilter(true);
                }
                if (!this.mdMetaData.isSupported(MetaData.Feature.Sort)) {
                    this.setMemSort(true);
                }
                if (!this.mdMetaData.isSupported(MetaData.Feature.WriteBack)) {
                    this.setWritebackEnabled(false);
                }
                objectArray = this.mdMetaData.getColumnMetaData();
                this.saMetaDataColumnNames = new String[objectArray.length];
                if (this.rdRowDefinition == null) {
                    this.rdRowDefinition = new RowDefinition();
                }
                object = new HashMap();
                n = RemoteDataSource.getMetaDataCacheRole() != RemoteDataSource.MetaDataCacheRole.Off && this.getDataSource().getMetaDataCacheOption() != MetaDataCacheOption.Off ? 1 : 0;
                String string = this.getName();
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (this.rdRowDefinition.getColumnDefinitionIndex(((ColumnMetaData)objectArray[n2]).getName()) < 0) {
                        StorageReferenceDefinition storageReferenceDefinition;
                        ColumnDefinition columnDefinition = ColumnMetaData.createColumnDefinition((ColumnMetaData)objectArray[n2]);
                        columnDefinition.setWritable(true);
                        this.rdRowDefinition.addColumnDefinition(columnDefinition);
                        if (UIFactoryManager.getFactory() != null && (storageReferenceDefinition = ((ColumnMetaData)objectArray[n2]).getLinkReference()) != null) {
                            Object object2;
                            String string2 = storageReferenceDefinition.getReferencedStorage();
                            if (string2.startsWith(".")) {
                                string2 = string + string2;
                            }
                            RemoteDataBook remoteDataBook = this.getDataBookForLinkedCellEditor(storageReferenceDefinition, (HashMap<String, RemoteDataBook>)object, n != 0);
                            ColumnView columnView = new ColumnView(new String[0]);
                            int n3 = storageReferenceDefinition.getReferencedColumnNames().length;
                            for (int i = 0; i < n3; ++i) {
                                object2 = storageReferenceDefinition.getReferencedColumnNames()[i];
                                if (ArrayUtil.contains(remoteDataBook.getRowDefinition().getPrimaryKeyColumnNames(), object2) || RowDefinition.isColumnIgnored((String)object2) || remoteDataBook.getRowDefinition().getColumnDefinition((String)object2).getDataType().getTypeIdentifier() == -2) continue;
                                columnView.addColumnNames(new String[]{object2});
                            }
                            if (columnView.getColumnCount() == 0) {
                                String[] stringArray = remoteDataBook.mdMetaData.getRepresentationColumnNames();
                                for (n3 = 0; n3 < stringArray.length; ++n3) {
                                    if (columnView.getColumnNameIndex(stringArray[n3]) >= 0) continue;
                                    columnView.addColumnNames(stringArray[n3]);
                                }
                            }
                            ReferenceDefinition referenceDefinition = new ReferenceDefinition();
                            referenceDefinition.setReferencedDataBook(remoteDataBook);
                            referenceDefinition.setReferencedColumnNames(storageReferenceDefinition.getReferencedColumnNames());
                            referenceDefinition.setColumnNames(storageReferenceDefinition.getColumnNames());
                            UILinkedCellEditor uILinkedCellEditor = new UILinkedCellEditor();
                            uILinkedCellEditor.setLinkReference(referenceDefinition);
                            uILinkedCellEditor.setColumnView(columnView);
                            uILinkedCellEditor.setValidationEnabled(!(columnDefinition.getDataType() instanceof StringDataType) || !((ColumnMetaData)objectArray[n2]).isWritable());
                            object2 = new ArrayUtil();
                            ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
                            String[] stringArray = referenceDefinition.getColumnNames();
                            int n4 = objectArray.length;
                            for (int i = 0; i < n4; ++i) {
                                String[] stringArray2;
                                StorageReferenceDefinition storageReferenceDefinition2 = ((ColumnMetaData)objectArray[i]).getLinkReference();
                                if (storageReferenceDefinition2 == null || (stringArray2 = storageReferenceDefinition2.getColumnNames()).length >= stringArray.length || !ArrayUtil.containsAll(stringArray, stringArray2)) continue;
                                for (int j = 0; j < stringArray2.length; ++j) {
                                    if (((ArrayUtil)object2).contains(stringArray2[j])) continue;
                                    ((ArrayUtil)object2).add(stringArray2[j]);
                                    arrayUtil.add(referenceDefinition.getReferencedColumnName(stringArray2[j]));
                                }
                            }
                            if (((ArrayUtil)object2).size() > 0) {
                                uILinkedCellEditor.setSearchColumnMapping(new ColumnMapping(((ArrayUtil)object2).toArray(new String[((ArrayUtil)object2).size()]), arrayUtil.toArray(new String[arrayUtil.size()])));
                            }
                            if (columnDefinition.getDataType() instanceof BigDecimalDataType) {
                                uILinkedCellEditor.setHorizontalAlignment(2);
                            }
                            columnDefinition.getDataType().setCellEditor(uILinkedCellEditor);
                        }
                    } else {
                        this.rdRowDefinition.getColumnDefinition(((ColumnMetaData)objectArray[n2]).getName()).setWritable(true);
                    }
                    this.saMetaDataColumnNames[n2] = ((ColumnMetaData)objectArray[n2]).getName();
                }
                this.iaFetchColumnIndexes = new int[objectArray.length];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    this.iaFetchColumnIndexes[n2] = this.rdRowDefinition.getColumnDefinitionIndex(((ColumnMetaData)objectArray[n2]).getName());
                }
                if (this.rdRowDefinition.getPrimaryKeyColumnNames() == null) {
                    String[] stringArray = this.mdMetaData.getPrimaryKeyColumnNames();
                    if (stringArray == null) {
                        this.setWritebackEnabled(false);
                    } else {
                        this.rdRowDefinition.setPrimaryKeyColumnNames(stringArray);
                    }
                }
            }
            if (this.saBlockFetchColumnNames == null) {
                this.iaMasterColumnIndexes = null;
                this.saBlockFetchReferencedColumnNames = null;
            } else {
                if (this.getMasterReference() == null) {
                    throw new ModelException("Block fetch is only allowed if a master reference is set!");
                }
                if (ArrayUtil.containsAll(this.getMasterReference().getColumnNames(), this.saBlockFetchColumnNames)) {
                    objectArray = this.getMasterReference().getColumnNames();
                    object = this.getMasterReference().getReferencedColumnNames();
                    this.iaMasterColumnIndexes = new int[objectArray.length];
                    for (n = 0; n < this.iaMasterColumnIndexes.length; n += 1) {
                        this.iaMasterColumnIndexes[n] = this.rdRowDefinition.getColumnDefinitionIndex((String)objectArray[n]);
                    }
                    this.saBlockFetchReferencedColumnNames = new String[this.saBlockFetchColumnNames.length];
                    for (n = 0; n < this.saBlockFetchColumnNames.length; n += 1) {
                        this.saBlockFetchReferencedColumnNames[n] = object[ArrayUtil.indexOf(objectArray, this.saBlockFetchColumnNames[n])];
                    }
                } else {
                    throw new ModelException("Block fetch have to be a subset of the master reference columns!");
                }
            }
            super.open();
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            super.close();
            this.htFetchedRowsForBlock = null;
        }
    }

    @Override
    protected void executeLockAndRefetch() throws ModelException {
        if (this.isWritebackEnabled()) {
            try {
                IDataRow iDataRow = this.getOriginalRow();
                if (iDataRow == null) {
                    iDataRow = this.getDataRow(this.getSelectedRow());
                }
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "refetchRow", iDataRow.getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.refetchRow(", this.getName(), ",", iDataRow.getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
                if (objectArray != null) {
                    this.setValuesInternal(this.saMetaDataColumnNames, objectArray);
                }
            }
            catch (Throwable throwable) {
                throw new ModelException("Execute Lock and Refetch failed!", throwable);
            }
        }
    }

    @Override
    protected void executeInsert() throws ModelException {
        if (this.isWritebackEnabled()) {
            int n = this.getSelectedRow();
            try {
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "insert", this.getDataRow(n).getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.insert(", this.getName(), ",", this.getDataRow(n), ") in ", System.currentTimeMillis() - l, "ms");
                if (objectArray != null) {
                    this.setValuesInternal(this.saMetaDataColumnNames, objectArray);
                }
            }
            catch (Throwable throwable) {
                this.setSelectedRow(n);
                throw new ModelException("Execute Insert failed!", throwable);
            }
        }
    }

    @Override
    protected void executeUpdate() throws ModelException {
        if (this.isWritebackEnabled()) {
            int n = this.getSelectedRow();
            try {
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "update", this.getOriginalRow().getValues(this.saMetaDataColumnNames), this.getDataRow(n).getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.update(", this.getName(), ",", this.getOriginalRow(), ",", this.getDataRow(n), ") in ", System.currentTimeMillis() - l, "ms");
                if (objectArray != null) {
                    this.setValuesInternal(this.saMetaDataColumnNames, objectArray);
                }
            }
            catch (Throwable throwable) {
                this.setSelectedRow(n);
                throw new ModelException("Execute Update failed!", throwable);
            }
        }
    }

    @Override
    protected void executeDelete() throws ModelException {
        if (this.isWritebackEnabled()) {
            int n = this.getSelectedRow();
            try {
                long l = System.currentTimeMillis();
                this.getConnection().call(this.getName(), "delete", this.getOriginalRow().getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.delete(", this.getName(), ",", this.getOriginalRow().getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
            }
            catch (Throwable throwable) {
                this.setSelectedRow(n);
                throw new ModelException("Execute Delete failed!", throwable);
            }
        }
    }

    @Override
    protected void executeRefresh() throws ModelException {
        super.clear();
        this.htFetchedRowsForBlock = null;
    }

    @Override
    public void setMemSort(boolean bl) {
        if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.Sort)) {
            return;
        }
        super.setMemSort(bl);
    }

    @Override
    public boolean isMemSort() {
        return super.isMemSort();
    }

    @Override
    public void setMemFilter(boolean bl) {
        if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.Filter)) {
            return;
        }
        super.setMemFilter(bl);
    }

    @Override
    public boolean isMemFilter() {
        return super.isMemFilter();
    }

    @Override
    public void setWritebackEnabled(boolean bl) {
        if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.WriteBack)) {
            return;
        }
        super.setWritebackEnabled(bl);
    }

    @Override
    public boolean isWritebackEnabled() {
        return super.isWritebackEnabled();
    }

    private RemoteDataBook getDataBookForLinkedCellEditor(StorageReferenceDefinition storageReferenceDefinition, HashMap<String, RemoteDataBook> hashMap, boolean bl) throws ModelException {
        String string = storageReferenceDefinition.getReferencedStorage();
        String string2 = string.startsWith(".") ? this.getName() + string : string;
        IDataBook[] iDataBookArray = this.getDataSource().getDataBooks();
        RemoteDataBook remoteDataBook = hashMap.get(string);
        if (remoteDataBook == null) {
            String[] stringArray;
            if (bl) {
                for (int i = 0; remoteDataBook == null && i < iDataBookArray.length; ++i) {
                    stringArray = iDataBookArray[i];
                    if (!(stringArray instanceof RemoteDataBook) || !stringArray.getName().equals(string2)) continue;
                    remoteDataBook = (RemoteDataBook)stringArray;
                }
            }
            if (remoteDataBook == null) {
                RemoteDataBook remoteDataBook2 = new RemoteDataBook();
                remoteDataBook2.setDataSource(this.getDataSource());
                remoteDataBook2.setName(string2);
                remoteDataBook2.setSelectionMode(IDataBook.SelectionMode.DESELECTED);
                remoteDataBook2.open();
                if (bl) {
                    stringArray = remoteDataBook2.getRowDefinition().getColumnNames();
                    for (int i = 0; remoteDataBook == null && i < iDataBookArray.length; ++i) {
                        IDataBook iDataBook = iDataBookArray[i];
                        String[] stringArray2 = iDataBook.getRowDefinition().getColumnNames();
                        if (!(iDataBook instanceof RemoteDataBook) || !iDataBook.getName().endsWith(string) || !ArrayUtil.containsAll(stringArray, stringArray2) || !ArrayUtil.containsAll(stringArray2, stringArray)) continue;
                        remoteDataBook = (RemoteDataBook)iDataBook;
                    }
                }
                if (remoteDataBook == null) {
                    remoteDataBook = remoteDataBook2;
                } else {
                    remoteDataBook2.close();
                }
            }
            hashMap.put(string, remoteDataBook);
        }
        return remoteDataBook;
    }

    public String[] getBlockFetchColumnNames() {
        return this.saBlockFetchColumnNames;
    }

    public void setBlockFetchColumnNames(String[] stringArray) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.saBlockFetchColumnNames = stringArray;
    }

    public void setMetaDataCacheEnabled(boolean bl) {
        this.bMetaDataCacheEnabled = bl;
    }

    public boolean isMetaDataCacheEnabled() {
        return this.bMetaDataCacheEnabled;
    }

    private void initServerMetaData() throws DataSourceException {
        block10: {
            try {
                RemoteDataSource remoteDataSource = this.getDataSource();
                String string = remoteDataSource.getConnection().getLifeCycleName();
                String string2 = this.getName();
                String string3 = string + "." + string2;
                this.mdMetaData = this.bMetaDataCacheEnabled ? remoteDataSource.getMetaData(string3) : null;
                if (this.mdMetaData == null) {
                    Boolean bl = htCachingStorage.get(string3);
                    this.bCachingStorage = bl != null ? bl : true;
                    long l = System.currentTimeMillis();
                    if (this.bCachingStorage) {
                        try {
                            Hashtable hashtable;
                            Object[] objectArray = this.getConnection().call(new String[]{string2, string2}, new String[]{"getMetaData", "getMetaDataFromCache"}, new Object[][]{{string, string2}, {string}});
                            this.mdMetaData = (MetaData)objectArray[0];
                            if (this.bMetaDataCacheEnabled && (hashtable = (Hashtable)objectArray[1]) != null) {
                                for (Map.Entry entry : hashtable.entrySet()) {
                                    remoteDataSource.putMetaData((String)entry.getKey(), (MetaData)entry.getValue());
                                }
                            }
                            logger.debug("getMetaDataFromCache(", string, ", ", string2, ") in ", System.currentTimeMillis() - l, "ms");
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            this.bCachingStorage = false;
                        }
                    }
                    if (!this.bCachingStorage) {
                        this.mdMetaData = (MetaData)this.getConnection().call(string2, "getMetaData");
                        if (this.bMetaDataCacheEnabled) {
                            remoteDataSource.putMetaData(string3, this.mdMetaData);
                        }
                        logger.debug("getMetaData(", string2, ") in ", System.currentTimeMillis() - l, "ms");
                    }
                    htCachingStorage.put(string3, this.bCachingStorage);
                    break block10;
                }
                logger.debug("use cached metadata: ", string2);
            }
            catch (Throwable throwable) {
                throw new DataSourceException("Init ServerMetaData failed!", throwable);
            }
        }
    }

    protected String[] getMetaDataColumnNames() {
        return this.saMetaDataColumnNames;
    }

    protected int[] getFetchColumnIndexes() {
        return this.iaFetchColumnIndexes;
    }

    protected int[] getMasterColumnIndexesForBlock() {
        return this.iaMasterColumnIndexes;
    }

    protected int getFetchedRowsForBlock(IDataRow iDataRow) throws ModelException {
        if (this.htFetchedRowsForBlock == null) {
            return 0;
        }
        Integer n = this.htFetchedRowsForBlock.get(iDataRow.createDataRow(this.saBlockFetchReferencedColumnNames));
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected void setFetchedRowsForBlock(IDataRow iDataRow, int n) throws ModelException {
        if (this.htFetchedRowsForBlock == null) {
            this.htFetchedRowsForBlock = new Hashtable();
        }
        this.htFetchedRowsForBlock.put(iDataRow.createDataRow(this.saBlockFetchReferencedColumnNames), n);
    }

    protected AbstractConnection getConnection() {
        RemoteDataSource remoteDataSource = this.getDataSource();
        if (remoteDataSource == null) {
            return null;
        }
        return remoteDataSource.getConnection();
    }

    protected boolean isCachingStorage() {
        return this.bCachingStorage;
    }
}

