/*
 * Copyright 2014 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 27.03.2014 - [HM] - creation
 */
package javax.rad.genui.celleditor;

import javax.rad.genui.UIFactoryManager;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.ui.celleditor.ICheckBoxCellEditor;

/**
 * Platform and technology independent check box editor.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public class UICheckBoxCellEditor extends UICellEditor<ICheckBoxCellEditor>
                                  implements ICheckBoxCellEditor
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UICheckBoxCellEditor</code>.
     *
     * @see ICheckBoxCellEditor
     */
	public UICheckBoxCellEditor()
	{
		super(UIFactoryManager.getFactory().createCheckBoxCellEditor());
	}

    /**
     * Creates a new instance of <code>UICheckBoxCellEditor</code> with the given
     * choice cell editor.
     * 
     * @param pEditor the choice cell editor
     * @see ICheckBoxCellEditor
     */
	protected UICheckBoxCellEditor(ICheckBoxCellEditor pEditor)
	{
		super(pEditor);
	}
	
	/**
	 * Creates a new instance of <code>UICheckBoxCellEditor</code> with the given selected and deselected values.
	 * 
	 * @param pSelectedValue the selected value.
	 * @param pDeselectedValue the deselected value.
	 */
	public UICheckBoxCellEditor(Object pSelectedValue, Object pDeselectedValue)
	{
		super(UIFactoryManager.getFactory().createCheckBoxCellEditor());
		
		getResource().setSelectedValue(pSelectedValue);
		getResource().setDeselectedValue(pDeselectedValue);
	}

	/**
	 * Creates a new instance of <code>UICheckBoxCellEditor</code> with the given selected and deselected values.
	 * 
	 * @param pSelectedValue the selected value.
	 * @param pDeselectedValue the deselected value.
	 * @param pText the text.
	 */
	public UICheckBoxCellEditor(Object pSelectedValue, Object pDeselectedValue, String pText)
	{
		super(UIFactoryManager.getFactory().createCheckBoxCellEditor());
		
		getResource().setSelectedValue(pSelectedValue);
		getResource().setDeselectedValue(pDeselectedValue);
		getResource().setText(pText);
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	public Object getSelectedValue() 
	{
		return getResource().getSelectedValue();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setSelectedValue(Object pSelectedValue)
	{
		getResource().setSelectedValue(pSelectedValue);
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getDeselectedValue() 
	{
		return getResource().getDeselectedValue();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setDeselectedValue(Object pDeselectedValue)
	{
		getResource().setDeselectedValue(pDeselectedValue);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getText()
	{
		return getResource().getText();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setText(String pText)
	{
		getResource().setText(pText);
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getCellRendererComponent(Object pParentComponent, 
			                               IDataPage pDataPage, 
			                               int pRowNumber, 
			                               IDataRow pDataRow, 
			                               String pColumnName, 
			                               boolean pIsSelected, 
			                               boolean pHasFocus)
	{
		return getResource().getCellRendererComponent(pParentComponent, pDataPage, pRowNumber, pDataRow, pColumnName, pIsSelected, pHasFocus);
	}

}	// UICheckBoxCellEditor
