/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 09.05.2009 - [JR] - creation
 * 18.11.2010 - [JR] - #206: removed constructors
 */
package com.sibvisions.rad.server.config;

import java.io.File;

/**
 * The <code>ServerZone</code> class encapsulates the access to
 * the server configuration.
 *  
 * @author Ren Jahn
 */
public class ServerZone extends Zone
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>ServerZone</code>.
	 * The server configuration will be used from the cached zone. The cache
	 * for all zones is the {@link Configuration}.
	 * 
	 * @throws Exception if the server zone has errors
	 */
	public ServerZone() throws Exception
	{
		super(Configuration.getServerZone().getDirectory());
	}
	
	/**
	 * Creates a new instance of <code>Zone</code> for a directory.
	 * 
	 * @param pDirectory the zone directory
	 * @throws Exception if the configuration for the zone is invalid
	 */
	ServerZone(File pDirectory) throws Exception
	{
		super(pDirectory);
	}

}	// ServerZone
