/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.Internalize;
import com.sibvisions.util.type.DateUtil;
import java.sql.Timestamp;
import java.util.Date;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;

public class TimestampDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = 93;
    private static final String FORMAT = "0000-01-01 00:00:00.000000000";
    private DateUtil dateUtil = new DateUtil();

    public int getTypeIdentifier() {
        return 93;
    }

    public Class getTypeClass() {
        return Timestamp.class;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.dateUtil.format((Date)object);
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        return Internalize.intern(this.convertToTypeClass(object));
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return object;
        }
        if (object instanceof Number) {
            return new Timestamp(((Number)object).longValue());
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            try {
                return Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                try {
                    return new Timestamp(this.dateUtil.parse(string).getTime());
                }
                catch (Exception exception2) {
                    if (string.length() < FORMAT.length()) {
                        string = string.concat(FORMAT.substring(string.length()));
                    }
                    return Timestamp.valueOf(string);
                }
            }
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public int getSize() {
        return FORMAT.length();
    }

    public TimestampDataType clone() {
        return (TimestampDataType)super.clone();
    }

    public String getDateFormat() {
        return this.dateUtil.getDatePattern();
    }

    public void setDateFormat(String string) {
        this.dateUtil.setDatePattern(string);
    }
}

