/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;

public class BooleanDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = 16;

    public int getTypeIdentifier() {
        return 16;
    }

    public Class getTypeClass() {
        return Boolean.class;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        Boolean bl = (Boolean)this.convertToTypeClass(object);
        if (bl == null) {
            return null;
        }
        return bl != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue() != 0;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return Boolean.valueOf(string);
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public int getSize() {
        return 1;
    }

    public BooleanDataType clone() {
        return (BooleanDataType)super.clone();
    }
}

