/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.condition;

import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;

public abstract class CompareCondition
extends BaseCondition {
    private Object oValue;
    private String sColumnName;
    private boolean bIgnoreNull;
    private transient IDataRow drDataRow;
    private transient String sDataRowColumnName;
    private transient IRowDefinition lastRowDefinition;
    private transient IDataType lastDataType;
    private transient int lastColumnIndex;

    public CompareCondition() {
    }

    public CompareCondition(String string, Object object) {
        this(string, object, false);
    }

    public CompareCondition(String string, Object object, boolean bl) {
        this.oValue = object;
        this.sColumnName = string;
        this.bIgnoreNull = bl;
        this.drDataRow = null;
        this.sDataRowColumnName = string;
    }

    public CompareCondition(IDataRow iDataRow, String string) {
        this(iDataRow, string, string, true);
    }

    public CompareCondition(IDataRow iDataRow, String string, boolean bl) {
        this(iDataRow, string, string, bl);
    }

    public CompareCondition(IDataRow iDataRow, String string, String string2) {
        this(iDataRow, string, string2, true);
    }

    public CompareCondition(IDataRow iDataRow, String string, String string2, boolean bl) {
        this.oValue = null;
        this.drDataRow = iDataRow;
        this.sDataRowColumnName = string;
        this.sColumnName = string2;
        this.bIgnoreNull = bl;
    }

    protected abstract boolean isFulfilled(IDataType var1, Object var2);

    public boolean isFulfilled(IDataRow iDataRow) {
        if (this.bIgnoreNull && this.getValue() == null) {
            return true;
        }
        try {
            if (iDataRow.getRowDefinition() != this.lastRowDefinition) {
                this.lastRowDefinition = iDataRow.getRowDefinition();
                this.lastColumnIndex = this.lastRowDefinition.getColumnDefinitionIndex(this.sColumnName);
                this.lastDataType = this.lastColumnIndex < 0 ? null : this.lastRowDefinition.getColumnDefinition(this.lastColumnIndex).getDataType();
            }
            if (this.lastDataType == null) {
                return false;
            }
            return this.isFulfilled(this.lastDataType, iDataRow.getValue(this.lastColumnIndex));
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public ICondition clone() {
        CompareCondition compareCondition = (CompareCondition)super.clone();
        compareCondition.drDataRow = null;
        compareCondition.sDataRowColumnName = null;
        compareCondition.oValue = this.getValue();
        return compareCondition;
    }

    public String getColumnName() {
        return this.sColumnName;
    }

    public void setColumnName(String string) {
        this.sColumnName = string;
    }

    public IDataRow getDataRow() {
        return this.drDataRow;
    }

    public String getDataRowColumnName() {
        return this.sDataRowColumnName;
    }

    public Object getValue() {
        if (this.drDataRow != null) {
            try {
                return this.drDataRow.getValue(this.sDataRowColumnName);
            }
            catch (ModelException modelException) {
                throw new RuntimeException("The DataRow column '" + this.sDataRowColumnName + "' doesn't exist in DataRow - " + this.drDataRow);
            }
        }
        return this.oValue;
    }

    public void setValue(Object object) {
        this.oValue = object;
    }

    public boolean isIgnoreNull() {
        return this.bIgnoreNull;
    }

    public void setIgnoreNull(boolean bl) {
        this.bIgnoreNull = bl;
    }
}

