/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.xml;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CodecUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XmlWorker
extends DefaultHandler
implements LexicalHandler {
    private XmlNode xmnStart = null;
    private Locator locator = null;
    private ArrayUtil<Element> auTags = null;
    private ArrayUtil<Boolean> auBreak = null;
    private List<XmlNode> liNamespaces = null;
    private String sSchema = null;
    private StringBuilder sbValueTrim = null;
    private List<String> liEncryptedNodes = null;
    private int iIndentation = 2;
    private boolean bValidation = false;
    private boolean bInsertNewLines = false;
    private boolean bCreateDeclaration = true;
    private boolean bAutoDecrypt = false;

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        XmlNode xmlNode = new XmlNode(0, "comment");
        xmlNode.setLineNumber(this.locator.getLineNumber());
        xmlNode.setColumnNumber(this.locator.getColumnNumber());
        if (n2 > 0) {
            String string = new String(cArray, n, n2);
            xmlNode.setValue(this.trimValue(string, true));
        }
        this.auTags.get(this.auTags.size() - 1).node.add(xmlNode);
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.auTags.get(0).node.add(XmlNode.createDoctype(string, string2, string3));
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.bValidation) {
            throw sAXParseException;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.bValidation) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.bValidation) {
            throw sAXParseException;
        }
    }

    public void startDocument() {
        if (this.bCreateDeclaration) {
            XmlNode xmlNode = XmlNode.createXmlDeclaration();
            this.auTags = new ArrayUtil();
            this.auTags.add(new Element(xmlNode));
        }
        this.auBreak = new ArrayUtil();
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        XmlNode xmlNode = new XmlNode(string3);
        int n = this.locator.getLineNumber();
        int n2 = this.locator.getColumnNumber();
        xmlNode.setLineNumber(n);
        xmlNode.setColumnNumber(n2);
        if (this.xmnStart == null) {
            if (this.auTags != null) {
                this.xmnStart = this.auTags.get(0).node;
            } else {
                this.xmnStart = xmlNode;
                this.auTags = new ArrayUtil();
                this.auTags.add(new Element(this.xmnStart));
            }
        }
        if (this.liNamespaces != null) {
            for (XmlNode xmlNode2 : this.liNamespaces) {
                xmlNode.add(xmlNode2);
            }
            this.liNamespaces = null;
        }
        int n3 = attributes.getLength();
        for (int i = 0; i < n3; ++i) {
            XmlNode xmlNode3 = new XmlNode(2, attributes.getQName(i));
            String string4 = attributes.getValue(i);
            if (string4 != null && string4.trim().length() > 0) {
                xmlNode3.setValue(attributes.getValue(i));
            }
            xmlNode3.setLineNumber(n);
            xmlNode3.setColumnNumber(n2);
            xmlNode.add(xmlNode3);
        }
        this.auTags.add(new Element(xmlNode));
        if (!this.auBreak.isEmpty()) {
            this.auBreak.remove(this.auBreak.size() - 1);
            this.auBreak.add(Boolean.TRUE);
        }
        this.auBreak.add(Boolean.FALSE);
    }

    public void characters(char[] cArray, int n, int n2) {
        Element element = this.auTags.get(this.auTags.size() - 1);
        StringBuilder stringBuilder = element.value;
        String string = new String(cArray, n, n2);
        boolean bl = this.auBreak.get(this.auBreak.size() - 1);
        if (bl || stringBuilder == null || stringBuilder.length() == 0) {
            this.auBreak.remove(this.auBreak.size() - 1);
            this.auBreak.add(Boolean.FALSE);
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            element.value = stringBuilder;
        }
        stringBuilder.append(string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = this.auTags.size() - 1;
        Element element = this.auTags.get(n);
        XmlNode xmlNode = element.node;
        StringBuilder stringBuilder = element.value;
        if (stringBuilder != null) {
            stringBuilder = new StringBuilder(stringBuilder.toString().trim());
            for (int i = 0; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (c != '\n') continue;
                int n2 = stringBuilder.length();
                for (int j = i; j < n2; ++j) {
                    if (Character.isWhitespace(stringBuilder.charAt(j))) continue;
                    if (j - i > 1) {
                        stringBuilder = stringBuilder.replace(i, j, "\n ");
                        ++i;
                    }
                    j = n2;
                }
            }
            if (stringBuilder.length() > 0) {
                xmlNode.setValue(stringBuilder.toString());
            }
        }
        if (string3.equals(xmlNode.getName())) {
            this.auTags.remove(element);
            XmlNode xmlNode2 = this.auTags.get(n - 1).node;
            if (xmlNode2 != xmlNode) {
                xmlNode2.add(xmlNode);
            }
        } else {
            throw new SAXException("Element '" + string3 + "' was not closed!");
        }
        this.auBreak.remove(this.auBreak.size() - 1);
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.liNamespaces == null) {
            this.liNamespaces = new ArrayUtil<XmlNode>();
        }
        String string3 = string != null && string.length() > 0 ? "xmlns:" + string : "xmlns";
        this.liNamespaces.add(new XmlNode(2, string3, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode read(File file) throws SAXException, IOException, ParserConfigurationException {
        XmlNode xmlNode;
        block5: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                xmlNode = this.read(fileInputStream);
                Object var5_4 = null;
                if (fileInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (fileInputStream == null) break block6;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return xmlNode;
    }

    public XmlNode read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        this.locator = null;
        this.xmnStart = null;
        this.auTags = null;
        this.auBreak = null;
        this.sbValueTrim = null;
        sAXParserFactory.setNamespaceAware(true);
        if (this.bValidation) {
            if (this.sSchema != null) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource streamSource = new StreamSource(ResourceUtil.getResourceAsStream(this.sSchema));
                sAXParserFactory.setSchema(schemaFactory.newSchema(streamSource));
            } else {
                sAXParserFactory.setValidating(true);
            }
        } else {
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        if (this.bValidation && this.sSchema == null) {
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        sAXParser.parse(inputStream, (DefaultHandler)this);
        return this.decrypt(this.xmnStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file, XmlNode xmlNode) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.write(fileOutputStream, xmlNode);
            Object var5_4 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {}
    }

    public void write(OutputStream outputStream, XmlNode xmlNode) throws IOException {
        XmlNode xmlNode2;
        XmlNode xmlNode3 = null;
        if (this.liEncryptedNodes != null && !this.liEncryptedNodes.isEmpty()) {
            try {
                xmlNode2 = (XmlNode)xmlNode.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        } else {
            xmlNode2 = xmlNode;
        }
        if (xmlNode.getType() != -1) {
            xmlNode3 = XmlNode.createXmlDeclaration();
            xmlNode3.add(xmlNode2);
        } else {
            xmlNode3 = xmlNode2;
        }
        this.encrypt(xmlNode3);
        xmlNode3.createXml(outputStream, this.iIndentation, this.bInsertNewLines);
        if (xmlNode2.getType() != -1) {
            xmlNode3.remove(xmlNode2);
        }
    }

    public void setIndentation(int n) {
        this.iIndentation = n;
    }

    public int getIndentation() {
        return this.iIndentation;
    }

    private String trimValue(String string, boolean bl) {
        ArrayUtil<String> arrayUtil;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (bl && !(arrayUtil = StringUtil.separateList(string, "\n", true)).isEmpty()) {
            if (this.sbValueTrim == null) {
                this.sbValueTrim = new StringBuilder();
            } else {
                this.sbValueTrim.setLength(0);
            }
            int n = arrayUtil.size();
            for (int i = 0; i < n; ++i) {
                String string2 = arrayUtil.get(i);
                if (this.sbValueTrim.length() > 0) {
                    this.sbValueTrim.append("\n");
                }
                this.sbValueTrim.append(string2);
            }
            string = this.sbValueTrim.toString();
            this.sbValueTrim.setLength(0);
        }
        return string;
    }

    public void setSchema(String string) {
        this.sSchema = string;
    }

    public String getSchema() {
        return this.sSchema;
    }

    public void setValidationEnabled(boolean bl) {
        this.bValidation = bl;
    }

    public boolean isValidationEnabled() {
        return this.bValidation;
    }

    public void setInsertNewLines(boolean bl) {
        this.bInsertNewLines = bl;
    }

    public boolean isInsertNewLines() {
        return this.bInsertNewLines;
    }

    public void setEncrypted(String string, boolean bl) {
        if (bl) {
            if (this.liEncryptedNodes == null) {
                this.liEncryptedNodes = new ArrayUtil<String>();
            }
            if (this.liEncryptedNodes.indexOf(string) < 0) {
                this.liEncryptedNodes.add(string);
            }
        } else {
            this.liEncryptedNodes.remove(string);
            if (this.liEncryptedNodes.isEmpty()) {
                this.liEncryptedNodes = null;
            }
        }
    }

    public boolean isEncrypted(String string) {
        return this.liEncryptedNodes != null && this.liEncryptedNodes.contains(string);
    }

    public void setAutomaticDecrypt(boolean bl) {
        this.bAutoDecrypt = bl;
    }

    public boolean isAutomaticDecrypt() {
        return this.bAutoDecrypt;
    }

    private XmlNode encrypt(XmlNode xmlNode) {
        XmlNode xmlNode2;
        List<XmlNode> list = xmlNode.getSubNodes();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                xmlNode2 = list.get(i);
                this.encrypt(xmlNode2);
            }
        }
        if (this.liEncryptedNodes != null && xmlNode.getType() != -1 && this.liEncryptedNodes.contains(xmlNode.getFullName())) {
            xmlNode2 = new XmlNode(1, xmlNode.getName(), this.encrypt(xmlNode.toString()));
            xmlNode2.add(new XmlNode(2, "encrypted", "true"));
            XmlNode.replace(xmlNode, xmlNode2);
            return xmlNode2;
        }
        return xmlNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlNode decrypt(XmlNode xmlNode) throws IOException, SAXException, ParserConfigurationException {
        Object object;
        int n;
        List<XmlNode> list = xmlNode.getSubNodes();
        if (list != null) {
            n = list.size();
            for (int i = 0; i < n; ++i) {
                object = list.get(i);
                this.decrypt((XmlNode)object);
            }
        }
        if (xmlNode.getType() != -1 && Boolean.valueOf(xmlNode.getNodeValue("/encrypted")).booleanValue() && (this.bAutoDecrypt || this.liEncryptedNodes != null && this.liEncryptedNodes.contains(xmlNode.getFullName())) && (object = this.decrypt(xmlNode.getValue())) != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
            n = this.bCreateDeclaration ? 1 : 0;
            try {
                this.bCreateDeclaration = false;
                XmlNode xmlNode2 = this.read(byteArrayInputStream);
                XmlNode.replace(xmlNode, xmlNode2);
                XmlNode xmlNode3 = xmlNode2;
                Object var9_9 = null;
                this.bCreateDeclaration = n;
                return xmlNode3;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.bCreateDeclaration = n;
                throw throwable;
            }
        }
        return xmlNode;
    }

    private String encrypt(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes("UTF-8"));
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return CodecUtil.encodeHex(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String decrypt(String string) {
        try {
            byte[] byArray = CodecUtil.decodeHexAsBytes(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            return new String(FileUtil.getContent(gZIPInputStream, true), "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class Element {
        private XmlNode node;
        private StringBuilder value = null;

        private Element(XmlNode xmlNode) {
            this.node = xmlNode;
        }
    }
}

