/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.LocaleUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.WeakHashMap;

public class NumberUtil {
    private static final String DEFAULT_NUMBER_FORMAT = "#.######################################";
    private static WeakHashMap<Locale, DecimalFormatSymbols> decimalFormatSymbolsCache = new WeakHashMap();
    private Locale creationLocale = null;
    private String creationPattern = null;
    private DecimalFormat numberFormat;

    public NumberUtil() {
        this.setNumberFormat(null);
    }

    public NumberUtil(NumberFormat numberFormat) {
        this.setNumberFormat(numberFormat);
    }

    public NumberUtil(String string) {
        this.setNumberPattern(string);
    }

    public Number parse(String string) throws ParseException {
        if (string == null || string.length() == 0 || "-".equals(string)) {
            return null;
        }
        if (this.creationLocale != null) {
            this.setNumberFormatIntern(LocaleUtil.getDefault(), this.creationPattern);
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.numberFormat.parse(string, parsePosition);
        if (parsePosition.getIndex() < string.length()) {
            try {
                number = new BigDecimal(string.replace(this.numberFormat.getDecimalFormatSymbols().getDecimalSeparator(), '.'));
            }
            catch (Exception exception) {
                throw new ParseException(string, parsePosition.getIndex());
            }
        }
        return number;
    }

    public String format(Number number) {
        if (number == null) {
            return null;
        }
        if (this.creationLocale != null) {
            this.setNumberFormatIntern(LocaleUtil.getDefault(), this.creationPattern);
        }
        return this.numberFormat.format(number);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    private DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = decimalFormatSymbolsCache.get(locale);
        if (decimalFormatSymbols == null) {
            decimalFormatSymbols = new DecimalFormatSymbols(locale);
            decimalFormatSymbolsCache.put(locale, decimalFormatSymbols);
        }
        return decimalFormatSymbols;
    }

    private void setNumberFormatIntern(Locale locale, String string) {
        if (locale != this.creationLocale || !string.equals(this.creationPattern)) {
            this.numberFormat = new DecimalFormat(string, this.getDecimalFormatSymbols(locale));
            this.creationLocale = locale;
            this.creationPattern = string;
        }
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            this.setNumberFormatIntern(LocaleUtil.getDefault(), DEFAULT_NUMBER_FORMAT);
        } else if (numberFormat instanceof DecimalFormat) {
            this.numberFormat = (DecimalFormat)numberFormat;
            this.creationLocale = null;
            this.creationPattern = null;
        } else {
            throw new IllegalArgumentException("Only DecimalFormat is supported!");
        }
        this.numberFormat.setParseBigDecimal(true);
    }

    public String getNumberPattern() {
        return this.numberFormat.toPattern();
    }

    public void setNumberPattern(String string) {
        if (string == null) {
            this.setNumberFormat(null);
        } else {
            this.setNumberFormatIntern(LocaleUtil.getDefault(), string);
        }
    }

    public static String format(Number number, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(number);
    }
}

