/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.db;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.db.ICommand;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBImporter {
    private ILogger log = LoggerFactory.getInstance(DBImporter.class);
    private List<Exception> liExceptions = new ArrayUtil<Exception>();
    private HashMap<String, Object> hmpParameters = new HashMap();
    private boolean bCancelOnFailure = true;

    public List<DBStatement> list(InputStream inputStream) throws Exception {
        DBStatement dBStatement;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<DBStatement> arrayList = new ArrayList<DBStatement>();
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!((string = string.trim()).length() <= 0 || string.startsWith("--") || string.startsWith("#") || string.startsWith("//"))) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            if (("".equals(string) || string.endsWith(";")) && stringBuilder.length() > 0) {
                dBStatement = this.createDBStatement(stringBuilder.toString());
                if (dBStatement != null) {
                    arrayList.add(dBStatement);
                }
                stringBuilder.setLength(0);
            }
            string = bufferedReader.readLine();
        }
        if (stringBuilder.length() > 0 && (dBStatement = this.createDBStatement(stringBuilder.toString())) != null) {
            arrayList.add(dBStatement);
        }
        return arrayList;
    }

    public boolean execute(Connection connection, InputStream inputStream) throws Exception {
        this.liExceptions.clear();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        boolean bl = true;
        while (string != null) {
            if (!((string = string.trim()).length() <= 0 || string.startsWith("--") || string.startsWith("#") || string.startsWith("//"))) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            if (("".equals(string) || string.endsWith(";")) && stringBuilder.length() > 0) {
                bl &= this.executeStatement(connection, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            string = bufferedReader.readLine();
        }
        if (stringBuilder.length() > 0) {
            bl &= this.executeStatement(connection, stringBuilder.toString());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeStatement(Connection connection, String string) throws Exception {
        int n;
        DBStatement dBStatement = this.createDBStatement(string);
        if (dBStatement == null) {
            return true;
        }
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(dBStatement.statement);
                int n2 = dBStatement.params.size();
                for (n = 0; n < n2; ++n) {
                    Object object = dBStatement.params.get(n);
                    if (object instanceof InputStream) {
                        Object var10_14;
                        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
                        try {
                            preparedStatement.setBinaryStream(n + 1, (InputStream)bufferedInputStream, -1);
                            var10_14 = null;
                        }
                        catch (Throwable throwable) {
                            var10_14 = null;
                            bufferedInputStream.close();
                            throw throwable;
                        }
                        bufferedInputStream.close();
                        continue;
                    }
                    if (object == null) {
                        preparedStatement.setNull(n + 1, 12);
                        continue;
                    }
                    preparedStatement.setObject(n + 1, object);
                }
                if (preparedStatement.execute()) {
                    ResultSet resultSet = preparedStatement.getResultSet();
                    if (dBStatement.returnParameter != null) {
                        if (!resultSet.next()) throw new RuntimeException("Statement '" + dBStatement.statement + "' returned no rows");
                        if (resultSet.getMetaData().getColumnCount() > 1) {
                            this.log.debug("Statement '", dBStatement.statement, "' returned more than one column. We use the first column: '", resultSet.getMetaData().getColumnName(1), "'");
                        }
                        Object object = resultSet.getObject(1);
                        if (resultSet.next()) {
                            throw new RuntimeException("Statement '" + dBStatement.statement + "' returned more than one row");
                        }
                        this.hmpParameters.put(dBStatement.returnParameter, object);
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                n = 1;
                Object var12_16 = null;
                if (preparedStatement == null) return n != 0;
            }
            catch (Exception exception) {
                this.log.error(dBStatement.statement, dBStatement.params, exception);
                this.liExceptions.add(exception);
                if (this.bCancelOnFailure) {
                    throw exception;
                }
                boolean bl = false;
                Object var12_17 = null;
                if (preparedStatement == null) return bl;
                try {
                    preparedStatement.close();
                    return bl;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (preparedStatement == null) throw throwable;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            preparedStatement.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return n != 0;
        }
        preparedStatement.close();
        return n != 0;
    }

    protected DBStatement createDBStatement(String string) throws Exception {
        ICommand iCommand;
        int n;
        char c;
        int n2;
        String string2 = string;
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n3 = 0;
        String string3 = this.getClass().getPackage().getName();
        ArrayUtil<ICommand> arrayUtil = new ArrayUtil<ICommand>();
        while ((n2 = string2.indexOf("(", n3)) >= 0) {
            int n4;
            int n5 = n2;
            int n6 = n3;
            for (n4 = n2 - 1; n4 >= n6; --n4) {
                c = string2.charAt(n4);
                if ((!Character.isWhitespace(c) || c == '\n' || c == '\r') && c != ',') continue;
                n6 = n4 + 1;
                n4 = -1;
            }
            String string4 = string2.substring(n6, n2).trim();
            int n7 = 1;
            n = string2.length();
            for (n4 = n2 + 1; n4 < n; ++n4) {
                c = string2.charAt(n4);
                if (c == '(') {
                    ++n7;
                    continue;
                }
                if (c != ')' || --n7 != 0) continue;
                n2 = n4;
                n4 = n;
            }
            n3 = n2 + 1;
            if (string4.length() > 0) {
                String string5 = string2.substring(n6, n3).trim();
                String string6 = string3 + "." + Character.toUpperCase(string4.charAt(0)) + string4.substring(1) + "Command";
                try {
                    Class<?> clazz = Class.forName(string6);
                    iCommand = (ICommand)clazz.newInstance();
                    iCommand.setCommand(string5);
                    iCommand.setPosition(n6);
                    arrayUtil.add(iCommand);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n3 = n5 + 1;
                    this.log.debug(classNotFoundException);
                }
                catch (Exception exception) {
                    this.log.debug(exception);
                }
                continue;
            }
            n3 = n5 + 1;
        }
        ArrayUtil<Object> arrayUtil2 = new ArrayUtil<Object>();
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (n = arrayUtil.size() - 1; n >= 0; --n) {
            iCommand = (ICommand)arrayUtil.get(n);
            stringBuilder.replace(iCommand.getPosition(), iCommand.getPosition() + iCommand.getCommand().length(), "?");
            arrayUtil2.add(0, iCommand.getValue());
        }
        string2 = stringBuilder.toString().trim();
        String string7 = null;
        if (string2.startsWith("${")) {
            n2 = string2.indexOf("}");
            string7 = string2.substring(0, n2 + 1).trim();
            if ((n2 = string2.indexOf("=", n2 + 1)) < 0) {
                throw new RuntimeException("Can't assign a value to variable '" + string7 + "' without '=' sign!");
            }
            int n8 = string2.length();
            for (int i = n2 + 1; i < n8; ++i) {
                c = string2.charAt(i);
                if (Character.isWhitespace(c)) continue;
                n2 = i;
                i = n8;
            }
            if ("null".equals(string2 = string2.substring(n2))) {
                this.hmpParameters.remove(string7);
                return null;
            }
        }
        for (Map.Entry<String, Object> entry : this.hmpParameters.entrySet()) {
            Object object = entry.getValue();
            String string8 = object == null ? "null" : (object instanceof String ? "'" + object + "'" : object.toString());
            string2 = string2.replace(entry.getKey(), string8);
        }
        DBStatement dBStatement = new DBStatement();
        dBStatement.statement = string2;
        dBStatement.params = arrayUtil2;
        dBStatement.returnParameter = string7;
        return dBStatement;
    }

    public void setCancelOnFailure(boolean bl) {
        this.bCancelOnFailure = bl;
    }

    public boolean isCancelOnFailure() {
        return this.bCancelOnFailure;
    }

    public Exception[] getExceptions() {
        return this.liExceptions.toArray(new Exception[this.liExceptions.size()]);
    }

    public void setParameter(String string, Object object) {
        this.hmpParameters.put("${" + string + "}", object);
    }

    public Object getParameter(String string) {
        return this.hmpParameters.get("${" + string + "}");
    }

    public boolean isParameterSet(String string) {
        return this.hmpParameters.containsKey("${" + string + "}");
    }

    protected static final class DBStatement {
        String statement;
        List<Object> params;
        String returnParameter;

        protected DBStatement() {
        }
    }
}

