/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSearch {
    private ArrayUtil<String> auFoundDirectories = new ArrayUtil();
    private ArrayUtil<String> auFoundFiles = new ArrayUtil();
    private Hashtable<String, List<String>> htDirList = new Hashtable();
    private NamePatternFilter filter = new NamePatternFilter();
    private File fiStartSearch = null;

    public void search(String string, boolean bl, String ... stringArray) {
        this.filter.setPattern(stringArray);
        this.filter.setBasePath(string);
        this.fiStartSearch = new File(string);
        this.searchIntern(this.fiStartSearch, bl);
        this.fiStartSearch = null;
    }

    public void search(File file, boolean bl, String ... stringArray) {
        this.filter.setPattern(stringArray);
        this.filter.setBasePath(file);
        this.fiStartSearch = file;
        this.searchIntern(file, bl);
        this.fiStartSearch = null;
    }

    private void searchIntern(File file, boolean bl) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        if (file.isFile()) {
            return;
        }
        File[] fileArray = file.listFiles(this.filter);
        if (fileArray != null) {
            boolean bl2 = false;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                if (fileArray[i].isDirectory()) {
                    if (this.filter.isAllowed(fileArray[i])) {
                        this.auFoundDirectories.add(fileArray[i].getAbsolutePath());
                    }
                    if (!bl) continue;
                    this.searchIntern(fileArray[i], true);
                    continue;
                }
                if (file != this.fiStartSearch && !bl2 && this.auFoundDirectories.indexOf(file.getAbsolutePath()) < 0) {
                    bl2 = true;
                    this.auFoundDirectories.add(file.getAbsolutePath());
                }
                this.auFoundFiles.add(fileArray[i].getAbsolutePath());
                arrayUtil.add(fileArray[i].getName());
            }
        }
        if ((fileArray == null || fileArray.length == 0) && file != this.fiStartSearch && this.filter.isAllowed(file) && this.auFoundDirectories.indexOf(file.getAbsolutePath()) <= 0) {
            this.auFoundDirectories.add(file.getAbsolutePath());
        }
        if (!arrayUtil.isEmpty()) {
            this.htDirList.put(file.getAbsolutePath(), arrayUtil);
        }
    }

    public void clear() {
        this.auFoundFiles = new ArrayUtil();
        this.auFoundDirectories = new ArrayUtil();
        this.htDirList = new Hashtable();
    }

    public List<String> getFoundFiles() {
        return this.auFoundFiles;
    }

    public List<String> getFoundDirectories() {
        return this.auFoundDirectories;
    }

    public Hashtable<String, List<String>> getFilesPerDirectory() {
        return this.htDirList;
    }

    public Set<String> getHierarchicalDirectoryList() {
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = string.length() - string2.length();
                if (n == 0) {
                    return string.compareTo(string2);
                }
                return n;
            }
        });
        treeSet.addAll(this.auFoundDirectories);
        return treeSet;
    }

    public static File searchFirstFile(File file, String ... stringArray) {
        NamePatternFilter namePatternFilter = new NamePatternFilter();
        namePatternFilter.setBasePath(file);
        namePatternFilter.setPattern(stringArray);
        return FileSearch.searchFirstFileIntern(file, namePatternFilter);
    }

    private static File searchFirstFileIntern(File file, FileFilter fileFilter) {
        if (file.isFile()) {
            return file;
        }
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isFile()) continue;
                return file2;
            }
            for (File file2 : fileArray) {
                if (!file2.isDirectory() || (file2 = FileSearch.searchFirstFileIntern(file2, fileFilter)) == null) continue;
                return file2;
            }
        }
        return null;
    }

    private static final class NamePatternFilter
    implements FileFilter {
        private String sBasePath = null;
        private String[] saInclude = null;
        private String[] saExclude = null;
        private int iBasePathLength;

        private NamePatternFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                if (this.saExclude != null) {
                    String string = file.getAbsolutePath().substring(this.iBasePathLength).replace('\\', '/');
                    for (String string2 : this.saExclude) {
                        if (!StringUtil.like(string, string2)) continue;
                        return false;
                    }
                }
                return true;
            }
            return this.isAllowed(file);
        }

        public void setPattern(String ... stringArray) {
            ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            if (stringArray == null || stringArray.length == 0) {
                this.saInclude = new String[]{"*"};
                return;
            }
            for (String string : stringArray) {
                if (string == null || string.length() == 0) {
                    arrayUtil.add("*");
                    continue;
                }
                if (string.charAt(0) == '!') {
                    arrayUtil2.add(string.substring(1).replace('\\', '/'));
                    continue;
                }
                arrayUtil.add(string.replace('\\', '/'));
            }
            if (arrayUtil.size() == 0) {
                this.saInclude = new String[]{"*"};
            } else {
                this.saInclude = new String[arrayUtil.size()];
                arrayUtil.toArray(this.saInclude);
            }
            if (arrayUtil2.size() == 0) {
                this.saExclude = null;
            } else {
                this.saExclude = new String[arrayUtil2.size()];
                arrayUtil2.toArray(this.saExclude);
            }
        }

        public void setBasePath(String string) {
            this.sBasePath = string;
            this.iBasePathLength = this.sBasePath.length();
        }

        public void setBasePath(File file) {
            this.sBasePath = file.getAbsolutePath();
            this.iBasePathLength = this.sBasePath.length();
        }

        public boolean isAllowed(File file) {
            String string = file.getAbsolutePath().substring(this.iBasePathLength).replace('\\', '/');
            if (file.isDirectory()) {
                string = string + "/";
            }
            if (this.saExclude != null) {
                for (String string2 : this.saExclude) {
                    if (!StringUtil.like(string, string2)) continue;
                    return false;
                }
            }
            if (this.saInclude != null) {
                for (String string2 : this.saInclude) {
                    if (!StringUtil.like(string, string2)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

