/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IMasterSession;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.xml.XmlNode;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.rad.remote.ChangePasswordException;
import javax.rad.server.IConfiguration;
import javax.rad.server.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MasterSession
extends AbstractSession
implements IMasterSession {
    private ArrayUtil<WeakReference<SubSession>> auSubSessions = null;
    private Object oSyncSubSessions = new Object();
    private ApplicationZone zone;
    private IAccessController accessController;

    MasterSession(DefaultSessionManager defaultSessionManager, ChangedHashtable<String, Object> changedHashtable) throws Exception {
        super(defaultSessionManager, changedHashtable);
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = (String)changedHashtable.get("client.application");
        this.zone = (ApplicationZone)Configuration.getApplicationZone(string).clone();
        if (!Boolean.valueOf(this.zone.getProperty("/application/liveconfig")).booleanValue()) {
            this.zone.setUpdateEnabled(false);
        }
        if (changedHashtable.get("server.session.timeout") == null && (object4 = this.zone.getProperty("/application/timeout/mastersession")) != null) {
            try {
                this.setMaxInactiveInterval(Integer.parseInt((String)object4));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.info("Invalid timeout!", numberFormatException);
                this.setMaxInactiveInterval(0);
            }
        }
        if ((object4 = this.zone.getNodes("/application/connection/property")) != null) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (XmlNode)object3.next();
                object = ((XmlNode)object2).getNode("name");
                if (object != null && ((XmlNode)object).getValue() != null) {
                    this.setPropertyIntern(((XmlNode)object).getValue(), ((XmlNode)object2).getValue());
                    continue;
                }
                this.log.debug("Invalid connection property: " + object2);
            }
        }
        object = this.getLifeCycleName();
        object3 = this.zone.getProperty("/application/lifecycle/mastersession");
        if (object == null || ((String)object).trim().length() == 0) {
            this.setLifeCycleName((String)object3);
        }
        object2 = defaultSessionManager.getSecurityManager(this);
        String string2 = (String)changedHashtable.get("client.oldpassword");
        String string3 = (String)changedHashtable.get("client.newpassword");
        try {
            object2.validateAuthentication(this);
            this.setPropertyIntern("client.oldpassword", null);
        }
        catch (Exception exception) {
            if (exception instanceof ChangePasswordException && string3 != null) {
                this.setNewPasswordIntern(string2, string3);
                string3 = null;
            }
            throw exception;
        }
        if (string3 != null) {
            this.setNewPasswordIntern(string2, string3);
        }
        this.accessController = object2.getAccessController(this);
        if (this.accessController != null) {
            List<XmlNode> list;
            if (object3 != null) {
                this.accessController.addAccess((String)object3);
            }
            if ((list = this.getApplicationZone().getNodes("/application/lifecycle/allow")) != null) {
                for (XmlNode xmlNode : list) {
                    this.accessController.addAccess(xmlNode.getValue());
                }
            }
        }
        this.checkAccess();
    }

    @Override
    protected ApplicationZone getApplicationZone() {
        return this.zone;
    }

    @Override
    public IAccessController getAccessController() {
        return this.accessController;
    }

    @Override
    public IConfiguration getConfig() {
        return this.zone.getConfig();
    }

    @Override
    protected Object executeWithSessionContext(SessionContext sessionContext, Call call) throws Throwable {
        if ("Session!".equals(call.getObjectName()) && "setNewPassword".equals(call.getMethodName())) {
            this.setNewPasswordIntern((String)call.getParameters()[0], (String)call.getParameters()[1]);
            return null;
        }
        return super.executeWithSessionContext(sessionContext, call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubSession(SubSession subSession) {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions == null) {
                this.auSubSessions = new ArrayUtil();
            }
            this.auSubSessions.add(new WeakReference<SubSession>(subSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubSession(SubSession subSession) {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                this.auSubSessions.remove(subSession);
                if (this.auSubSessions.size() == 0) {
                    this.auSubSessions = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayUtil<SubSession> removeSubSessions() {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                ArrayUtil<SubSession> arrayUtil = null;
                int n = 0;
                int n2 = this.auSubSessions.size();
                while (n < n2) {
                    WeakReference<SubSession> weakReference = this.auSubSessions.get(n);
                    SubSession subSession = (SubSession)weakReference.get();
                    if (subSession == null) {
                        this.auSubSessions.remove(n);
                        --n2;
                        continue;
                    }
                    if (arrayUtil == null) {
                        arrayUtil = new ArrayUtil<SubSession>();
                    }
                    arrayUtil.add(subSession);
                    ++n;
                }
                this.auSubSessions = null;
                return arrayUtil;
            }
            return null;
        }
    }

    public final void setNewPassword(String string, String string2) throws Exception {
        this.setLastAccessTime(System.currentTimeMillis());
        this.setNewPasswordIntern(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setNewPasswordIntern(String string, String string2) throws Exception {
        this.setLastAliveTime(System.currentTimeMillis());
        this.chtProperties.put("client.oldpassword", string, false);
        this.chtProperties.put("client.newpassword", string2, false);
        this.getSessionManager().getSecurityManager(this).changePassword(this);
        this.setPropertyIntern("client.oldpassword", null);
        this.setPropertyIntern("client.newpassword", null);
        this.setPassword(string2);
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                int n = 0;
                int n2 = this.auSubSessions.size();
                while (n < n2) {
                    WeakReference<SubSession> weakReference = this.auSubSessions.get(n);
                    SubSession subSession = (SubSession)weakReference.get();
                    if (subSession == null) {
                        this.auSubSessions.remove(n);
                        --n2;
                        continue;
                    }
                    subSession.setPassword(string2);
                    ++n;
                }
                this.auSubSessions = null;
            }
        }
    }
}

