/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.SubSession;
import java.util.Hashtable;
import javax.rad.server.IConfiguration;
import javax.rad.server.IServer;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;

public abstract class AbstractSessionContext
extends SessionContext {
    private WrappedSession wsessMaster;

    public ISession getMasterSession() {
        ISession iSession = this.getSession();
        if (this.wsessMaster != null) {
            return this.wsessMaster;
        }
        if (iSession instanceof WrappedSession) {
            AbstractSession abstractSession = ((WrappedSession)iSession).session;
            if (abstractSession instanceof MasterSession) {
                this.wsessMaster = (WrappedSession)iSession;
                return this.wsessMaster;
            }
            if (abstractSession instanceof SubSession) {
                this.wsessMaster = new WrappedSession(((SubSession)abstractSession).getMasterSession());
                return this.wsessMaster;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class WrappedSession
    implements ISession {
        protected final AbstractSession session;

        protected WrappedSession(AbstractSession abstractSession) {
            this.session = abstractSession;
        }

        @Override
        public Object getId() {
            return this.session.getId();
        }

        @Override
        public String getLifeCycleName() {
            return this.session.getLifeCycleName();
        }

        @Override
        public String getApplicationName() {
            return this.session.getApplicationName();
        }

        @Override
        public String getUserName() {
            return this.session.getUserName();
        }

        @Override
        public String getPassword() {
            return this.session.getPassword();
        }

        @Override
        public Object getProperty(String string) {
            return this.session.getProperty(string);
        }

        @Override
        public Hashtable<String, Object> getProperties() {
            return (Hashtable)this.session.getProperties().clone();
        }

        @Override
        public void setProperty(String string, Object object) {
            if (string != null && string.startsWith("client.")) {
                throw new SecurityException("It's not allowed to change client properties through the SessionContext!");
            }
            this.session.setProperty(string, object);
        }

        @Override
        public long getStartTime() {
            return this.session.getStartTime();
        }

        @Override
        public long getLastAccessTime() {
            return this.session.getLastAccessTime();
        }

        @Override
        public long getLastAliveTime() {
            return this.session.getLastAliveTime();
        }

        @Override
        public void setAliveInterval(long l) {
            this.session.setAliveInterval(l);
        }

        @Override
        public long getAliveInterval() {
            return this.session.getAliveInterval();
        }

        @Override
        public boolean isAlive(long l) {
            return this.session.isAlive(l);
        }

        @Override
        public void setMaxInactiveInterval(int n) {
            this.session.setMaxInactiveInterval(n);
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.session.getMaxInactiveInterval();
        }

        @Override
        public boolean isInactive(long l) {
            return this.session.isInactive(l);
        }

        @Override
        public Object call(String string, String string2, Object ... objectArray) throws Throwable {
            return this.session.call(string, string2, objectArray);
        }

        @Override
        public Object callAction(String string, Object ... objectArray) throws Throwable {
            return this.session.callAction(string, objectArray);
        }

        @Override
        public Object get(String string) throws Throwable {
            return this.session.get(string);
        }

        @Override
        public Object put(String string, Object object) throws Throwable {
            return this.session.put(string, object);
        }

        @Override
        public IConfiguration getConfig() {
            return this.session.getApplicationZone().getConfig();
        }

        protected IConfiguration getServerConfig() {
            return this.session.getApplicationZone().getServerZone().getConfig();
        }

        protected IServer getServer() {
            return this.session.getSessionManager().getServer();
        }
    }
}

