/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SessionContextImpl;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.xml.XmlNode;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.ResultObject;
import javax.rad.server.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements ISession {
    private static long lSessionCount = 0L;
    protected ILogger log = LoggerFactory.getInstance(this.getClass());
    private DefaultSessionManager manager = null;
    private AbstractObjectProvider objProvider = null;
    private ISerializer serializer = null;
    private ArrayUtil<ResultObject> auCallBackResult = null;
    private Object oId;
    protected ChangedHashtable<String, Object> chtProperties = new ChangedHashtable();
    protected ChangedHashtable<String, Object> chtExternalProperties = null;
    private Object oSyncCallBack = new Object();
    private ChangedHashtable<String, InjectObject> chtInjectObjects = null;
    private final Long lObjectId = ++lSessionCount;
    private int iExecution = 0;
    private long lStartTime;
    private long lLastAccessTime;
    private long lLastAliveTime;
    private int iMaxInactiveInterval = 0;
    private long lAliveInterval = -1L;

    AbstractSession(DefaultSessionManager defaultSessionManager, ChangedHashtable<String, Object> changedHashtable) {
        this.manager = defaultSessionManager;
        this.objProvider = defaultSessionManager.getServer().getObjectProvider();
        this.chtExternalProperties = changedHashtable;
        this.oId = UUID.randomUUID().toString();
        this.lStartTime = System.currentTimeMillis();
        this.setLastAccessTime(this.lStartTime);
        for (Map.Entry entry : changedHashtable.entrySet()) {
            this.setPropertyIntern((String)entry.getKey(), entry.getValue());
        }
    }

    protected abstract ApplicationZone getApplicationZone();

    public abstract IAccessController getAccessController();

    @Override
    public Object getId() {
        return this.oId;
    }

    @Override
    public String getLifeCycleName() {
        return this.getPropertyAsString("client.lifecyclename");
    }

    @Override
    public final String getApplicationName() {
        return this.getPropertyAsString("client.application");
    }

    @Override
    public final String getUserName() {
        return this.getPropertyAsString("client.username");
    }

    @Override
    public final String getPassword() {
        return this.getPropertyAsString("client.password");
    }

    @Override
    public Object getProperty(String string) {
        this.setLastAccessTime(System.currentTimeMillis());
        return this.getPropertyIntern(string);
    }

    @Override
    public long getStartTime() {
        return this.lStartTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lLastAccessTime;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this.iMaxInactiveInterval = n;
        this.chtProperties.put("server.session.timeout", n);
        if (this.chtExternalProperties != null) {
            this.chtExternalProperties.put("server.session.timeout", n);
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.iMaxInactiveInterval;
    }

    @Override
    public boolean isInactive(long l) {
        return this.iMaxInactiveInterval > 0 && this.getLastAccessTime() + (long)this.iMaxInactiveInterval * 60000L < l;
    }

    @Override
    public long getLastAliveTime() {
        return this.lLastAliveTime;
    }

    @Override
    public void setAliveInterval(long l) {
        this.lAliveInterval = l;
        this.chtProperties.put("client.alive.interval", l);
        if (this.chtExternalProperties != null) {
            this.chtExternalProperties.put("client.alive.interval", l);
        }
    }

    @Override
    public long getAliveInterval() {
        return this.lAliveInterval;
    }

    @Override
    public boolean isAlive(long l) {
        return this.isExecuting() || this.lAliveInterval < 0L || this.getLastAliveTime() + this.lAliveInterval * 4L >= l;
    }

    @Override
    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        return this.executeIntern(new Call(null, string, string2, objectArray));
    }

    @Override
    public Object callAction(String string, Object ... objectArray) throws Throwable {
        return this.executeIntern(new Call(null, null, string, objectArray));
    }

    @Override
    public Object get(String string) throws Throwable {
        SessionContext sessionContext = this.createSessionContext(string, null);
        try {
            Object object = this.objProvider.getObject(this, string);
            return object;
        }
        catch (Throwable throwable) {
            throw this.addCallInfo(throwable, string, null);
        }
        finally {
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
    }

    @Override
    public Object put(String string, Object object) throws Throwable {
        SessionContext sessionContext = this.createSessionContext(string, null);
        try {
            Object object2 = this.objProvider.putObject(this, string, object);
            return object2;
        }
        catch (Throwable throwable) {
            throw this.addCallInfo(throwable, string, null);
        }
        finally {
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
    }

    private final String getPropertyAsString(String string) {
        Object v = this.chtProperties.get(string);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    final void setLifeCycleName(String string) {
        this.chtProperties.put("client.lifecyclename", string);
    }

    final void setApplicationName(String string) {
        this.chtProperties.put("client.application", string);
    }

    public final void setUserName(String string) {
        this.chtProperties.put("client.username", string);
    }

    public final void setPassword(String string) {
        this.chtProperties.put("client.password", string);
    }

    void setSerializer(ISerializer iSerializer) {
        this.serializer = iSerializer;
        if (iSerializer != null) {
            this.setPropertyIntern("server.session.serializer", iSerializer.getClass().getSimpleName());
        } else {
            this.setPropertyIntern("server.session.serializer", "");
        }
    }

    ISerializer getSerializer() {
        return this.serializer;
    }

    Long getObjectId() {
        return this.lObjectId;
    }

    public void setLastAccessTime(long l) {
        this.lLastAccessTime = l;
        this.setLastAliveTime(l);
    }

    public void setLastAliveTime(long l) {
        this.lLastAliveTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object execute(Call call) throws Throwable {
        this.chtExternalProperties = null;
        this.setExecuting(true);
        try {
            Object object;
            this.setLastAccessTime(System.currentTimeMillis());
            Object object2 = object = this.executeIntern(call);
            return object2;
        }
        finally {
            this.setLastAliveTime(System.currentTimeMillis());
            this.setExecuting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object executeIntern(Call call) throws Throwable {
        SessionContext sessionContext = this.createSessionContext(call.getObjectName(), call.getMethodName());
        try {
            Object object = this.executeWithSessionContext(sessionContext, call);
            return object;
        }
        finally {
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
    }

    protected Object executeWithSessionContext(SessionContext sessionContext, Call call) throws Throwable {
        String string = call.getObjectName();
        String string2 = call.getMethodName();
        Object[] objectArray = call.getParameters();
        if ("Session!".equals(string)) {
            if ("setProperty".equals(string2)) {
                List list = (List)objectArray[0];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray2 = (Object[])list.get(i);
                    this.setPropertyIntern((String)objectArray2[0], objectArray2[1]);
                }
                return null;
            }
            throw new NoSuchMethodException("Unknown method '" + string2 + "'");
        }
        if (call.isCallBack()) {
            ThreadHandler.start(new CallBackWorker(call));
            return null;
        }
        try {
            return this.objProvider.invoke(this, string, string2, objectArray);
        }
        catch (Throwable throwable) {
            throw this.addCallInfo(throwable, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCallBackResult(ResultObject resultObject) {
        Object object = this.oSyncCallBack;
        synchronized (object) {
            if (this.auCallBackResult == null) {
                this.auCallBackResult = new ArrayUtil();
            }
            this.auCallBackResult.add(resultObject);
        }
    }

    ArrayUtil<ResultObject> removeCallBackResults() {
        return this.removeCallBackResultsIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayUtil<ResultObject> removeCallBackResultsIntern() {
        this.setLastAliveTime(System.currentTimeMillis());
        Object object = this.oSyncCallBack;
        synchronized (object) {
            ArrayUtil<ResultObject> arrayUtil = this.auCallBackResult;
            this.auCallBackResult = null;
            return arrayUtil;
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        this.setLastAccessTime(System.currentTimeMillis());
        this.setPropertyIntern(string, object);
    }

    protected final void setPropertyIntern(String string, Object object) {
        this.setLastAliveTime(System.currentTimeMillis());
        this.checkPropertyAccess(string, object);
        if ("server.session.timeout".equals(string)) {
            if (object instanceof String) {
                this.setMaxInactiveInterval(Integer.valueOf((String)object));
            } else {
                this.setMaxInactiveInterval(((Number)object).intValue());
            }
        } else if ("client.alive.interval".equals(string)) {
            if (object instanceof String) {
                this.setAliveInterval(Long.valueOf((String)object));
            } else {
                this.setAliveInterval(((Number)object).longValue());
            }
        } else {
            this.chtProperties.put(string, object);
            if (this.chtExternalProperties != null) {
                this.chtExternalProperties.put(string, object);
            }
        }
    }

    private void checkPropertyAccess(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid property name: null");
        }
        if ("server.session.timeout".equals(string) && object == null) {
            throw new SecurityException("It's not allowed to change the property '" + string + "' to '" + object + "'");
        }
    }

    private Object getPropertyIntern(String string) {
        this.setLastAliveTime(System.currentTimeMillis());
        if (string == null) {
            throw new IllegalArgumentException("Invalid property name '" + string + "'");
        }
        return this.chtProperties.get(string);
    }

    public ChangedHashtable<String, Object> getProperties() {
        return this.chtProperties;
    }

    protected DefaultSessionManager getSessionManager() {
        return this.manager;
    }

    final SessionContext createSessionContext(String string, String string2) {
        SessionContextImpl sessionContextImpl = new SessionContextImpl(this);
        sessionContextImpl.setObjectName(string);
        sessionContextImpl.setMethodName(string2);
        return sessionContextImpl;
    }

    public InjectObject putObject(InjectObject injectObject) {
        if (injectObject == null) {
            return null;
        }
        String string = injectObject.getName();
        if (string == null || string.startsWith("!")) {
            throw new RuntimeException("The object name '" + string + "' is not valid!");
        }
        try {
            this.initInjectObjects();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.chtInjectObjects.containsKey("!" + string)) {
            throw new RuntimeException("It is not allowed to change the preconfigured object '" + string + "'!");
        }
        return this.chtInjectObjects.put(string, injectObject);
    }

    public InjectObject removeObject(InjectObject injectObject) {
        if (injectObject == null) {
            return null;
        }
        String string = injectObject.getName();
        if (string == null || string.startsWith("!")) {
            throw new RuntimeException("The object name '" + string + "' is not valid!");
        }
        try {
            this.initInjectObjects();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.chtInjectObjects.containsKey("!" + string)) {
            throw new RuntimeException("It is not allowed to remove the preconfigured object '" + string + "'!");
        }
        return this.chtInjectObjects.remove(string);
    }

    public InjectObject getObject(String string) {
        try {
            this.initInjectObjects();
            InjectObject injectObject = (InjectObject)this.chtInjectObjects.get("!" + string);
            if (injectObject != null) {
                return injectObject;
            }
            return (InjectObject)this.chtInjectObjects.get(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    Enumeration<InjectObject> getInjectObjects() throws Exception {
        this.initInjectObjects();
        return this.chtInjectObjects.elements();
    }

    List<Map.Entry<String, InjectObject>> getChangedInjectObjects() {
        if (this.chtInjectObjects == null) {
            return null;
        }
        return this.chtInjectObjects.getChanges(new Class[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initInjectObjects() throws Exception {
        if (this.chtInjectObjects != null) return;
        this.chtInjectObjects = new ChangedHashtable();
        try {
            List<XmlNode> list = this.getApplicationZone().getNodes("/application/inject");
            if (list == null) return;
            for (XmlNode xmlNode : list) {
                void var4_6;
                String string;
                XmlNode xmlNode2 = xmlNode.getNode("name");
                String string2 = xmlNode2 != null ? xmlNode2.getValue() : null;
                XmlNode xmlNode3 = xmlNode.getNode("object");
                if (xmlNode3 != null) {
                    string = xmlNode3.getValue();
                    if (!"monitoring".equals(string)) {
                        throw new SecurityException("Object '" + string + "' is not supported!");
                    }
                    Monitoring monitoring = ((Server)this.getSessionManager().getServer()).getMonitoring();
                    if (string2 == null) {
                        string2 = string;
                    }
                } else {
                    xmlNode3 = xmlNode.getNode("class");
                    if (xmlNode3 == null) {
                        throw new SecurityException("Unsupported inject definition: " + xmlNode);
                    }
                    string = xmlNode3.getValue();
                    try {
                        Class<?> clazz = Class.forName(string);
                        Object obj = clazz.newInstance();
                        if (string2 == null) {
                            string2 = clazz.getSimpleName();
                        }
                    }
                    catch (Exception exception) {
                        this.log.error(exception);
                        Object var4_9 = null;
                    }
                }
                if (var4_6 == null || !this.isInjectionAllowed(xmlNode)) continue;
                if (this.chtInjectObjects.containsKey("!" + string2)) {
                    throw new IllegalArgumentException("Object name '" + string2 + "' is already used!");
                }
                this.chtInjectObjects.put("!" + string2, new InjectObject(string2, var4_6), false);
            }
            return;
        }
        catch (Exception exception) {
            this.chtInjectObjects = null;
            throw exception;
        }
    }

    private boolean isInjectionAllowed(XmlNode xmlNode) {
        List<XmlNode> list = xmlNode.getNodes("allow");
        if (list == null) {
            return true;
        }
        String string = this.getLifeCycleName();
        for (XmlNode xmlNode2 : list) {
            XmlNode xmlNode3 = xmlNode2.getNode("instanceof");
            XmlNode xmlNode4 = xmlNode2.getNode("lifecyclename");
            if (xmlNode4 != null && string.equals(xmlNode4.getValue())) {
                return true;
            }
            if (xmlNode3 == null) continue;
            String string2 = xmlNode3.getValue();
            try {
                Class<?> clazz = Class.forName(string2);
                if (!clazz.isAssignableFrom(this.getClass())) continue;
                return true;
            }
            catch (Exception exception) {
                this.log.error(exception);
            }
        }
        return false;
    }

    protected boolean isExecuting() {
        return this.iExecution > 0;
    }

    protected void setExecuting(boolean bl) {
        this.iExecution = bl ? ++this.iExecution : --this.iExecution;
    }

    protected void checkAccess() {
        IAccessController iAccessController = this.getAccessController();
        if (iAccessController != null && !iAccessController.isAllowed(this.getLifeCycleName())) {
            throw new SecurityException("Access to '" + this.getLifeCycleName() + "' denied!");
        }
    }

    private Throwable addCallInfo(Throwable throwable, String string, String string2) {
        Throwable throwable2 = throwable;
        do {
            StackTraceElement[] stackTraceElementArray;
            if ((stackTraceElementArray = throwable2.getStackTrace()) == null) continue;
            ArrayUtil<StackTraceElement> arrayUtil = new ArrayUtil<StackTraceElement>();
            boolean bl = false;
            for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                try {
                    if (!bl && AbstractObjectProvider.class.isAssignableFrom(Class.forName(stackTraceElementArray[i].getClassName()))) {
                        bl = true;
                        arrayUtil.add(0, new StackTraceElement(this.getLifeCycleName() + ".<" + string + ">", string2 != null ? string2 : "", null, -1));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayUtil.add(0, stackTraceElementArray[i]);
            }
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[arrayUtil.size()];
            arrayUtil.toArray(stackTraceElementArray2);
            throwable2.setStackTrace(stackTraceElementArray2);
        } while ((throwable2 = throwable2.getCause()) != null);
        return throwable;
    }

    final class CallBackWorker
    implements Runnable {
        private Call call = null;

        private CallBackWorker(Call call) {
            this.call = call;
        }

        public void run() {
            try {
                Object object = AbstractSession.this.executeIntern(new Call((Object)null, this.call.getObjectName(), this.call.getMethodName(), this.call.getParameters()));
                this.call.success(AbstractSession.this, object);
            }
            catch (Throwable throwable) {
                this.call.error(AbstractSession.this, AbstractSession.this.addCallInfo(AbstractSecurityManager.prepareException(throwable), this.call.getObjectName(), this.call.getMethodName()));
            }
        }
    }
}

