/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.serializer.ArraySerializer;
import com.sibvisions.rad.remote.serializer.BeanSerializer;
import com.sibvisions.rad.remote.serializer.BeanTypeSerializer;
import com.sibvisions.rad.remote.serializer.BooleanArraySerializer;
import com.sibvisions.rad.remote.serializer.BooleanSerializer;
import com.sibvisions.rad.remote.serializer.ByteArraySerializer;
import com.sibvisions.rad.remote.serializer.ByteSerializer;
import com.sibvisions.rad.remote.serializer.CharArraySerializer;
import com.sibvisions.rad.remote.serializer.CharacterSerializer;
import com.sibvisions.rad.remote.serializer.DateSerializer;
import com.sibvisions.rad.remote.serializer.DecimalSerializer;
import com.sibvisions.rad.remote.serializer.DoubleArraySerializer;
import com.sibvisions.rad.remote.serializer.DoubleSerializer;
import com.sibvisions.rad.remote.serializer.EnumSerializer;
import com.sibvisions.rad.remote.serializer.FloatArraySerializer;
import com.sibvisions.rad.remote.serializer.FloatSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.IntArraySerializer;
import com.sibvisions.rad.remote.serializer.IntegerSerializer;
import com.sibvisions.rad.remote.serializer.ListSerializer;
import com.sibvisions.rad.remote.serializer.LongArraySerializer;
import com.sibvisions.rad.remote.serializer.LongSerializer;
import com.sibvisions.rad.remote.serializer.MapSerializer;
import com.sibvisions.rad.remote.serializer.NullSerializer;
import com.sibvisions.rad.remote.serializer.ObjectSerializer;
import com.sibvisions.rad.remote.serializer.ShortArraySerializer;
import com.sibvisions.rad.remote.serializer.ShortSerializer;
import com.sibvisions.rad.remote.serializer.StringSerializer;
import com.sibvisions.rad.remote.serializer.ThrowableSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import com.sibvisions.util.ArrayUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UniversalSerializer
implements ISerializer {
    private HashMap<Class, ITypeSerializer> serializerTypes = new HashMap();
    private ITypeSerializer nullSerializer;
    private ITypeSerializer[] deserializerTypes = new ITypeSerializer[256];
    private ArrayUtil<ITypeSerializer> instanceOfTypesOrder = new ArrayUtil();
    private HashMap<Class, ITypeSerializer> instanceOfCache = new HashMap();

    public UniversalSerializer() {
        this.registerTypeSerializer(new NullSerializer());
        this.registerTypeSerializer(new ByteSerializer());
        this.registerTypeSerializer(new CharacterSerializer());
        this.registerTypeSerializer(new BooleanSerializer());
        this.registerTypeSerializer(new FloatSerializer());
        this.registerTypeSerializer(new DoubleSerializer());
        this.registerTypeSerializer(new ShortSerializer());
        this.registerTypeSerializer(new IntegerSerializer());
        this.registerTypeSerializer(new LongSerializer());
        this.registerTypeSerializer(new DateSerializer());
        this.registerTypeSerializer(new DecimalSerializer());
        this.registerTypeSerializer(new StringSerializer());
        this.registerTypeSerializer(new ByteArraySerializer());
        this.registerTypeSerializer(new BooleanArraySerializer());
        this.registerTypeSerializer(new FloatArraySerializer());
        this.registerTypeSerializer(new DoubleArraySerializer());
        this.registerTypeSerializer(new ShortArraySerializer());
        this.registerTypeSerializer(new IntArraySerializer());
        this.registerTypeSerializer(new LongArraySerializer());
        this.registerTypeSerializer(new CharArraySerializer());
        this.registerTypeSerializer(new ArraySerializer());
        this.registerTypeSerializer(new ListSerializer());
        this.registerTypeSerializer(new MapSerializer());
        this.registerTypeSerializer(new BeanSerializer());
        this.registerTypeSerializer(new BeanTypeSerializer());
        this.registerTypeSerializer(new ObjectSerializer());
        this.registerTypeSerializer(new EnumSerializer());
        this.registerTypeSerializer(new ThrowableSerializer());
    }

    @Override
    public final Object read(DataInputStream dataInputStream) throws Exception {
        TypeCache typeCache = new TypeCache();
        return this.read(dataInputStream, typeCache);
    }

    @Override
    public final void write(DataOutputStream dataOutputStream, Object object) throws Exception {
        TypeCache typeCache = new TypeCache();
        this.write(dataOutputStream, object, typeCache);
    }

    public final Object read(DataInputStream dataInputStream, TypeCache typeCache) throws Exception {
        int n = dataInputStream.readUnsignedByte();
        return this.getTypeSerializer(n).read(this, dataInputStream, n, typeCache);
    }

    public final void write(DataOutputStream dataOutputStream, Object object, TypeCache typeCache) throws Exception {
        this.getTypeSerializer(object).write(this, dataOutputStream, object, typeCache);
    }

    public void registerTypeSerializer(ITypeSerializer iTypeSerializer) {
        int n;
        this.unregisterTypeSerializer(iTypeSerializer);
        int n2 = iTypeSerializer.getMinValue();
        int n3 = iTypeSerializer.getMaxValue();
        for (n = n2; n <= n3; ++n) {
            if (this.deserializerTypes[n] == null) continue;
            throw new IllegalArgumentException("The identification byte " + n + " of " + iTypeSerializer.getClass().getName() + " is already used by " + this.deserializerTypes[n].getClass().getName() + "!");
        }
        for (n = n2; n <= n3; ++n) {
            this.deserializerTypes[n] = iTypeSerializer;
        }
        Class clazz = iTypeSerializer.getTypeClass();
        if (clazz == null) {
            this.nullSerializer = iTypeSerializer;
        } else {
            if (clazz != Object.class) {
                this.serializerTypes.put(clazz, iTypeSerializer);
            }
            if (!Modifier.isFinal(clazz.getModifiers()) || clazz == Object[].class) {
                int n4 = -1;
                for (int i = 0; i < this.instanceOfTypesOrder.size(); ++i) {
                    if (!clazz.isAssignableFrom(this.instanceOfTypesOrder.get(i).getTypeClass())) continue;
                    n4 = i;
                }
                this.instanceOfTypesOrder.add(n4 + 1, iTypeSerializer);
            }
        }
    }

    public void unregisterTypeSerializer(ITypeSerializer iTypeSerializer) {
        boolean bl;
        Class clazz = iTypeSerializer.getTypeClass();
        if (clazz == null) {
            boolean bl2 = bl = this.nullSerializer != null;
            if (bl) {
                this.nullSerializer = null;
            }
        } else {
            bl = this.serializerTypes.remove(clazz) != null;
            this.instanceOfTypesOrder.remove(iTypeSerializer);
            this.instanceOfCache.clear();
        }
        if (bl) {
            int n = iTypeSerializer.getMinValue();
            int n2 = iTypeSerializer.getMaxValue();
            for (int i = n; i <= n2; ++i) {
                this.deserializerTypes[i] = null;
            }
        }
    }

    public ITypeSerializer getTypeSerializer(int n) throws IOException {
        ITypeSerializer iTypeSerializer = this.deserializerTypes[n];
        if (iTypeSerializer == null) {
            throw new IOException("There is no ITypeSerializer registered for type value " + n + "!");
        }
        return iTypeSerializer;
    }

    public ITypeSerializer getTypeSerializer(Class<?> clazz) throws IOException {
        if (clazz == null) {
            return this.nullSerializer;
        }
        ITypeSerializer iTypeSerializer = this.serializerTypes.get(clazz);
        if (iTypeSerializer == null) {
            iTypeSerializer = this.instanceOfCache.get(clazz);
            if (iTypeSerializer == null) {
                for (int i = 0; i < this.instanceOfTypesOrder.size() && iTypeSerializer == null; ++i) {
                    ITypeSerializer iTypeSerializer2 = this.instanceOfTypesOrder.get(i);
                    if (!iTypeSerializer2.getTypeClass().isAssignableFrom(clazz)) continue;
                    iTypeSerializer = iTypeSerializer2;
                    this.instanceOfCache.put(clazz, iTypeSerializer);
                }
            }
            if (iTypeSerializer == null) {
                throw new IOException("There is no ITypeSerializer registered for Objects of instance " + clazz + "!");
            }
        }
        return iTypeSerializer;
    }

    public ITypeSerializer getTypeSerializer(Object object) throws IOException {
        if (object == null) {
            return this.nullSerializer;
        }
        return this.getTypeSerializer(object.getClass());
    }
}

