/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Name;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;

public class ServerColumnMetaData
implements Cloneable {
    private ColumnMetaData columnMetaData;
    private ForeignKey fkAutoLink;
    private IDataType dataType;
    private String sRealQueryColumnName;
    private Name nColumnName;
    private int iSQLType;
    private int iDetectedType = Integer.MAX_VALUE;
    private String sSQLTypeName;

    public ServerColumnMetaData() {
    }

    public ServerColumnMetaData(Name name) {
        this.nColumnName = name;
        this.columnMetaData = new ColumnMetaData(name.getName());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Server");
        stringBuilder.append(this.columnMetaData);
        stringBuilder.append(",sRealQueryColumnName=");
        stringBuilder.append(this.sRealQueryColumnName);
        stringBuilder.append(",sColumnName=");
        stringBuilder.append(this.nColumnName);
        return stringBuilder.toString();
    }

    public ServerColumnMetaData clone() {
        try {
            return (ServerColumnMetaData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public String getName() {
        return this.columnMetaData.getName();
    }

    public String getQuotedName() {
        return this.nColumnName.getQuotedName();
    }

    public Name getColumnName() {
        return this.nColumnName;
    }

    public String getLabel() {
        return this.columnMetaData.getLabel();
    }

    public void setLabel(String string) {
        this.columnMetaData.setLabel(string);
    }

    public void setDataType(int n) {
        this.columnMetaData.setDataType(n);
        this.dataType = null;
    }

    public void setDataType(IDataType iDataType) {
        this.columnMetaData.setDataType(iDataType.getTypeIdentifier());
        this.dataType = iDataType;
    }

    public IDataType getDataType() {
        if (this.dataType == null) {
            this.dataType = ColumnMetaData.createDataType(this.columnMetaData);
        }
        return this.dataType;
    }

    public void setNullable(boolean bl) {
        this.columnMetaData.setNullable(bl);
    }

    public boolean isNullable() {
        return this.columnMetaData.isNullable();
    }

    public int getPrecision() {
        return this.columnMetaData.getPrecision();
    }

    public void setPrecision(int n) {
        this.columnMetaData.setPrecision(n);
    }

    public int getScale() {
        return this.columnMetaData.getScale();
    }

    public void setScale(int n) {
        this.columnMetaData.setScale(n);
    }

    public int getSQLType() {
        return this.iSQLType;
    }

    public void setSQLType(int n) {
        this.iSQLType = n;
    }

    public int getDetectedType() {
        if (this.iDetectedType == Integer.MAX_VALUE) {
            return this.iSQLType;
        }
        return this.iDetectedType;
    }

    public void setDetectedType(int n) {
        this.iDetectedType = n;
    }

    public String getSQLTypeName() {
        return this.sSQLTypeName;
    }

    public void setSQLTypeName(String string) {
        this.sSQLTypeName = string;
    }

    public void setWritable(boolean bl) {
        this.columnMetaData.setWritable(bl);
    }

    public boolean isWritable() {
        return this.columnMetaData.isWritable();
    }

    public boolean isSigned() {
        return this.columnMetaData.isSigned();
    }

    public void setSigned(boolean bl) {
        this.columnMetaData.setSigned(bl);
    }

    public boolean isAutoIncrement() {
        return this.columnMetaData.isAutoIncrement();
    }

    public void setAutoIncrement(boolean bl) {
        this.columnMetaData.setAutoIncrement(bl);
    }

    public StorageReferenceDefinition getLinkReference() {
        return this.columnMetaData.getLinkReference();
    }

    public void setLinkReference(StorageReferenceDefinition storageReferenceDefinition) {
        this.columnMetaData.setLinkReference(storageReferenceDefinition);
    }

    public ForeignKey getLinkForeignKey() {
        return this.fkAutoLink;
    }

    public void setLinkForeignKey(ForeignKey foreignKey) {
        this.fkAutoLink = foreignKey;
    }

    public void setDefaultValue(Object object) {
        this.columnMetaData.setDefaultValue(object);
    }

    public Object getDefaultValue() {
        return this.columnMetaData.getDefaultValue();
    }

    public void setAllowedValues(Object[] objectArray) {
        this.columnMetaData.setAllowedValues(objectArray);
    }

    public Object[] getAllowedValues() {
        return this.columnMetaData.getAllowedValues();
    }

    public String getRealQueryColumnName() {
        return this.sRealQueryColumnName;
    }

    public void setRealQueryColumnName(String string) {
        this.sRealQueryColumnName = string;
    }
}

