/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import javax.rad.model.ModelException;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.persist.DataSourceException;
import org.postgresql.util.PGobject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLDBAccess
extends DBAccess {
    public static final int TYPE_ENUM = -900;

    public PostgreSQLDBAccess() {
        this.setDriver("org.postgresql.Driver");
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NO WAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertPostgres(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toLowerCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    public SQLException formatSQLException(SQLException sQLException) {
        return this.formatSQLException(sQLException, sQLException.getMessage(), sQLException.getSQLState());
    }

    private Object[] insertPostgres(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(" RETURNING ");
        String[] stringArray = serverMetaData.getPrimaryKeyQuotedColumnNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string4 = this.translateQuotes(stringBuffer.toString());
            logger.debug("executeSQL->" + string4);
            statement = this.getConnection().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            if (string3 == null) {
                this.setColumnsToStore((PreparedStatement)statement, serverColumnMetaDataArray, nArray, objectArray, null);
            } else {
                for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                    if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                    statement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                    break;
                }
            }
            resultSet = statement.executeQuery();
            int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
            if (resultSet.next()) {
                for (int i = 0; nArray2 != null && i < nArray2.length; ++i) {
                    objectArray[nArray2[i]] = resultSet.getObject(i + 1);
                }
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Insert failed! - " + stringBuffer, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    protected int setColumnsToStore(PreparedStatement preparedStatement, ServerColumnMetaData[] serverColumnMetaDataArray, int[] nArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if ((objectArray2 != null || objectArray[n2] == null) && (objectArray2 == null || serverColumnMetaDataArray[n2].getDataType().compareTo(objectArray[n2], objectArray2[n2]) == 0)) continue;
            try {
                preparedStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]), serverColumnMetaDataArray[n2].getSQLType());
                ++n;
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
        return --n;
    }

    @Override
    public boolean isAutoQuote(String string) {
        StringUtil.CaseSensitiveType caseSensitiveType = StringUtil.getCaseSensitiveType(string);
        return caseSensitiveType != StringUtil.CaseSensitiveType.LowerCase;
    }

    @Override
    public void setUsername(String string) {
        String string2 = string;
        if (string != null) {
            string2 = string2.equals(DBAccess.removeQuotes(string)) ? string2.toLowerCase() : DBAccess.removeQuotes(string);
        }
        super.setUsername(string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String var1_1, String[] var2_2, String var3_3, String var4_4, String var5_5, String var6_6, String[] var7_7) throws DataSourceException {
        block32: {
            block33: {
                block34: {
                    var8_8 = super.getColumnMetaData(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
                    var9_9 = var8_8.getColumnMetaData();
                    for (var10_10 = 0; var10_10 < var9_9.length; ++var10_10) {
                        if (var9_9[var10_10].getSQLType() != 1111 || !this.isEnum(var9_9[var10_10])) continue;
                        var9_9[var10_10].setDetectedType(-900);
                        try {
                            var11_12 = this.executeSql("select e.enumlabel from pg_enum e, pg_type t where e.enumtypid = t.oid and t.typtype = 'e' and t.typname = ?", new Object[]{var9_9[var10_10].getSQLTypeName()});
                            if (var11_12 == null) continue;
                            var9_9[var10_10].setAllowedValues(var11_12.toArray());
                            continue;
                        }
                        catch (SQLException var12_13) {
                            throw new DataSourceException("Create enum link reference to '" + var9_9[var10_10].getName() + "' failed!", var12_13);
                        }
                    }
                    var10_11 = DBAccess.removeQuotes(var8_8.getTable());
                    if (var8_8.getSchema() != null) {
                        var11_12 = var8_8.getSchema();
                        var12_14 = DBAccess.removeQuotes((String)var11_12);
                        var11_12 = var12_14.equals(var11_12) != false ? var11_12.toLowerCase() : var12_14;
                        var13_15 = this.checkTablesAndViews((String)var11_12, var10_11);
                        if (var13_15.size() == 0) {
                            var13_15 = this.checkTablesAndViews(DBAccess.removeQuotes((String)var11_12), var10_11.toLowerCase());
                        }
                        if (var13_15.size() == 1) {
                            var8_8.setTable(((Name)var13_15.get(0)[1]).getRealName());
                            var8_8.setSchema(((Name)var13_15.get(0)[0]).getRealName());
                            return var8_8;
                        }
                    }
                    var11_12 = null;
                    var12_14 = null;
                    var13_16 = System.currentTimeMillis();
                    try {
                        var11_12 = this.getPreparedStatement("SHOW search_path", false);
                        var12_14 = var11_12.executeQuery();
                        if (!var12_14.next()) break block32;
                        var15_17 = var12_14.getString(1);
                        var16_21 = StringUtil.separateList(var15_17, ",", true);
                        var17_22 = 0;
lbl35:
                        // 2 sources

                        while (var17_22 < var16_21.size()) {
                            var18_23 = var16_21.get(var17_22);
                            if (var18_23.contains("$user")) {
                                var18_23 = this.getUsername();
                            }
                            if ((var19_24 = this.checkTablesAndViews(DBAccess.removeQuotes(var18_23), var10_11)).size() == 0) {
                                var19_24 = this.checkTablesAndViews(DBAccess.removeQuotes(var18_23), var10_11.toLowerCase());
                            }
                            if (var19_24.size() == 1) {
                                var8_8.setTable(((Name)var19_24.get(0)[1]).getRealName());
                                var8_8.setSchema(((Name)var19_24.get(0)[0]).getRealName());
                                var20_25 = var8_8;
                                if (var12_14 == null) break block33;
                                break block34;
                            }
                            ** GOTO lbl-1000
                        }
                        break block32;
                    }
                    catch (SQLException var15_20) {
                        try {
                            throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var15_20));
                        }
                        catch (Throwable var22_28) {
                            if (var12_14 != null) {
                                try {
                                    var12_14.close();
                                }
                                catch (SQLException var23_29) {
                                    // empty catch block
                                }
                            }
                            if (var11_12 != null) {
                                try {
                                    var11_12.close();
                                }
                                catch (SQLException var23_30) {
                                    // empty catch block
                                }
                            }
                            PostgreSQLDBAccess.logger.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=" + (System.currentTimeMillis() - var13_16)});
                            throw var22_28;
                        }
                    }
                }
                try {
                    var12_14.close();
                }
                catch (SQLException var21_26) {
                    // empty catch block
                }
            }
            if (var11_12 != null) {
                try {
                    var11_12.close();
                }
                catch (SQLException var21_27) {
                    // empty catch block
                }
            }
            PostgreSQLDBAccess.logger.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=" + (System.currentTimeMillis() - var13_16)});
            return var20_25;
lbl-1000:
            // 1 sources

            {
                ++var17_22;
                ** GOTO lbl35
            }
        }
        if (var12_14 != null) {
            try {
                var12_14.close();
            }
            catch (SQLException var15_18) {
                // empty catch block
            }
        }
        if (var11_12 != null) {
            try {
                var11_12.close();
            }
            catch (SQLException var15_19) {
                // empty catch block
            }
        }
        PostgreSQLDBAccess.logger.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=" + (System.currentTimeMillis() - var13_16)});
        return var8_8;
    }

    @Override
    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) {
        if (object instanceof PGobject) {
            return ((PGobject)object).getValue();
        }
        return object;
    }

    @Override
    protected boolean setDatabaseSpecificType(ResultSetMetaData resultSetMetaData, int n, ServerColumnMetaData serverColumnMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnType(n);
        if (n2 == 1111) {
            serverColumnMetaData.setDataType(12);
            serverColumnMetaData.setPrecision(Integer.MAX_VALUE);
            return true;
        }
        return super.setDatabaseSpecificType(resultSetMetaData, n, serverColumnMetaData);
    }

    @Override
    protected String createWhereParam(ServerMetaData serverMetaData, CompareCondition compareCondition) {
        try {
            ServerColumnMetaData serverColumnMetaData = serverMetaData.getServerColumnMetaData(compareCondition.getColumnName());
            if (serverColumnMetaData.getDetectedType() == -900) {
                return "cast(? as " + serverColumnMetaData.getSQLTypeName() + ")";
            }
            Object object = compareCondition.getValue();
            if (compareCondition instanceof Equals && !this.isTypeEqual(serverColumnMetaData, compareCondition) && !(object instanceof String) || compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase || compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) {
                return "cast(? as varchar)";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return super.createWhereParam(serverMetaData, compareCondition);
    }

    @Override
    protected String createWhereColumn(ServerMetaData serverMetaData, CompareCondition compareCondition, String string) {
        try {
            ServerColumnMetaData serverColumnMetaData = serverMetaData.getServerColumnMetaData(compareCondition.getColumnName());
            IDataType iDataType = serverColumnMetaData.getDataType();
            if (compareCondition instanceof Equals && !this.isTypeEqual(serverColumnMetaData, compareCondition) && !(iDataType instanceof StringDataType) || compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase || compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) {
                return "cast(" + string + " as varchar)";
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return super.createWhereColumn(serverMetaData, compareCondition, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        ArrayUtil<Object[]> arrayUtil2;
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().getMetaData().getTables(this.getConnection().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            while (resultSet.next()) {
                arrayUtil.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME"))), resultSet.getString("TABLE_TYPE"), resultSet.getString("REMARKS")});
            }
            arrayUtil2 = arrayUtil;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    logger.debug("getTables() time=" + (System.currentTimeMillis() - l));
                    throw throwable;
                }
                catch (SQLException sQLException2) {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException2));
                }
            }
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            logger.debug("getTables() time=" + (System.currentTimeMillis() - l));
            return arrayUtil2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
        }
    }

    protected boolean isEnum(ServerColumnMetaData serverColumnMetaData) throws DataSourceException {
        if (serverColumnMetaData.getSQLType() == 1111) {
            String string = serverColumnMetaData.getSQLTypeName();
            try {
                List<Object> list = this.executeSql("select oid from pg_type where typname = ? and typtype = 'e'", string);
                return list.size() == 1;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Enum detection failed", this.formatSQLException(sQLException));
            }
        }
        return false;
    }
}

