/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDBAccess
extends DBAccess {
    private static String sUKSelectBase = "SELECT cons.owner table_schem, cols.table_name, cons.constraint_name, cols.column_name FROM all_constraints cons, all_cons_columns cols WHERE cols.table_name = ? AND cons.constraint_type = 'U' AND cons.constraint_name = cols.constraint_name AND cons.owner = cols.owner ";
    private static String sUKSelectWithSchema = sUKSelectBase + "AND cons.owner = ? " + "ORDER BY cols.table_name, cols.constraint_name, cols.position";
    private static String sCheckSelect = "select search_condition from user_constraints where constraint_type = 'C' and generated = 'USER NAME' and status = 'ENABLED' and table_name = ?";
    private static String sFKSelectBase = "SELECT c.owner           fktable_schem ,c.constraint_name fk_name ,c.table_name      fktable_name ,cc.column_name    fkcolumn_name ,r_owner           pktable_schem ,r_constraint_name pk_name ,ccr.table_name    pktable_name ,ccr.column_name   pkcolumn_name FROM all_constraints c ,all_cons_columns cc ,all_cons_columns ccr WHERE cc.owner = c.owner AND cc.constraint_name = c.constraint_name AND ccr.owner = c.r_owner AND ccr.constraint_name = c.r_constraint_name AND ccr.position = cc.position AND c.constraint_type = 'R' AND c.table_name = ? ";
    private static String sFKSelectOrder = "ORDER BY c.owner, c.table_name, c.constraint_name, cc.position";
    private static String sFKSelectWithSchema = sFKSelectBase + " AND c.owner = ? " + sFKSelectOrder;
    private static String sSynonymSelect = "select s.table_owner, s.table_name, s.db_link FROM user_synonyms s WHERE s.synonym_name = ?";

    public OracleDBAccess() {
        this.setDriver("oracle.jdbc.OracleDriver");
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NOWAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertOracle(string, string2, serverMetaData, objectArray, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DataSourceException {
        super.open();
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            statement.executeUpdate("ALTER SESSION SET NLS_COMP='BINARY'");
            statement.executeUpdate("ALTER SESSION SET NLS_SORT='BINARY'");
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<Key> getUKs(String string, String string2, String string3) throws DataSourceException {
        Object object;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            ArrayUtil<Key> arrayUtil = new ArrayUtil<Key>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            statement = this.getPreparedStatement(sUKSelectWithSchema, false);
            statement.setString(1, string3);
            statement.setString(2, string2);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                statement.close();
                ArrayUtil<Key> arrayUtil3 = arrayUtil;
                return arrayUtil3;
            }
            String string4 = null;
            do {
                if (resultSet.getString("COLUMN_NAME") == null) continue;
                if (string4 != null && !resultSet.getString("CONSTRAINT_NAME").equals(string4)) {
                    object = new Key(string4);
                    ((Key)object).setColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                    arrayUtil.add((Key)object);
                    arrayUtil2.clear();
                }
                string4 = resultSet.getString("CONSTRAINT_NAME");
                arrayUtil2.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
            } while (resultSet.next());
            if (arrayUtil2.size() > 0) {
                object = new Key(string4);
                ((Key)object).setColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add((Key)object);
            }
            logger.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Unique Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return object;
    }

    @Override
    public List<ForeignKey> getFKs(String string, String string2, String string3) throws DataSourceException {
        ArrayUtil<ForeignKey> arrayUtil;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            ArrayUtil<ForeignKey> arrayUtil2 = new ArrayUtil<ForeignKey>();
            long l = System.currentTimeMillis();
            String string4 = this.getConnection().getCatalog();
            statement = this.getPreparedStatement(sFKSelectWithSchema, false);
            statement.setString(1, string3);
            statement.setString(2, string2);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                ArrayUtil<ForeignKey> arrayUtil3 = arrayUtil2;
                return arrayUtil3;
            }
            String string5 = null;
            String string6 = null;
            ArrayUtil<Name> arrayUtil4 = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil5 = new ArrayUtil<Name>();
            ForeignKey foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(string4, this.quote(string4)), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
            do {
                if (!((string5 = resultSet.getString("FK_NAME")) != null && string5.length() != 0 || (string5 = resultSet.getString("PK_NAME")) != null && string5.length() != 0)) {
                    throw new DataSourceException("Database/jdbc driver didn't support FK, PK names!");
                }
                if (string6 != null && !string6.equals(string5)) {
                    foreignKey.setFKColumns(arrayUtil5.toArray(new Name[arrayUtil5.size()]));
                    foreignKey.setPKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
                    arrayUtil2.add(foreignKey);
                    arrayUtil4.clear();
                    arrayUtil5.clear();
                    foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(string4, this.quote(string4)), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
                }
                string6 = string5;
                arrayUtil4.add(new Name(resultSet.getString("PKCOLUMN_NAME"), this.quote(resultSet.getString("PKCOLUMN_NAME"))));
                arrayUtil5.add(new Name(resultSet.getString("FKCOLUMN_NAME"), this.quote(resultSet.getString("FKCOLUMN_NAME"))));
                foreignKey.setFKName(resultSet.getString("FK_NAME"));
            } while (resultSet.next());
            foreignKey.setFKColumns(arrayUtil5.toArray(new Name[arrayUtil5.size()]));
            foreignKey.setPKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
            arrayUtil2.add(foreignKey);
            logger.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            arrayUtil = arrayUtil2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayUtil;
    }

    @Override
    public String getTableForSynonym(String string) throws DataSourceException {
        String string2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect, false);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                preparedStatement.close();
                String string3 = string;
                return string3;
            }
            String string4 = resultSet.getString("TABLE_OWNER");
            String string5 = resultSet.getString("TABLE_NAME");
            String string6 = resultSet.getString("DB_LINK");
            StringBuilder stringBuilder = new StringBuilder();
            if (string4 != null) {
                stringBuilder.append(string4);
                stringBuilder.append('.');
            }
            stringBuilder.append(string5);
            if (string6 != null) {
                stringBuilder.append('@');
                stringBuilder.append(string6);
            }
            logger.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            string2 = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    @Override
    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    public Hashtable<String, Object[]> getAllowedValues(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object[]> hashtable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            preparedStatement = this.getPreparedStatement(sCheckSelect, false);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(1), hashtable2, true);
            }
            hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashtable;
    }

    private Object[] insertOracle(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("BEGIN " + string2);
        stringBuffer.append(" RETURNING ");
        String[] stringArray = serverMetaData.getPrimaryKeyQuotedColumnNames();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n]);
        }
        stringBuffer.append(" INTO ");
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append("; END;");
        Statement statement = null;
        try {
            int n2;
            String string4 = this.translateQuotes(stringBuffer.toString());
            logger.debug("executeSQL->" + string4);
            statement = this.getConnection().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            int n3 = 0;
            if (string3 == null) {
                n3 = this.setColumnsToStore((PreparedStatement)statement, serverColumnMetaDataArray, nArray, objectArray, null);
            } else {
                for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                    if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                    statement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                    break;
                }
                n3 = 1;
            }
            int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
            for (n2 = 0; nArray2 != null && n2 < nArray2.length; ++n2) {
                IDataType iDataType = ColumnMetaData.createDataType(serverColumnMetaDataArray[nArray2[n2]].getColumnMetaData());
                int n4 = iDataType instanceof BigDecimalDataType ? 2 : (iDataType instanceof TimestampDataType ? 93 : 1);
                statement.registerOutParameter(n3 + n2 + 1, n4);
            }
            if (this.executeUpdate((PreparedStatement)statement) == 1) {
                for (n2 = 0; nArray2 != null && n2 < nArray2.length; ++n2) {
                    objectArray[nArray2[n2]] = statement.getObject(n3 + n2 + 1);
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            try {
                throw new DataSourceException("Insert failed ! - Result row count != 1 ! - " + stringBuffer);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + stringBuffer, this.formatSQLException(sQLException));
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2) throws DataSourceException {
        String string6;
        DBAccess.ColumnMetaDataInfo columnMetaDataInfo = super.getColumnMetaData(string, stringArray, string2, string3, string4, string5, stringArray2);
        if (columnMetaDataInfo.getSchema() == null) {
            columnMetaDataInfo.setSchema(this.getUsername().toUpperCase());
        }
        if ((string6 = columnMetaDataInfo.getTable()) != null && !string6.startsWith("`") && !string6.endsWith("`")) {
            columnMetaDataInfo.setTable(string6.toUpperCase());
        }
        return columnMetaDataInfo;
    }
}

