/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.util.type.StringUtil;
import java.util.Hashtable;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDBAccess
extends DBAccess {
    public DerbyDBAccess() {
        this.setDriver("org.apache.derby.jdbc.ClientDriver");
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    protected String createReplace(String string, String string2, String string3) {
        return string;
    }

    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2) throws DataSourceException {
        DBAccess.ColumnMetaDataInfo columnMetaDataInfo = super.getColumnMetaData(string, stringArray, string2, string3, string4, string5, stringArray2);
        String string6 = columnMetaDataInfo.getTable();
        if (string6 != null && !string6.startsWith("`") && !string6.endsWith("`")) {
            columnMetaDataInfo.setTable(string6.toUpperCase());
        }
        return columnMetaDataInfo;
    }
}

