/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.DataBookUtil;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.AbstractStorage;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.type.BeanUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.Filter;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.IStorage;
import javax.rad.persist.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStorage
extends AbstractCachedStorage {
    private static Hashtable<Object, ServerMetaData> htServerMetaDataCache = null;
    private static KeyValueList<Object, CacheLink> kvlCacheLink = null;
    private ServerMetaData mdServerMetaData;
    private HashMap<String, IStorage> hmpSubStorages;
    private boolean bIsOpen = false;
    private boolean bRefetch = true;
    private IDBAccess dbAccess;
    private String sFromClause;
    private String sFromClauseBeforeOpen;
    private String[] saQueryColumns;
    private String[] saQueryColumnsBeforeOpen;
    private String sBeforeQueryColumns;
    private String sWhereClause;
    private String sAfterWhereClause;
    private String[] saWritebackColumns;
    private String sWritebackTable;
    private String sWritebackTableSchema;
    private String sWritebackTableCatalog;
    private Object oCacheKey = null;
    private SortDefinition sdDefaultSort;
    private ICondition cRestrictCondition;
    private Boolean bAutoLinkReference;
    private static boolean bDefaultAutoLinkReference = true;
    private Boolean bDefaultValue;
    private static boolean bDefaultDefaultValue = true;
    private Boolean bAllowedValues;
    private static boolean bDefaultAllowedValues = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCSV(OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-1");
        try {
            int n;
            if (this.cRestrictCondition != null) {
                iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
            }
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            }
            if (stringArray == null) {
                stringArray = this.mdServerMetaData.getColumnNames();
            }
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = this.mdServerMetaData.getServerColumnMetaData(stringArray[n]).getLabel();
                    if (stringArray2[n] != null) continue;
                    stringArray2[n] = ColumnMetaData.getDefaultLabel(stringArray[n]);
                }
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (n > 0) {
                    outputStreamWriter.write(string);
                }
                outputStreamWriter.write(StringUtil.quote(stringArray2[n], '\"'));
            }
            outputStreamWriter.write("\n");
            IDataType[] iDataTypeArray = new IDataType[stringArray.length];
            int[] nArray = new int[stringArray.length];
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                iDataTypeArray[i] = ColumnMetaData.createDataType(this.mdServerMetaData.getServerColumnMetaData(stringArray[i]).getColumnMetaData());
                nArray[i] = this.mdServerMetaData.getServerColumnMetaDataIndex(stringArray[i]);
            }
            int n3 = 0;
            boolean bl = false;
            String string2 = this.getFromClauseIntern();
            while (!bl) {
                List<Object[]> list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, string2, iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, n3, 1000);
                n3 += list.size();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    Object[] objectArray = list.get(i);
                    if (objectArray != null) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (j > 0) {
                                outputStreamWriter.write(string);
                            }
                            DataBookUtil.writeQuoted(outputStreamWriter, iDataTypeArray[j], objectArray[nArray[j]], string);
                        }
                        outputStreamWriter.write("\n");
                        continue;
                    }
                    bl = true;
                }
            }
            outputStreamWriter.flush();
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStreamWriter.close();
        }
        catch (Exception exception) {}
    }

    @Override
    public MetaData executeGetMetaData() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        return this.mdServerMetaData.getMetaData();
    }

    @Override
    public int getEstimatedRowCount(ICondition iCondition) throws DataSourceException {
        List<Object[]> list;
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, new String[]{"COUNT(*)"}, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 1)) != null && list.size() >= 1 && list.get(0).length > 0) {
            Object object = list.get(0)[0];
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            throw new DataSourceException("countRows() result data typ not supported! - " + object.getClass().getName());
        }
        return 0;
    }

    @Override
    public List<Object[]> executeFetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if (sortDefinition == null) {
            sortDefinition = this.sdDefaultSort;
        }
        return this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, n, n2);
    }

    @Override
    public Object[] executeRefetchRow(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        return this.refetchRow(objectArray, true);
    }

    @Override
    public Object[] executeInsert(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        Object[] objectArray3 = this.dbAccess.insert(this.getWritebackTable(), this.mdServerMetaData, objectArray);
        if (this.isRefetch() && (objectArray2 = this.refetchRow(objectArray3, false)) != null) {
            return objectArray2;
        }
        return objectArray3;
    }

    @Override
    public Object[] executeUpdate(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        Object[] objectArray3 = this.dbAccess.update(this.getWritebackTable(), this.mdServerMetaData, objectArray, objectArray2);
        if (this.isRefetch()) {
            return this.refetchRow(objectArray3, false);
        }
        return objectArray3;
    }

    @Override
    public void executeDelete(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return;
        }
        this.dbAccess.delete(this.getWritebackTable(), this.mdServerMetaData, objectArray);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsOpen()=");
        stringBuffer.append(this.bIsOpen);
        stringBuffer.append("\n");
        stringBuffer.append(this.dbAccess);
        stringBuffer.append("\n");
        stringBuffer.append(this.sBeforeQueryColumns);
        stringBuffer.append(" ");
        for (n = 0; this.saQueryColumns != null && n < this.saQueryColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saQueryColumns[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.sFromClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sAfterWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append("Writeback:\n");
        stringBuffer.append(this.getWritebackTable());
        stringBuffer.append("\n");
        for (n = 0; this.saWritebackColumns != null && n < this.saWritebackColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saWritebackColumns[n]);
        }
        return stringBuffer.toString();
    }

    @Override
    public MetaData getMetaData(String string, String string2) throws DataSourceException {
        if (kvlCacheLink == null) {
            kvlCacheLink = new KeyValueList();
        }
        CacheLink cacheLink = new CacheLink(string, string2);
        kvlCacheLink.put(this.oCacheKey, cacheLink, true);
        return super.getMetaData(string, string2);
    }

    public void open() throws DataSourceException {
        this.sFromClauseBeforeOpen = this.getFromClause();
        String[] stringArray = this.getQueryColumns();
        this.saQueryColumnsBeforeOpen = stringArray != null ? stringArray : null;
        this.openInternal(false);
    }

    protected void openInternal(boolean bl) throws DataSourceException {
        if (this.dbAccess == null) {
            throw new DataSourceException("DBAccess isn't set!");
        }
        this.mdServerMetaData = this.getMetaData(this.getBeforeQueryColumns(), this.getQueryColumns(), this.getFromClause(), this.getWhereClause(), this.getAfterWhereClause(), this.getWritebackTable(), this.getWritebackColumns(), this.isAutoLinkReference(), bl);
        this.bIsOpen = true;
    }

    protected void refreshMetaData() throws DataSourceException {
        if (this.hmpSubStorages != null) {
            this.hmpSubStorages.clear();
        }
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.openInternal(false);
    }

    private IStorage putSubStorage(String string, IStorage iStorage) {
        if (this.hmpSubStorages == null) {
            this.hmpSubStorages = new HashMap();
        }
        return this.hmpSubStorages.put(string, iStorage);
    }

    public void createAutomaticLinkReference(String[] stringArray, String string, String[] stringArray2) throws ModelException {
        this.createAutomaticLinkReference(this.mdServerMetaData, stringArray, this.createAutomaticLinkStorage(string), stringArray2);
    }

    public void createAutomaticLinkReference(String[] stringArray, DBStorage dBStorage, String[] stringArray2) throws ModelException {
        this.createAutomaticLinkReference(this.mdServerMetaData, stringArray, dBStorage, stringArray2);
    }

    protected void createAutomaticLinkReference(ServerMetaData serverMetaData, String[] stringArray, AbstractStorage abstractStorage, String[] stringArray2) throws ModelException {
        int n;
        Object object;
        String string;
        if (abstractStorage.getName() != null) {
            string = abstractStorage.getName();
        } else if (abstractStorage instanceof DBStorage) {
            object = (DBStorage)abstractStorage;
            string = ((DBStorage)object).getWritebackTable() != null ? ((DBStorage)object).getWritebackTable().toLowerCase() : ((DBStorage)object).getFromClause().toLowerCase();
        } else {
            object = new StringBuilder();
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    ((StringBuilder)object).append("_");
                }
                ((StringBuilder)object).append(stringArray[n]);
            }
            string = ((StringBuilder)object).toString();
        }
        this.putSubStorage(string, abstractStorage);
        object = new StorageReferenceDefinition(stringArray, ".subStorages." + string, stringArray2);
        for (n = 0; n < stringArray.length; ++n) {
            serverMetaData.getServerColumnMetaData(stringArray[n]).setLinkReference((StorageReferenceDefinition)object);
        }
    }

    public void removeLinkReference(String string) throws ModelException {
        this.mdServerMetaData.getServerColumnMetaData(string).setLinkReference(null);
    }

    public boolean hasLinkReference(String string) throws ModelException {
        return this.hasLinkReference(this.mdServerMetaData, string);
    }

    protected boolean hasLinkReference(ServerMetaData serverMetaData, String string) throws ModelException {
        return serverMetaData.getServerColumnMetaData(string).getLinkReference() != null;
    }

    ServerMetaData getMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2, boolean bl, boolean bl2) throws DataSourceException {
        this.oCacheKey = this.createCheckSum(string, stringArray, string2, string3, string4, string5, stringArray2, bl, bl2, ((DBAccess)this.dbAccess).getUrl(), ((DBAccess)this.dbAccess).getUsername());
        try {
            Object object;
            Cloneable cloneable;
            String[] stringArray3;
            Object object2;
            String[] stringArray4;
            int n;
            int n2;
            Object object3;
            ServerColumnMetaData[] serverColumnMetaDataArray;
            ServerColumnMetaData[] serverColumnMetaDataArray2;
            Object object4;
            ServerMetaData serverMetaData;
            if (this.isMetaDataCacheEnabled()) {
                if (this.oCacheKey != null && htServerMetaDataCache != null) {
                    this.validateMetaDataCache();
                    serverMetaData = htServerMetaDataCache.get(this.oCacheKey);
                } else {
                    serverMetaData = null;
                }
            } else {
                if (htServerMetaDataCache != null) {
                    htServerMetaDataCache = null;
                    kvlCacheLink = null;
                }
                serverMetaData = null;
            }
            if (serverMetaData != null) {
                String[] stringArray5;
                serverMetaData = serverMetaData.clone();
                ServerColumnMetaData[] serverColumnMetaDataArray3 = serverMetaData.getServerColumnMetaData();
                for (int i = 0; i < serverColumnMetaDataArray3.length; ++i) {
                    ForeignKey foreignKey = serverColumnMetaDataArray3[i].getLinkForeignKey();
                    if (foreignKey == null) continue;
                    DBStorage dBStorage = this.createAutomaticLinkStorage(foreignKey.getPKTable().getQuotedName());
                    dBStorage.setDefaultSort(new SortDefinition(foreignKey.getLinkReferenceColumn().getName()));
                    this.putSubStorage(foreignKey.getPKTable().getName().toLowerCase(), dBStorage);
                }
                String string6 = serverMetaData.getFromClause();
                if (string6 != null) {
                    this.setFromClause(string6);
                }
                if ((stringArray5 = serverMetaData.getQueryColumns()) != null) {
                    this.setQueryColumns(stringArray5);
                }
                return serverMetaData;
            }
            Key key = null;
            List<Key> list = null;
            List<ForeignKey> list2 = null;
            ArrayUtil<String[]> arrayUtil = null;
            DBAccess dBAccess = (DBAccess)this.dbAccess;
            string3 = string3 == null ? "1=2" : string3 + " AND 1=2";
            Hashtable<String, Object> hashtable = null;
            Hashtable<String, Object> hashtable2 = null;
            DBAccess.ColumnMetaDataInfo columnMetaDataInfo = null;
            if (string5 != null) {
                Object[] objectArray;
                object4 = dBAccess.getTableForSynonym(string5);
                columnMetaDataInfo = dBAccess.getColumnMetaData((String)object4, null, null, "1=2", null, null, null);
                serverColumnMetaDataArray2 = columnMetaDataInfo.getCatalog();
                serverColumnMetaDataArray = columnMetaDataInfo.getSchema();
                this.sWritebackTableCatalog = serverColumnMetaDataArray2;
                this.sWritebackTableSchema = serverColumnMetaDataArray;
                this.debug("WritebackTable Schema=" + (String)serverColumnMetaDataArray + ",Catalog=" + (String)serverColumnMetaDataArray2);
                object3 = columnMetaDataInfo.getTable();
                if (this.isDefaultValue()) {
                    hashtable = dBAccess.getDefaultValues((String)serverColumnMetaDataArray2, (String)serverColumnMetaDataArray, (String)object3);
                }
                Object[] objectArray2 = columnMetaDataInfo.getColumnMetaData();
                if (this.isAllowedValues()) {
                    hashtable2 = dBAccess.getAllowedValues((String)serverColumnMetaDataArray2, (String)serverColumnMetaDataArray, (String)object3);
                    n2 = objectArray2.length;
                    for (n = 0; n < n2; ++n) {
                        if (hashtable2 != null && hashtable2.get(objectArray2[n].getName()) != null || (objectArray = dBAccess.getDefaultAllowedValues((String)serverColumnMetaDataArray2, (String)serverColumnMetaDataArray, (String)object3, (ServerColumnMetaData)objectArray2[n])) == null) continue;
                        if (hashtable2 == null) {
                            hashtable2 = new Hashtable();
                        }
                        hashtable2.put(((ServerColumnMetaData)objectArray2[n]).getName(), objectArray);
                    }
                }
                key = dBAccess.getPK((String)serverColumnMetaDataArray2, (String)serverColumnMetaDataArray, (String)object3);
                list = dBAccess.getUKs((String)serverColumnMetaDataArray2, (String)serverColumnMetaDataArray, (String)object3);
                objectArray = new String[objectArray2.length];
                BeanUtil.toArray(objectArray2, objectArray, "quotedName");
                if (stringArray2 == null) {
                    stringArray2 = objectArray;
                }
                if (bl) {
                    list2 = dBAccess.getFKs((String)serverColumnMetaDataArray2, (String)serverColumnMetaDataArray, (String)object3);
                    arrayUtil = new ArrayUtil<String[]>(list2.size());
                    if (list2 != null) {
                        Iterator<ForeignKey> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            ForeignKey foreignKey = iterator.next();
                            Name[] nameArray = foreignKey.getFKColumns();
                            boolean bl3 = false;
                            for (int i = 0; i < nameArray.length && !bl3; ++i) {
                                int n3 = ArrayUtil.indexOf(objectArray, nameArray[i].getQuotedName());
                                if (n3 < 0 || !((ServerColumnMetaData)objectArray2[n3]).isNullable()) continue;
                                foreignKey.setNullable(true);
                                bl3 = true;
                            }
                            stringArray4 = this.createAutomaticLinkStorage(foreignKey.getPKTable().getQuotedName());
                            object2 = stringArray4.mdServerMetaData;
                            stringArray3 = ((ServerMetaData)object2).getRepresentationColumnNames();
                            cloneable = null;
                            ServerColumnMetaData[] serverColumnMetaDataArray4 = ((ServerMetaData)object2).getServerColumnMetaData();
                            String[] stringArray6 = BeanUtil.toArray(foreignKey.getPKColumns(), new String[foreignKey.getPKColumns().length], "name");
                            bl3 = false;
                            for (int i = 0; i < serverColumnMetaDataArray4.length && !bl3; ++i) {
                                object = serverColumnMetaDataArray4[i].getName();
                                if (serverColumnMetaDataArray4[i].getColumnMetaData().getDataType() == 12 && ArrayUtil.indexOf(stringArray6, object) < 0 && ArrayUtil.indexOf(stringArray3, object) >= 0) {
                                    foreignKey.setLinkReferenceColumn(serverColumnMetaDataArray4[i].getColumnName());
                                    bl3 = true;
                                    continue;
                                }
                                if (cloneable != null || ArrayUtil.indexOf(stringArray6, object) >= 0) continue;
                                cloneable = serverColumnMetaDataArray4[i].getColumnName();
                            }
                            if (!bl3 && cloneable != null) {
                                foreignKey.setLinkReferenceColumn((Name)cloneable);
                            }
                            if (foreignKey.getLinkReferenceColumn() == null) {
                                iterator.remove();
                                continue;
                            }
                            stringArray4.setDefaultSort(new SortDefinition(foreignKey.getLinkReferenceColumn().getName()));
                            arrayUtil.add(stringArray4);
                        }
                    }
                    this.debug("auForeignKeys = ", list2);
                    if (string2 == null || string2.equals(string5)) {
                        if (this.getQueryColumns() == null) {
                            stringArray = dBAccess.getQueryColumns(string5, list2, stringArray2);
                            this.setQueryColumns(stringArray);
                        }
                        string2 = dBAccess.getFromClause(string5, list2);
                        this.setFromClause(string2);
                    }
                }
                if (string2 == null) {
                    string2 = string5;
                }
            }
            serverMetaData = new ServerMetaData();
            if (string5 == null) {
                serverMetaData.getMetaData().removeFeature(MetaData.Feature.WriteBack);
            }
            object4 = dBAccess.getColumnMetaData(string2, stringArray, string, string3, string4, string5, stringArray2);
            serverColumnMetaDataArray2 = ((DBAccess.ColumnMetaDataInfo)object4).getColumnMetaData();
            serverColumnMetaDataArray = null;
            if (columnMetaDataInfo != null) {
                serverColumnMetaDataArray = columnMetaDataInfo.getColumnMetaData();
            }
            serverMetaData.setServerColumnMetaData(serverColumnMetaDataArray2);
            object3 = new ArrayUtil<Name>();
            for (int i = 0; i < serverColumnMetaDataArray2.length; ++i) {
                Object[] objectArray;
                if (serverColumnMetaDataArray2[i].isAutoIncrement()) {
                    ((ArrayUtil)object3).add(serverColumnMetaDataArray2[i].getColumnName());
                }
                if (hashtable != null) {
                    serverColumnMetaDataArray2[i].setDefaultValue(hashtable.get(serverColumnMetaDataArray2[i].getName()));
                }
                if (hashtable2 != null && (objectArray = (Object[])hashtable2.get(serverColumnMetaDataArray2[i].getName())) != null && objectArray.length > 0) {
                    serverColumnMetaDataArray2[i].setAllowedValues(objectArray);
                }
                if (serverColumnMetaDataArray == null) continue;
                for (int j = 0; j < serverColumnMetaDataArray.length; ++j) {
                    if (!serverColumnMetaDataArray[j].getName().equals(serverColumnMetaDataArray2[i].getName())) continue;
                    serverColumnMetaDataArray2[i].setNullable(serverColumnMetaDataArray[j].isNullable());
                }
            }
            if (!((ArrayUtil)object3).isEmpty()) {
                serverMetaData.setAutoIncrementColumnNames(((ArrayUtil)object3).toArray(new Name[((ArrayUtil)object3).size()]));
            }
            if (string5 != null) {
                if (key != null && key.getColumns() != null && key.getColumns().length > 0) {
                    serverMetaData.setPrimaryKeyColumnNames(key.getColumns());
                    serverMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.PrimaryKeyColumns);
                } else if (list != null && list.size() > 0) {
                    Name[] nameArray = ((Key)list.get(0)).getColumns();
                    serverMetaData.setPrimaryKeyColumnNames(nameArray);
                    serverMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.UniqueKeyColumns);
                } else {
                    ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        n = 0;
                        Name name = new Name(stringArray2[n2], dBAccess.quote(stringArray2[n2]));
                        for (int i = 0; i < serverColumnMetaDataArray2.length && n == 0; ++i) {
                            n = serverColumnMetaDataArray2[i].getColumnName().equals(name) && serverColumnMetaDataArray2[i].getColumnMetaData().getDataType() == -2 ? 1 : 0;
                        }
                        if (n != 0) continue;
                        arrayUtil2.add(name);
                    }
                    if (!arrayUtil2.isEmpty()) {
                        serverMetaData.setPrimaryKeyColumnNames(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                        serverMetaData.setPrimaryKeyType(ServerMetaData.PrimaryKeyType.AllColumns);
                    }
                }
                if (list != null && list.size() > 0) {
                    ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
                    for (int i = 0; i < list.size(); ++i) {
                        Name[] nameArray = list.get(i).getColumns();
                        for (n2 = 0; n2 < nameArray.length; ++n2) {
                            if (arrayUtil3.indexOf(nameArray[n2]) >= 0) continue;
                            arrayUtil3.add(nameArray[n2]);
                        }
                    }
                    if (arrayUtil3.size() > 0) {
                        Name[] nameArray = new Name[arrayUtil3.size()];
                        arrayUtil3.toArray(nameArray);
                        serverMetaData.setRepresentationColumnNames(nameArray);
                    }
                }
                if (bl && list2 != null) {
                    n = list2.size();
                    for (int i = 0; i < n; ++i) {
                        Object object5;
                        ForeignKey foreignKey = (ForeignKey)list2.get(i);
                        try {
                            String string7 = foreignKey.getLinkReferenceColumn().getName();
                            String string8 = dBAccess.getAutomaticLinkColumnName(foreignKey);
                            object5 = serverMetaData.getServerColumnMetaData(string8);
                            ((ServerColumnMetaData)object5).setLabel(ColumnMetaData.getDefaultLabel(string7));
                            stringArray4 = ArrayUtil.add(BeanUtil.toArray(foreignKey.getFKColumns(), new String[foreignKey.getFKColumns().length], "name"), string8);
                            object2 = ArrayUtil.add(BeanUtil.toArray(foreignKey.getPKColumns(), new String[foreignKey.getPKColumns().length], "name"), string7);
                            stringArray3 = foreignKey.getPKTable().getName().toLowerCase();
                            cloneable = new StorageReferenceDefinition(stringArray4, ".subStorages." + (String)stringArray3, (String[])object2);
                            object = (IStorage)arrayUtil.get(i);
                            ((ServerColumnMetaData)object5).setLinkReference((StorageReferenceDefinition)cloneable);
                            ((ServerColumnMetaData)object5).setNullable(foreignKey.isNullable());
                            ((ServerColumnMetaData)object5).setLinkForeignKey(foreignKey);
                            this.putSubStorage((String)stringArray3, (IStorage)object);
                            continue;
                        }
                        catch (ModelException modelException) {
                            object5 = new String[serverMetaData.getServerColumnMetaData().length];
                            this.debug(Arrays.toString(BeanUtil.toArray(serverMetaData.getServerColumnMetaData(), object5, "name")));
                            this.debug(modelException);
                        }
                    }
                }
            }
            if (serverMetaData.getRepresentationColumnNames() == null) {
                Name[] nameArray = new Name[serverMetaData.getServerColumnMetaData().length];
                n = nameArray.length;
                for (int i = 0; i < n; ++i) {
                    nameArray[i] = serverMetaData.getServerColumnMetaData()[i].getColumnName();
                }
                serverMetaData.setRepresentationColumnNames(nameArray);
            }
            if (bl2) {
                String[] stringArray7 = serverMetaData.getRepresentationColumnNames();
                String[] stringArray8 = serverMetaData.getPrimaryKeyColumnNames();
                if (stringArray8 != null) {
                    for (n = 0; n < stringArray8.length; ++n) {
                        if (ArrayUtil.indexOf(stringArray7, stringArray8[n]) >= 0) continue;
                        stringArray7 = ArrayUtil.add(stringArray7, stringArray8[n]);
                    }
                }
                ServerColumnMetaData[] serverColumnMetaDataArray5 = serverMetaData.getServerColumnMetaData();
                for (n2 = serverColumnMetaDataArray5.length - 1; n2 >= 0; --n2) {
                    if (ArrayUtil.indexOf(stringArray7, serverColumnMetaDataArray5[n2].getName()) >= 0) continue;
                    serverColumnMetaDataArray5 = (ServerColumnMetaData[])ArrayUtil.remove(serverColumnMetaDataArray5, n2);
                }
                this.saQueryColumns = new String[serverColumnMetaDataArray5.length];
                for (n2 = 0; n2 < serverColumnMetaDataArray5.length; ++n2) {
                    this.saQueryColumns[n2] = serverColumnMetaDataArray5[n2].getColumnName().getQuotedName();
                }
                serverMetaData.setServerColumnMetaData(serverColumnMetaDataArray5);
            }
            serverMetaData.setFromClause(this.getFromClause());
            serverMetaData.setQueryColumns(this.getQueryColumns());
            if (htServerMetaDataCache == null) {
                htServerMetaDataCache = new Hashtable();
            }
            htServerMetaDataCache.put(this.oCacheKey, serverMetaData);
            this.updateMetaDataCache(serverMetaData);
            return serverMetaData;
        }
        catch (DataSourceException dataSourceException) {
            this.updateMetaDataCache(null);
            if (htServerMetaDataCache != null) {
                htServerMetaDataCache.remove(this.oCacheKey);
            }
            throw dataSourceException;
        }
        catch (RuntimeException runtimeException) {
            this.updateMetaDataCache(null);
            if (htServerMetaDataCache != null) {
                htServerMetaDataCache.remove(this.oCacheKey);
            }
            throw runtimeException;
        }
    }

    private void updateMetaDataCache(ServerMetaData serverMetaData) {
        List<CacheLink> list;
        if (kvlCacheLink != null && (list = kvlCacheLink.get(this.oCacheKey)) != null) {
            for (CacheLink cacheLink : list) {
                this.putMetaDataToCache(cacheLink.sGroup, cacheLink.sName, serverMetaData != null ? serverMetaData.getMetaData() : null);
            }
        }
    }

    private void validateMetaDataCache() {
        List<CacheLink> list;
        if (kvlCacheLink != null && (list = kvlCacheLink.get(this.oCacheKey)) != null) {
            for (CacheLink cacheLink : list) {
                if (this.getMetaDataFromCache(cacheLink.sGroup, cacheLink.sName) != null) continue;
                kvlCacheLink.remove(this.oCacheKey);
                htServerMetaDataCache.remove(this.oCacheKey);
            }
        }
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    public void close() {
        this.oCacheKey = null;
        this.bIsOpen = false;
    }

    public void setDBAccess(IDBAccess iDBAccess) {
        this.dbAccess = iDBAccess;
    }

    public IDBAccess getDBAccess() {
        return this.dbAccess;
    }

    public String getFromClause() {
        return this.sFromClause;
    }

    private String getFromClauseIntern() {
        if (this.sFromClause == null) {
            return this.sWritebackTable;
        }
        return this.sFromClause;
    }

    public void setFromClause(String string) {
        this.sFromClause = string;
    }

    public String[] getQueryColumns() {
        return this.saQueryColumns;
    }

    public void setQueryColumns(String[] stringArray) {
        this.saQueryColumns = stringArray;
    }

    public String getBeforeQueryColumns() {
        return this.sBeforeQueryColumns;
    }

    public void setBeforeQueryColumns(String string) {
        this.sBeforeQueryColumns = string;
    }

    public String getWhereClause() {
        return this.sWhereClause;
    }

    public void setWhereClause(String string) {
        this.sWhereClause = string;
    }

    public String getAfterWhereClause() {
        return this.sAfterWhereClause;
    }

    public void setAfterWhereClause(String string) {
        this.sAfterWhereClause = string;
    }

    public String[] getWritebackColumns() {
        return this.saWritebackColumns;
    }

    public void setWritebackColumns(String[] stringArray) {
        this.saWritebackColumns = stringArray;
    }

    public String getWritebackTable() {
        return this.sWritebackTable;
    }

    public void setWritebackTable(String string) {
        this.sWritebackTable = string;
    }

    public SortDefinition getDefaultSort() {
        return this.sdDefaultSort;
    }

    public void setDefaultSort(SortDefinition sortDefinition) {
        this.sdDefaultSort = sortDefinition;
    }

    public ICondition getRestrictCondition() {
        return this.cRestrictCondition;
    }

    public void setRestrictCondition(ICondition iCondition) {
        this.cRestrictCondition = iCondition;
    }

    public boolean isRefetch() {
        return this.bRefetch;
    }

    public void setRefetch(boolean bl) {
        this.bRefetch = bl;
    }

    public void setAutoLinkReference(boolean bl) {
        this.bAutoLinkReference = bl;
    }

    public boolean isAutoLinkReference() {
        if (this.bAutoLinkReference == null) {
            return bDefaultAutoLinkReference;
        }
        return this.bAutoLinkReference;
    }

    public static void setDefaultAutoLinkReference(boolean bl) {
        bDefaultAutoLinkReference = bl;
    }

    public static boolean isDefaultAutoLinkReference() {
        return bDefaultAutoLinkReference;
    }

    public void setDefaultValue(boolean bl) {
        this.bDefaultValue = bl;
    }

    public boolean isDefaultValue() {
        if (this.bDefaultValue == null) {
            return bDefaultDefaultValue;
        }
        return this.bDefaultValue;
    }

    public static void setDefaultDefaultValue(boolean bl) {
        bDefaultDefaultValue = bl;
    }

    public static boolean isDefaultDefaultValue() {
        return bDefaultDefaultValue;
    }

    public void setAllowedValues(boolean bl) {
        this.bAllowedValues = bl;
    }

    public boolean isAllowedValues() {
        if (this.bAllowedValues == null) {
            return bDefaultAllowedValues;
        }
        return this.bAllowedValues;
    }

    public static void setDefaultAllowedValues(boolean bl) {
        bDefaultAllowedValues = bl;
    }

    public boolean isDefaultAllowedValues() {
        return bDefaultAllowedValues;
    }

    protected String getWritebackTableCatalog() {
        return this.sWritebackTableCatalog;
    }

    protected String getWritebackTableSchema() {
        return this.sWritebackTableSchema;
    }

    protected Object[] refetchRow(Object[] objectArray, boolean bl) throws DataSourceException {
        List<Object[]> list;
        if (objectArray == null) {
            return null;
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        ICondition iCondition = Filter.createEqualsFilter(this.mdServerMetaData.getPrimaryKeyColumnNames(), objectArray, this.mdServerMetaData.getMetaData().getColumnMetaData());
        if (bl) {
            this.dbAccess.lockRow(this.getFromClauseIntern(), this.mdServerMetaData, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 2)) != null && list.size() == 2 && list.get(1) == null) {
            return list.get(0);
        }
        return null;
    }

    public String[] getColumnNames() {
        return this.mdServerMetaData.getColumnNames();
    }

    public Map<String, IStorage> getSubStorages() {
        return this.hmpSubStorages;
    }

    protected DBStorage createAutomaticLinkStorage(String string) throws DataSourceException {
        DBStorage dBStorage = new DBStorage();
        dBStorage.setDBAccess(this.dbAccess);
        dBStorage.setWritebackTable(string);
        dBStorage.setAutoLinkReference(false);
        dBStorage.openInternal(true);
        return dBStorage;
    }

    protected Object createCheckSum(Object ... objectArray) {
        try {
            SecureHash secureHash = new SecureHash("MD5");
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) {
                    if (objectArray[i] instanceof String) {
                        secureHash.add(((String)objectArray[i]).getBytes());
                        continue;
                    }
                    if (objectArray[i] instanceof String[]) {
                        for (String string : (String[])objectArray[i]) {
                            if (string == null) continue;
                            secureHash.add(string.getBytes());
                        }
                        continue;
                    }
                    if (!(objectArray[i] instanceof Boolean)) continue;
                    if (Boolean.TRUE == objectArray[i]) {
                        secureHash.add(new byte[]{1});
                        continue;
                    }
                    secureHash.add(new byte[]{0});
                    continue;
                }
                secureHash.add(new byte[]{0});
            }
            return secureHash.getHash();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static final class CacheLink {
        private String sGroup;
        private String sName;
        private int iHashCode = -1;

        private CacheLink(String string, String string2) {
            this.sGroup = string;
            this.sName = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheLink) {
                return CommonUtil.equals(this.sGroup, ((CacheLink)object).sGroup) && CommonUtil.equals(this.sName, ((CacheLink)object).sName);
            }
            return false;
        }

        public int hashCode() {
            if (this.iHashCode == -1) {
                this.iHashCode = (this.sGroup != null ? this.sGroup.hashCode() : 7) + (this.sName != null ? this.sName.hashCode() : 31);
            }
            return this.iHashCode;
        }
    }
}

