/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 26.02.2010 - [JR] - creation
 */
package javax.rad.application.genui;

import java.util.Hashtable;

import javax.rad.application.IWorkScreen;
import javax.rad.application.IWorkScreenApplication;
import javax.rad.remote.AbstractConnection;

/**
 * The <code>RemoteWorkScreenApplication</code> is a {@link RemoteApplication} with {@link IWorkScreenApplication}
 * implemented. It will be used to make the usage of {@link IWorkScreenApplication} easier and provides some additional
 * methods.
 * 
 * @author Ren Jahn
 */
public abstract class RemoteWorkScreenApplication extends RemoteApplication
                                                  implements IWorkScreenApplication
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>RemoteApplication</code> with
	 * a desired launcher.
	 * 
	 * @param pLauncher the launcher of this application
	 */
	public RemoteWorkScreenApplication(UILauncher pLauncher)
	{
		this(pLauncher, null);
	}
	
	/**
	 * Creates a new instance of <code>RemoteApplication</code> with a desired
	 * launcher and connection.
	 * 
	 * @param pLauncher the launcher of this application
	 * @param pConnection the connection
	 */
	public RemoteWorkScreenApplication(UILauncher pLauncher, AbstractConnection pConnection)
	{
		super(pLauncher);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// User-defined methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Opens a work screen with modality mode of the work screen.
	 * 
	 * @param pClassName the class name of the work screen
	 * @return the work screen.
	 * @throws Throwable if the content could not be initialized
	 */
	public IWorkScreen openWorkScreen(String pClassName) throws Throwable
	{
		return openWorkScreen(pClassName, Modality.WorkScreen, null);
	}

	/**
	 * Opens a work screen with modality mode of the work screen.
	 * 
	 * @param pClassName the class name of the work screen
	 * @param pParameters additional work screen parameters
	 * @return the work screen.
	 * @throws Throwable if the content could not be initialized
	 */
	public IWorkScreen openWorkScreen(String pClassName, Hashtable<String, Object> pParameters) throws Throwable
	{
		return openWorkScreen(pClassName, Modality.WorkScreen, pParameters);
	}
	
}	// RemoteWorkScreenApplication
