/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.type.bean;

import com.sibvisions.util.ArrayUtil;
import javax.rad.type.AbstractType;
import javax.rad.type.IType;
import javax.rad.type.bean.IBeanType;
import javax.rad.type.bean.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanType<T>
extends AbstractType<T>
implements IBeanType<T> {
    protected String className;
    protected String[] propertyNames;
    protected transient PropertyDefinition[] propertyDefinitions;

    protected AbstractBeanType() {
    }

    protected AbstractBeanType(String string, String[] stringArray) {
        this.className = string == null ? string : string.intern();
        if (stringArray == null) {
            this.propertyNames = new String[0];
        } else {
            this.propertyNames = stringArray;
            for (int i = 0; i < this.propertyNames.length; ++i) {
                this.propertyNames[i] = this.propertyNames[i].intern();
            }
        }
        this.propertyDefinitions = null;
    }

    protected AbstractBeanType(String string, PropertyDefinition[] propertyDefinitionArray) {
        this.className = string == null ? string : string.intern();
        if (propertyDefinitionArray == null) {
            this.propertyNames = new String[0];
            this.propertyDefinitions = null;
        } else {
            this.propertyNames = new String[propertyDefinitionArray.length];
            for (int i = 0; i < this.propertyNames.length; ++i) {
                this.propertyNames[i] = propertyDefinitionArray[i].name;
            }
        }
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public int getPropertyIndex(String string) {
        for (int i = 0; i < this.propertyNames.length; ++i) {
            if (string != this.propertyNames[i]) continue;
            return i;
        }
        String string2 = string.intern();
        if (string2 != string) {
            for (int i = 0; i < this.propertyNames.length; ++i) {
                if (string2 != this.propertyNames[i]) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getPropertyCount() {
        return this.propertyNames.length;
    }

    @Override
    public PropertyDefinition getPropertyDefinition(int n) {
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = this.createPropertyDefinitions(this.propertyNames.length);
        }
        return this.propertyDefinitions[n];
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String string) {
        int n = this.getPropertyIndex(string);
        if (n < 0) {
            throw new IllegalArgumentException("The property [" + string + "] does not exist!");
        }
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = this.createPropertyDefinitions(this.propertyNames.length);
        }
        return this.propertyDefinitions[n];
    }

    public int hashCode() {
        int n = this.className == null ? 0 : this.className.hashCode();
        for (int i = 0; i < this.propertyNames.length; ++i) {
            String string = this.propertyNames[i];
            n = 31 * n + string.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractBeanType) {
            AbstractBeanType abstractBeanType = (AbstractBeanType)object;
            if (this.className != abstractBeanType.className || this.propertyNames.length != abstractBeanType.propertyNames.length) {
                return false;
            }
            for (int i = 0; i < this.propertyNames.length; ++i) {
                if (this.propertyNames[i] == abstractBeanType.propertyNames[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    protected PropertyDefinition[] createPropertyDefinitions(int n) {
        PropertyDefinition[] propertyDefinitionArray = new PropertyDefinition[n];
        for (int i = 0; i < this.propertyNames.length; ++i) {
            propertyDefinitionArray[i] = this.createPropertyDefinition(this.propertyNames[i]);
        }
        return propertyDefinitionArray;
    }

    protected PropertyDefinition createPropertyDefinition(String string) {
        return new PropertyDefinition(string, IType.UNKNOWN_TYPE);
    }

    public void addPropertyDefinition(PropertyDefinition propertyDefinition) {
        if (this.className != null) {
            throw new UnsupportedOperationException("A Property can not be added manually if the IBeanType handles a bean class!");
        }
        if (ArrayUtil.indexOfReference(this.propertyNames, propertyDefinition.name) >= 0) {
            throw new IllegalArgumentException("The property " + propertyDefinition.name + " is defined more than once!");
        }
        if (this.propertyDefinitions == null) {
            this.propertyDefinitions = this.createPropertyDefinitions(this.propertyNames.length + 1);
            this.propertyDefinitions[this.propertyNames.length] = propertyDefinition;
        } else {
            this.propertyDefinitions = ArrayUtil.add(this.propertyDefinitions, propertyDefinition);
        }
        this.propertyNames = ArrayUtil.add(this.propertyNames, propertyDefinition.name);
    }

    public void addPropertyDefinition(String string) {
        if (this.className != null) {
            throw new UnsupportedOperationException("The property " + string + " does not exist!");
        }
        if (ArrayUtil.indexOfReference(this.propertyNames, string) >= 0) {
            throw new IllegalArgumentException("The property " + string + " is defined more than once!");
        }
        string = string.intern();
        this.propertyNames = ArrayUtil.add(this.propertyNames, string);
        if (this.propertyDefinitions != null) {
            this.propertyDefinitions = ArrayUtil.add(this.propertyDefinitions, this.createPropertyDefinition(string));
        }
    }
}

