/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.persist;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import javax.rad.model.ModelException;
import javax.rad.persist.ColumnMetaData;

public class MetaData
implements Serializable,
Cloneable {
    private ArrayUtil<ColumnMetaData> auColumnMetaData = new ArrayUtil();
    private Feature[] faFeatures = new Feature[]{Feature.Sort, Feature.Filter, Feature.WriteBack};
    private String[] saPrimaryKeyColumnNames;
    private String[] saRepresentationColumnNames;
    private String[] saAutoIncrementColumnNames;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnMetaData :: ");
        stringBuilder.append(this.auColumnMetaData.toString());
        if (this.saPrimaryKeyColumnNames != null) {
            stringBuilder.append("PrimaryKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saPrimaryKeyColumnNames));
        }
        if (this.saRepresentationColumnNames != null) {
            stringBuilder.append("UniqueKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saRepresentationColumnNames));
        }
        if (this.saAutoIncrementColumnNames != null) {
            stringBuilder.append("AutoIncrementKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saAutoIncrementColumnNames));
        }
        return stringBuilder.toString();
    }

    public MetaData clone() {
        try {
            MetaData metaData = (MetaData)super.clone();
            if (this.saAutoIncrementColumnNames != null) {
                metaData.saAutoIncrementColumnNames = (String[])this.saAutoIncrementColumnNames.clone();
            }
            if (this.saPrimaryKeyColumnNames != null) {
                metaData.saPrimaryKeyColumnNames = (String[])this.saPrimaryKeyColumnNames.clone();
            }
            if (this.saRepresentationColumnNames != null) {
                metaData.saRepresentationColumnNames = (String[])this.saRepresentationColumnNames.clone();
            }
            return metaData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = 31 + (this.auColumnMetaData == null ? 0 : this.auColumnMetaData.hashCode());
        n = 31 * n + Arrays.hashCode((Object[])this.faFeatures);
        n = 31 * n + Arrays.hashCode(this.saAutoIncrementColumnNames);
        n = 31 * n + Arrays.hashCode(this.saPrimaryKeyColumnNames);
        n = 31 * n + Arrays.hashCode(this.saRepresentationColumnNames);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)object;
        if (this.auColumnMetaData == null ? metaData.auColumnMetaData != null : !this.auColumnMetaData.equals(metaData.auColumnMetaData)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.faFeatures, (Object[])metaData.faFeatures)) {
            return false;
        }
        if (!Arrays.equals(this.saAutoIncrementColumnNames, metaData.saAutoIncrementColumnNames)) {
            return false;
        }
        if (!Arrays.equals(this.saPrimaryKeyColumnNames, metaData.saPrimaryKeyColumnNames)) {
            return false;
        }
        return Arrays.equals(this.saRepresentationColumnNames, metaData.saRepresentationColumnNames);
    }

    public void addColumnMetaData(ColumnMetaData columnMetaData) {
        this.auColumnMetaData.add(columnMetaData);
    }

    public void setColumnMetaData(ColumnMetaData[] columnMetaDataArray) {
        this.auColumnMetaData.clear();
        this.auColumnMetaData.addAll((ColumnMetaData[])columnMetaDataArray);
    }

    public ColumnMetaData[] getColumnMetaData() {
        return this.auColumnMetaData.toArray(new ColumnMetaData[this.auColumnMetaData.size()]);
    }

    public ColumnMetaData getColumnMetaData(String string) throws ModelException {
        int n = this.getColumnMetaDataIndex(string);
        if (n >= 0) {
            return this.auColumnMetaData.get(n);
        }
        throw new ModelException("Column '" + string + "' doesn't exists in MetaData!");
    }

    public int getColumnMetaDataIndex(String string) {
        for (int i = 0; i < this.auColumnMetaData.size(); ++i) {
            if (!this.auColumnMetaData.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String[] getPrimaryKeyColumnNames() {
        return this.saPrimaryKeyColumnNames;
    }

    public void setPrimaryKeyColumnNames(String[] stringArray) {
        this.saPrimaryKeyColumnNames = stringArray;
    }

    public String[] getRepresentationColumnNames() {
        return this.saRepresentationColumnNames;
    }

    public void setRepresentationColumnNames(String[] stringArray) {
        this.saRepresentationColumnNames = stringArray;
    }

    public String[] getAutoIncrementColumnNames() {
        return this.saAutoIncrementColumnNames;
    }

    public void setAutoIncrementColumnNames(String[] stringArray) {
        this.saAutoIncrementColumnNames = stringArray;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.auColumnMetaData.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.auColumnMetaData.get(i).getName();
        }
        return stringArray;
    }

    public void setFeatures(Feature ... featureArray) {
        this.faFeatures = featureArray == null ? new Feature[0] : featureArray;
    }

    public void addFeature(Feature feature) {
        if (!ArrayUtil.contains(this.faFeatures, feature)) {
            this.faFeatures = ArrayUtil.add(this.faFeatures, feature);
        }
    }

    public void removeFeature(Feature feature) {
        this.faFeatures = ArrayUtil.remove(this.faFeatures, feature);
    }

    public Feature[] getFeatures() {
        return this.faFeatures;
    }

    public boolean isSupported(Feature feature) {
        return ArrayUtil.contains(this.faFeatures, feature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        Sort,
        Filter,
        WriteBack;

    }
}

