/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.condition;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.condition.And;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.Greater;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Less;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.condition.Not;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.condition.Or;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.ui.celleditor.ILinkedCellEditor;

public class Filter {
    protected Filter() {
    }

    public static ICondition createLikeFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new Like(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Like(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createLikeIgnoreCaseFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new LikeIgnoreCase(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new LikeIgnoreCase(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createEqualsFilter(IDataRow iDataRow, String[] stringArray) {
        return Filter.createEqualsFilter(iDataRow, stringArray, true);
    }

    public static ICondition createEqualsFilter(IDataRow iDataRow, String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new Equals(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Equals(iDataRow, stringArray[i], bl));
        }
        return baseCondition;
    }

    public static ICondition createEqualsFilter(String[] stringArray, Object[] objectArray, ColumnMetaData[] columnMetaDataArray) {
        if (stringArray.length == 0) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = columnMetaDataArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = ArrayUtil.indexOf(stringArray, columnMetaDataArray[i].getName());
            if (n2 < 0) continue;
            nArray[n2] = i;
        }
        BaseCondition baseCondition = new Equals(stringArray[0], objectArray[nArray[0]]);
        for (n = 1; n < stringArray.length; ++n) {
            baseCondition = baseCondition.and(new Equals(stringArray[n], objectArray[nArray[n]]));
        }
        return baseCondition;
    }

    public static ICondition createFilter(IDataRow iDataRow) {
        return Filter.createFilter(iDataRow, iDataRow.getRowDefinition().getColumnNames());
    }

    public static ICondition createFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = null;
        CompareCondition compareCondition = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDefinition columnDefinition = iDataRow.getRowDefinition().getColumnDefinition(i);
            IDataType iDataType = columnDefinition.getDataType();
            compareCondition = iDataType instanceof TimestampDataType && i + 1 < stringArray.length && iDataRow.getRowDefinition().getColumnDefinition(i + 1).getDataType() instanceof TimestampDataType ? new GreaterEquals(iDataRow, stringArray[i]) : (iDataType instanceof TimestampDataType && compareCondition instanceof GreaterEquals ? new LessEquals(iDataRow, stringArray[i]) : (iDataType instanceof BigDecimalDataType || iDataType instanceof BooleanDataType || iDataType.getCellEditor() instanceof ILinkedCellEditor && ((ILinkedCellEditor)iDataType.getCellEditor()).isValidationEnabled() || iDataType instanceof TimestampDataType ? new Equals(iDataRow, stringArray[i]) : (iDataType instanceof StringDataType ? new LikeIgnoreCase(iDataRow, stringArray[i]) : null)));
            if (compareCondition == null) continue;
            baseCondition = baseCondition == null ? compareCondition : baseCondition.and(compareCondition);
        }
        return baseCondition;
    }

    public static ICondition createFullTextFilter(IDataBook iDataBook, String string, String ... stringArray) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String[] stringArray2 = stringArray != null && stringArray.length > 0 ? stringArray : iDataBook.getRowDefinition().getColumnNames();
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            try {
                if (!(iDataBook.getRowDefinition().getColumnDefinition(stringArray2[i]).getDataType() instanceof BinaryDataType) && iDataBook.getRowDefinition().getColumnDefinition(stringArray2[i]).isWritable()) continue;
                stringArray2 = (String[])ArrayUtil.remove(stringArray2, i);
                continue;
            }
            catch (ModelException modelException) {
                stringArray2 = (String[])ArrayUtil.remove(stringArray2, i);
            }
        }
        string = "*" + string.trim() + "*";
        Or or = new Or();
        for (int i = 0; i < stringArray2.length; ++i) {
            or.add(new LikeIgnoreCase(stringArray2[i], (Object)string));
        }
        return or;
    }

    public static String toString(ICondition iCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            if (!compareCondition.isIgnoreNull() || object != null) {
                String string = compareCondition.getColumnName();
                String string2 = CommonUtil.nvl(compareCondition.getValue(), "?");
                if ((compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) && compareCondition.getValue() != null) {
                    if (compareCondition instanceof LikeReverse) {
                        stringBuilder.append((Object)string2);
                    } else if (compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("UPPER(");
                        stringBuilder.append((Object)string2);
                        stringBuilder.append(")");
                    }
                } else if (compareCondition instanceof LikeIgnoreCase) {
                    stringBuilder.append("UPPER(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(' ');
                if (compareCondition.getValue() == null) {
                    stringBuilder.append("IS NULL");
                } else {
                    if (compareCondition instanceof Equals) {
                        stringBuilder.append("= ");
                    } else if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("LIKE UPPER(");
                    } else if (compareCondition instanceof Like || compareCondition instanceof LikeReverse) {
                        stringBuilder.append("LIKE ");
                    } else if (compareCondition instanceof Greater) {
                        stringBuilder.append("> ");
                    } else if (compareCondition instanceof GreaterEquals) {
                        stringBuilder.append(">= ");
                    } else if (compareCondition instanceof Less) {
                        stringBuilder.append("< ");
                    } else if (compareCondition instanceof LessEquals) {
                        stringBuilder.append("<= ");
                    } else {
                        stringBuilder.append(' ');
                    }
                    if (compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(string);
                    } else {
                        stringBuilder.append((Object)string2);
                    }
                    if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(")");
                    }
                }
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                String string = Filter.toString(iConditionArray[i]);
                if (string == null || string.length() <= 0) continue;
                if (i > 0 && stringBuilder.length() > 0) {
                    if (operatorCondition instanceof And) {
                        stringBuilder.append(" AND ");
                    } else if (operatorCondition instanceof Or) {
                        stringBuilder.append(" OR ");
                    }
                }
                if (iConditionArray[i] instanceof OperatorCondition) {
                    stringBuilder.append("(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                    continue;
                }
                stringBuilder.append(string);
            }
        } else if (iCondition instanceof Not) {
            ICondition iCondition2 = ((Not)iCondition).getCondition();
            String string = Filter.toString(iCondition2);
            stringBuilder.append("NOT ");
            if (iCondition2 instanceof OperatorCondition) {
                stringBuilder.append("(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static ICondition createCondition(ICondition iCondition, boolean bl, String ... stringArray) {
        ICondition iCondition2;
        ICondition iCondition3;
        ICondition iCondition4 = null;
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            String string = compareCondition.getColumnName();
            if (bl) {
                if (ArrayUtil.contains(stringArray, string)) {
                    iCondition4 = compareCondition;
                }
            } else if (!ArrayUtil.contains(stringArray, string)) {
                iCondition4 = compareCondition;
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                ICondition iCondition5 = Filter.createCondition(iConditionArray[i], bl, stringArray);
                if (iCondition5 == null) continue;
                if (i > 0 && iCondition4 != null) {
                    if (operatorCondition instanceof And) {
                        iCondition4 = iCondition4.and(iCondition5);
                        continue;
                    }
                    if (!(operatorCondition instanceof Or)) continue;
                    iCondition4 = iCondition4.or(iCondition5);
                    continue;
                }
                iCondition4 = iCondition5;
            }
        } else if (iCondition instanceof Not && (iCondition3 = Filter.createCondition(iCondition2 = ((Not)iCondition).getCondition(), bl, stringArray)) != null) {
            iCondition4 = new Not(iCondition3);
        }
        return iCondition4;
    }
}

