/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import javax.rad.genui.UIColor;
import javax.rad.genui.UICursor;
import javax.rad.genui.UIDimension;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.UIFont;
import javax.rad.genui.UIPoint;
import javax.rad.genui.UIRectangle;
import javax.rad.genui.UIResource;
import javax.rad.model.ui.ITranslatable;
import javax.rad.ui.IColor;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.ICursor;
import javax.rad.ui.IDimension;
import javax.rad.ui.IFactory;
import javax.rad.ui.IFont;
import javax.rad.ui.IImage;
import javax.rad.ui.IPoint;
import javax.rad.ui.IRectangle;
import javax.rad.ui.control.ICellFormatter;
import javax.rad.ui.control.INodeFormatter;
import javax.rad.ui.event.ComponentHandler;
import javax.rad.ui.event.KeyHandler;
import javax.rad.ui.event.MouseHandler;
import javax.rad.util.EventHandler;
import javax.rad.util.TranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponent<C extends IComponent>
extends UIResource<C>
implements IComponent,
ITranslatable {
    private static EventHandler<Runnable> runnableEventHandler = new EventHandler<Runnable>(Runnable.class, new Class[0]);
    private static EventHandler<ICellFormatter> cellFormatterProvider = new EventHandler<ICellFormatter>(ICellFormatter.class, new Class[0]);
    private static EventHandler<INodeFormatter> nodeFormatterProvider = new EventHandler<INodeFormatter>(INodeFormatter.class, new Class[0]);
    private ILogger logger = null;
    protected IContainer parent = null;
    private IComponent parentExpected = null;
    private TranslationMap tmpUserdefined = null;
    private TranslationMap tmpCurrent = null;
    private String sToolTip = null;
    protected long lLastTranslationModified = -1L;
    private boolean bBeforeNotified = false;
    private boolean bNotified = false;
    private boolean bTranslate = true;

    protected UIComponent(C c) {
        super(c);
        c.setEventSource(this);
    }

    @Override
    public String getName() {
        return ((IComponent)this.uiResource).getName();
    }

    @Override
    public void setName(String string) {
        ((IComponent)this.uiResource).setName(string);
    }

    @Override
    public IFactory getFactory() {
        return ((IComponent)this.uiResource).getFactory();
    }

    @Override
    public IDimension getPreferredSize() {
        return this.getComponentUIResource().getPreferredSize();
    }

    @Override
    public void setPreferredSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setPreferredSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setPreferredSize(iDimension);
        }
    }

    public void setPreferredSize(int n, int n2) {
        this.getComponentUIResource().setPreferredSize(this.getFactory().createDimension(n, n2));
    }

    @Override
    public boolean isPreferredSizeSet() {
        return this.getComponentUIResource().isPreferredSizeSet();
    }

    @Override
    public IDimension getMinimumSize() {
        return this.getComponentUIResource().getMinimumSize();
    }

    @Override
    public void setMinimumSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setMinimumSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setMinimumSize(iDimension);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.getComponentUIResource().setMinimumSize(this.getFactory().createDimension(n, n2));
    }

    @Override
    public boolean isMinimumSizeSet() {
        return this.getComponentUIResource().isMinimumSizeSet();
    }

    @Override
    public IDimension getMaximumSize() {
        return this.getComponentUIResource().getMaximumSize();
    }

    @Override
    public void setMaximumSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setMaximumSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setMaximumSize(iDimension);
        }
    }

    public void setMaximumSize(int n, int n2) {
        this.getComponentUIResource().setMaximumSize(this.getFactory().createDimension(n, n2));
    }

    @Override
    public boolean isMaximumSizeSet() {
        return this.getComponentUIResource().isMaximumSizeSet();
    }

    @Override
    public IColor getBackground() {
        return ((IComponent)this.uiResource).getBackground();
    }

    @Override
    public void setBackground(IColor iColor) {
        if (iColor instanceof UIColor) {
            ((IComponent)this.uiResource).setBackground((IColor)((UIColor)iColor).uiResource);
        } else {
            ((IComponent)this.uiResource).setBackground(iColor);
        }
    }

    @Override
    public boolean isBackgroundSet() {
        return ((IComponent)this.uiResource).isBackgroundSet();
    }

    @Override
    public IColor getForeground() {
        return ((IComponent)this.uiResource).getForeground();
    }

    @Override
    public void setForeground(IColor iColor) {
        if (iColor instanceof UIColor) {
            ((IComponent)this.uiResource).setForeground((IColor)((UIColor)iColor).uiResource);
        } else {
            ((IComponent)this.uiResource).setForeground(iColor);
        }
    }

    @Override
    public boolean isForegroundSet() {
        return ((IComponent)this.uiResource).isForegroundSet();
    }

    @Override
    public ICursor getCursor() {
        return ((IComponent)this.uiResource).getCursor();
    }

    @Override
    public void setCursor(ICursor iCursor) {
        if (iCursor instanceof UICursor) {
            ((IComponent)this.uiResource).setCursor((ICursor)((UICursor)iCursor).uiResource);
        } else {
            ((IComponent)this.uiResource).setCursor(iCursor);
        }
    }

    @Override
    public boolean isCursorSet() {
        return ((IComponent)this.uiResource).isCursorSet();
    }

    @Override
    public IFont getFont() {
        return ((IComponent)this.uiResource).getFont();
    }

    @Override
    public void setFont(IFont iFont) {
        if (iFont instanceof UIFont) {
            ((IComponent)this.uiResource).setFont((IFont)((UIFont)iFont).uiResource);
        } else {
            ((IComponent)this.uiResource).setFont(iFont);
        }
    }

    @Override
    public boolean isFontSet() {
        return ((IComponent)this.uiResource).isFontSet();
    }

    @Override
    public String getToolTipText() {
        return this.sToolTip;
    }

    @Override
    public void setToolTipText(String string) {
        this.sToolTip = string;
        ((IComponent)this.uiResource).setToolTipText(this.translate(string));
    }

    @Override
    public void setFocusable(boolean bl) {
        ((IComponent)this.uiResource).setFocusable(bl);
    }

    @Override
    public boolean isFocusable() {
        return ((IComponent)this.uiResource).isFocusable();
    }

    @Override
    public void requestFocus() {
        ((IComponent)this.uiResource).requestFocus();
    }

    @Override
    public IContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainer iContainer) {
        if (iContainer == null) {
            if (this.parent != null && this.parent.indexOf(this) >= 0) {
                throw new IllegalArgumentException("Can't unset parent, because this component is still added!");
            }
        } else if (iContainer.indexOf(this) < 0) {
            throw new IllegalArgumentException("Can't set parent, because this component is not added!");
        }
        boolean bl = this.parent != null && this.parent != iContainer;
        this.parent = iContainer;
        if (bl && this.isNotified()) {
            this.updateTranslation();
        }
    }

    @Override
    public boolean isVisible() {
        return this.getComponentUIResource().isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        this.getComponentUIResource().setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        ((IComponent)this.uiResource).setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return ((IComponent)this.uiResource).isEnabled();
    }

    @Override
    public IPoint getLocationRelativeTo(IComponent iComponent) {
        return ((IComponent)this.uiResource).getLocationRelativeTo(iComponent);
    }

    @Override
    public void setLocationRelativeTo(IComponent iComponent, IPoint iPoint) {
        ((IComponent)this.uiResource).setLocationRelativeTo(iComponent, iPoint);
    }

    @Override
    public IPoint getLocation() {
        return this.getComponentUIResource().getLocation();
    }

    @Override
    public void setLocation(IPoint iPoint) {
        if (iPoint instanceof UIPoint) {
            this.getComponentUIResource().setLocation((IPoint)((UIPoint)iPoint).uiResource);
        } else {
            this.getComponentUIResource().setLocation(iPoint);
        }
    }

    public void setLocation(int n, int n2) {
        this.getComponentUIResource().setLocation(this.getFactory().createPoint(n, n2));
    }

    @Override
    public IDimension getSize() {
        return this.getComponentUIResource().getSize();
    }

    @Override
    public void setSize(IDimension iDimension) {
        if (iDimension instanceof UIDimension) {
            this.getComponentUIResource().setSize((IDimension)((UIDimension)iDimension).uiResource);
        } else {
            this.getComponentUIResource().setSize(iDimension);
        }
    }

    public void setSize(int n, int n2) {
        this.getComponentUIResource().setSize(this.getFactory().createDimension(n, n2));
    }

    @Override
    public IRectangle getBounds() {
        return this.getComponentUIResource().getBounds();
    }

    @Override
    public void setBounds(IRectangle iRectangle) {
        if (iRectangle instanceof UIRectangle) {
            this.getComponentUIResource().setBounds((IRectangle)((UIRectangle)iRectangle).uiResource);
        } else {
            this.getComponentUIResource().setBounds(iRectangle);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.getComponentUIResource().setBounds(this.getFactory().createRectangle(n, n2, n3, n4));
    }

    @Override
    public Object getResource() {
        return this.getComponentUIResource().getResource();
    }

    @Override
    public IComponent getEventSource() {
        return ((IComponent)this.uiResource).getEventSource();
    }

    @Override
    public void setEventSource(IComponent iComponent) {
        ((IComponent)this.uiResource).setEventSource(iComponent);
    }

    @Override
    public MouseHandler eventMousePressed() {
        return ((IComponent)this.uiResource).eventMousePressed();
    }

    @Override
    public MouseHandler eventMouseReleased() {
        return ((IComponent)this.uiResource).eventMouseReleased();
    }

    @Override
    public MouseHandler eventMouseClicked() {
        return ((IComponent)this.uiResource).eventMouseClicked();
    }

    @Override
    public MouseHandler eventMouseEntered() {
        return ((IComponent)this.uiResource).eventMouseEntered();
    }

    @Override
    public MouseHandler eventMouseExited() {
        return ((IComponent)this.uiResource).eventMouseExited();
    }

    @Override
    public KeyHandler eventKeyPressed() {
        return ((IComponent)this.uiResource).eventKeyPressed();
    }

    @Override
    public KeyHandler eventKeyReleased() {
        return ((IComponent)this.uiResource).eventKeyReleased();
    }

    @Override
    public KeyHandler eventKeyTyped() {
        return ((IComponent)this.uiResource).eventKeyTyped();
    }

    @Override
    public ComponentHandler eventComponentResized() {
        return ((IComponent)this.uiResource).eventComponentResized();
    }

    @Override
    public ComponentHandler eventComponentMoved() {
        return ((IComponent)this.uiResource).eventComponentMoved();
    }

    @Override
    public IImage capture(int n, int n2) {
        return this.getComponentUIResource().capture(n, n2);
    }

    public static void invokeLater(Runnable runnable) {
        UIFactoryManager.getFactory().invokeLater(runnable);
    }

    public static void invokeLater(Object object, String string) {
        UIFactoryManager.getFactory().invokeLater(runnableEventHandler.createListener(object, string));
    }

    public static void invokeAndWait(Runnable runnable) throws Exception {
        UIFactoryManager.getFactory().invokeAndWait(runnable);
    }

    public static void invokeAndWait(Object object, String string) throws Exception {
        UIFactoryManager.getFactory().invokeAndWait(runnableEventHandler.createListener(object, string));
    }

    public static void invokeInThread(Runnable runnable) {
        UIFactoryManager.getFactory().invokeInThread(runnable);
    }

    public static void invokeInThread(Object object, String string) {
        UIFactoryManager.getFactory().invokeInThread(runnableEventHandler.createListener(object, string));
    }

    public static ICellFormatter createCellFormatter(Object object, String string) {
        return cellFormatterProvider.createListener(object, string);
    }

    public static INodeFormatter createNodeFormatter(Object object, String string) {
        return nodeFormatterProvider.createListener(object, string);
    }

    protected IComponent getComponentUIResource() {
        return (IComponent)this.getUIResource();
    }

    public void debug(Object ... objectArray) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getInstance(this.getClass());
        }
        this.logger.debug(objectArray);
    }

    public void info(Object ... objectArray) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getInstance(this.getClass());
        }
        this.logger.info(objectArray);
    }

    public void error(Object ... objectArray) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getInstance(this.getClass());
        }
        this.logger.error(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAddNotify(IComponent iComponent) {
        this.parentExpected = iComponent;
        this.bBeforeNotified = true;
        try {
            this.updateTranslation();
            Object var3_2 = null;
            this.parentExpected = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parentExpected = null;
            throw throwable;
        }
    }

    public boolean isBeforeNotified() {
        return this.bBeforeNotified;
    }

    public void addNotify() {
        this.bNotified = true;
        if (!this.bBeforeNotified) {
            this.updateTranslation();
        }
    }

    public boolean isNotified() {
        return this.bNotified;
    }

    public void removeNotify() {
        this.bBeforeNotified = false;
        this.bNotified = false;
    }

    @Override
    public void setTranslation(TranslationMap translationMap) {
        if (this.tmpCurrent != translationMap) {
            this.lLastTranslationModified = -1L;
        }
        this.tmpUserdefined = translationMap;
        this.tmpCurrent = translationMap;
        if (this.isNotified()) {
            this.updateTranslation();
        }
    }

    @Override
    public TranslationMap getTranslation() {
        return this.tmpUserdefined;
    }

    public void setTranslationEnabled(boolean bl) {
        this.bTranslate = bl;
    }

    public boolean isTranslationEnabled() {
        return this.bTranslate;
    }

    protected TranslationMap getCurrentTranslation() {
        return this.tmpCurrent;
    }

    public String translate(String string) {
        if (this.bTranslate && this.tmpCurrent != null) {
            return this.tmpCurrent.translate(string);
        }
        return string;
    }

    public void updateTranslation() {
        IComponent iComponent = this.parent == null ? this.parentExpected : this.parent;
        if (iComponent != null && this.tmpUserdefined == null) {
            if (this.tmpCurrent != ((UIComponent)iComponent).tmpCurrent) {
                this.lLastTranslationModified = -1L;
            }
            this.tmpCurrent = ((UIComponent)iComponent).tmpCurrent;
        }
        if (this.isTranslationChanged()) {
            if (this.sToolTip != null) {
                ((IComponent)this.uiResource).setToolTipText(this.translate(this.sToolTip));
            }
            if (this.tmpCurrent != null) {
                this.lLastTranslationModified = this.tmpCurrent.lastModified();
            }
        }
    }

    protected boolean isTranslationChanged() {
        IComponent iComponent = this.parent == null ? this.parentExpected : this.parent;
        return this.lLastTranslationModified == -1L || iComponent != null && this.tmpCurrent != ((UIComponent)iComponent).tmpCurrent || this.tmpCurrent != null && this.tmpCurrent.lastModified() != this.lLastTranslationModified;
    }
}

