/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.event.IExecuteListener;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Execute {
    private String sProgram = null;
    private File fiWorkDir = null;
    private ArrayList<String> alParams = null;
    private Process proc;
    private ProcessStreamReader psrOutput = null;
    private ProcessStreamReader psrError = null;
    private PrintStream psOutForward = null;
    private PrintStream psErrForward = null;
    private ILogger log = null;
    private List<IExecuteListener> listener = null;
    private boolean bParamsLog = true;
    private int iBufferCharCount = 4000;

    public void setProgram(String string) {
        this.sProgram = string;
    }

    public String getProgram() {
        return this.sProgram;
    }

    public void addParameter(String string) {
        if (this.alParams == null) {
            this.alParams = new ArrayList();
        }
        this.alParams.add(string);
    }

    private String[] getCommand() {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        String string = this.getProgram();
        arrayUtil.add(string);
        if (this.alParams != null) {
            for (String string2 : this.alParams) {
                if (string2 == null) {
                    arrayUtil.add(" ");
                    continue;
                }
                arrayUtil.add(string2);
            }
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(boolean bl) throws Exception {
        block10: {
            this.destroy();
            String[] stringArray = this.getCommand();
            if (this.log == null) {
                this.log = LoggerFactory.getInstance(this.getClass());
            }
            Runtime runtime = Runtime.getRuntime();
            this.proc = null;
            try {
                if (this.bParamsLog) {
                    this.log.info(new Object[]{stringArray});
                } else {
                    this.log.info(this.getProgram());
                }
                this.proc = this.fiWorkDir == null ? runtime.exec(stringArray) : runtime.exec(stringArray, null, this.fiWorkDir);
                this.psrOutput = new ProcessStreamReader(this.proc.getInputStream(), this.psOutForward);
                this.psrOutput.iCharCount = this.iBufferCharCount;
                this.psrError = new ProcessStreamReader(this.proc.getErrorStream(), this.psErrForward);
                this.psrError.iCharCount = this.iBufferCharCount;
                if (!bl) break block10;
                int n = this.proc.waitFor();
                if (this.bParamsLog) {
                    this.log.debug(stringArray, "\n:: OUTPUT ::\n~~~~~~~~~~~~\n", this.getOutput(), "\n:: TYPE_ERROR  ::\n~~~~~~~~~~~~\n", this.getError());
                } else {
                    this.log.debug(this.getProgram(), "\n:: OUTPUT ::\n~~~~~~~~~~~~\n", this.getOutput(), "\n:: TYPE_ERROR  ::\n~~~~~~~~~~~~\n", this.getError());
                }
                boolean bl2 = n == 0;
                Object var7_7 = null;
                if (bl) {
                    this.destroy();
                }
                return bl2;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var7_9 = null;
                    if (!bl) break block11;
                    this.destroy();
                }
                throw throwable;
            }
        }
        ThreadHandler.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Execute.this.proc.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        Execute.this.destroy();
                    }
                    Object var3_1 = null;
                    Execute.this.destroy();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    Execute.this.destroy();
                    throw throwable;
                }
            }
        });
        boolean bl3 = true;
        Object var7_8 = null;
        if (bl) {
            this.destroy();
        }
        return bl3;
    }

    public void destroy() {
        if (this.psrOutput != null) {
            this.psrOutput.terminate();
        }
        if (this.psrError != null) {
            this.psrError.terminate();
        }
        if (this.proc != null) {
            this.proc.destroy();
            this.proc = null;
        }
        if (this.listener != null) {
            for (IExecuteListener iExecuteListener : this.listener) {
                iExecuteListener.destroyed(this);
            }
        }
    }

    public String getError() {
        if (this.psrError != null) {
            return this.psrError.getResult();
        }
        return null;
    }

    public String getOutput() {
        if (this.psrOutput != null) {
            return this.psrOutput.getResult();
        }
        return null;
    }

    public void setWorkingDirectory(File file) {
        this.fiWorkDir = file;
    }

    public File getWorkingDirectory() {
        return this.fiWorkDir;
    }

    public void setOutputForwarder(PrintStream printStream) {
        this.psOutForward = printStream;
    }

    public PrintStream getOutputForwarder() {
        return this.psOutForward;
    }

    public void setErrorForwarder(PrintStream printStream) {
        this.psErrForward = printStream;
    }

    public PrintStream getErrorForwarder() {
        return this.psErrForward;
    }

    public void addListener(IExecuteListener iExecuteListener) {
        if (this.listener == null) {
            this.listener = new ArrayUtil<IExecuteListener>();
        }
        this.listener.add(iExecuteListener);
    }

    public void removeListener(IExecuteListener iExecuteListener) {
        if (this.listener != null) {
            this.listener.remove(iExecuteListener);
            if (this.listener.size() == 0) {
                this.listener = null;
            }
        }
    }

    public void send(byte[] byArray) throws IOException {
        OutputStream outputStream = this.proc.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
    }

    public boolean isRunning() {
        try {
            if (this.proc != null) {
                this.proc.exitValue();
            }
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public void setParamsLogEnabled(boolean bl) {
        this.bParamsLog = bl;
    }

    public boolean isParamsLogEnabled() {
        return this.bParamsLog;
    }

    public void setBufferCharacterCount(int n) {
        this.iBufferCharCount = n;
    }

    public int getBufferCharacterCount() {
        return this.iBufferCharCount;
    }

    static class ProcessStreamReader
    implements Runnable {
        private InputStream isIn = null;
        private Thread thRead = null;
        private StringBuilder sbResult;
        private PrintStream psForwarder;
        private int iCharCount = -1;

        ProcessStreamReader(InputStream inputStream, PrintStream printStream) {
            this.isIn = inputStream;
            this.thRead = ThreadHandler.start(this);
            this.psForwarder = printStream;
            this.sbResult = new StringBuilder();
        }

        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n;
                while ((n = this.isIn.read(byArray)) >= 0) {
                    String string = new String(byArray, 0, n);
                    if (this.psForwarder != null) {
                        this.psForwarder.append(string);
                    }
                    if (this.iCharCount > 0 && this.sbResult.length() > this.iCharCount) {
                        this.sbResult = new StringBuilder();
                    }
                    this.sbResult.append(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void terminate() {
            this.thRead = ThreadHandler.stop(this.thRead);
        }

        public String getResult() {
            return this.sbResult.toString();
        }
    }
}

