/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.layout;

import com.sibvisions.rad.ui.swing.ext.JVxConstants;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxFormLayout
implements LayoutManager2,
JVxConstants {
    public static final String NEWLINE = "\n";
    private Anchor leftAnchor = new Anchor(this, 0);
    private Anchor rightAnchor = new Anchor(this, 0);
    private Anchor topAnchor = new Anchor(this, 1);
    private Anchor bottomAnchor = new Anchor(this, 1);
    private Anchor leftMarginAnchor = new Anchor(this.leftAnchor, 10);
    private Anchor rightMarginAnchor = new Anchor(this.rightAnchor, -10);
    private Anchor topMarginAnchor = new Anchor(this.topAnchor, 10);
    private Anchor bottomMarginAnchor = new Anchor(this.bottomAnchor, -10);
    private List<Anchor> horizontalAnchors = new ArrayList<Anchor>();
    private List<Anchor> verticalAnchors = new ArrayList<Anchor>();
    private List<Anchor> anchorsBuffer = new ArrayList<Anchor>();
    private List<Anchor> leftDefaultAnchors = new ArrayList<Anchor>();
    private List<Anchor> topDefaultAnchors = new ArrayList<Anchor>();
    private List<Anchor> rightDefaultAnchors = new ArrayList<Anchor>();
    private List<Anchor> bottomDefaultAnchors = new ArrayList<Anchor>();
    private Hashtable<Component, Constraint> constraints = new Hashtable();
    private int horizontalAlignment = 100;
    private int verticalAlignment = 100;
    private int hgap = 5;
    private int vgap = 5;
    private int newlineCount = 2;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private int minimumWidth = 0;
    private int minimumHeight = 0;
    private boolean valid = false;
    private boolean calculateTargetDependentAnchors = false;
    private boolean leftBorderUsed = false;
    private boolean rightBorderUsed = false;
    private boolean topBorderUsed = false;
    private boolean bottomBorderUsed = false;

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.valid = false;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        Constraint constraint;
        if (object instanceof Constraint) {
            constraint = (Constraint)object;
        } else {
            constraint = null;
            Container container = component.getParent();
            int n = container.getComponentZOrder(component);
            if (n == container.getComponentCount() - 1) {
                Constraint constraint2 = n == 0 ? null : this.getConstraint(container.getComponent(n - 1));
                if (constraint2 == null) {
                    constraint = this.createConstraint(0, 0);
                } else {
                    int n2 = this.leftDefaultAnchors.indexOf(constraint2.leftAnchor) / 2 + 1;
                    int n3 = this.topDefaultAnchors.indexOf(constraint2.topAnchor) / 2;
                    if (object == NEWLINE || object == null && n2 % this.newlineCount == 0) {
                        constraint = this.createConstraint(0, n3 + 1);
                    } else if (object == null) {
                        constraint = this.createConstraint(n2, n3);
                    }
                }
            }
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Constraint " + object + " is not allowed!");
        }
        if (constraint.getLeftAnchor().getLayout() != this || constraint.getRightAnchor().getLayout() != this || constraint.getTopAnchor().getLayout() != this || constraint.getBottomAnchor().getLayout() != this) {
            throw new IllegalArgumentException("Constraint " + object + " has anchors for an other layout!");
        }
        this.constraints.put(component, constraint);
        this.valid = false;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
        this.valid = false;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (container.isMinimumSizeSet()) {
            return container.getMinimumSize();
        }
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.calculateAnchors(container);
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        if (container.isMaximumSizeSet()) {
            return container.getMaximumSize();
        }
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container container) {
        this.calculateAnchors(container);
        this.calculateTargetDependentAnchors(container);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Constraint constraint = this.getConstraint(component);
            int n = constraint.leftAnchor.getAbsolutePosition();
            int n2 = constraint.rightAnchor.getAbsolutePosition() - n;
            int n3 = constraint.topAnchor.getAbsolutePosition();
            int n4 = constraint.bottomAnchor.getAbsolutePosition() - n3;
            component.setBounds(n, n3, n2, n4);
        }
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public void setHorizontalGap(int n) {
        this.hgap = n;
    }

    public int getVerticalGap() {
        return this.vgap;
    }

    public void setVerticalGap(int n) {
        this.vgap = n;
    }

    public Insets getMargins() {
        return new Insets(this.topMarginAnchor.position, this.leftMarginAnchor.position, -this.bottomMarginAnchor.position, -this.rightMarginAnchor.position);
    }

    public void setMargins(Insets insets) {
        if (insets == null) {
            this.topMarginAnchor.position = 0;
            this.leftMarginAnchor.position = 0;
            this.bottomMarginAnchor.position = 0;
            this.rightMarginAnchor.position = 0;
        } else {
            this.topMarginAnchor.position = insets.top;
            this.leftMarginAnchor.position = insets.left;
            this.bottomMarginAnchor.position = -insets.bottom;
            this.rightMarginAnchor.position = -insets.right;
        }
    }

    public int getNewlineCount() {
        return this.newlineCount;
    }

    public void setNewlineCount(int n) {
        this.newlineCount = n;
    }

    public Anchor getLeftAnchor() {
        return this.leftAnchor;
    }

    public Anchor getRightAnchor() {
        return this.rightAnchor;
    }

    public Anchor getTopAnchor() {
        return this.topAnchor;
    }

    public Anchor getBottomAnchor() {
        return this.bottomAnchor;
    }

    public Anchor getLeftMarginAnchor() {
        return this.leftMarginAnchor;
    }

    public Anchor getRightMarginAnchor() {
        return this.rightMarginAnchor;
    }

    public Anchor getTopMarginAnchor() {
        return this.topMarginAnchor;
    }

    public Anchor getBottomMarginAnchor() {
        return this.bottomMarginAnchor;
    }

    public Anchor[] getHorizontalAnchors() {
        return this.horizontalAnchors.toArray(new Anchor[this.horizontalAnchors.size()]);
    }

    public Anchor[] getVerticalAnchors() {
        return this.verticalAnchors.toArray(new Anchor[this.verticalAnchors.size()]);
    }

    public Constraint getConstraint(Component component) {
        return this.constraints.get(component);
    }

    public void setConstraint(Component component, Constraint constraint) {
        if (!this.constraints.containsKey(component)) {
            throw new IllegalArgumentException("Component " + component + " has no constraints to overwrite!");
        }
        this.constraints.put(component, constraint);
    }

    private Anchor[] createDefaultAnchors(List<Anchor> list, List<Anchor> list2, Anchor anchor, Anchor anchor2, int n, int n2) {
        int n3;
        Anchor anchor3;
        List<Anchor> list3;
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = (-n - 1) * 2;
            list3 = list2;
            anchor3 = anchor2;
            n3 = -n2;
        } else {
            n *= 2;
            list3 = list;
            anchor3 = anchor;
            n3 = n2;
        }
        int n4 = list3.size();
        while (n >= n4) {
            if (n4 == 0) {
                list3.add(anchor3);
            } else {
                list3.add(new Anchor(list3.get(n4 - 1), n3));
            }
            list3.add(new Anchor(list3.get(n4)));
            n4 = list3.size();
        }
        if (bl) {
            return new Anchor[]{list3.get(n + 1), list3.get(n)};
        }
        return new Anchor[]{list3.get(n), list3.get(n + 1)};
    }

    public Constraint createConstraint(int n, int n2) {
        return this.createConstraint(n, n2, n, n2);
    }

    public Constraint createConstraint(int n, int n2, int n3, int n4) {
        Anchor[] anchorArray = this.createDefaultAnchors(this.leftDefaultAnchors, this.rightDefaultAnchors, this.leftMarginAnchor, this.rightMarginAnchor, n, this.hgap);
        Anchor[] anchorArray2 = n == n3 ? anchorArray : this.createDefaultAnchors(this.leftDefaultAnchors, this.rightDefaultAnchors, this.leftMarginAnchor, this.rightMarginAnchor, n3, this.hgap);
        Anchor[] anchorArray3 = this.createDefaultAnchors(this.topDefaultAnchors, this.bottomDefaultAnchors, this.topMarginAnchor, this.bottomMarginAnchor, n2, this.vgap);
        Anchor[] anchorArray4 = n2 == n4 ? anchorArray3 : this.createDefaultAnchors(this.topDefaultAnchors, this.bottomDefaultAnchors, this.topMarginAnchor, this.bottomMarginAnchor, n4, this.vgap);
        return new Constraint(anchorArray3[0], anchorArray[0], anchorArray4[1], anchorArray2[1]);
    }

    private void clearAutoSize(Anchor anchor, Anchor anchor2) {
        anchor.relative = anchor.autoSize;
        anchor.firstCalculation = true;
        if (anchor.autoSize) {
            anchor.position = 0;
        }
        anchor2.relative = anchor2.autoSize;
        anchor2.firstCalculation = true;
        if (anchor2.autoSize) {
            anchor2.position = 0;
        }
    }

    private List<Anchor> getAutoSizeAnchorsBetween(Anchor anchor, Anchor anchor2) {
        this.anchorsBuffer.clear();
        while (anchor != null && anchor != anchor2) {
            if (anchor.autoSize) {
                this.anchorsBuffer.add(anchor);
            }
            anchor = anchor.relatedAnchor;
        }
        if (anchor == null) {
            this.anchorsBuffer.clear();
        }
        return this.anchorsBuffer;
    }

    private void initAutoSize(Anchor anchor, Anchor anchor2) {
        List<Anchor> list = this.getAutoSizeAnchorsBetween(anchor, anchor2);
        for (int i = 0; i < list.size(); ++i) {
            Anchor anchor3 = list.get(i);
            anchor3.relative = false;
            if (!anchor3.relatedAnchor.autoSize && anchor3.secondRelatedAnchor == null) {
                anchor3.position = -anchor3.relatedAnchor.position;
                continue;
            }
            anchor3.position = 0;
        }
    }

    private void calculateAutoSize(Anchor anchor, Anchor anchor2, int n) {
        Anchor anchor3;
        int n2;
        int n3;
        List<Anchor> list = this.getAutoSizeAnchorsBetween(anchor, anchor2);
        if (list.size() == 1 && anchor.getRelatedAnchor() == anchor2) {
            n3 = (n + list.size() - 1) / list.size();
            for (n2 = 0; n2 < list.size(); ++n2) {
                anchor3 = list.get(n2);
                if (n3 <= -anchor3.position) continue;
                anchor3.position = -n3;
            }
        }
        if ((list = this.getAutoSizeAnchorsBetween(anchor2, anchor)).size() == 1 && anchor2.getRelatedAnchor() == anchor) {
            n3 = (n + list.size() - 1) / list.size();
            for (n2 = 0; n2 < list.size(); ++n2) {
                anchor3 = list.get(n2);
                if (n3 <= anchor3.position) continue;
                anchor3.position = n3;
            }
        }
    }

    private void calculateRelativeAnchor(Anchor anchor, Anchor anchor2, int n) {
        Anchor anchor3;
        if (anchor.relative) {
            Anchor anchor4 = anchor2.getRelativeAnchor();
            if (anchor4 != null && anchor4 != anchor) {
                int n2;
                int n3 = anchor4.getAbsolutePosition() - anchor2.getAbsolutePosition() + n;
                int n4 = n3 - (n2 = anchor4.relatedAnchor.getAbsolutePosition() - anchor.relatedAnchor.getAbsolutePosition());
                n4 = n4 < 0 ? (n4 /= 2) : (n4 -= n4 / 2);
                if (anchor4.firstCalculation || n4 > anchor4.position) {
                    anchor4.firstCalculation = false;
                    anchor4.position = n4;
                }
                n4 = n3 - n2 - n4;
                if (anchor.firstCalculation || n4 > -anchor.position) {
                    anchor.firstCalculation = false;
                    anchor.position = -n4;
                }
            }
        } else if (anchor2.relative && (anchor3 = anchor.getRelativeAnchor()) != null && anchor3 != anchor2) {
            int n5 = anchor.getAbsolutePosition() - anchor3.getAbsolutePosition() + n;
            int n6 = anchor2.relatedAnchor.getAbsolutePosition() - anchor3.relatedAnchor.getAbsolutePosition();
            int n7 = n6 - n5;
            n7 = n7 < 0 ? (n7 -= n7 / 2) : (n7 /= 2);
            if (anchor3.firstCalculation || n7 < anchor3.position) {
                anchor3.firstCalculation = false;
                anchor3.position = n7;
            }
            n7 = n5 - n6 - n7;
            if (anchor2.firstCalculation || n7 > -anchor2.position) {
                anchor2.firstCalculation = false;
                anchor2.position = -n7;
            }
        }
    }

    private void calculateAnchors(Container container) {
        if (!this.valid) {
            int n;
            Object object;
            int n2;
            this.leftAnchor.position = 0;
            this.rightAnchor.position = 0;
            this.topAnchor.position = 0;
            this.bottomAnchor.position = 0;
            this.preferredWidth = 0;
            this.preferredHeight = 0;
            this.minimumWidth = 0;
            this.minimumHeight = 0;
            this.horizontalAnchors.clear();
            this.verticalAnchors.clear();
            for (n2 = 0; n2 < container.getComponentCount(); ++n2) {
                object = this.getConstraint(container.getComponent(n2));
                this.clearAutoSize(((Constraint)object).leftAnchor, ((Constraint)object).rightAnchor);
                this.clearAutoSize(((Constraint)object).topAnchor, ((Constraint)object).bottomAnchor);
                if (!this.horizontalAnchors.contains(((Constraint)object).leftAnchor)) {
                    this.horizontalAnchors.add(((Constraint)object).leftAnchor);
                }
                if (!this.horizontalAnchors.contains(((Constraint)object).rightAnchor)) {
                    this.horizontalAnchors.add(((Constraint)object).rightAnchor);
                }
                if (!this.verticalAnchors.contains(((Constraint)object).topAnchor)) {
                    this.verticalAnchors.add(((Constraint)object).topAnchor);
                }
                if (this.verticalAnchors.contains(((Constraint)object).bottomAnchor)) continue;
                this.verticalAnchors.add(((Constraint)object).bottomAnchor);
            }
            for (n2 = 0; n2 < container.getComponentCount(); ++n2) {
                object = this.getConstraint(container.getComponent(n2));
                this.initAutoSize(((Constraint)object).leftAnchor, ((Constraint)object).rightAnchor);
                this.initAutoSize(((Constraint)object).rightAnchor, ((Constraint)object).leftAnchor);
                this.initAutoSize(((Constraint)object).topAnchor, ((Constraint)object).bottomAnchor);
                this.initAutoSize(((Constraint)object).bottomAnchor, ((Constraint)object).topAnchor);
            }
            for (n2 = 0; n2 < container.getComponentCount(); ++n2) {
                object = container.getComponent(n2);
                if (!((Component)object).isVisible()) continue;
                Constraint constraint = this.getConstraint((Component)object);
                Dimension dimension = JVxUtil.getPreferredSize((Component)object);
                this.calculateAutoSize(constraint.leftAnchor, constraint.rightAnchor, dimension.width);
                this.calculateAutoSize(constraint.topAnchor, constraint.bottomAnchor, dimension.height);
            }
            this.leftBorderUsed = false;
            this.rightBorderUsed = false;
            this.topBorderUsed = false;
            this.bottomBorderUsed = false;
            n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < container.getComponentCount(); ++n) {
                int n6;
                Component component = container.getComponent(n);
                if (!component.isVisible()) continue;
                Constraint constraint = this.getConstraint(component);
                Dimension dimension = JVxUtil.getPreferredSize(component);
                Dimension dimension2 = JVxUtil.getMinimumSize(component);
                if (constraint.rightAnchor.getBorderAnchor() == this.leftAnchor) {
                    n6 = constraint.rightAnchor.getAbsolutePosition();
                    if (n6 > n2) {
                        n2 = n6;
                    }
                    this.leftBorderUsed = true;
                }
                if (constraint.leftAnchor.getBorderAnchor() == this.rightAnchor) {
                    n6 = -constraint.leftAnchor.getAbsolutePosition();
                    if (n6 > n3) {
                        n3 = n6;
                    }
                    this.rightBorderUsed = true;
                }
                if (constraint.bottomAnchor.getBorderAnchor() == this.topAnchor) {
                    n6 = constraint.bottomAnchor.getAbsolutePosition();
                    if (n6 > n4) {
                        n4 = n6;
                    }
                    this.topBorderUsed = true;
                }
                if (constraint.topAnchor.getBorderAnchor() == this.bottomAnchor) {
                    n6 = -constraint.topAnchor.getAbsolutePosition();
                    if (n6 > n5) {
                        n5 = n6;
                    }
                    this.bottomBorderUsed = true;
                }
                if (constraint.leftAnchor.getBorderAnchor() == this.leftAnchor && constraint.rightAnchor.getBorderAnchor() == this.rightAnchor) {
                    n6 = constraint.leftAnchor.getAbsolutePosition() - constraint.rightAnchor.getAbsolutePosition() + dimension.width;
                    if (n6 > this.preferredWidth) {
                        this.preferredWidth = n6;
                    }
                    if ((n6 = constraint.leftAnchor.getAbsolutePosition() - constraint.rightAnchor.getAbsolutePosition() + dimension2.width) > this.minimumWidth) {
                        this.minimumWidth = n6;
                    }
                    this.leftBorderUsed = true;
                    this.rightBorderUsed = true;
                }
                if (constraint.topAnchor.getBorderAnchor() != this.topAnchor || constraint.bottomAnchor.getBorderAnchor() != this.bottomAnchor) continue;
                n6 = constraint.topAnchor.getAbsolutePosition() - constraint.bottomAnchor.getAbsolutePosition() + dimension.height;
                if (n6 > this.preferredHeight) {
                    this.preferredHeight = n6;
                }
                if ((n6 = constraint.topAnchor.getAbsolutePosition() - constraint.bottomAnchor.getAbsolutePosition() + dimension2.height) > this.minimumHeight) {
                    this.minimumHeight = n6;
                }
                this.topBorderUsed = true;
                this.bottomBorderUsed = true;
            }
            if (n2 != 0 && n3 != 0) {
                n = n2 + n3 + this.hgap;
                if (n > this.preferredWidth) {
                    this.preferredWidth = n;
                }
                if (n > this.minimumWidth) {
                    this.minimumWidth = n;
                }
            } else if (n2 != 0) {
                n = n2 - this.rightMarginAnchor.position;
                if (n > this.preferredWidth) {
                    this.preferredWidth = n;
                }
                if (n > this.minimumWidth) {
                    this.minimumWidth = n;
                }
            } else {
                n = n3 + this.leftMarginAnchor.position;
                if (n > this.preferredWidth) {
                    this.preferredWidth = n;
                }
                if (n > this.minimumWidth) {
                    this.minimumWidth = n;
                }
            }
            if (n4 != 0 && n5 != 0) {
                n = n4 + n5 + this.vgap;
                if (n > this.preferredHeight) {
                    this.preferredHeight = n;
                }
                if (n > this.minimumHeight) {
                    this.minimumHeight = n;
                }
            } else if (n4 != 0) {
                n = n4 - this.bottomMarginAnchor.position;
                if (n > this.preferredHeight) {
                    this.preferredHeight = n;
                }
                if (n > this.minimumHeight) {
                    this.minimumHeight = n;
                }
            } else {
                n = n5 + this.topMarginAnchor.position;
                if (n > this.preferredHeight) {
                    this.preferredHeight = n;
                }
                if (n > this.minimumHeight) {
                    this.minimumHeight = n;
                }
            }
            Insets insets = container.getInsets();
            this.preferredWidth += insets.left + insets.right;
            this.preferredHeight += insets.top + insets.bottom;
            this.minimumWidth += insets.left + insets.right;
            this.minimumHeight += insets.top + insets.bottom;
            this.calculateTargetDependentAnchors = true;
            this.valid = true;
        }
    }

    private void calculateTargetDependentAnchors(Container container) {
        if (this.calculateTargetDependentAnchors) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = this.minimumLayoutSize(container);
            Dimension dimension3 = this.maximumLayoutSize(container);
            Insets insets = container.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            dimension2.width -= insets.left + insets.right;
            dimension2.height -= insets.top + insets.bottom;
            dimension3.width -= insets.left + insets.right;
            dimension3.height -= insets.top + insets.bottom;
            if (this.horizontalAlignment == 100 || this.leftBorderUsed && this.rightBorderUsed) {
                if (dimension2.width > dimension.width) {
                    this.leftAnchor.position = 0;
                    this.rightAnchor.position = dimension2.width;
                } else if (dimension3.width < dimension.width) {
                    switch (this.horizontalAlignment) {
                        case 2: {
                            this.leftAnchor.position = 0;
                            break;
                        }
                        case 4: {
                            this.leftAnchor.position = dimension.width - dimension3.width;
                            break;
                        }
                        default: {
                            this.leftAnchor.position = (dimension.width - dimension3.width) / 2;
                        }
                    }
                    this.rightAnchor.position = this.leftAnchor.position + dimension3.width;
                } else {
                    this.leftAnchor.position = 0;
                    this.rightAnchor.position = dimension.width;
                }
            } else {
                if (this.preferredWidth > dimension.width) {
                    this.leftAnchor.position = 0;
                } else {
                    switch (this.horizontalAlignment) {
                        case 2: {
                            this.leftAnchor.position = 0;
                            break;
                        }
                        case 4: {
                            this.leftAnchor.position = dimension.width - this.preferredWidth;
                            break;
                        }
                        default: {
                            this.leftAnchor.position = (dimension.width - this.preferredWidth) / 2;
                        }
                    }
                }
                this.rightAnchor.position = this.leftAnchor.position + this.preferredWidth;
            }
            if (this.verticalAlignment == 100 || this.topBorderUsed && this.bottomBorderUsed) {
                if (dimension2.height > dimension.height) {
                    this.topAnchor.position = 0;
                    this.bottomAnchor.position = dimension2.height;
                } else if (dimension3.height < dimension.height) {
                    switch (this.verticalAlignment) {
                        case 1: {
                            this.topAnchor.position = 0;
                            break;
                        }
                        case 3: {
                            this.topAnchor.position = dimension.height - dimension3.height;
                            break;
                        }
                        default: {
                            this.topAnchor.position = (dimension.height - dimension3.height) / 2;
                        }
                    }
                    this.bottomAnchor.position = this.topAnchor.position + dimension3.height;
                } else {
                    this.topAnchor.position = 0;
                    this.bottomAnchor.position = dimension.height;
                }
            } else {
                if (this.preferredHeight > dimension.height) {
                    this.topAnchor.position = 0;
                } else {
                    switch (this.verticalAlignment) {
                        case 1: {
                            this.topAnchor.position = 0;
                            break;
                        }
                        case 3: {
                            this.topAnchor.position = dimension.height - this.preferredHeight;
                            break;
                        }
                        default: {
                            this.topAnchor.position = (dimension.height - this.preferredHeight) / 2;
                        }
                    }
                }
                this.bottomAnchor.position = this.topAnchor.position + this.preferredHeight;
            }
            this.leftAnchor.position += insets.left;
            this.rightAnchor.position += insets.left;
            this.topAnchor.position += insets.top;
            this.bottomAnchor.position += insets.top;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Constraint constraint = this.getConstraint(component);
                Dimension dimension4 = JVxUtil.getPreferredSize(component);
                this.calculateRelativeAnchor(constraint.leftAnchor, constraint.rightAnchor, dimension4.width);
                this.calculateRelativeAnchor(constraint.topAnchor, constraint.bottomAnchor, dimension4.height);
            }
            this.calculateTargetDependentAnchors = false;
        }
    }

    public static class Constraint
    implements Cloneable {
        private Anchor topAnchor;
        private Anchor leftAnchor;
        private Anchor bottomAnchor;
        private Anchor rightAnchor;

        public Constraint(Anchor anchor, Anchor anchor2, Anchor anchor3, Anchor anchor4) {
            if (anchor2 == null && anchor4 != null) {
                anchor2 = new Anchor(anchor4);
            } else if (anchor4 == null && anchor2 != null) {
                anchor4 = new Anchor(anchor2);
            }
            if (anchor == null && anchor3 != null) {
                anchor = new Anchor(anchor3);
            } else if (anchor3 == null && anchor != null) {
                anchor3 = new Anchor(anchor);
            }
            this.setLeftAnchor(anchor2);
            this.setRightAnchor(anchor4);
            this.setTopAnchor(anchor);
            this.setBottomAnchor(anchor3);
        }

        public Constraint(Anchor anchor, Anchor anchor2) {
            this(anchor, anchor2, null, null);
        }

        public Anchor getLeftAnchor() {
            return this.leftAnchor;
        }

        public void setLeftAnchor(Anchor anchor) {
            if (anchor == null && this.rightAnchor != null) {
                this.leftAnchor = new Anchor(this.rightAnchor);
            } else {
                if (anchor.orientation == 1) {
                    throw new IllegalArgumentException("A vertical anchor can not be used as left anchor!");
                }
                this.leftAnchor = anchor;
            }
        }

        public Anchor getRightAnchor() {
            return this.rightAnchor;
        }

        public void setRightAnchor(Anchor anchor) {
            if (anchor == null && this.leftAnchor != null) {
                this.rightAnchor = new Anchor(this.leftAnchor);
            } else {
                if (anchor.orientation == 1) {
                    throw new IllegalArgumentException("A vertical anchor can not be used as right anchor!");
                }
                this.rightAnchor = anchor;
            }
        }

        public Anchor getTopAnchor() {
            return this.topAnchor;
        }

        public void setTopAnchor(Anchor anchor) {
            if (anchor == null && this.bottomAnchor != null) {
                this.topAnchor = new Anchor(this.bottomAnchor);
            } else {
                if (anchor.orientation == 0) {
                    throw new IllegalArgumentException("A horizontal anchor can not be used as top anchor!");
                }
                this.topAnchor = anchor;
            }
        }

        public Anchor getBottomAnchor() {
            return this.bottomAnchor;
        }

        public void setBottomAnchor(Anchor anchor) {
            if (anchor == null && this.topAnchor != null) {
                this.bottomAnchor = new Anchor(this.topAnchor);
            } else {
                if (anchor.orientation == 0) {
                    throw new IllegalArgumentException("A vertical anchor can not be used as bottom anchor!");
                }
                this.bottomAnchor = anchor;
            }
        }
    }

    public static class Anchor {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        private JVxFormLayout layout;
        private int orientation;
        private Anchor relatedAnchor;
        private Anchor secondRelatedAnchor;
        private float relativePosition;
        private boolean autoSize;
        private int position;
        private boolean relative;
        private boolean firstCalculation;

        private Anchor(JVxFormLayout jVxFormLayout, int n) {
            this.layout = jVxFormLayout;
            this.orientation = n;
            this.relatedAnchor = null;
            this.secondRelatedAnchor = null;
            this.autoSize = false;
            this.position = 0;
            this.relativePosition = 0.5f;
        }

        public Anchor(Anchor anchor) {
            this.layout = anchor.layout;
            this.orientation = anchor.orientation;
            this.relatedAnchor = anchor;
            this.secondRelatedAnchor = null;
            this.autoSize = true;
            this.position = 0;
            this.relativePosition = 0.5f;
        }

        public Anchor(Anchor anchor, int n) {
            this.layout = anchor.layout;
            this.orientation = anchor.orientation;
            this.relatedAnchor = anchor;
            this.secondRelatedAnchor = null;
            this.autoSize = false;
            this.position = n;
            this.relativePosition = 0.5f;
        }

        public Anchor(Anchor anchor, Anchor anchor2, float f) {
            this.layout = anchor.layout;
            this.orientation = anchor.orientation;
            this.relatedAnchor = anchor;
            this.secondRelatedAnchor = anchor2;
            this.autoSize = false;
            this.position = 0;
            this.setRelativePosition(f);
        }

        public Anchor(Anchor anchor, Anchor anchor2) {
            this(anchor, anchor2, 0.5f);
        }

        public JVxFormLayout getLayout() {
            return this.layout;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public boolean isBorderAnchor() {
            return this.relatedAnchor == null;
        }

        public Anchor getRelatedAnchor() {
            return this.relatedAnchor;
        }

        private boolean hasCycleReference(Anchor anchor) {
            do {
                if (anchor != this) continue;
                return true;
            } while ((anchor = anchor.relatedAnchor) != null);
            return false;
        }

        public void setRelatedAnchor(Anchor anchor) {
            if (this.layout != anchor.layout || this.orientation != anchor.orientation) {
                throw new IllegalArgumentException("The related anchor must have the same layout and the same orientation!");
            }
            if (this.hasCycleReference(anchor)) {
                throw new IllegalArgumentException("The related anchor has a cycle reference to this anchor!");
            }
            this.relatedAnchor = anchor;
        }

        public Anchor getSecondRelatedAnchor() {
            return this.secondRelatedAnchor;
        }

        public void setSecondRelatedAnchor(Anchor anchor) {
            if (this.layout != anchor.layout || this.orientation != anchor.orientation) {
                throw new IllegalArgumentException("The related anchor must have the same layout and the same orientation!");
            }
            if (this.hasCycleReference(anchor)) {
                throw new IllegalArgumentException("The related anchor has a cycle reference to this anchor!");
            }
            this.secondRelatedAnchor = anchor;
        }

        public float getRelativePosition() {
            return this.relativePosition;
        }

        public void setRelativePosition(float f) {
            if (this.relatedAnchor == null) {
                throw new IllegalArgumentException("Relative position of border anchor may not be set!");
            }
            this.relativePosition = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        }

        public boolean isAutoSize() {
            return this.autoSize;
        }

        public void setAutoSize(boolean bl) {
            this.autoSize = bl;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            if (this.relatedAnchor == null) {
                throw new IllegalArgumentException("Position of border anchor may not be set!");
            }
            this.position = n;
        }

        public int getAbsolutePosition() {
            if (this.relatedAnchor == null) {
                return this.position;
            }
            if (this.secondRelatedAnchor == null) {
                return this.relatedAnchor.getAbsolutePosition() + this.position;
            }
            int n = this.relatedAnchor.getAbsolutePosition();
            return n + (int)((float)(this.secondRelatedAnchor.getAbsolutePosition() - n) * this.relativePosition);
        }

        public Anchor getBorderAnchor() {
            Anchor anchor = this;
            while (anchor.relatedAnchor != null) {
                anchor = anchor.relatedAnchor;
            }
            return anchor;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public Anchor getRelativeAnchor() {
            Anchor anchor = this;
            while (anchor != null && !anchor.relative) {
                anchor = anchor.relatedAnchor;
            }
            return anchor;
        }
    }
}

