/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.awt.impl.AwtDimension;
import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxComboBase;
import com.sibvisions.rad.ui.swing.ext.JVxTable;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxComboCellEditor;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxIconRenderer;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxRendererContainer;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.IControl;
import javax.rad.ui.IDimension;
import javax.rad.ui.celleditor.ILinkedCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxLinkedCellEditor
extends JVxComboCellEditor
implements ILinkedCellEditor,
ICellRenderer<JComponent> {
    private JVxRendererContainer cellRenderer = null;
    private DefaultTableCellRenderer textRenderer = null;
    private JVxIconRenderer iconRenderer = null;
    private ReferenceDefinition linkReference;
    private ICondition additionalCondition;
    private ColumnMapping searchColumnMapping;
    private boolean sortByColumnName = false;
    private boolean tableReadonly = true;
    private boolean tableHeaderVisible = false;
    private boolean validationEnabled = true;
    private boolean searchTextAnywhere = true;
    private IDimension popupSize = new AwtDimension(400, 200);

    public JVxLinkedCellEditor() {
        this(null);
    }

    public JVxLinkedCellEditor(ReferenceDefinition referenceDefinition) {
        this.setLinkReference(referenceDefinition);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public boolean isDirectCellEditor() {
        return false;
    }

    @Override
    public ReferenceDefinition getLinkReference() {
        return this.linkReference;
    }

    @Override
    public void setLinkReference(ReferenceDefinition referenceDefinition) {
        this.linkReference = referenceDefinition;
    }

    @Override
    public ICondition getAdditionalCondition() {
        return this.additionalCondition;
    }

    @Override
    public void setAdditionalCondition(ICondition iCondition) {
        this.additionalCondition = iCondition;
    }

    @Override
    public ColumnMapping getSearchColumnMapping() {
        return this.searchColumnMapping;
    }

    @Override
    public void setSearchColumnMapping(ColumnMapping columnMapping) {
        this.searchColumnMapping = columnMapping;
    }

    @Override
    public boolean isSortByColumnName() {
        return this.sortByColumnName;
    }

    @Override
    public void setSortByColumnName(boolean bl) {
        this.sortByColumnName = bl;
    }

    @Override
    public boolean isTableReadonly() {
        return this.tableReadonly;
    }

    @Override
    public void setTableReadonly(boolean bl) {
        this.tableReadonly = bl;
    }

    @Override
    public boolean isTableHeaderVisible() {
        return this.tableHeaderVisible;
    }

    @Override
    public void setTableHeaderVisible(boolean bl) {
        this.tableHeaderVisible = bl;
    }

    @Override
    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Override
    public void setValidationEnabled(boolean bl) {
        this.validationEnabled = bl;
    }

    @Override
    public boolean isSearchTextAnywhere() {
        return this.searchTextAnywhere;
    }

    @Override
    public void setSearchTextAnywhere(boolean bl) {
        this.searchTextAnywhere = bl;
    }

    @Override
    public IDimension getPopupSize() {
        return this.popupSize;
    }

    @Override
    public void setPopupSize(IDimension iDimension) {
        this.popupSize = iDimension;
    }

    @Override
    public JComponent getCellRendererComponent(JComponent jComponent, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new JVxRendererContainer();
            this.textRenderer = new DefaultTableCellRenderer();
            this.textRenderer.setFont(null);
            this.textRenderer.setOpaque(false);
            this.iconRenderer = new JVxIconRenderer();
            this.iconRenderer.setImage(JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/combobox.png"));
            this.iconRenderer.setOpaque(false);
            this.cellRenderer.add((Component)this.textRenderer, "Center");
            this.cellRenderer.add((Component)this.iconRenderer, "East");
        }
        this.textRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.textRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        IDataBook iDataBook = iDataPage.getDataBook();
        try {
            this.iconRenderer.setVisible(bl && !iDataBook.isReadonly() && iDataBook.isUpdateAllowed() && !iDataBook.getRowDefinition().getColumnDefinition(string).isReadOnly());
        }
        catch (Exception exception) {
            this.iconRenderer.setVisible(false);
        }
        try {
            String string2 = iDataRow.getRowDefinition().getColumnDefinition(string).getDataType().convertToString(iDataRow.getValue(string));
            this.textRenderer.setText(string2);
        }
        catch (Exception exception) {
            this.textRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    extends AbstractListModel
    implements ICellEditorHandler<JComponent>,
    ComboBoxModel,
    DocumentListener,
    KeyListener,
    PopupMenuListener,
    FocusListener,
    MouseListener,
    Runnable {
        private JVxLinkedCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IDataRow dataRow;
        private int columnIndex;
        private String[] columnNames;
        private String[] referencedColumnNames;
        private String columnName;
        private String referencedColumnName;
        private String[] searchColumns;
        private String[] referencedSearchColumns;
        private IDataBook referencedDataBook;
        private JVxComboBase cellEditorComponent;
        private JVxTable table;
        private boolean ignoreEvent = false;
        private boolean firstEditingStarted = true;
        private boolean popupChanged = false;

        public CellEditorHandler(JVxLinkedCellEditor jVxLinkedCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxLinkedCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.columnNames = this.cellEditor.linkReference.getColumnNames();
            this.referencedColumnNames = this.cellEditor.linkReference.getReferencedColumnNames();
            this.columnIndex = ArrayUtil.indexOf(this.columnNames, this.columnName);
            if (this.columnIndex < 0) {
                throw new IllegalArgumentException("The edited column " + this.columnName + " has to be part of in column names list in LinkReference!");
            }
            this.referencedColumnName = this.referencedColumnNames[this.columnIndex];
            if (this.cellEditor.searchColumnMapping == null) {
                this.searchColumns = null;
                this.referencedSearchColumns = null;
            } else {
                this.searchColumns = this.cellEditor.searchColumnMapping.getColumnNames();
                this.referencedSearchColumns = this.cellEditor.searchColumnMapping.getReferencedColumnNames();
            }
            this.referencedDataBook = this.cellEditor.linkReference.getReferencedDataBook();
            try {
                this.referencedDataBook.setReadOnly(this.cellEditor.isTableReadonly());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.referencedDataBook.setSelectionMode(IDataBook.SelectionMode.DESELECTED);
            this.table = new JVxTable();
            this.table.setTableHeaderVisible(this.cellEditor.isTableHeaderVisible());
            this.table.setDataBook(this.referencedDataBook);
            this.table.setBorder(BorderFactory.createEmptyBorder());
            this.table.setAutoResize(true);
            this.table.getJTable().setFocusable(false);
            this.cellEditorComponent = new JVxComboBase();
            this.cellEditorComponent.setPopupComponent(this.table);
            this.cellEditorComponent.setModel(this);
            if (this.cellEditor.getPopupSize() != null) {
                this.cellEditorComponent.setPopupSize((Dimension)this.cellEditor.getPopupSize().getResource());
            }
            if (this.cellEditorComponent.getEditorComponent() instanceof JTextField) {
                ((JTextField)this.cellEditorComponent.getEditorComponent()).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
            }
            this.cellEditorComponent.getEditorComponent().getDocument().addDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().addKeyListener(this);
            this.cellEditorComponent.getEditorComponent().addFocusListener(this);
            this.cellEditorComponent.getEditorComponent().setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addPopupMenuListener(this);
            this.table.getJTable().addMouseListener(this);
            this.updateEditor();
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.getEditorComponent().getDocument().removeDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().removeKeyListener(this);
            this.cellEditorComponent.getEditorComponent().removeFocusListener(this);
            this.cellEditorComponent.removePopupMenuListener(this);
            this.table.getJTable().removeKeyListener(this);
            this.table.getJTable().removeMouseListener(this);
            this.table.setDataBook(null);
        }

        @Override
        public void updateEditor() {
            this.cellEditorComponent.setTranslation(((IControl)((Object)this.cellEditorListener)).getTranslation());
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        private String getWildCardString(Object object) {
            if (this.cellEditor.isSearchTextAnywhere()) {
                return "*" + object + "*";
            }
            return object + "*";
        }

        private ICondition getSearchCondition(ICondition iCondition) {
            if (iCondition == null) {
                iCondition = this.cellEditor.additionalCondition;
            } else if (this.cellEditor.additionalCondition != null) {
                iCondition = iCondition.and(this.cellEditor.additionalCondition);
            }
            if (this.searchColumns != null) {
                for (int i = 0; i < this.searchColumns.length; ++i) {
                    Equals equals = new Equals(this.dataRow, this.searchColumns[i], this.referencedSearchColumns[i]);
                    iCondition = iCondition == null ? equals : iCondition.and(equals);
                }
            }
            return iCondition;
        }

        @Override
        public void saveEditing() throws ModelException {
            if (this.popupChanged && this.referencedDataBook.getSelectedRow() >= 0) {
                this.dataRow.setValues(this.columnNames, this.referencedDataBook.getValues(this.referencedColumnNames));
            } else {
                Object object = this.cellEditorComponent.getEditor().getItem();
                if (object == null || "".equals(object)) {
                    Object[] objectArray = new Object[this.referencedColumnNames.length];
                    this.dataRow.setValues(this.columnNames, objectArray);
                } else {
                    this.referencedDataBook.setFilter(this.getSearchCondition(new Like(this.referencedColumnName, object)));
                    if (this.referencedDataBook.getDataRow(0) != null && this.referencedDataBook.getDataRow(1) == null) {
                        this.dataRow.setValues(this.columnNames, this.referencedDataBook.getDataRow(0).getValues(this.referencedColumnNames));
                    } else if (this.cellEditor.isValidationEnabled()) {
                        this.referencedDataBook.setFilter(this.getSearchCondition(new LikeIgnoreCase(this.referencedColumnName, (Object)this.getWildCardString(object))));
                        if (this.referencedDataBook.getDataRow(0) != null && this.referencedDataBook.getDataRow(1) == null) {
                            this.dataRow.setValues(this.columnNames, this.referencedDataBook.getDataRow(0).getValues(this.referencedColumnNames));
                        } else {
                            this.dataRow.setValues(this.columnNames, this.dataRow.getValues(this.columnNames));
                        }
                    } else {
                        Object[] objectArray = new Object[this.referencedColumnNames.length];
                        objectArray[this.columnIndex] = object;
                        this.dataRow.setValues(this.columnNames, objectArray);
                    }
                }
            }
            this.popupChanged = false;
        }

        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                try {
                    try {
                        Font font;
                        Color color;
                        Object object;
                        boolean bl;
                        ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                        this.cellEditorComponent.setSelectedItem(this.dataRow.getValueAsString(this.columnName));
                        CellFormat cellFormat = null;
                        Container container = this.cellEditorComponent.getParent();
                        boolean bl2 = bl = container == null || container.isEnabled();
                        if (this.dataRow instanceof IDataBook) {
                            object = (IDataBook)this.dataRow;
                            this.cellEditorComponent.setEditorEditable(bl && object.isUpdateAllowed() && !columnDefinition.isReadOnly() && object.getSelectedRow() >= 0);
                            if (this.cellEditorListener.getCellFormatter() != null) {
                                try {
                                    cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                                }
                                catch (ModelException modelException) {}
                            }
                        } else {
                            this.cellEditorComponent.setEditorEditable(bl && !columnDefinition.isReadOnly());
                        }
                        if (cellFormat == null) {
                            object = null;
                            color = null;
                            font = null;
                        } else {
                            object = cellFormat.getBackground();
                            color = cellFormat.getForeground();
                            font = cellFormat.getFont();
                        }
                        if (font == null) {
                            font = ((Component)((Object)this.cellEditorListener)).getFont();
                        }
                        if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                            color = ((Component)((Object)this.cellEditorListener)).getForeground();
                        }
                        if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                            object = ((Component)((Object)this.cellEditorListener)).getBackground();
                        }
                        this.cellEditorComponent.getEditorComponent().setFont(font);
                        if (this.cellEditorComponent.isEditorEditable()) {
                            if (object == null) {
                                object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                            }
                            if (this.cellEditorComponent.getEditorComponent().hasFocus()) {
                                this.cellEditorComponent.getEditorComponent().selectAll();
                            } else {
                                this.cellEditorComponent.getEditorComponent().select(0, 0);
                            }
                        } else {
                            object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                            this.cellEditorComponent.getEditorComponent().select(0, 0);
                        }
                        this.cellEditorComponent.getEditorComponent().setBackground((Color)object);
                        this.cellEditorComponent.getEditorComponent().setForeground(color);
                        this.table.setCellFormatter(this.cellEditorListener.getCellFormatter());
                    }
                    catch (Exception exception) {
                        this.cellEditorComponent.setSelectedItem(null);
                        this.cellEditorComponent.setEditorEditable(false);
                        this.cellEditorComponent.getEditorComponent().setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                        throw new ModelException("Editor cannot be restored!", exception);
                    }
                    Object var9_10 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                    throw throwable;
                }
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                if (this.popupChanged && this.referencedDataBook.getSelectedRow() >= 0) {
                    return this.referencedDataBook.getValue(this.referencedColumnName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.cellEditorComponent.getEditor().getItem();
        }

        @Override
        public void setSelectedItem(Object object) {
            try {
                if (this.firstEditingStarted) {
                    this.referencedDataBook.setFilter(this.getSearchCondition(null));
                    if (this.cellEditor.isSortByColumnName()) {
                        this.referencedDataBook.setSort(new SortDefinition(this.referencedColumnName));
                    }
                    if (object != null) {
                        String[] stringArray = new String[]{this.referencedColumnName};
                        IDataRow iDataRow = this.referencedDataBook.createEmptyRow(null);
                        iDataRow.setValue(this.referencedColumnName, object);
                        this.referencedDataBook.setSelectedRow(-1);
                        int n = 0;
                        IChangeableDataRow iChangeableDataRow = this.referencedDataBook.getDataRow(n);
                        while (iChangeableDataRow != null && this.referencedDataBook.getSelectedRow() < 0) {
                            if (iDataRow.equals(iChangeableDataRow, stringArray)) {
                                this.referencedDataBook.setSelectedRow(n);
                                continue;
                            }
                            iChangeableDataRow = this.referencedDataBook.getDataRow(++n);
                        }
                    }
                } else if (object == null) {
                    this.referencedDataBook.setFilter(this.getSearchCondition(null));
                } else {
                    this.referencedDataBook.setFilter(this.getSearchCondition(new LikeIgnoreCase(this.referencedColumnName, (Object)this.getWildCardString(object))));
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.popupChanged = false;
        }

        @Override
        public Object getElementAt(int n) {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.cellEditorComponent.setPopupCanceled(true);
                        this.cellEditorComponent.setPopupVisible(false);
                        this.fireEditingComplete("ESCAPE_KEY", true);
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (this.cellEditorComponent.isPopupVisible()) {
                            this.popupChanged = true;
                            this.fireEditingStarted();
                            this.cellEditorComponent.setPopupVisible(false);
                        }
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY", true);
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY", true);
                        break;
                    }
                    case 38: 
                    case 40: {
                        if (!this.cellEditorComponent.isPopupVisible()) break;
                        this.table.keyPressed(keyEvent);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.fireEditingComplete("ESCAPE_KEY", false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.cellEditorComponent.getEditorComponent().select(this.cellEditorComponent.getEditorComponent().getSelectionStart(), this.cellEditorComponent.getEditorComponent().getSelectionEnd());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            try {
                this.referencedDataBook.setReadOnly(this.cellEditor.isTableReadonly());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (this.firstEditingStarted) {
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.table.scrollToSelectedCell();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!this.cellEditorComponent.isPopupVisible() && this.cellEditorComponent.isEditorEditable()) {
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && !this.cellEditorComponent.isPopupFocusEvent(focusEvent)) {
                this.fireEditingComplete("FOCUS_LOST", true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.popupChanged = true;
            this.fireEditingStarted();
            this.fireEditingComplete("ENTER_KEY", true);
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
                if (this.cellEditor.isAutoOpenPopup() && !this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        protected void fireEditingComplete(String string, boolean bl) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                if (bl && this.cellEditorComponent.isPopupVisible()) {
                    this.ignoreEvent = true;
                    this.cellEditorComponent.setPopupCanceled(true);
                    this.cellEditorComponent.setPopupVisible(false);
                    this.ignoreEvent = false;
                }
                this.cellEditorListener.editingComplete(string);
            }
        }
    }
}

