/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.swing.ext.JVxIcon;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxStyledCellEditor;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxIconRenderer;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Component;
import java.awt.Dimension;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.ui.celleditor.IImageViewer;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxImageViewer
extends JVxStyledCellEditor
implements IImageViewer<Component> {
    private JVxIconRenderer cellRenderer = null;
    private String defaultImageName;

    public JVxImageViewer() {
        this.setHorizontalAlignment(1);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, iCellEditorListener, iDataRow, string);
    }

    @Override
    public Component getCellRendererComponent(Component component, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new JVxIconRenderer();
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            Object object = iDataRow.getValue(string);
            if (object instanceof String) {
                this.cellRenderer.setImage(JVxUtil.getImage((String)object));
            } else if (object instanceof byte[]) {
                this.cellRenderer.setImage(JVxUtil.getImage(null, (byte[])object));
            } else {
                this.cellRenderer.setImage(JVxUtil.getImage(this.defaultImageName));
            }
        }
        catch (Exception exception) {
            this.cellRenderer.setImage(JVxUtil.getImage(this.defaultImageName));
        }
        return this.cellRenderer;
    }

    @Override
    public boolean isDirectCellEditor() {
        return true;
    }

    @Override
    public String getDefaultImageName() {
        return this.defaultImageName;
    }

    @Override
    public void setDefaultImageName(String string) {
        this.defaultImageName = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellEditorHandler
    implements ICellEditorHandler<JComponent> {
        private JVxImageViewer cellEditor;
        private ICellEditorListener cellEditorListener;
        private IDataRow dataRow;
        private String columnName;
        private JVxIcon cellEditorComponent;

        public CellEditorHandler(JVxImageViewer jVxImageViewer, ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxImageViewer;
            this.cellEditorListener = iCellEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.cellEditorComponent = new JVxIcon();
            this.cellEditorComponent.setMinimumSize(new Dimension(16, 16));
            this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
            this.cellEditorComponent.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.cellEditor.getVerticalAlignment()));
            this.cellEditorComponent.setImage(JVxUtil.getImage(this.cellEditor.defaultImageName));
        }

        @Override
        public void uninstallEditor() {
        }

        @Override
        public void updateEditor() {
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
        }

        @Override
        public void cancelEditing() throws ModelException {
            try {
                Object object = this.dataRow.getValue(this.columnName);
                if (object instanceof String) {
                    this.cellEditorComponent.setImage(JVxUtil.getImage((String)object));
                } else if (object instanceof byte[]) {
                    this.cellEditorComponent.setImage(JVxUtil.getImage(null, (byte[])object));
                } else {
                    this.cellEditorComponent.setImage(JVxUtil.getImage(this.cellEditor.defaultImageName));
                }
            }
            catch (Exception exception) {
                this.cellEditorComponent.setImage(JVxUtil.getImage(this.cellEditor.defaultImageName));
                throw new ModelException("Editor cannot be restored!", exception);
            }
        }
    }
}

