/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxDateCombo;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxComboCellEditor;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.ext.text.DateFormatter;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.IControl;
import javax.rad.ui.celleditor.IDateCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxDateCellEditor
extends JVxComboCellEditor
implements IDateCellEditor,
ICellRenderer<Component> {
    private JLabel cellRenderer = null;
    private DateFormatter dateFormatter = new DateFormatter();

    public JVxDateCellEditor() {
        this(null);
    }

    public JVxDateCellEditor(String string) {
        this.setDateFormat(string);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public boolean isDirectCellEditor() {
        return false;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormatter.getDatePattern();
    }

    @Override
    public void setDateFormat(String string) {
        this.dateFormatter.setDatePattern(string);
    }

    @Override
    public Component getCellRendererComponent(Component component, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DefaultTableCellRenderer();
            this.cellRenderer.setOpaque(true);
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            this.cellRenderer.setText(this.dateFormatter.valueToString(iDataRow.getValue(string)));
        }
        catch (Exception exception) {
            this.cellRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    DocumentListener,
    KeyListener,
    PopupMenuListener,
    FocusListener {
        private JVxDateCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IDataRow dataRow;
        private String columnName;
        private JVxDateCombo cellEditorComponent;
        private boolean ignoreEvent = false;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxDateCellEditor jVxDateCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxDateCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.cellEditorComponent = new JVxDateCombo(this.cellEditor.getDateFormat());
            if (this.cellEditorComponent.getEditorComponent() instanceof JTextField) {
                ((JTextField)this.cellEditorComponent.getEditorComponent()).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
            }
            this.cellEditorComponent.getEditorComponent().getDocument().addDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().addKeyListener(this);
            this.cellEditorComponent.getEditorComponent().addFocusListener(this);
            this.cellEditorComponent.getEditorComponent().setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addPopupMenuListener(this);
            this.updateEditor();
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.getEditorComponent().getDocument().removeDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().removeKeyListener(this);
            this.cellEditorComponent.getEditorComponent().removeFocusListener(this);
            this.cellEditorComponent.removePopupMenuListener(this);
        }

        @Override
        public void updateEditor() {
            this.cellEditorComponent.setTranslation(((IControl)((Object)this.cellEditorListener)).getTranslation());
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            this.ignoreEvent = true;
            this.cellEditorComponent.setSelectedItem(this.cellEditorComponent.getEditor().getItem());
            this.ignoreEvent = false;
            this.dataRow.setValue(this.columnName, this.cellEditorComponent.getSelectedItem());
        }

        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                try {
                    try {
                        Font font;
                        Color color;
                        Object object;
                        boolean bl;
                        ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                        this.cellEditorComponent.setSelectedItem(this.dataRow.getValue(this.columnName));
                        CellFormat cellFormat = null;
                        Container container = this.cellEditorComponent.getParent();
                        boolean bl2 = bl = container == null || container.isEnabled();
                        if (this.dataRow instanceof IDataBook) {
                            object = (IDataBook)this.dataRow;
                            this.cellEditorComponent.setEditorEditable(bl && object.isUpdateAllowed() && !columnDefinition.isReadOnly() && object.getSelectedRow() >= 0);
                            if (this.cellEditorListener.getCellFormatter() != null) {
                                try {
                                    cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                                }
                                catch (ModelException modelException) {}
                            }
                        } else {
                            this.cellEditorComponent.setEditorEditable(bl && !columnDefinition.isReadOnly());
                        }
                        if (cellFormat == null) {
                            object = null;
                            color = null;
                            font = null;
                        } else {
                            object = cellFormat.getBackground();
                            color = cellFormat.getForeground();
                            font = cellFormat.getFont();
                        }
                        if (font == null) {
                            font = ((Component)((Object)this.cellEditorListener)).getFont();
                        }
                        if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                            color = ((Component)((Object)this.cellEditorListener)).getForeground();
                        }
                        if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                            object = ((Component)((Object)this.cellEditorListener)).getBackground();
                        }
                        this.cellEditorComponent.getEditorComponent().setFont(font);
                        if (this.cellEditorComponent.isEditorEditable()) {
                            if (object == null) {
                                object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                            }
                            if (this.cellEditorComponent.getEditorComponent().hasFocus()) {
                                this.cellEditorComponent.getEditorComponent().selectAll();
                            } else {
                                this.cellEditorComponent.getEditorComponent().select(0, 0);
                            }
                        } else {
                            object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                            this.cellEditorComponent.getEditorComponent().select(0, 0);
                        }
                        this.cellEditorComponent.getEditorComponent().setBackground((Color)object);
                        this.cellEditorComponent.getEditorComponent().setForeground(color);
                    }
                    catch (Exception exception) {
                        this.cellEditorComponent.setSelectedItem(null);
                        this.cellEditorComponent.setEditorEditable(false);
                        this.cellEditorComponent.getEditorComponent().setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                        throw new ModelException("Editor cannot be restored!", exception);
                    }
                    Object var9_10 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                    throw throwable;
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.fireEditingComplete("ESCAPE_KEY", true);
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY", true);
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY", true);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.fireEditingComplete("ESCAPE_KEY", false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (!this.cellEditorComponent.isPopupCanceled()) {
                this.fireEditingStarted();
                this.fireEditingComplete("FOCUS_LOST", false);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.cellEditorComponent.isEditorEditable()) {
                this.cellEditorComponent.getEditorComponent().setText(this.cellEditorComponent.getEditorComponent().getText());
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && !this.cellEditorComponent.isPopupFocusEvent(focusEvent)) {
                this.fireEditingComplete("FOCUS_LOST", true);
            }
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string, boolean bl) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                if (bl && this.cellEditorComponent.isPopupVisible()) {
                    this.ignoreEvent = true;
                    this.cellEditorComponent.setPopupCanceled(true);
                    this.cellEditorComponent.setPopupVisible(false);
                    this.ignoreEvent = false;
                }
                this.cellEditorListener.editingComplete(string);
            }
        }
    }
}

