/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.Webstart;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxDateCellEditor;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxNumberCellEditor;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxTextCellEditor;
import com.sibvisions.rad.ui.swing.ext.layout.JVxBorderLayout;
import com.sibvisions.rad.ui.swing.ext.layout.JVxFormLayout;
import com.sibvisions.rad.ui.swing.impl.component.SwingTextComponent;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.rad.model.ui.ICellEditor;
import javax.rad.ui.InvokeLaterThread;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JVxUtil {
    private static final ICellEditor NUMBER_CELL_EDITOR;
    private static final ICellEditor DATE_CELL_EDITOR;
    private static final ICellEditor TEXT_CELL_EDITOR;
    private static Hashtable<Class<?>, ICellEditor> defaultCellEditors;
    private static Hashtable<String, ImageIcon> htImageCache;
    private static WeakHashMap<byte[], ImageIcon> htCreateImageCache;
    private static Hashtable<String, String> htImageMapping;
    private static WeakReference<RootPaneContainer> rootPaneContainer;
    private static Hashtable<String, Color> systemColors;

    protected JVxUtil() {
    }

    public static Dimension getPreferredSize(Component component) {
        Dimension dimension = component.getMinimumSize();
        Dimension dimension2 = component.getPreferredSize();
        Dimension dimension3 = component.getMaximumSize();
        int n = dimension2.width;
        int n2 = dimension2.height;
        if (component.isMinimumSizeSet()) {
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height > n2) {
                n2 = dimension.height;
            }
        }
        if (component.isMaximumSizeSet()) {
            if (dimension3.width < n) {
                n = dimension3.width;
            }
            if (dimension3.height < n2) {
                n2 = dimension3.height;
            }
        }
        return new Dimension(n, n2);
    }

    public static Dimension getMinimumSize(Component component) {
        Object object;
        Dimension dimension = component.isMinimumSizeSet() ? component.getMinimumSize() : (component instanceof JScrollPane || component instanceof JTabbedPane || component instanceof JSplitPane ? ((JComponent)component).getMinimumSize() : (component instanceof JRootPane ? JVxUtil.getMinimumSize(((JRootPane)component).getContentPane()) : (component instanceof JPanel ? ((object = ((JPanel)component).getLayout()) instanceof JVxFormLayout ? ((JVxFormLayout)object).minimumLayoutSize((JPanel)component) : (object instanceof JVxBorderLayout ? ((JVxBorderLayout)object).minimumLayoutSize((JPanel)component) : JVxUtil.getPreferredSize(component))) : JVxUtil.getPreferredSize(component))));
        if (component.isMaximumSizeSet()) {
            object = component.getMaximumSize();
            if (((Dimension)object).width < dimension.width) {
                dimension.width = ((Dimension)object).width;
            }
            if (((Dimension)object).height < dimension.height) {
                dimension.height = ((Dimension)object).height;
            }
        }
        return dimension;
    }

    public static void revalidateAll(Component component) {
        Component component2 = component;
        while (component2.getParent() != null && component2.getParent().getLayout() != null) {
            component2 = component2.getParent();
        }
        if (component2 != null && component2 != component) {
            component2.validate();
        }
    }

    public static ICellEditor getDefaultCellEditor(Class<?> clazz) {
        if (clazz == null) {
            return TEXT_CELL_EDITOR;
        }
        ICellEditor iCellEditor = defaultCellEditors.get(clazz);
        if (iCellEditor == null) {
            return JVxUtil.getDefaultCellEditor(clazz.getSuperclass());
        }
        return iCellEditor;
    }

    public static void setDefaultCellEditor(Class<?> clazz, ICellEditor iCellEditor) {
        if (iCellEditor == null) {
            defaultCellEditors.remove(clazz);
        } else {
            defaultCellEditors.put(clazz, iCellEditor);
        }
    }

    public static Color getSystemColor(String string) {
        return systemColors.get(string);
    }

    public static void setSystemColor(String string, Color color) {
        if (color == null) {
            systemColors.remove(string);
        } else {
            systemColors.put(string, color);
        }
    }

    public static Color getAverageColor(Color color, Color color2) {
        if (color == null) {
            return color2;
        }
        if (color2 == null) {
            return color;
        }
        int n = (color.getRed() + color2.getRed()) / 2;
        int n2 = (color.getGreen() + color2.getGreen()) / 2;
        int n3 = (color.getBlue() + color2.getBlue()) / 2;
        return new Color(n, n2, n3);
    }

    public static Image getImage(String string) {
        ImageIcon imageIcon = JVxUtil.getIcon(string);
        if (imageIcon == null) {
            return null;
        }
        return imageIcon.getImage();
    }

    public static ImageIcon getIcon(String string) {
        InputStream inputStream;
        if (string == null) {
            return null;
        }
        ImageIcon imageIcon = htImageCache.get(string = JVxUtil.getImageMapping(string));
        if (imageIcon == null && (inputStream = ResourceUtil.getResourceAsStream(string)) != null) {
            imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FileUtil.getContent(inputStream)));
            htImageCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static Image getImage(String string, byte[] byArray) {
        ImageIcon imageIcon = JVxUtil.getIcon(string, byArray);
        if (imageIcon == null) {
            return null;
        }
        return imageIcon.getImage();
    }

    public static ImageIcon getIcon(String string, byte[] byArray) {
        if (byArray == null) {
            ImageIcon imageIcon = JVxUtil.getIcon(string);
            if (imageIcon != null) {
                return imageIcon;
            }
            return null;
        }
        ImageIcon imageIcon = htCreateImageCache.get(byArray);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(byArray));
            htCreateImageCache.put(byArray, imageIcon);
        }
        if (string != null) {
            htImageCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static String getImageMapping(String string) {
        String string2 = htImageMapping.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static void setImageMapping(String string, String string2) {
        if (string2 == null) {
            String string3 = htImageMapping.remove(string);
            if (string3 != null) {
                htImageCache.remove(string3);
            }
        } else {
            String string4 = htImageMapping.put(string, string2);
            if (string4 != null) {
                htImageCache.remove(string4);
            }
        }
    }

    public static String[] getImageMappingNames() {
        return htImageMapping.keySet().toArray(new String[htImageMapping.size()]);
    }

    public static Cursor getGlobalCursor(Component component) {
        RootPaneContainer rootPaneContainer = null;
        while (component != null) {
            if (component instanceof RootPaneContainer) {
                rootPaneContainer = (RootPaneContainer)((Object)component);
            }
            component = component.getParent();
        }
        if (JVxUtil.rootPaneContainer != null && rootPaneContainer == null) {
            rootPaneContainer = (RootPaneContainer)JVxUtil.rootPaneContainer.get();
        }
        if (rootPaneContainer != null) {
            Component component2 = rootPaneContainer.getGlassPane();
            return component2.getCursor();
        }
        return null;
    }

    public static void setGlobalCursor(Component component, Cursor cursor) {
        Serializable serializable;
        Object object;
        RootPaneContainer rootPaneContainer = null;
        while (component != null) {
            if (component instanceof RootPaneContainer) {
                rootPaneContainer = (RootPaneContainer)((Object)component);
            }
            component = component.getParent();
        }
        if (JVxUtil.rootPaneContainer != null) {
            if (rootPaneContainer == null) {
                rootPaneContainer = (RootPaneContainer)JVxUtil.rootPaneContainer.get();
            } else {
                object = (RootPaneContainer)JVxUtil.rootPaneContainer.get();
                if (object != null) {
                    serializable = object.getGlassPane();
                    ((Component)serializable).setVisible(false);
                    ((Component)serializable).setCursor(null);
                }
                JVxUtil.rootPaneContainer = null;
            }
        }
        if (rootPaneContainer != null) {
            object = rootPaneContainer.getGlassPane();
            if (cursor == null || cursor.getType() == 0) {
                if (((Component)object).isVisible()) {
                    ((Component)object).setVisible(false);
                }
                if ((serializable = ((Component)object).getCursor()) != null && ((Cursor)serializable).getType() != 0) {
                    ((Component)object).setCursor(Cursor.getPredefinedCursor(0));
                }
            } else {
                if (!((Component)object).isVisible()) {
                    ((Component)object).setVisible(true);
                }
                if ((serializable = ((Component)object).getCursor()) == null || ((Cursor)serializable).getType() != cursor.getType()) {
                    ((Component)object).setCursor(cursor);
                }
            }
            JVxUtil.rootPaneContainer = new WeakReference<RootPaneContainer>(rootPaneContainer);
        }
    }

    public static void invokeLater(Runnable runnable) {
        Thread thread = Thread.currentThread();
        if (thread instanceof InvokeLaterThread) {
            ((InvokeLaterThread)thread).invokeLater(runnable);
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void installActions(final JTextComponent jTextComponent) {
        if (Webstart.isJnlp()) {
            String string;
            boolean bl;
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl && (string = System.getProperty("java.version")).compareTo("1.6.0_24") >= 0) {
                Action action;
                Action action2;
                ActionMap actionMap = jTextComponent.getActionMap();
                Action action3 = actionMap.get("copy-to-clipboard");
                if (!(action3 instanceof ForwardAction)) {
                    actionMap.put("copy-to-clipboard", new ForwardAction(action3){

                        public void actionPerformed(ActionEvent actionEvent) {
                            super.actionPerformed(actionEvent);
                            if (!(jTextComponent instanceof JPasswordField)) {
                                try {
                                    Webstart.setClipboard(jTextComponent.getSelectedText());
                                }
                                catch (Exception exception) {
                                    LoggerFactory.getInstance(SwingTextComponent.class).error(exception);
                                }
                            }
                        }
                    });
                }
                if (!((action2 = actionMap.get("paste-from-clipboard")) instanceof ForwardAction)) {
                    actionMap.put("paste-from-clipboard", new ForwardAction(action2){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = jTextComponent.getSelectionStart();
                            int n2 = jTextComponent.getSelectionEnd();
                            int n3 = jTextComponent.getCaretPosition();
                            try {
                                String string = Webstart.getClipboard();
                                if (string != null) {
                                    if (n >= 0 && n2 > n) {
                                        jTextComponent.getDocument().remove(n, n2 - n);
                                        jTextComponent.getDocument().insertString(n, string, null);
                                        jTextComponent.requestFocus();
                                        jTextComponent.setCaretPosition(n + string.length());
                                    } else {
                                        jTextComponent.getDocument().insertString(n3, string, null);
                                        jTextComponent.requestFocus();
                                        jTextComponent.setCaretPosition(n + string.length());
                                    }
                                } else {
                                    super.actionPerformed(actionEvent);
                                }
                            }
                            catch (Exception exception) {
                                LoggerFactory.getInstance(SwingTextComponent.class).error(exception);
                                super.actionPerformed(actionEvent);
                            }
                        }
                    });
                }
                if (!((action = actionMap.get("cut-to-clipboard")) instanceof ForwardAction)) {
                    actionMap.put("cut-to-clipboard", new ForwardAction(action){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                if (!(jTextComponent instanceof JPasswordField)) {
                                    int n = jTextComponent.getSelectionStart();
                                    int n2 = jTextComponent.getSelectionEnd();
                                    if (n >= 0 && n2 > n) {
                                        Webstart.setClipboard(jTextComponent.getSelectedText());
                                        jTextComponent.getDocument().remove(n, n2 - n);
                                        jTextComponent.requestFocus();
                                        jTextComponent.setCaretPosition(n);
                                    } else {
                                        super.actionPerformed(actionEvent);
                                    }
                                } else {
                                    super.actionPerformed(actionEvent);
                                }
                            }
                            catch (Exception exception) {
                                LoggerFactory.getInstance(SwingTextComponent.class).error(exception);
                                super.actionPerformed(actionEvent);
                            }
                        }
                    });
                }
            }
        }
    }

    static {
        Color color;
        NUMBER_CELL_EDITOR = new JVxNumberCellEditor();
        DATE_CELL_EDITOR = new JVxDateCellEditor();
        TEXT_CELL_EDITOR = new JVxTextCellEditor();
        defaultCellEditors = new Hashtable();
        htImageCache = new Hashtable();
        htCreateImageCache = new WeakHashMap();
        htImageMapping = new Hashtable();
        rootPaneContainer = null;
        systemColors = new Hashtable();
        defaultCellEditors.put(Number.class, NUMBER_CELL_EDITOR);
        defaultCellEditors.put(Date.class, DATE_CELL_EDITOR);
        Color color2 = (Color)UIManager.getDefaults().get("Table.selectionBackground");
        if (color2 == null) {
            color2 = new Color(0, 0, 255);
        }
        if ((color = (Color)UIManager.getDefaults().get("Table.selectionForeground")) == null) {
            color = new Color(255, 255, 255);
        }
        systemColors.put("IControl.background", CommonUtil.nvl((Color)UIManager.getDefaults().get("Table.background"), new Color(255, 255, 255)));
        systemColors.put("IControl.alternateBackground", new Color(244, 244, 244));
        systemColors.put("IControl.foreground", CommonUtil.nvl((Color)UIManager.getDefaults().get("Table.foreground"), new Color(0, 0, 0)));
        systemColors.put("IControl.activeSelectionBackground", color2);
        systemColors.put("IControl.activeSelectionForeground", color);
        systemColors.put("IControl.inactiveSelectionBackground", color2);
        systemColors.put("IControl.inactiveSelectionForeground", color);
        systemColors.put("IControl.mandatoryBackground", new Color(255, 244, 210));
        systemColors.put("IControl.readOnlyBackground", CommonUtil.nvl((Color)UIManager.getDefaults().get("Panel.background"), new Color(204, 204, 204)));
        systemColors.put("IControl.invalidEditorBackground", new Color(209, 51, 51));
    }

    static class ForwardAction
    extends AbstractAction {
        private Action action;

        ForwardAction(Action action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }
    }
}

