/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.DBObjects;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.DataSourceHandler;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.xml.XmlNode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.UUID;
import javax.rad.remote.ChangePasswordException;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public class DBSecurityManager
extends AbstractSecurityManager {
    protected static final String TABLE_USERS = "USERS";
    protected static final String TABLE_AUTOLOGIN = "AUTOLOGIN";
    protected static final String VIEW_ACCESSRULES = "V_ACCESSRULES";
    private static ILogger log = LoggerFactory.getInstance(DBSecurityManager.class);
    private DBCredentials credentials = null;
    private Connection con = null;
    private PreparedStatement psAutoLogin;
    private PreparedStatement psInsertAutoLogin;
    private PreparedStatement psDeleteAutoLoginKey;
    private PreparedStatement psDeleteAutoLoginUser;
    private PreparedStatement psUserId;
    private PreparedStatement psUserName;
    private PreparedStatement psAccessRule;
    private PreparedStatement psChangePwd;
    private PreparedStatement psChangePwdUnset;
    String sUsersTable;
    String sUsersId;
    String sUsersName;
    String sUsersChgPwd;
    String sUsersPwd;
    String sAutoLoginTable;
    String sAutoLoginId;
    String sAutoLoginKey;
    String sAccessTable;
    String sAccessUser;
    private long lConfigModified = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void validateAuthentication(ISession var1_1) throws Exception {
        block47: {
            var2_2 = var1_1.getApplicationName();
            var3_3 = var1_1.getUserName();
            var4_4 = var1_1.getConfig();
            var5_5 = null;
            var6_6 = false;
            this.openConnection(var1_1);
            try {
                block46: {
                    block45: {
                        var7_7 = (String)var1_1.getProperty("client.login.key");
                        if (this.psAutoLogin != null && var7_7 != null) {
                            var8_9 = null;
                            try {
                                block44: {
                                    this.psAutoLogin.clearParameters();
                                    this.psAutoLogin.setString(1, var7_7);
                                    var8_9 = this.psAutoLogin.executeQuery();
                                    if (!var8_9.next()) break block44;
                                    this.psUserId.clearParameters();
                                    this.psUserId.setBigDecimal(1, var8_9.getBigDecimal(1));
                                    var5_5 = this.psUserId.executeQuery();
                                    var6_6 = true;
                                }
                                var11_10 = null;
                                ** if (var8_9 == null) goto lbl-1000
                            }
                            catch (Throwable var10_21) {
                                var11_11 = null;
                                if (var8_9 != null) {
                                    try {
                                        var8_9.close();
                                    }
                                    catch (SQLException var12_15) {
                                        // empty catch block
                                    }
                                }
                                throw var10_21;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    var8_9.close();
                                }
                                catch (SQLException var12_13) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block45;
                                catch (Exception var9_16) {
                                    DBSecurityManager.log.debug(new Object[]{var9_16});
                                    var11_10 = null;
                                    if (var8_9 != null) {
                                        try {
                                            var8_9.close();
                                        }
                                        catch (SQLException var12_14) {}
                                    }
                                }
                            }
                        }
                    }
                    if (var5_5 == null) {
                        this.psUserName.clearParameters();
                        this.psUserName.setString(1, var3_3);
                        var5_5 = this.psUserName.executeQuery();
                    }
                    this.validateUser(var1_1, var5_5);
                    if (!var6_6) {
                        try {
                            var8_9 = var5_5.getString(DBObjects.getColumnName(var4_4, "USERS", "PASSWORD"));
                        }
                        catch (SQLException var9_17) {
                            var8_9 = null;
                        }
                        if (!this.isPasswordValid(var1_1, (String)var8_9)) {
                            throw new SecurityException("Invalid password for '" + var3_3 + "' and application '" + var2_2 + "'");
                        }
                    }
                    try {
                        var8_9 = var5_5.getString(DBObjects.getColumnName(var4_4, "USERS", "CHANGE_PASSWORD"));
                    }
                    catch (SQLException var9_19) {
                        var8_9 = null;
                    }
                    if (this.isChangePassword(var1_1, (String)var8_9)) {
                        throw new ChangePasswordException("Please change your password");
                    }
                    var9_20 = Boolean.valueOf((String)var1_1.getProperty("client.login.auto"));
                    if (var7_7 == null && var9_20 && this.psAutoLogin != null && this.psDeleteAutoLoginUser != null && this.psInsertAutoLogin != null) {
                        var7_7 = UUID.randomUUID().toString();
                        try {
                            var10_22 = var5_5.getBigDecimal(DBObjects.getColumnName(var4_4, "USERS", "ID"));
                            this.psDeleteAutoLoginUser.clearParameters();
                            this.psDeleteAutoLoginUser.setBigDecimal(1, var10_22);
                            if (this.psDeleteAutoLoginUser.execute()) {
                                this.psDeleteAutoLoginUser.getResultSet().close();
                            }
                            this.psInsertAutoLogin.clearParameters();
                            this.psInsertAutoLogin.setBigDecimal(1, var10_22);
                            this.psInsertAutoLogin.setString(2, var7_7);
                            if (this.psInsertAutoLogin.execute()) {
                                this.psInsertAutoLogin.getResultSet().close();
                            }
                            this.con.commit();
                            var1_1.setProperty("client.login.key", var7_7);
                        }
                        catch (Exception var10_23) {
                            try {
                                this.con.rollback();
                            }
                            catch (SQLException var11_12) {
                                DBSecurityManager.log.error(new Object[]{var11_12});
                            }
                            DBSecurityManager.log.error(new Object[]{var10_23});
                        }
                    }
                    if (var6_6) {
                        if (!(var1_1 instanceof AbstractSession)) break block46;
                        try {
                            ((AbstractSession)var1_1).setUserName(var5_5.getString(DBObjects.getColumnName(var4_4, "USERS", "USERNAME")));
                            break block46;
                        }
                        catch (SQLException var10_24) {
                            throw new SecurityException("USERNAME column for application '" + var2_2 + "' was not found!");
                        }
                    }
                    if (var9_20) break block46;
                    var1_1.setProperty("client.login.key", null);
                }
                var14_25 = null;
                ** if (var5_5 == null) goto lbl-1000
            }
            catch (Throwable var13_37) {
                var14_26 = null;
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (Throwable var16_36) {
                        var17_32 = null;
                        var5_5 = null;
                        throw var16_36;
                    }
                }
                throw var13_37;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var5_5.close();
                }
                catch (Throwable var16_35) {
                    var17_29 = null;
                    var5_5 = null;
                    throw var16_35;
                }
            }
lbl-1000:
            // 1 sources

            {
                break block47;
                catch (SQLException var7_8) {
                    DBSecurityManager.log.error(new Object[]{var7_8});
                    throw new SecurityException("Authentication for user '" + var3_3 + "' and application '" + var2_2 + "' is not possible");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void changePassword(ISession iSession) throws Exception {
        boolean bl;
        String string;
        String string2 = (String)iSession.getProperty("client.oldpassword");
        String string3 = (String)iSession.getProperty("client.newpassword");
        this.validatePassword(iSession, string2, string3);
        String string4 = iSession.getApplicationName();
        String string5 = iSession.getUserName();
        IConfiguration iConfiguration = iSession.getConfig();
        this.openConnection(iSession);
        ResultSet resultSet = null;
        this.psUserName.clearParameters();
        this.psUserName.setString(1, string5);
        resultSet = this.psUserName.executeQuery();
        this.validateUser(iSession, resultSet);
        try {
            string = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD"));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if ((iSession.getProperty("client.login.key") == null || iSession.getPassword() != null) && !this.comparePassword(iConfiguration, iSession.getPassword(), string2) || !this.comparePassword(iConfiguration, string2, string)) throw new SecurityException("Invalid password for '" + string5 + "' and application '" + string4 + "'");
        try {
            resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD"));
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        PreparedStatement preparedStatement = bl ? this.psChangePwdUnset : this.psChangePwd;
        preparedStatement.clearParameters();
        preparedStatement.setString(1, DBSecurityManager.getEncryptedPassword(iConfiguration, string3));
        preparedStatement.setString(2, string5);
        if (preparedStatement.execute()) {
            preparedStatement.getResultSet().close();
        }
        this.con.commit();
        if (preparedStatement.getUpdateCount() != 1) {
            throw new SecurityException("User '" + string5 + "' was not found for application '" + string4 + "'");
        }
        Object var12_15 = null;
        if (resultSet == null) return;
        try {
            resultSet.close();
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            resultSet = null;
            throw throwable;
        }
        {
            catch (SQLException sQLException) {
                log.debug(sQLException);
                try {
                    this.con.rollback();
                    throw new SecurityException("Error while changing password of '" + string5 + "' for application '" + string4 + "'");
                }
                catch (SQLException sQLException2) {
                    log.error(sQLException2);
                }
                throw new SecurityException("Error while changing password of '" + string5 + "' for application '" + string4 + "'");
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
            }
            catch (Throwable throwable2) {
                Object var15_22 = null;
                resultSet = null;
                throw throwable2;
            }
        }
    }

    public synchronized void logout(ISession iSession) {
        if (Boolean.valueOf((String)iSession.getProperty("userlogout")).booleanValue()) {
            try {
                String string = (String)iSession.getProperty("client.login.key");
                if (string != null) {
                    this.openConnection(iSession);
                    this.psDeleteAutoLoginKey.clearParameters();
                    this.psDeleteAutoLoginKey.setString(1, string);
                    if (this.psDeleteAutoLoginKey.execute()) {
                        this.psDeleteAutoLoginKey.getResultSet().close();
                    }
                    this.con.commit();
                    iSession.setProperty("client.login.key", null);
                }
            }
            catch (Exception exception) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    log.error(sQLException);
                }
                log.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized IAccessController getAccessController(ISession iSession) throws Exception {
        Object object;
        IConfiguration iConfiguration = iSession.getConfig();
        ResultSet resultSet = null;
        this.openConnection(iSession);
        if (this.psAccessRule == null) {
            return null;
        }
        this.psAccessRule.clearParameters();
        this.psAccessRule.setObject(1, iSession.getUserName());
        resultSet = this.psAccessRule.executeQuery();
        String string = (String)iSession.getProperty("client.Launcher.environment");
        String string2 = DBObjects.getYesValue(iConfiguration);
        IAccessController iAccessController = this.createAccessController(iSession);
        String string3 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "LIFECYCLENAME");
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (string != null) {
            string4 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_DESKTOP");
            string5 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_WEB");
            string6 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_MOBILE");
            object = resultSet.getMetaData();
            int n = object.getColumnCount();
            for (int i = 1; i <= n && !bl; ++i) {
                String string7 = object.getColumnName(i);
                if (!string7.equals(string4) && !string7.equals(string5) && !string7.equals(string6)) continue;
                bl = true;
            }
        }
        while (resultSet.next()) {
            boolean bl2 = true;
            if (bl) {
                if (string.equals("DESKTOP")) {
                    if (!string2.equals(resultSet.getString(string4))) {
                        bl2 = false;
                    }
                } else if (string.equals("WEB")) {
                    if (!string2.equals(resultSet.getString(string5))) {
                        bl2 = false;
                    }
                } else if (string.equals("MOBILE") && !string2.equals(resultSet.getString(string6))) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            iAccessController.addAccess(resultSet.getString(string3));
        }
        object = iAccessController;
        Object var18_19 = null;
        if (resultSet == null) return object;
        try {
            resultSet.close();
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            resultSet = null;
            throw throwable;
        }
        catch (SQLException sQLException) {
            try {
                log.debug(sQLException);
                IAccessController iAccessController2 = null;
                Object var18_20 = null;
                if (resultSet == null) return iAccessController2;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                if (resultSet == null) throw throwable;
                try {
                    resultSet.close();
                }
                catch (Throwable throwable2) {
                    Object var21_30 = null;
                    resultSet = null;
                    throw throwable2;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                resultSet = null;
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            log.error(exception);
        }
    }

    protected void finalize() throws Throwable {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Connection openConnection(ISession iSession) throws Exception {
        Object object;
        long l;
        IConfiguration iConfiguration;
        boolean bl;
        DBCredentials dBCredentials;
        String string;
        block34: {
            ResultSet resultSet;
            string = iSession.getApplicationName();
            dBCredentials = this.getCredentials(iSession);
            if (dBCredentials == null) {
                throw new IllegalArgumentException("Database credentials were not found!");
            }
            if (dBCredentials.getDriver() == null) {
                DBAccess dBAccess = DBAccess.getDBAccess(dBCredentials.getUrl());
                if (dBAccess != null) {
                    dBCredentials = new DBCredentials(dBAccess.getDriver(), dBCredentials.getUrl(), dBCredentials.getUserName(), dBCredentials.getPassword());
                    if (dBCredentials.getDriver() == null) {
                        throw new IllegalArgumentException("Parameter 'driver' is missing for application '" + string + "'");
                    }
                } else {
                    throw new IllegalArgumentException("Parameter 'url' is missing for application '" + string + "'");
                }
            }
            if (dBCredentials.getUrl() == null) {
                throw new IllegalArgumentException("Parameter 'url' is missing for application '" + string + "'");
            }
            if (dBCredentials.getUserName() == null) {
                throw new IllegalArgumentException("Parameter 'username' is missing for application '" + string + "'");
            }
            if (dBCredentials.getPassword() == null) {
                throw new IllegalArgumentException("Parameter 'password' is missing for application '" + string + "'");
            }
            bl = false;
            iConfiguration = iSession.getConfig();
            l = iConfiguration instanceof Zone ? ((Zone)((Object)iConfiguration)).getFile().lastModified() : Configuration.getApplicationZone(string).getFile().lastModified();
            if (this.con == null || !this.credentials.equals(dBCredentials) || this.lConfigModified != l) {
                bl = true;
            } else {
                Throwable throwable2222;
                block32: {
                    object = null;
                    resultSet = null;
                    object = this.con.createStatement();
                    resultSet = object.executeQuery("select ID from " + DBObjects.getTableName(iConfiguration, TABLE_USERS));
                    resultSet.next();
                    Object var12_12 = null;
                    if (resultSet == null) break block32;
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2222) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable2222) {}
                }
            }
            break block34;
            {
                catch (Throwable throwable) {
                    Throwable throwable32222;
                    bl = true;
                    Object var12_13 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable32222) {
                            // empty catch block
                        }
                    }
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable32222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable throwable42222;
                Object var12_14 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (bl) {
            this.closeConnection();
            try {
                Class.forName(dBCredentials.getDriver());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException("JDBC driver '" + dBCredentials.getDriver() + "' for application '" + string + "' was not found!", classNotFoundException);
            }
            try {
                object = DBAccess.getDBAccess(dBCredentials);
                ((DBAccess)object).open();
                this.con = ((DBAccess)object).getConnection();
                this.con.setAutoCommit(false);
                this.initStatements(iConfiguration);
            }
            catch (SQLException sQLException) {
                this.closeConnection();
                throw new Exception("Can not open database connection with '" + dBCredentials.getUrl() + "' for application '" + string + "'", sQLException);
            }
            this.credentials = dBCredentials;
            this.lConfigModified = l;
        }
        return this.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws Exception {
        if (this.con != null) {
            for (Field field : DBSecurityManager.class.getDeclaredFields()) {
                int n = field.getModifiers();
                if (Modifier.isFinal(n) || Modifier.isStatic(n)) continue;
                try {
                    Object object = field.get(this);
                    if (object == null || !(object instanceof PreparedStatement)) continue;
                    try {
                        ((PreparedStatement)object).close();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    log.debug(field.getName(), exception);
                }
            }
            try {
                this.con.close();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.con = null;
                throw throwable;
            }
        }
    }

    private void initStatements(IConfiguration iConfiguration) throws Exception {
        this.sUsersTable = DBObjects.getTableName(iConfiguration, TABLE_USERS);
        this.sUsersId = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ID");
        this.sUsersName = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "USERNAME");
        this.sUsersChgPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD");
        this.sUsersPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD");
        this.sAutoLoginTable = DBObjects.getTableName(iConfiguration, TABLE_AUTOLOGIN);
        this.sAutoLoginId = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "USER_ID");
        this.sAutoLoginKey = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "LOGINKEY");
        this.sAccessTable = DBObjects.getTableName(iConfiguration, VIEW_ACCESSRULES);
        this.sAccessUser = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "USERNAME");
        this.initStatements(this.con);
    }

    protected void initStatements(Connection connection) throws Exception {
        block15: {
            this.psUserId = connection.prepareStatement("select * from " + this.sUsersTable + " u where u." + this.sUsersId + " = ?");
            this.psUserName = connection.prepareStatement("select * from " + this.sUsersTable + " u where u." + this.sUsersName + " = ?");
            this.psChangePwd = connection.prepareStatement("update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ? " + " where u." + this.sUsersName + " = ?");
            this.psChangePwdUnset = connection.prepareStatement("update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ?, " + "u." + this.sUsersChgPwd + " = 'N' " + " where u." + this.sUsersName + " = ?");
            try {
                this.psAutoLogin = connection.prepareStatement("select al." + this.sAutoLoginId + " from " + this.sAutoLoginTable + " as al where al." + this.sAutoLoginKey + " = ?");
                this.psInsertAutoLogin = connection.prepareStatement("insert into " + this.sAutoLoginTable + "(" + this.sAutoLoginId + ", " + this.sAutoLoginKey + ") values (?, ?)");
                this.psDeleteAutoLoginKey = connection.prepareStatement("delete from " + this.sAutoLoginTable + " where " + this.sAutoLoginKey + " = ?");
                this.psDeleteAutoLoginUser = connection.prepareStatement("delete from " + this.sAutoLoginTable + " where " + this.sAutoLoginId + " = ?");
            }
            catch (SQLException sQLException) {
                if (this.psAutoLogin != null) {
                    try {
                        this.psAutoLogin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.psAutoLogin = null;
                }
                if (this.psInsertAutoLogin != null) {
                    try {
                        this.psInsertAutoLogin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.psInsertAutoLogin = null;
                }
                if (this.psDeleteAutoLoginKey != null) {
                    try {
                        this.psDeleteAutoLoginKey.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.psDeleteAutoLoginKey = null;
                }
                if (this.psDeleteAutoLoginUser == null) break block15;
                try {
                    this.psDeleteAutoLoginUser.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.psDeleteAutoLoginUser = null;
            }
        }
        try {
            this.psAccessRule = connection.prepareStatement("select * from " + this.sAccessTable + " where " + this.sAccessUser + " = ?");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUser(ISession iSession, ResultSet resultSet) throws Exception {
        Timestamp timestamp;
        Timestamp timestamp2;
        String string;
        String string2 = iSession.getApplicationName();
        String string3 = iSession.getUserName();
        if (!resultSet.next()) throw new SecurityException("User '" + string3 + "' was not found for application '" + string2 + "'");
        IConfiguration iConfiguration = iSession.getConfig();
        try {
            string = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ACTIVE"));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if (!this.isActive(iSession, string)) throw new SecurityException("User '" + string3 + "' is inactive for application '" + string2 + "'");
        try {
            timestamp2 = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_FROM"));
        }
        catch (SQLException sQLException) {
            timestamp2 = null;
        }
        try {
            timestamp = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_TO"));
        }
        catch (SQLException sQLException) {
            timestamp = null;
        }
        if (this.isValid(iSession, timestamp2, timestamp)) return;
        throw new SecurityException("User '" + string3 + "' is expired for application '" + string2 + "'");
    }

    protected boolean isActive(ISession iSession, String string) throws Exception {
        if (string == null) {
            return true;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected boolean isValid(ISession iSession, Timestamp timestamp, Timestamp timestamp2) {
        long l = System.currentTimeMillis();
        return !(timestamp != null && timestamp.getTime() > l || timestamp2 != null && timestamp2.getTime() <= l);
    }

    protected boolean isPasswordValid(ISession iSession, String string) throws Exception {
        return this.comparePassword(iSession.getConfig(), iSession.getPassword(), string);
    }

    protected boolean isChangePassword(ISession iSession, String string) throws Exception {
        if (string == null) {
            return false;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected IAccessController createAccessController(ISession iSession) {
        String string = iSession.getConfig().getProperty("/application/securitymanager/accesscontroller");
        if (string != null && string.trim().length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                return (IAccessController)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SecurityException("Access controller '" + string + "' was not found!");
            }
            catch (InstantiationException instantiationException) {
                throw new SecurityException("Can't instantiate access controller '" + string + "'!");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SecurityException("Access controller '" + string + "' not accessible!");
            }
        }
        return new DBAccessController();
    }

    protected DBCredentials getCredentials(ISession iSession) {
        return DBSecurityManager.getCredentials(iSession.getConfig());
    }

    public static DBCredentials getCredentials(IConfiguration iConfiguration) {
        try {
            XmlNode xmlNode = iConfiguration.getNode("/application/securitymanager/database");
            if (xmlNode == null) {
                return DataSourceHandler.createDBCredentials(iConfiguration, "default");
            }
            XmlNode xmlNode2 = xmlNode.getNode("/datasource");
            if (xmlNode2 == null) {
                return DataSourceHandler.createDBCredentials(xmlNode);
            }
            return DataSourceHandler.createDBCredentials(iConfiguration, xmlNode2.getValue());
        }
        catch (Exception exception) {
            log.error(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Connection getConnection() throws Exception {
        block22: {
            boolean bl;
            block23: {
                Throwable throwable2222;
                ResultSet resultSet;
                Statement statement;
                block20: {
                    if (this.con == null) break block22;
                    bl = false;
                    statement = null;
                    resultSet = null;
                    statement = this.con.createStatement();
                    resultSet = statement.executeQuery("select ID from " + this.sUsersTable);
                    resultSet.next();
                    Object var6_4 = null;
                    if (resultSet == null) break block20;
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2222) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2222) {}
                }
                break block23;
                {
                    catch (Throwable throwable3) {
                        Throwable throwable42222;
                        bl = true;
                        Object var6_5 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable42222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable42222) {}
                        }
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable62222;
                    Object var6_6 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable62222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable62222) {
                            // empty catch block
                        }
                    }
                    throw throwable5;
                }
            }
            if (bl) {
                try {
                    DBAccess dBAccess = DBAccess.getDBAccess(this.credentials);
                    this.con = dBAccess.getConnection();
                    this.con.setAutoCommit(false);
                    this.initStatements(this.con);
                }
                catch (SQLException sQLException) {
                    this.closeConnection();
                    throw new Exception("Can not open database connection with '" + this.credentials.getUrl() + "'", sQLException);
                }
            }
        }
        return this.con;
    }

    public Connection getConnection(ISession iSession) throws Exception {
        return this.openConnection(iSession);
    }

    public static final class DBAccessController
    implements IAccessController {
        private ArrayUtil<String> auAllowedLCO = null;

        public boolean isAllowed(String string) {
            if (string != null && this.auAllowedLCO != null) {
                return this.auAllowedLCO.contains(string);
            }
            return false;
        }

        public void addAccess(String string) {
            if (string == null) {
                return;
            }
            if (this.auAllowedLCO == null) {
                this.auAllowedLCO = new ArrayUtil();
            }
            if (!this.auAllowedLCO.contains(string)) {
                this.auAllowedLCO.add(string);
            }
        }

        public void removeAccess(String string) {
            if (string == null || this.auAllowedLCO == null) {
                return;
            }
            this.auAllowedLCO.remove(string);
        }

        public String[] getAllowedLifeCycleNames() {
            if (this.auAllowedLCO == null) {
                return new String[0];
            }
            return this.auAllowedLCO.toArray(new String[this.auAllowedLCO.size()]);
        }
    }
}

