/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.UpToDateConfigFile;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.File;
import java.util.List;
import javax.rad.server.IConfiguration;

public abstract class Zone
extends UpToDateConfigFile {
    static final String NAME_CONFIG = "config.xml";
    private List<String> liEncryptedNodes = null;
    private File fiDirectory;
    private IConfiguration config;

    Zone(File file) throws Exception {
        this(file, NAME_CONFIG);
    }

    Zone(File file, String string) throws Exception {
        super(file, string);
        this.fiDirectory = file;
    }

    protected XmlWorker createXmlWorker() {
        XmlWorker xmlWorker = new XmlWorker();
        xmlWorker.setAutomaticDecrypt(true);
        if (this.liEncryptedNodes != null) {
            for (String string : this.liEncryptedNodes) {
                xmlWorker.setEncrypted(string, true);
            }
        }
        return xmlWorker;
    }

    public static boolean isValid(File file) {
        if (file != null) {
            return UpToDateConfigFile.isValid(new File(file, NAME_CONFIG));
        }
        return false;
    }

    public File getDirectory() {
        return this.fiDirectory;
    }

    public IConfiguration getConfig() {
        if (this.config == null) {
            this.config = new ZoneConfig(this);
        }
        return this.config;
    }

    public boolean addEncryptedNode(String string) {
        if (this.liEncryptedNodes == null) {
            this.liEncryptedNodes = new ArrayUtil<String>();
        }
        if (!this.liEncryptedNodes.contains(string)) {
            return this.liEncryptedNodes.add(string);
        }
        return false;
    }

    public boolean removeEncryptedNode(String string) {
        boolean bl = this.liEncryptedNodes.remove(string);
        if (this.liEncryptedNodes.isEmpty()) {
            this.liEncryptedNodes = null;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ZoneConfig
    implements IConfiguration {
        private final Zone zone;

        ZoneConfig(Zone zone) {
            this.zone = zone;
        }

        @Override
        public String getProperty(String string) {
            try {
                return this.zone.getProperty(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }

        @Override
        public String getProperty(String string, String string2) {
            try {
                return this.zone.getProperty(string, string2);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }

        @Override
        public List<String> getProperties(String string) {
            try {
                return this.zone.getProperties(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }

        @Override
        public XmlNode getNode(String string) {
            try {
                return this.zone.getNode(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }

        @Override
        public List<XmlNode> getNodes(String string) {
            try {
                return this.zone.getNodes(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
    }
}

