/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.rad.remote.CommunicationException;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.IConnectionConstants;
import javax.rad.remote.event.CallBackEvent;
import javax.rad.remote.event.ICallBackListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializedConnection
implements IConnection {
    public static final String PROP_SERIALIZER = "serializer";
    private Reflective refUIThread = new Reflective();
    private Hashtable<Object, CallBackInfo> htCallBack = null;
    private KeyValueList<Object, Object> kvlConCallBack = null;
    private Object oSync = new Object();
    private ISerializer serializer = null;
    private long lSequence = 0L;
    private boolean bCalling = false;

    public AbstractSerializedConnection(Properties properties) throws ClassNotFoundException {
        this(AbstractSerializedConnection.createSerializer(properties.getProperty(PROP_SERIALIZER)));
    }

    public AbstractSerializedConnection(ISerializer iSerializer) {
        this.serializer = iSerializer == null ? new UniversalSerializer() : iSerializer;
    }

    @Override
    public void open(ConnectionInfo connectionInfo) throws Throwable {
        Object object = this.callIntern(connectionInfo, new String[]{"Session!"}, new String[]{"createSession"}, null, null)[0];
        connectionInfo.setConnectionId(object);
    }

    @Override
    public void openSub(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) throws Throwable {
        Object object = this.callIntern(connectionInfo2, new String[]{"Session!"}, new String[]{"createSubSession"}, new Object[][]{{connectionInfo.getConnectionId()}}, null)[0];
        connectionInfo2.setConnectionId(object);
    }

    @Override
    public boolean isOpen(ConnectionInfo connectionInfo) {
        return connectionInfo != null && connectionInfo.getConnectionId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ConnectionInfo connectionInfo) throws Throwable {
        if (this.isOpen(connectionInfo)) {
            try {
                this.call(connectionInfo, new String[]{"Session!"}, new String[]{"destroySession"}, null, null);
            }
            finally {
                List<Object> list;
                Object object = connectionInfo.getConnectionId();
                connectionInfo.setConnectionId(null);
                if (this.kvlConCallBack != null && (list = this.kvlConCallBack.remove(object)) != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        this.htCallBack.remove(list.get(i));
                    }
                }
            }
        } else {
            throw new IllegalStateException("Connection not open");
        }
    }

    @Override
    public void reopen(ConnectionInfo connectionInfo) throws Throwable {
        try {
            this.close(connectionInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.open(connectionInfo);
    }

    @Override
    public Object[] call(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("Invalid connection information: null");
        }
        if (connectionInfo.getConnectionId() == null) {
            throw new IllegalStateException("The connection is not open!");
        }
        return this.callIntern(connectionInfo, stringArray, stringArray2, objectArray, iCallBackListenerArray);
    }

    @Override
    public ConnectionInfo[] setAndCheckAlive(ConnectionInfo connectionInfo, ConnectionInfo[] connectionInfoArray) throws Throwable {
        Object[] objectArray;
        Hashtable<Object, ConnectionInfo> hashtable;
        int n;
        if (connectionInfoArray != null) {
            n = connectionInfoArray.length;
            hashtable = new Hashtable<Object, ConnectionInfo>(n);
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = connectionInfoArray[i].getConnectionId();
                hashtable.put(objectArray[i], connectionInfoArray[i]);
            }
        } else {
            hashtable = null;
            objectArray = null;
        }
        if ((objectArray = (Object[])this.callIntern(connectionInfo, new String[]{"Session!"}, new String[]{"setAndCheckAlive"}, new Object[][]{objectArray}, null)[0]) == null) {
            return null;
        }
        n = objectArray.length;
        ConnectionInfo[] connectionInfoArray2 = new ConnectionInfo[n];
        for (int i = 0; i < n; ++i) {
            connectionInfoArray2[i] = (ConnectionInfo)hashtable.get(objectArray[i]);
        }
        return connectionInfoArray2;
    }

    @Override
    public void setProperty(ConnectionInfo connectionInfo, String string, Object object) throws Throwable {
        if (string != null && string.startsWith("client.")) {
            if (this.isOpen(connectionInfo)) {
                throw new SecurityException("Client properties are not accessible after the connection was opened!");
            }
            connectionInfo.getProperties().put(string, object);
        } else {
            Object object2 = connectionInfo.getProperties().put(string, object);
            if ((object2 == null || !object2.equals(object)) && string != null && string.startsWith("server.session.") && this.isOpen(connectionInfo)) {
                this.callIntern(connectionInfo, new String[0], new String[0], null, null);
            }
        }
    }

    @Override
    public Object getProperty(ConnectionInfo connectionInfo, String string) throws Throwable {
        if (connectionInfo != null) {
            return connectionInfo.getProperties().get(string);
        }
        return null;
    }

    @Override
    public Hashtable<String, Object> getProperties(ConnectionInfo connectionInfo) throws Throwable {
        if (connectionInfo != null) {
            return (Hashtable)connectionInfo.getProperties().clone();
        }
        return null;
    }

    @Override
    public void setNewPassword(ConnectionInfo connectionInfo, String string, String string2) throws Throwable {
        this.callIntern(connectionInfo, new String[]{"Session!"}, new String[]{"setNewPassword"}, new Object[][]{{string, string2}}, null);
    }

    public abstract OutputStream getOutputStream(ConnectionInfo var1) throws Throwable;

    public abstract InputStream getInputStream(ConnectionInfo var1) throws Throwable;

    protected void finalize() throws Throwable {
        this.htCallBack = null;
        this.kvlConCallBack = null;
        super.finalize();
    }

    protected static ISerializer createSerializer(String string) throws ClassNotFoundException {
        if (string != null) {
            ISerializer iSerializer = null;
            try {
                iSerializer = (ISerializer)Class.forName(string).newInstance();
                return iSerializer;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private Object[] callIntern(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        Object object = this.oSync;
        synchronized (object) {
            try {
                Object[] objectArray2;
                Object object2;
                void var15_27;
                OutputStream outputStream;
                List<Map.Entry<String, Object>> list;
                Object[] objectArray3;
                this.bCalling = true;
                if (stringArray2 == null) {
                    throw new IllegalArgumentException("No remote method specified!");
                }
                if (stringArray != null && stringArray2.length != stringArray.length) {
                    throw new IllegalArgumentException("More or less objects than methods!");
                }
                if (objectArray != null && objectArray.length != stringArray2.length) {
                    throw new IllegalArgumentException("More or less params than methods!");
                }
                Object object3 = connectionInfo.getConnectionId();
                if (!(object3 != null || stringArray != null && "Session!".equals(stringArray[0]) && ("createSession".equals(stringArray2[0]) || "createSubSession".equals(stringArray2[0])))) {
                    throw new IOException("Connection is not open!");
                }
                if (iCallBackListenerArray != null && iCallBackListenerArray.length != stringArray2.length) {
                    throw new IllegalArgumentException("More or less callbacks than methods!");
                }
                int n = stringArray2.length;
                if (iCallBackListenerArray != null) {
                    objectArray3 = new Object[iCallBackListenerArray.length];
                    int n2 = iCallBackListenerArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (iCallBackListenerArray[i] == null) continue;
                        objectArray3[i] = this.createCallBackId();
                        if (this.htCallBack == null) {
                            this.htCallBack = new Hashtable();
                            this.kvlConCallBack = new KeyValueList();
                        }
                        this.htCallBack.put(objectArray3[i], new CallBackInfo(object3, stringArray != null ? stringArray[i] : null, stringArray2[i], iCallBackListenerArray[i]));
                        this.kvlConCallBack.put(object3, objectArray3[i]);
                    }
                } else {
                    objectArray3 = null;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                if (object3 == null) {
                    dataOutputStream.writeUTF(this.serializer.getClass().getName());
                    dataOutputStream.writeUTF("");
                } else {
                    dataOutputStream.writeUTF((String)connectionInfo.getConnectionId());
                }
                if (this.isOpen(connectionInfo)) {
                    list = connectionInfo.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES);
                } else {
                    list = connectionInfo.getProperties().getMapping(IConnectionConstants.PROPERTY_CLASSES);
                    connectionInfo.getProperties().clearChanges();
                }
                this.serializer.write(dataOutputStream, n += list != null ? 1 : 0);
                if (list != null) {
                    ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>(list.size());
                    for (Map.Entry<String, Object> entry : list) {
                        arrayUtil.add(new Object[]{entry.getKey(), entry.getValue()});
                    }
                    this.serializer.write(dataOutputStream, new Object[]{"Session!", "setProperty", new Object[]{arrayUtil}, null});
                }
                int n3 = stringArray2.length;
                for (int i = 0; i < n3; ++i) {
                    this.serializer.write(dataOutputStream, new Object[]{stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null, objectArray3 != null ? objectArray3[i] : null});
                }
                byteArrayOutputStream.close();
                dataOutputStream.close();
                try {
                    outputStream = this.getOutputStream(connectionInfo);
                }
                catch (Throwable throwable) {
                    throw new CommunicationException(throwable);
                }
                dataOutputStream = new DataOutputStream(outputStream);
                try {
                    if (object3 == null) {
                        outputStream.write(65);
                    } else {
                        outputStream.write(69);
                    }
                    n3 = Boolean.parseBoolean((String)connectionInfo.getProperties().get("client.session.compression")) ? 1 : 0;
                    if (n3 != 0 && byteArrayOutputStream.size() >= 256) {
                        outputStream.write(2);
                        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
                        gZIPOutputStream.write(byteArrayOutputStream.toByteArray());
                        gZIPOutputStream.flush();
                        gZIPOutputStream.finish();
                    } else {
                        outputStream.write(1);
                        outputStream.write(byteArrayOutputStream.toByteArray());
                    }
                    outputStream.flush();
                }
                finally {
                    dataOutputStream.close();
                }
                InputStream inputStream = this.getInputStream(connectionInfo);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                connectionInfo.setLastCallTime(System.currentTimeMillis());
                char c = (char)((InputStream)bufferedInputStream).read();
                if (c != 'E' && c != 'B') {
                    throw new IOException("Invalid stream identifier '" + c + "'");
                }
                int n4 = ((InputStream)bufferedInputStream).read();
                if (n4 == 2) {
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
                }
                DataInputStream dataInputStream = new DataInputStream((InputStream)var15_27);
                try {
                    if (c == 'B') {
                        Throwable throwable = (Throwable)Class.forName(dataInputStream.readUTF()).getConstructor(String.class).newInstance(dataInputStream.readUTF());
                        int n5 = dataInputStream.read();
                        if (n5 > 0) {
                            StackTraceElement[] stackTraceElementArray = new StackTraceElement[n5];
                            for (int i = 0; i < n5; ++i) {
                                stackTraceElementArray[i] = new StackTraceElement(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readInt());
                            }
                            throwable.setStackTrace(stackTraceElementArray);
                        }
                        throw throwable;
                    }
                    n = (Integer)this.serializer.read(dataInputStream);
                    ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>(n);
                    for (int i = 0; i < n; ++i) {
                        Object object4 = null;
                        Object object5 = this.serializer.read(dataInputStream);
                        if (object5.getClass() == Byte.class) {
                            byte by = (Byte)object5;
                            object5 = this.serializer.read(dataInputStream);
                            if (by == 2 || by == 1) {
                                object4 = this.serializer.read(dataInputStream);
                                this.doCallBack(by, object4, object5);
                                continue;
                            }
                            if (by == 5) {
                                object2 = connectionInfo.getProperties();
                                if (object2 == null) continue;
                                ArrayUtil arrayUtil2 = (ArrayUtil)object5;
                                int n6 = arrayUtil2.size();
                                for (int j = 0; j < n6; ++j) {
                                    Object[] objectArray4 = (Object[])arrayUtil2.get(j);
                                    ((ChangedHashtable)object2).put((String)objectArray4[0], objectArray4[1], false);
                                }
                                continue;
                            }
                            if (by == 4 || by == 3) {
                                if (by == 4) {
                                    throw (Throwable)object5;
                                }
                                arrayUtil.add(object5);
                                continue;
                            }
                            throw new IOException("Invalid return type");
                        }
                        throw new IOException("Invalid response type");
                    }
                    objectArray2 = arrayUtil.toArray(new Object[arrayUtil.size()]);
                }
                catch (Throwable throwable) {
                    byte[] byArray = new byte[4096];
                    while (inputStream.read(byArray) >= 0) {
                    }
                    inputStream.close();
                    if (var15_27 != inputStream) {
                        var15_27.close();
                    }
                    dataInputStream.close();
                    throw throwable;
                }
                object2 = new byte[4096];
                while (inputStream.read((byte[])object2) >= 0) {
                }
                inputStream.close();
                if (var15_27 != inputStream) {
                    var15_27.close();
                }
                dataInputStream.close();
                return objectArray2;
            }
            finally {
                this.bCalling = false;
            }
        }
    }

    @Override
    public boolean isCalling() {
        return this.bCalling;
    }

    private synchronized Object createCallBackId() {
        return Long.toHexString(++this.lSequence) + "SC";
    }

    private void doCallBack(byte by, Object object, Object object2) {
        CallBackInfo callBackInfo = this.htCallBack.remove(object);
        if (callBackInfo != null) {
            this.kvlConCallBack.remove(callBackInfo.getConnectionId(), object);
            if (this.htCallBack.size() == 0) {
                this.htCallBack = null;
                this.kvlConCallBack = null;
            }
            if (callBackInfo.getCallBackListener() != null) {
                this.refUIThread.invokeLater(new CallBackWorker(callBackInfo, by, object2));
            }
        } else {
            throw new IllegalArgumentException("CallBack ID not found: '" + object + "'");
        }
    }

    private static final class CallBackWorker
    implements Runnable {
        private CallBackInfo cbiInfo;
        private byte byType;
        private Object oResult;
        private ILogger log;
        private long lCreated = System.currentTimeMillis();

        private CallBackWorker(CallBackInfo callBackInfo, byte by, Object object) {
            this.cbiInfo = callBackInfo;
            this.byType = by;
            this.oResult = object;
        }

        public void run() {
            ICallBackListener iCallBackListener = this.cbiInfo.getCallBackListener();
            if (iCallBackListener != null) {
                try {
                    Object object = null;
                    Throwable throwable = null;
                    switch (this.byType) {
                        case 2: {
                            throwable = (Throwable)this.oResult;
                            break;
                        }
                        default: {
                            object = this.oResult;
                        }
                    }
                    iCallBackListener.callBack(new CallBackEvent(this.cbiInfo.getObjectName(), this.cbiInfo.getMethodName(), object, throwable, this.cbiInfo.getCreateTime(), this.lCreated));
                }
                catch (Throwable throwable) {
                    this.error(throwable);
                }
            }
        }

        private void error(Object ... objectArray) {
            if (this.log == null) {
                this.log = LoggerFactory.getInstance(this.getClass());
            }
            this.log.error(objectArray);
        }
    }

    private static final class CallBackInfo {
        private Object oConnectionId;
        private ICallBackListener cblListener;
        private String sObjectName;
        private String sMethodName;
        private long lCreated = System.currentTimeMillis();

        private CallBackInfo(Object object, String string, String string2, ICallBackListener iCallBackListener) {
            this.oConnectionId = object;
            this.sObjectName = string;
            this.sMethodName = string2;
            this.cblListener = iCallBackListener;
        }

        private Object getConnectionId() {
            return this.oConnectionId;
        }

        private String getObjectName() {
            return this.sObjectName;
        }

        private String getMethodName() {
            return this.sMethodName;
        }

        private ICallBackListener getCallBackListener() {
            return this.cblListener;
        }

        private long getCreateTime() {
            return this.lCreated;
        }
    }
}

