/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.BeanUtil;
import javax.rad.model.ModelException;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.MetaData;

public class ServerMetaData
implements Cloneable {
    private MetaData metaData;
    private ArrayUtil<ServerColumnMetaData> auServerColumnMetaData = new ArrayUtil();
    private int[] iaPKColumnIndices;
    private int[] iaAutoIncrementColumnIndices;
    private int[] iaWritableColumnIndices;
    private String sFromClause;
    private String[] saQueryColumns;
    private Name[] naPrimaryKeyColumnNames;
    private String[] saPrimaryKeyQuotedColumnNames;
    private Name[] naRepresentationColumnNames;
    private String[] saRepresentationQuotedColumnNames;
    private Name[] naAutoIncrementColumnNames;
    private String[] saAutoIncrementQuotedColumnNames;
    private PrimaryKeyType pktype = PrimaryKeyType.PrimaryKeyColumns;

    public ServerMetaData() {
        this.metaData = new MetaData();
    }

    public ServerMetaData clone() {
        try {
            ServerMetaData serverMetaData = (ServerMetaData)super.clone();
            if (this.auServerColumnMetaData != null) {
                serverMetaData.auServerColumnMetaData = new ArrayUtil(this.auServerColumnMetaData.size());
                int n = this.auServerColumnMetaData.size();
                for (int i = 0; i < n; ++i) {
                    serverMetaData.auServerColumnMetaData.add(this.auServerColumnMetaData.get(i).clone());
                }
            }
            if (this.iaPKColumnIndices != null) {
                serverMetaData.iaPKColumnIndices = (int[])this.iaPKColumnIndices.clone();
            }
            if (this.iaAutoIncrementColumnIndices != null) {
                serverMetaData.iaAutoIncrementColumnIndices = (int[])this.iaAutoIncrementColumnIndices.clone();
            }
            if (this.iaWritableColumnIndices != null) {
                serverMetaData.iaWritableColumnIndices = (int[])this.iaWritableColumnIndices.clone();
            }
            if (this.saQueryColumns != null) {
                serverMetaData.saQueryColumns = (String[])this.saQueryColumns.clone();
            }
            if (this.naPrimaryKeyColumnNames != null) {
                serverMetaData.naPrimaryKeyColumnNames = (Name[])this.naPrimaryKeyColumnNames.clone();
            }
            if (this.naRepresentationColumnNames != null) {
                serverMetaData.naRepresentationColumnNames = (Name[])this.naRepresentationColumnNames.clone();
            }
            if (this.naAutoIncrementColumnNames != null) {
                serverMetaData.naAutoIncrementColumnNames = (Name[])this.naAutoIncrementColumnNames.clone();
            }
            return serverMetaData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void addServerColumnMetaData(ServerColumnMetaData serverColumnMetaData) {
        this.metaData.addColumnMetaData(serverColumnMetaData.getColumnMetaData());
        this.auServerColumnMetaData.add(serverColumnMetaData);
        this.iaWritableColumnIndices = null;
        this.iaPKColumnIndices = null;
        this.iaAutoIncrementColumnIndices = null;
    }

    public void setServerColumnMetaData(ServerColumnMetaData[] serverColumnMetaDataArray) {
        this.auServerColumnMetaData.clear();
        this.auServerColumnMetaData.addAll((ServerColumnMetaData[])serverColumnMetaDataArray);
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[serverColumnMetaDataArray.length];
        for (int i = 0; i < columnMetaDataArray.length; ++i) {
            columnMetaDataArray[i] = serverColumnMetaDataArray[i].getColumnMetaData();
        }
        this.metaData.setColumnMetaData(columnMetaDataArray);
        this.iaWritableColumnIndices = null;
        this.iaPKColumnIndices = null;
        this.iaAutoIncrementColumnIndices = null;
    }

    public ServerColumnMetaData[] getServerColumnMetaData() {
        return this.auServerColumnMetaData.toArray(new ServerColumnMetaData[this.auServerColumnMetaData.size()]);
    }

    public ServerColumnMetaData getServerColumnMetaData(String string) throws ModelException {
        int n = this.getServerColumnMetaDataIndex(string);
        if (n >= 0) {
            return this.auServerColumnMetaData.get(n);
        }
        throw new ModelException("Column '" + string + "' doesn't exists in MetaData!");
    }

    public int getServerColumnMetaDataIndex(String string) {
        for (int i = 0; i < this.auServerColumnMetaData.size(); ++i) {
            if (!this.auServerColumnMetaData.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int[] getWritableColumnIndices() {
        if (this.iaWritableColumnIndices == null) {
            this.iaWritableColumnIndices = new int[this.auServerColumnMetaData.size()];
            int n = 0;
            for (int i = 0; i < this.auServerColumnMetaData.size(); ++i) {
                if (!this.auServerColumnMetaData.get(i).isWritable()) continue;
                this.iaWritableColumnIndices[n] = i;
                ++n;
            }
            this.iaWritableColumnIndices = ArrayUtil.truncate(this.iaWritableColumnIndices, n);
        }
        return this.iaWritableColumnIndices;
    }

    public int[] getPrimaryKeyColumnIndices() {
        String[] stringArray = this.metaData.getPrimaryKeyColumnNames();
        if (stringArray == null) {
            return null;
        }
        if (this.iaPKColumnIndices == null) {
            this.iaPKColumnIndices = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.iaPKColumnIndices[i] = this.getServerColumnMetaDataIndex(stringArray[i]);
            }
        }
        return this.iaPKColumnIndices;
    }

    public int[] getAutoIncrementColumnIndices() {
        String[] stringArray = this.metaData.getAutoIncrementColumnNames();
        if (stringArray == null) {
            return null;
        }
        if (this.iaAutoIncrementColumnIndices == null) {
            this.iaAutoIncrementColumnIndices = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.iaAutoIncrementColumnIndices[i] = this.getServerColumnMetaDataIndex(stringArray[i]);
            }
        }
        return this.iaAutoIncrementColumnIndices;
    }

    public String[] getPrimaryKeyColumnNames() {
        return this.metaData.getPrimaryKeyColumnNames();
    }

    public String[] getPrimaryKeyQuotedColumnNames() {
        if (this.saPrimaryKeyQuotedColumnNames == null) {
            this.saPrimaryKeyQuotedColumnNames = BeanUtil.toArray(this.naPrimaryKeyColumnNames, new String[this.naPrimaryKeyColumnNames.length], "quotedName");
        }
        return this.saPrimaryKeyQuotedColumnNames;
    }

    public void setPrimaryKeyColumnNames(Name[] nameArray) {
        this.naPrimaryKeyColumnNames = nameArray;
        this.metaData.setPrimaryKeyColumnNames(BeanUtil.toArray(this.naPrimaryKeyColumnNames, new String[this.naPrimaryKeyColumnNames.length], "name"));
        this.iaPKColumnIndices = null;
        this.saPrimaryKeyQuotedColumnNames = null;
    }

    public String[] getRepresentationColumnNames() {
        return this.metaData.getRepresentationColumnNames();
    }

    public String[] getRepresentationQuotedColumnNames() {
        if (this.saRepresentationQuotedColumnNames == null) {
            this.saRepresentationQuotedColumnNames = BeanUtil.toArray(this.naRepresentationColumnNames, new String[this.naRepresentationColumnNames.length], "quotedName");
        }
        return this.saRepresentationQuotedColumnNames;
    }

    public void setRepresentationColumnNames(Name[] nameArray) {
        this.naRepresentationColumnNames = nameArray;
        this.metaData.setRepresentationColumnNames(BeanUtil.toArray(this.naRepresentationColumnNames, new String[this.naRepresentationColumnNames.length], "name"));
        this.saRepresentationQuotedColumnNames = null;
    }

    public String[] getAutoIncrementColumnNames() {
        return this.metaData.getAutoIncrementColumnNames();
    }

    public String[] getAutoIncrementQuotedColumnNames() {
        if (this.saAutoIncrementQuotedColumnNames == null) {
            this.saAutoIncrementQuotedColumnNames = BeanUtil.toArray(this.naAutoIncrementColumnNames, new String[this.naAutoIncrementColumnNames.length], "quotedName");
        }
        return this.saAutoIncrementQuotedColumnNames;
    }

    public void setAutoIncrementColumnNames(Name[] nameArray) {
        this.naAutoIncrementColumnNames = nameArray;
        this.metaData.setAutoIncrementColumnNames(BeanUtil.toArray(this.naAutoIncrementColumnNames, new String[this.naAutoIncrementColumnNames.length], "name"));
        this.saAutoIncrementQuotedColumnNames = null;
        this.iaAutoIncrementColumnIndices = null;
    }

    public String[] getColumnNames() {
        return this.metaData.getColumnNames();
    }

    public void setFromClause(String string) {
        this.sFromClause = string;
    }

    public String getFromClause() {
        return this.sFromClause;
    }

    public void setQueryColumns(String[] stringArray) {
        this.saQueryColumns = stringArray;
    }

    public String[] getQueryColumns() {
        return this.saQueryColumns;
    }

    public PrimaryKeyType getPrimaryKeyType() {
        return this.pktype;
    }

    public void setPrimaryKeyType(PrimaryKeyType primaryKeyType) {
        this.pktype = primaryKeyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrimaryKeyType {
        PrimaryKeyColumns,
        UniqueKeyColumns,
        AllColumns;

    }
}

