/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDBAccess
extends DBAccess {
    private static String sUKSelect = "SELECT cons.constraint_name FROM all_constraints cons WHERE cons.table_name = ? AND cons.constraint_type = 'U' AND cons.owner = ? ";
    private static String sConstraintColumnsSelect = "SELECT cols.column_name ,cols.table_name FROM all_cons_columns cols WHERE cols.owner = ? AND cols.constraint_name = ? ORDER BY POSITION";
    private static String sPKSelect = "SELECT cons.constraint_name FROM all_constraints cons WHERE cons.constraint_type = 'P' AND cons.table_name = ? AND cons.owner = ?";
    private static String sFKSelect = "SELECT  c.constraint_name   fk_name  ,r_owner             pktable_schem  ,c.r_constraint_name pk_name FROM all_constraints c WHERE c.table_name = ? AND c.constraint_type = 'R' AND c.owner = ? ORDER BY c.owner, c.table_name, c.constraint_name";
    private static String sCheckSelect = "select /*+ rule */ search_condition from user_constraints where constraint_type = 'C' and generated = 'USER NAME' and status = 'ENABLED' and table_name = ?";
    private static String sSynonymSelect = "select s.table_owner, s.table_name, s.db_link FROM user_synonyms s WHERE s.synonym_name = ?";

    public OracleDBAccess() {
        this.setDriver("oracle.jdbc.OracleDriver");
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NOWAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertOracle(string, string2, serverMetaData, objectArray, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DataSourceException {
        super.open();
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            statement.executeUpdate("ALTER SESSION SET NLS_COMP='BINARY'");
            statement.executeUpdate("ALTER SESSION SET NLS_SORT='BINARY'");
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<Key> getUKs(String string, String string2, String string3) throws DataSourceException {
        ResultSet resultSet = null;
        Statement statement = null;
        ResultSet resultSet2 = null;
        Statement statement2 = null;
        try {
            Object object;
            ArrayUtil<Key> arrayUtil = new ArrayUtil<Key>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            statement = this.getPreparedStatement(sUKSelect, false);
            statement2 = this.getPreparedStatement(sConstraintColumnsSelect, false);
            statement.setString(1, string3);
            statement.setString(2, string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("CONSTRAINT_NAME");
                statement2.setString(1, string2);
                statement2.setString(2, (String)object);
                resultSet2 = statement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                try {
                    resultSet2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Key key = new Key((String)object);
                key.setColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add(key);
                arrayUtil2.clear();
            }
            logger.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            object = arrayUtil;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Unique Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (resultSet2 != null) {
                try {
                    resultSet2.close();
                }
                catch (Exception exception) {}
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Key getPK(String string, String string2, String string3) throws DataSourceException {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            String string4;
            Key key = null;
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            statement = this.getPreparedStatement(sPKSelect, false);
            statement.setString(1, string3);
            statement.setString(2, string2);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString("CONSTRAINT_NAME");
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                statement = this.getPreparedStatement(sConstraintColumnsSelect, false);
                statement.setString(1, string2);
                statement.setString(2, string4);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    do {
                        arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
                    } while (resultSet.next());
                    if (arrayUtil.size() > 0) {
                        key = new Key(string4);
                        key.setColumns(arrayUtil.toArray(new Name[arrayUtil.size()]));
                    }
                }
            }
            logger.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            string4 = key;
            return string4;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Primary Key couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<ForeignKey> getFKs(String string, String string2, String string3) throws DataSourceException {
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        Statement statement2 = null;
        try {
            Object object;
            ArrayUtil<ForeignKey> arrayUtil = new ArrayUtil<ForeignKey>();
            long l = System.currentTimeMillis();
            String string4 = this.getConnection().getCatalog();
            statement = this.getPreparedStatement(sFKSelect, false);
            statement2 = this.getPreparedStatement(sConstraintColumnsSelect, false);
            statement.setString(1, string3);
            statement.setString(2, string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("FK_NAME");
                String string5 = resultSet.getString("PK_NAME");
                String string6 = resultSet.getString("PKTABLE_SCHEM");
                String string7 = null;
                ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
                statement2.setString(1, string2);
                statement2.setString(2, (String)object);
                resultSet2 = statement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil3.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                try {
                    resultSet2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                statement2.setString(1, string6);
                statement2.setString(2, string5);
                resultSet2 = statement2.executeQuery();
                while (resultSet2.next()) {
                    if (string7 == null) {
                        string7 = resultSet2.getString("TABLE_NAME");
                    }
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                try {
                    resultSet2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ForeignKey foreignKey = new ForeignKey(new Name(string7, this.quote(string7)), new Name(string4, this.quote(string4)), new Name(string6, this.quote(string6)));
                foreignKey.setFKName((String)object);
                foreignKey.setFKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                foreignKey.setPKColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add(foreignKey);
                arrayUtil2.clear();
                arrayUtil3.clear();
            }
            logger.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            object = arrayUtil;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (resultSet2 != null) {
                try {
                    resultSet2.close();
                }
                catch (Exception exception) {}
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String getTableForSynonym(String string) throws DataSourceException {
        String string2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect, false);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                String string3 = string;
                return string3;
            }
            String string4 = resultSet.getString("TABLE_OWNER");
            String string5 = resultSet.getString("TABLE_NAME");
            String string6 = resultSet.getString("DB_LINK");
            StringBuilder stringBuilder = new StringBuilder();
            if (string4 != null) {
                stringBuilder.append(string4);
                stringBuilder.append('.');
            }
            stringBuilder.append(string5);
            if (string6 != null) {
                stringBuilder.append('@');
                stringBuilder.append(string6);
            }
            logger.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            string2 = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    @Override
    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    public Hashtable<String, Object[]> getAllowedValues(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object[]> hashtable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            preparedStatement = this.getPreparedStatement(sCheckSelect, false);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(1), hashtable2, true);
            }
            hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashtable;
    }

    private Object[] insertOracle(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("BEGIN " + string2);
        stringBuffer.append(" RETURNING ");
        String[] stringArray = serverMetaData.getPrimaryKeyQuotedColumnNames();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n]);
        }
        stringBuffer.append(" INTO ");
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append("; END;");
        Statement statement = null;
        try {
            int n2;
            String string4 = this.translateQuotes(stringBuffer.toString());
            logger.debug("executeSQL->" + string4);
            statement = this.getConnection().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            int n3 = 0;
            if (string3 == null) {
                n3 = this.setColumnsToStore((PreparedStatement)statement, serverColumnMetaDataArray, nArray, objectArray, null);
            } else {
                for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                    if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                    statement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                    break;
                }
                n3 = 1;
            }
            int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
            for (n2 = 0; nArray2 != null && n2 < nArray2.length; ++n2) {
                IDataType iDataType = ColumnMetaData.createDataType(serverColumnMetaDataArray[nArray2[n2]].getColumnMetaData());
                int n4 = iDataType instanceof BigDecimalDataType ? 2 : (iDataType instanceof TimestampDataType ? 93 : 1);
                statement.registerOutParameter(n3 + n2 + 1, n4);
            }
            if (this.executeUpdate((PreparedStatement)statement) == 1) {
                for (n2 = 0; nArray2 != null && n2 < nArray2.length; ++n2) {
                    objectArray[nArray2[n2]] = statement.getObject(n3 + n2 + 1);
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            try {
                throw new DataSourceException("Insert failed ! - Result row count != 1 ! - " + stringBuffer);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + stringBuffer, this.formatSQLException(sQLException));
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2) throws DataSourceException {
        String string6;
        DBAccess.ColumnMetaDataInfo columnMetaDataInfo = super.getColumnMetaData(string, stringArray, string2, string3, string4, string5, stringArray2);
        if (columnMetaDataInfo.getSchema() == null) {
            columnMetaDataInfo.setSchema(this.getUsername().toUpperCase());
        }
        if ((string6 = columnMetaDataInfo.getTable()) != null && !string6.startsWith("`") && !string6.endsWith("`")) {
            columnMetaDataInfo.setTable(string6.toUpperCase());
        }
        return columnMetaDataInfo;
    }
}

