/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DB2DBAccess;
import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.persist.jdbc.DerbyDBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.HSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.MSSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.MySQLDBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.OracleDBAccess;
import com.sibvisions.rad.persist.jdbc.PostgreSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.param.AbstractParam;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.BeanUtil;
import com.sibvisions.util.type.DateUtil;
import com.sibvisions.util.type.StringUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.Filter;
import javax.rad.model.condition.Greater;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Less;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.condition.Not;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.condition.Or;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.DataSourceException;
import javax.rad.util.TranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAccess
implements IDBAccess {
    public static final int NCHAR = -15;
    public static final int NVARCHAR = -9;
    public static final int LONGNVARCHAR = -16;
    public static final int SQLXML = 2009;
    public static final int NCLOB = 2011;
    public static final String QUOTE = "`";
    private static TranslationMap tmpAutoLinkColumnNames = new TranslationMap();
    private static Hashtable<String, Class<? extends DBAccess>> dbAccessClasses = new Hashtable();
    protected static ILogger logger = LoggerFactory.getInstance(DBAccess.class);
    private int iMaxTime = 100;
    private Connection cConnection;
    private String sUrl;
    private String sDriver;
    private String sUsername;
    private String sPassword;
    private String sOpenQuote;
    private String sCloseQuote;
    private String sDefaultSchema;
    private Properties properties = new Properties();
    private int iQueryTimeOut = 0;
    private Hashtable<Select, ResultSet> htFetchResultSetCache = new Hashtable();
    private DateUtil dateUtil = new DateUtil(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private boolean bExternalConnection = false;
    private int iMaxColumnLength;

    public DBAccess() {
        this.setQuoteCharacters("\"", "\"");
    }

    public static DBAccess getDBAccess(String string) throws DataSourceException {
        Object object;
        Object object2;
        if (string == null) {
            return null;
        }
        if (!string.toLowerCase().startsWith("jdbc:")) {
            try {
                object2 = new InitialContext();
                if (object2 != null) {
                    object = ((InitialContext)object2).lookup(string);
                    if (object instanceof DBAccess) {
                        return (DBAccess)object;
                    }
                    if (object instanceof Connection) {
                        return DBAccess.getDBAccess((Connection)object);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.debug("Connection is not configured as JNDI resource", exception);
            }
        }
        object2 = DBAccess.getDBAccessClass(string);
        try {
            object = (DBAccess)((Class)object2).newInstance();
            ((DBAccess)object).setUrl(string);
            return object;
        }
        catch (Exception exception) {
            throw new DataSourceException("Instantion of '" + object2 + "' failed!", exception);
        }
    }

    public static DBAccess getDBAccess(DBCredentials dBCredentials) throws DataSourceException {
        if (dBCredentials == null) {
            return null;
        }
        Class<? extends DBAccess> clazz = DBAccess.getDBAccessClass(dBCredentials.getUrl());
        try {
            DBAccess dBAccess = clazz.newInstance();
            dBAccess.setUrl(dBCredentials.getUrl());
            dBAccess.setUsername(dBCredentials.getUserName());
            dBAccess.setPassword(dBCredentials.getPassword());
            return dBAccess;
        }
        catch (Exception exception) {
            throw new DataSourceException("Instantion of '" + clazz + "' failed!", exception);
        }
    }

    public static DBAccess getDBAccess(Connection connection) throws DataSourceException {
        if (connection == null) {
            throw new DataSourceException("Connection is null");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getURL();
            Class<? extends DBAccess> clazz = DBAccess.getDBAccessClass(string);
            DBAccess dBAccess = clazz.newInstance();
            dBAccess.setUrl(string);
            dBAccess.setUsername(databaseMetaData.getUserName());
            dBAccess.setConnection(connection);
            dBAccess.bExternalConnection = true;
            return dBAccess;
        }
        catch (Exception exception) {
            throw new DataSourceException("Database detection for '" + connection.getClass().getName() + "' failed!", exception);
        }
    }

    private static Class<? extends DBAccess> getDBAccessClass(String string) {
        for (String string2 : dbAccessClasses.keySet()) {
            if (!string.startsWith(string2)) continue;
            return dbAccessClasses.get(string2);
        }
        return DBAccess.class;
    }

    public static void registerDBAccessClass(String string, Class<? extends DBAccess> clazz) {
        dbAccessClasses.put(string, clazz);
    }

    public static void setAutomaticLinkColumnNameTranslation(TranslationMap translationMap) {
        tmpAutoLinkColumnNames = translationMap;
    }

    public static TranslationMap getAutomaticLinkColumnNameTranslation() {
        return tmpAutoLinkColumnNames;
    }

    protected String getFromClause(String string, List<ForeignKey> list) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" m ");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ForeignKey foreignKey = list.get(i);
                if (foreignKey.isNullable()) {
                    stringBuilder.append("LEFT OUTER JOIN ");
                } else {
                    stringBuilder.append("INNER JOIN ");
                }
                if (foreignKey.getPKSchema() != null && foreignKey.getPKSchema().getQuotedName().length() > 0) {
                    stringBuilder.append(foreignKey.getPKSchema().getQuotedName());
                    stringBuilder.append('.');
                }
                stringBuilder.append(foreignKey.getPKTable().getQuotedName());
                stringBuilder.append(" l");
                stringBuilder.append(i + 1);
                stringBuilder.append(" ON ");
                Name[] nameArray = foreignKey.getPKColumns();
                Name[] nameArray2 = foreignKey.getFKColumns();
                for (int j = 0; j < nameArray2.length; ++j) {
                    if (j > 0) {
                        stringBuilder.append(" AND ");
                    }
                    stringBuilder.append("m.");
                    stringBuilder.append(nameArray2[j].getQuotedName());
                    stringBuilder.append(" = ");
                    stringBuilder.append("l");
                    stringBuilder.append(i + 1);
                    stringBuilder.append('.');
                    stringBuilder.append(nameArray[j].getQuotedName());
                }
                stringBuilder.append("\n");
            }
        }
        logger.debug("FROM CLAUSE::", stringBuilder);
        return stringBuilder.toString();
    }

    protected String getAutomaticLinkColumnName(ForeignKey foreignKey) {
        Object object;
        String string = null;
        if (foreignKey.getFKColumns().length == 1) {
            string = foreignKey.getFKColumns()[0].getName();
        } else {
            Object object2;
            object = null;
            try {
                object2 = this.getPK(foreignKey.getPKCatalog().getRealName(), foreignKey.getPKSchema().getRealName(), foreignKey.getPKTable().getRealName());
                if (object2 != null) {
                    object = ((Key)object2).getColumns();
                }
            }
            catch (DataSourceException dataSourceException) {
                // empty catch block
            }
            if (object != null && (object).length == 1) {
                int n = ArrayUtil.indexOf(foreignKey.getPKColumns(), object[0]);
                if (n >= 0) {
                    string = foreignKey.getFKColumns()[n].getName();
                }
            } else {
                object2 = foreignKey.getFKColumns();
                if (object2 != null && ((Name[])object2).length > 0) {
                    StringBuilder stringBuilder = new StringBuilder(((Name)object2[0]).getName());
                    for (int i = 1; i < ((Object)object2).length; ++i) {
                        stringBuilder.append("_");
                        stringBuilder.append(((Name)object2[i]).getName());
                    }
                    string = stringBuilder.toString();
                }
            }
        }
        if (string == null) {
            object = foreignKey.getLinkReferenceColumn().getName();
            if (((String)object).length() > this.iMaxColumnLength) {
                object = ((String)object).substring(0, this.iMaxColumnLength);
            }
            return object;
        }
        if (tmpAutoLinkColumnNames != null) {
            string = tmpAutoLinkColumnNames.translate(string);
        }
        if (((String)(object = string + "_" + foreignKey.getLinkReferenceColumn().getName())).length() > this.iMaxColumnLength) {
            object = ((String)object).substring(0, this.iMaxColumnLength);
        }
        return object;
    }

    protected String[] getQueryColumns(String string, List<ForeignKey> list, String[] stringArray) throws DataSourceException {
        ForeignKey foreignKey;
        int n;
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
        String string2 = null;
        ArrayUtil<ForeignKey> arrayUtil3 = new ArrayUtil<ForeignKey>();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            arrayUtil3.add(list.get(n));
        }
        for (n = 0; n < stringArray.length; ++n) {
            arrayUtil.add("m." + stringArray[n]);
            if (arrayUtil3 == null) continue;
            for (n2 = arrayUtil3.size() - 1; n2 >= 0; --n2) {
                foreignKey = (ForeignKey)arrayUtil3.get(n2);
                if (ArrayUtil.indexOf(BeanUtil.toArray(foreignKey.getFKColumns(), new String[foreignKey.getFKColumns().length], "quotedName"), stringArray[n]) < 0) continue;
                string2 = this.getAutomaticLinkColumnName(foreignKey);
                if (arrayUtil2.indexOf(string2) < 0 && ArrayUtil.indexOf(stringArray, string2) < 0) {
                    arrayUtil2.add(string2);
                    arrayUtil.add("l" + (list.indexOf(foreignKey) + 1) + "." + foreignKey.getLinkReferenceColumn().getQuotedName() + " " + string2);
                }
                arrayUtil3.remove(n2);
            }
        }
        if (arrayUtil3 != null) {
            n2 = arrayUtil3.size();
            for (n = 0; n < n2; ++n) {
                foreignKey = (ForeignKey)arrayUtil3.get(n);
                arrayUtil.add("l" + (list.indexOf(foreignKey) + 1) + "." + foreignKey.getLinkReferenceColumn().getQuotedName() + " " + this.getAutomaticLinkColumnName(foreignKey));
            }
        }
        logger.debug("sQueryColumns::", arrayUtil);
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Key> getUKs(String string, String string2, String string3) throws DataSourceException {
        ArrayUtil<Key> arrayUtil;
        ResultSet resultSet = null;
        try {
            Object object;
            ArrayUtil<Key> arrayUtil2 = new ArrayUtil<Key>();
            arrayUtil = new ArrayUtil<Key>();
            long l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.cConnection.getMetaData();
            resultSet = databaseMetaData.getIndexInfo(string, string2, string3, true, false);
            if (!resultSet.next()) {
                resultSet.close();
                ArrayUtil<Key> arrayUtil3 = arrayUtil2;
                return arrayUtil3;
            }
            String string4 = null;
            do {
                if (resultSet.getString("COLUMN_NAME") == null) continue;
                if (string4 != null && !resultSet.getString("INDEX_NAME").equals(string4)) {
                    object = new Key(string4);
                    ((Key)object).setColumns(arrayUtil.toArray(new Name[arrayUtil.size()]));
                    arrayUtil2.add((Key)object);
                    arrayUtil.clear();
                }
                string4 = resultSet.getString("INDEX_NAME");
                arrayUtil.add((Key)((Object)new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME")))));
            } while (resultSet.next());
            if (arrayUtil.size() > 0) {
                object = new Key(string4);
                ((Key)object).setColumns(arrayUtil.toArray(new Name[arrayUtil.size()]));
                arrayUtil2.add((Key)object);
            }
            if (arrayUtil2.size() > 0 && (object = this.getPK(string, string2, string3)) != null) {
                for (int i = arrayUtil2.size() - 1; i >= 0; --i) {
                    Name[] nameArray = arrayUtil2.get(i).getColumns();
                    if (!ArrayUtil.containsAll(nameArray, ((Key)object).getColumns()) || nameArray.length != ((Key)object).getColumns().length) continue;
                    arrayUtil2.remove(i);
                }
            }
            logger.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            object = arrayUtil2;
            return object;
        }
        catch (SQLException sQLException) {
            logger.error("Unique Keys couldn't determined from database! - ", string3, sQLException);
            arrayUtil = null;
            return arrayUtil;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getPK(String string, String string2, String string3) throws DataSourceException {
        ResultSet resultSet = null;
        try {
            long l = System.currentTimeMillis();
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            String string4 = null;
            DatabaseMetaData databaseMetaData = this.cConnection.getMetaData();
            resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
            if (!resultSet.next()) {
                resultSet.close();
                Key key = null;
                return key;
            }
            do {
                if (string4 == null) {
                    string4 = resultSet.getString("PK_NAME");
                }
                arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
            } while (resultSet.next());
            logger.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            Key key = new Key(string4);
            key.setColumns(arrayUtil.toArray(new Name[arrayUtil.size()]));
            Key key2 = key;
            return key2;
        }
        catch (SQLException sQLException) {
            logger.error("PrimaryKey couldn't determined from database! - ", string3, sQLException);
            Key key = null;
            return key;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
        }
    }

    public List<ForeignKey> getFKs(String string, String string2, String string3) throws DataSourceException {
        ResultSet resultSet = null;
        try {
            ArrayUtil<ForeignKey> arrayUtil = new ArrayUtil<ForeignKey>();
            long l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.cConnection.getMetaData();
            resultSet = databaseMetaData.getImportedKeys(string, string2, string3);
            if (!resultSet.next()) {
                resultSet.close();
                ArrayUtil<ForeignKey> arrayUtil2 = arrayUtil;
                return arrayUtil2;
            }
            String string4 = null;
            String string5 = null;
            ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil4 = new ArrayUtil<Name>();
            ForeignKey foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(resultSet.getString("PKTABLE_CAT"), this.quote(resultSet.getString("PKTABLE_CAT"))), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
            do {
                if (!((string4 = resultSet.getString("FK_NAME")) != null && string4.length() != 0 || (string4 = resultSet.getString("PK_NAME")) != null && string4.length() != 0)) {
                    throw new DataSourceException("Database/jdbc driver didn't support FK, PK names!");
                }
                if (string5 != null && !string5.equals(string4)) {
                    foreignKey.setFKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
                    foreignKey.setPKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                    arrayUtil.add(foreignKey);
                    arrayUtil3.clear();
                    arrayUtil4.clear();
                    foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(resultSet.getString("PKTABLE_CAT"), this.quote(resultSet.getString("PKTABLE_CAT"))), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
                }
                string5 = string4;
                arrayUtil3.add(new Name(resultSet.getString("PKCOLUMN_NAME"), this.quote(resultSet.getString("PKCOLUMN_NAME"))));
                arrayUtil4.add(new Name(resultSet.getString("FKCOLUMN_NAME"), this.quote(resultSet.getString("FKCOLUMN_NAME"))));
                foreignKey.setFKName(resultSet.getString("FK_NAME"));
            } while (resultSet.next());
            foreignKey.setFKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
            foreignKey.setPKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
            arrayUtil.add(foreignKey);
            logger.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            ArrayUtil<ForeignKey> arrayUtil5 = arrayUtil;
            return arrayUtil5;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
        }
    }

    public String getTableForSynonym(String string) throws DataSourceException {
        return string;
    }

    @Override
    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        Object object;
        Object object2;
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        StringBuilder stringBuilder = new StringBuilder(this.getSelectStatement(iCondition, string2, stringArray, string, string3, string4, serverMetaData));
        Object[] objectArray = serverMetaData.getServerColumnMetaData();
        if (sortDefinition != null) {
            stringBuilder.append(" ORDER BY ");
            object2 = sortDefinition.getColumns();
            object = sortDefinition.isAscending();
            String[] stringArray2 = BeanUtil.toArray(objectArray, new String[objectArray.length], "name");
            for (int i = 0; i < ((String[])object2).length; ++i) {
                int n3 = ArrayUtil.indexOf(stringArray2, object2[i]);
                if (n3 < 0) {
                    stringBuilder.append(object2[i]);
                } else {
                    stringBuilder.append(((ServerColumnMetaData)objectArray[n3]).getColumnName().getQuotedName());
                }
                if (object[i] != false) {
                    stringBuilder.append(" ASC ");
                } else {
                    stringBuilder.append(" DESC ");
                }
                if (i + 1 >= ((Object)object2).length) continue;
                stringBuilder.append(", ");
            }
        }
        object2 = null;
        object = null;
        try {
            int n4;
            long l = System.currentTimeMillis();
            String string5 = stringBuilder.toString();
            Select select = new Select(string5, iCondition, n);
            object = this.htFetchResultSetCache.remove(select);
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            if (object == null) {
                object2 = this.getPreparedStatement(string5, false);
                if (this.iQueryTimeOut > 0) {
                    object2.setQueryTimeout(this.iQueryTimeOut);
                }
                if (iCondition != null) {
                    this.setFilterParameter(1, (PreparedStatement)object2, iCondition);
                }
                object = object2.executeQuery();
                for (int i = 0; i < n; ++i) {
                    if (object.next()) continue;
                    arrayUtil.add(null);
                    try {
                        object.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        object2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return arrayUtil;
                }
                if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
                    logger.debug("select(", string5, ", ", DBAccess.getParameter(iCondition), ", from Row ", n, ", MinimumCount ", n2, ") in ", System.currentTimeMillis() - l, "ms");
                }
            } else {
                object2 = (PreparedStatement)object.getStatement();
            }
            ResultSetMetaData resultSetMetaData = object.getMetaData();
            l = System.currentTimeMillis();
            int n5 = this.iMaxTime;
            int n6 = resultSetMetaData.getColumnCount();
            for (n4 = 0; n2 < 0 || n4 < n2 || n5 >= 0; ++n4) {
                Object[] objectArray2 = null;
                if (object.next()) {
                    objectArray2 = new Object[n6];
                    for (int i = 0; i < n6; ++i) {
                        Object object3;
                        Object object4 = object.getObject(i + 1);
                        if (object4 instanceof Number && !(object4 instanceof BigDecimal)) {
                            object4 = object.getBigDecimal(i + 1);
                        } else if (object4 instanceof Date && !(object4 instanceof Timestamp)) {
                            object4 = object.getTimestamp(i + 1);
                        } else if (object4 instanceof Clob) {
                            object3 = (Clob)object4;
                            object4 = object3.getSubString(1L, (int)object3.length());
                        } else if (object4 instanceof Blob) {
                            object3 = (Blob)object4;
                            object4 = object3.getBytes(1L, (int)object3.length());
                        }
                        objectArray2[i] = this.convertDatabaseSpecificObjectToValue((ServerColumnMetaData)objectArray[i], object4);
                    }
                } else {
                    arrayUtil.add(null);
                    try {
                        object.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        object2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return arrayUtil;
                }
                arrayUtil.add(objectArray2);
                n5 = this.iMaxTime - (int)(System.currentTimeMillis() - l);
            }
            if (arrayUtil.size() == 0) {
                arrayUtil.add(null);
                try {
                    object.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            } else {
                this.htFetchResultSetCache.put(new Select(string5, iCondition, n + n4), (ResultSet)object);
            }
            return arrayUtil;
        }
        catch (Exception exception) {
            try {
                object.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                object2.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw new DataSourceException("fetch statement failed! - " + stringBuilder, exception instanceof SQLException ? this.formatSQLException((SQLException)exception) : exception);
        }
    }

    @Override
    public void lockRow(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        try {
            if (!this.cConnection.getAutoCommit() && this.cConnection.getMetaData().supportsSelectForUpdate()) {
                this.lockRowInternal(string, serverMetaData, iCondition);
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Execute locking failed!", this.formatSQLException(sQLException));
        }
    }

    protected int lockRowInternal(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return this.getRowCount(this.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition), iCondition, 1);
    }

    @Override
    public Object[] insert(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        int n;
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        stringBuilder.append(string);
        stringBuilder.append(" (");
        int n2 = 0;
        String string2 = null;
        ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        int[] nArray = serverMetaData.getWritableColumnIndices();
        for (n = 0; n < nArray.length; ++n) {
            if (objectArray[nArray[n]] == null) continue;
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName());
            ++n2;
        }
        if (n2 == 0) {
            for (n = 0; n2 == 0 && n < nArray.length; ++n) {
                if (serverColumnMetaDataArray[nArray[n]].isAutoIncrement()) continue;
                string2 = serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName();
                stringBuilder.append(string2);
                ++n2;
            }
        }
        stringBuilder.append(") VALUES (");
        if (n2 > 0) {
            stringBuilder.append("?");
            for (n = 1; n < n2; ++n) {
                stringBuilder.append(",?");
            }
        }
        stringBuilder.append(")");
        objectArray = this.insertDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, string2);
        if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
            logger.debug(stringBuilder.toString(), "[", objectArray, "]");
        }
        if (serverMetaData.getPrimaryKeyType() != ServerMetaData.PrimaryKeyType.AllColumns) {
            n = 1;
            int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
            if (nArray2 != null) {
                for (int i = 0; i < nArray2.length && n != 0; ++i) {
                    if (objectArray[nArray2[i]] == null) continue;
                    n = 0;
                }
            }
            if (n != 0) {
                throw new DataSourceException("Primary key column empty after insert!" + string);
            }
        }
        return objectArray;
    }

    @Override
    public Object[] update(String string, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        if (serverMetaData.getPrimaryKeyColumnNames() == null || serverMetaData.getPrimaryKeyColumnNames().length == 0) {
            throw new DataSourceException("PK Columns empty! - update not possible!");
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        stringBuilder.append(string);
        stringBuilder.append(" SET ");
        int n = 0;
        ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        int[] nArray = serverMetaData.getWritableColumnIndices();
        for (int i = 0; i < nArray.length; ++i) {
            IDataType iDataType = serverColumnMetaDataArray[nArray[i]].getDataType();
            if (iDataType.compareTo(objectArray2[nArray[i]], objectArray[nArray[i]]) == 0) continue;
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(serverColumnMetaDataArray[nArray[i]].getColumnName().getQuotedName());
            stringBuilder.append(" = ? ");
            ++n;
        }
        ICondition iCondition = Filter.createEqualsFilter(serverMetaData.getPrimaryKeyColumnNames(), objectArray, serverMetaData.getMetaData().getColumnMetaData());
        int n2 = 0;
        if (n == 0) {
            try {
                if (!this.cConnection.getAutoCommit() && this.cConnection.getMetaData().supportsSelectForUpdate()) {
                    n2 = this.lockRowInternal(string, serverMetaData, iCondition);
                }
                StringBuilder stringBuilder2 = new StringBuilder("SELECT * FROM ");
                stringBuilder2.append(string);
                stringBuilder2.append(this.getWHEREClause(iCondition, serverMetaData, false));
                n2 = this.getRowCount(stringBuilder2.toString(), iCondition, 1);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Connection access failed!", this.formatSQLException(sQLException));
            }
        } else {
            stringBuilder.append(this.getWHEREClause(iCondition, serverMetaData, false));
            n2 = this.updateDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, objectArray2, iCondition);
            if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
                logger.debug(stringBuilder.toString(), "[", objectArray2, "]");
            }
        }
        if (n2 == 0) {
            return this.insert(string, serverMetaData, objectArray2);
        }
        if (n2 != 1) {
            throw new DataSourceException("Update failed ! - Result row count != 1 ! - " + stringBuilder.toString());
        }
        if (n == 0) {
            return objectArray;
        }
        return objectArray2;
    }

    public int updateDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2, ICondition iCondition) throws DataSourceException {
        return this.updateAnsiSQL(string, string2, serverMetaData, objectArray, objectArray2, iCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateAnsiSQL(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2, ICondition iCondition) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        int[] nArray = serverMetaData.getWritableColumnIndices();
        PreparedStatement preparedStatement = this.getPreparedStatement(string2, false);
        try {
            int n = this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray2, objectArray);
            this.setFilterParameter(++n, preparedStatement, iCondition);
            int n2 = this.executeUpdate(preparedStatement);
            return n2;
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        if (serverMetaData.getPrimaryKeyColumnNames() == null || serverMetaData.getPrimaryKeyColumnNames().length == 0) {
            throw new DataSourceException("PK Columns empty! - delete not possible!");
        }
        ICondition iCondition = null;
        ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        String[] stringArray = serverMetaData.getPrimaryKeyColumnNames();
        if (serverColumnMetaDataArray != null) {
            iCondition = Filter.createEqualsFilter(stringArray, objectArray, serverMetaData.getMetaData().getColumnMetaData());
        } else {
            iCondition = new Equals(stringArray[0], objectArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                iCondition = iCondition.and(new Equals(stringArray[i], objectArray[i]));
            }
        }
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
        stringBuilder.append(string);
        String string2 = this.getWHEREClause(iCondition, serverMetaData, false);
        stringBuilder.append(string2);
        logger.debug("delete(", stringBuilder, ")", stringArray, objectArray);
        PreparedStatement preparedStatement = this.getPreparedStatement(stringBuilder.toString(), false);
        try {
            this.setFilterParameter(1, preparedStatement, iCondition);
            int n = this.executeUpdate(preparedStatement);
            if (n > 1) {
                throw new DataSourceException("Delete failed ! - Result row count > 1 ! - " + n + "," + stringBuilder.toString());
            }
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.sPassword != null ? ",Password set" : ",Password not set";
        boolean bl = false;
        try {
            bl = this.isOpen();
        }
        catch (DataSourceException dataSourceException) {
            return stringBuilder.toString() + " :: " + dataSourceException.getMessage();
        }
        Properties properties = new Properties(this.properties);
        properties.remove("user");
        properties.remove("password");
        stringBuilder.append("DBAccess :: Connected=");
        stringBuilder.append(bl);
        stringBuilder.append(", ConnectionString=");
        stringBuilder.append(this.sUrl);
        stringBuilder.append(", DriverName=");
        stringBuilder.append(this.sDriver);
        stringBuilder.append(", UserName=");
        stringBuilder.append(this.sUsername);
        stringBuilder.append(string);
        stringBuilder.append(",Properties=");
        stringBuilder.append(properties);
        stringBuilder.append("\n");
        stringBuilder.append("ResultSet Cache:\n");
        for (Map.Entry<Select, ResultSet> entry : this.htFetchResultSetCache.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("\n");
        }
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    public String getOpenQuoteCharacter() {
        return this.sOpenQuote;
    }

    public String getCloseQuoteCharacter() {
        return this.sCloseQuote;
    }

    protected void setQuoteCharacters(String string, String string2) {
        this.sOpenQuote = string;
        this.sCloseQuote = string2;
    }

    public boolean isAutoQuote(String string) {
        StringUtil.CaseSensitiveType caseSensitiveType = StringUtil.getCaseSensitiveType(string);
        return caseSensitiveType != StringUtil.CaseSensitiveType.UpperCase;
    }

    public String quote(String string) {
        if (string == null) {
            return null;
        }
        if (this.isAutoQuote(string)) {
            return this.quoteAllways(string);
        }
        return string;
    }

    public String quoteAllways(String string) {
        StringBuilder stringBuilder = new StringBuilder(QUOTE);
        stringBuilder.append(StringUtil.replace(string, QUOTE, "\\`"));
        stringBuilder.append(QUOTE);
        return stringBuilder.toString();
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = QUOTE.charAt(0);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                if (i == 0 || string.charAt(i - 1) != '\\') continue;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public String removeDBSpecificQuotes(String string) {
        return StringUtil.removeQuotes(string, this.sOpenQuote, this.sCloseQuote);
    }

    public String translateQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = QUOTE.charAt(0);
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                if (i != 0 && string.charAt(i - 1) == '\\') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder.append(c2);
                    continue;
                }
                if (bl) {
                    stringBuilder.append(this.sOpenQuote);
                    bl = false;
                    continue;
                }
                stringBuilder.append(this.sCloseQuote);
                bl = true;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public void open() throws DataSourceException {
        if (!this.isOpen()) {
            long l = System.currentTimeMillis();
            if (!this.bExternalConnection) {
                if (this.sDriver == null) {
                    throw new DataSourceException("Jdbc Driver is null!");
                }
                if (this.sUrl == null) {
                    throw new DataSourceException("Connection String is null!");
                }
                try {
                    Class.forName(this.sDriver);
                }
                catch (Exception exception) {
                    throw new DataSourceException("Jdbc driver not found!", exception);
                }
                try {
                    Connection connection;
                    Properties properties = new Properties(this.properties);
                    properties.setProperty("user", this.translateQuotes(this.sUsername));
                    if (this.sPassword != null) {
                        properties.setProperty("password", this.sPassword);
                    }
                    if ((connection = DriverManager.getConnection(this.sUrl, properties)).getTransactionIsolation() != 2) {
                        connection.setTransactionIsolation(2);
                    }
                    this.setConnection(connection);
                }
                catch (SQLException sQLException) {
                    String string = this.sPassword != null ? "Password set" : "Password not set";
                    throw new DataSourceException("Connection failed! - " + this.sUrl + "; Username=" + this.sUsername + "; " + string, this.formatSQLException(sQLException));
                }
            }
            try {
                this.iMaxColumnLength = this.cConnection.getMetaData().getMaxColumnNameLength();
                if (this.iMaxColumnLength == 0) {
                    this.iMaxColumnLength = Integer.MAX_VALUE;
                }
            }
            catch (SQLException sQLException) {
                this.iMaxColumnLength = 30;
                logger.debug(sQLException);
            }
            logger.debug("open(", this.sUrl, ",", this.translateQuotes(this.sUsername), ") in ", System.currentTimeMillis() - l, "ms");
        } else {
            logger.debug("connection is already open!");
        }
    }

    public boolean isOpen() throws DataSourceException {
        try {
            return this.cConnection != null && !this.cConnection.isClosed();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Open failed!", this.formatSQLException(sQLException));
        }
    }

    public void close() throws DataSourceException {
        if (!this.bExternalConnection) {
            try {
                if (this.isOpen()) {
                    this.cConnection.close();
                    this.setConnection(null);
                }
            }
            catch (SQLException sQLException) {
                this.setConnection(null);
                throw new DataSourceException("Close failed!", this.formatSQLException(sQLException));
            }
        }
    }

    public void rollback() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        try {
            this.cConnection.rollback();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Rollback failed!", this.formatSQLException(sQLException));
        }
    }

    public void commit() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        try {
            this.cConnection.commit();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Commit failed!", this.formatSQLException(sQLException));
        }
    }

    public int getQueryTimeOut() {
        return this.iQueryTimeOut;
    }

    public void setQueryTimeOut(int n) {
        this.iQueryTimeOut = n;
    }

    public Connection getConnection() {
        return this.cConnection;
    }

    protected void setConnection(Connection connection) {
        this.cConnection = connection;
    }

    public String getDriver() {
        return this.sDriver;
    }

    public void setDriver(String string) {
        this.sDriver = string;
    }

    public String getUrl() {
        return this.sUrl;
    }

    public void setUrl(String string) {
        this.sUrl = string;
    }

    public String getUsername() {
        return this.sUsername;
    }

    public void setUsername(String string) {
        this.sUsername = string;
    }

    public String getPassword() {
        return this.sPassword;
    }

    public void setPassword(String string) {
        this.sPassword = string;
    }

    public void setDBProperty(String string, String string2) {
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.setProperty(string, string2);
        }
    }

    public String getDBProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setDBProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getDBProperties() {
        return this.properties;
    }

    public int getMaxTime() {
        return this.iMaxTime;
    }

    public void setMaxTime(int n) {
        this.iMaxTime = n;
    }

    public void executeProcedure(String string, Object ... objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        StringBuilder stringBuilder = new StringBuilder("{ call ");
        stringBuilder.append(string);
        if (objectArray.length > 0) {
            stringBuilder.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" }");
        Statement statement = null;
        try {
            AbstractParam.ParameterType parameterType;
            AbstractParam abstractParam;
            int n;
            logger.debug("executeProcedure -> ", stringBuilder);
            statement = this.cConnection.prepareCall(this.translateQuotes(stringBuilder.toString()));
            for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                if (objectArray[n] == null) {
                    statement.setNull(n + 1, 12);
                    continue;
                }
                if (objectArray[n] instanceof AbstractParam) {
                    abstractParam = (AbstractParam)objectArray[n];
                    parameterType = abstractParam.getType();
                    if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                        statement.registerOutParameter(n + 1, abstractParam.getSqlType());
                    }
                    if (abstractParam.getValue() == null) {
                        statement.setNull(n + 1, abstractParam.getSqlType());
                        continue;
                    }
                    statement.setObject(n + 1, this.convertValueToDatabaseSpecificObject(abstractParam.getValue()), abstractParam.getSqlType());
                    continue;
                }
                statement.setObject(n + 1, this.convertValueToDatabaseSpecificObject(objectArray[n]));
            }
            statement.execute();
            for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                abstractParam.setValue(statement.getObject(n + 1));
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("executeProcedure failed! - " + stringBuilder, this.formatSQLException(sQLException));
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public Object executeFunction(String string, int n, Object ... objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        StringBuilder stringBuilder = new StringBuilder("{ ? = call ");
        stringBuilder.append(string);
        if (objectArray.length > 0) {
            stringBuilder.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" }");
        Statement statement = null;
        try {
            AbstractParam.ParameterType parameterType;
            AbstractParam abstractParam;
            logger.debug("executeFunction -> ", stringBuilder);
            statement = this.cConnection.prepareCall(this.translateQuotes(stringBuilder.toString()));
            statement.registerOutParameter(1, n);
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    statement.setNull(i + 2, 12);
                    continue;
                }
                if (objectArray[i] instanceof AbstractParam) {
                    abstractParam = (AbstractParam)objectArray[i];
                    parameterType = abstractParam.getType();
                    if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                        statement.registerOutParameter(i + 2, abstractParam.getSqlType());
                    }
                    if (abstractParam.getValue() == null) {
                        statement.setNull(i + 2, abstractParam.getSqlType());
                        continue;
                    }
                    statement.setObject(i + 2, this.convertValueToDatabaseSpecificObject(abstractParam.getValue()), abstractParam.getSqlType());
                    continue;
                }
                statement.setObject(i + 2, this.convertValueToDatabaseSpecificObject(objectArray[i]));
            }
            if (statement.execute()) {
                statement.getResultSet().close();
            }
            Object object = statement.getObject(1);
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[i]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                abstractParam.setValue(statement.getObject(i + 2));
            }
            Object object2 = object;
            return object2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("executeFunction failed! - " + stringBuilder, this.formatSQLException(sQLException));
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(String string) throws SQLException {
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            String string2 = this.translateQuotes(string);
            logger.debug("executeStatement -> ", string2);
            if (statement.execute(string2)) {
                statement.getResultSet().close();
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> executeSql(String string, Object ... objectArray) throws SQLException {
        Statement statement = null;
        String string2 = this.translateQuotes(string);
        statement = this.getConnection().prepareStatement(string2);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    statement.setNull(i + 1, 12);
                    continue;
                }
                statement.setObject(i + 1, this.convertValueToDatabaseSpecificObject(objectArray[i]));
            }
        }
        logger.debug("executeSql -> ", string);
        if (statement.execute()) {
            ResultSet resultSet = statement.getResultSet();
            if (resultSet.next()) {
                ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
                do {
                    arrayUtil.add(resultSet.getObject(1));
                } while (resultSet.next());
                ArrayUtil<Object> arrayUtil2 = arrayUtil;
                return arrayUtil2;
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        List<Object> list = null;
        return list;
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public PreparedStatement getPreparedStatement(String string, boolean bl) throws DataSourceException {
        PreparedStatement preparedStatement;
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        string = this.translateQuotes(string.toString());
        try {
            if (bl) {
                try {
                    preparedStatement = this.cConnection.prepareStatement(string, 1);
                }
                catch (SQLException sQLException) {
                    preparedStatement = this.cConnection.prepareStatement(string);
                }
            } else {
                preparedStatement = this.cConnection.prepareStatement(string);
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("PrepareStatement failed! - " + string, this.formatSQLException(sQLException));
        }
        return preparedStatement;
    }

    public int executeUpdate(PreparedStatement preparedStatement) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAcces is not open!");
        }
        try {
            return preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Execute update failed!", this.formatSQLException(sQLException));
        }
    }

    protected SQLException formatSQLException(SQLException sQLException) {
        return this.formatSQLException(sQLException, sQLException.getMessage(), "" + sQLException.getErrorCode());
    }

    protected SQLException formatSQLException(SQLException sQLException, String string, String string2) {
        if (string.indexOf(string2) < 0) {
            String string3 = this.getClass().getSimpleName();
            int n = string3.indexOf("DBAccess");
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
            SQLException sQLException2 = new SQLException(string3 + "-" + string2 + ": " + string);
            sQLException2.setStackTrace(sQLException.getStackTrace());
            sQLException2.initCause(sQLException.getCause());
            return sQLException2;
        }
        return sQLException;
    }

    public String getSelectStatement(ICondition iCondition, String string, String[] stringArray, String string2, String string3, String string4, ServerMetaData serverMetaData) throws DataSourceException {
        if (string == null) {
            throw new DataSourceException("Missing FROM clause!");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(" ");
        }
        if (stringArray != null && stringArray.length > 0 && stringArray[0].length() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
        } else {
            stringBuilder.append("*");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(string);
        if (iCondition != null) {
            stringBuilder.append(this.getWHEREClause(iCondition, serverMetaData, true));
        }
        if (string3 != null) {
            if (iCondition == null) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(" ");
            stringBuilder.append(string3);
            stringBuilder.append(" ");
        }
        if (string4 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string4);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ");
        stringBuilder.append(string);
        stringBuilder.append(this.getWHEREClause(iCondition, serverMetaData, false));
        stringBuilder.append(" FOR UPDATE");
        return stringBuilder.toString();
    }

    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    public boolean supportsGetGeneratedKeys() {
        try {
            return this.cConnection.getMetaData().supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public Object[] insertAnsiSQL(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        boolean bl = this.supportsGetGeneratedKeys();
        PreparedStatement preparedStatement = this.getPreparedStatement(string2, bl);
        ResultSet resultSet = null;
        try {
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            if (string3 == null) {
                this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray, null);
            } else {
                try {
                    for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                        if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                        preparedStatement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
                }
            }
            if (this.executeUpdate(preparedStatement) == 1) {
                if (bl) {
                    try {
                        resultSet = preparedStatement.getGeneratedKeys();
                        if (resultSet.next()) {
                            String[] stringArray = serverMetaData.getPrimaryKeyColumnNames();
                            int n = resultSet.getMetaData().getColumnCount();
                            block17: for (int i = 0; i < n && stringArray != null && i < stringArray.length; ++i) {
                                for (int j = 0; j < serverColumnMetaDataArray.length; ++j) {
                                    if (!serverColumnMetaDataArray[j].getName().equals(stringArray[i])) continue;
                                    Object object = resultSet.getObject(i + 1);
                                    if (object == null) continue block17;
                                    objectArray[j] = object;
                                    continue block17;
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DataSourceException("The generated keys couldn't read! - " + string2, this.formatSQLException(sQLException));
                    }
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            throw new DataSourceException("Insert failed! - Result row count != 1" + string2);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    public ColumnMetaDataInfo getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2) throws DataSourceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string6 = this.getSelectStatement(null, string, stringArray, string2, string3, string4, null);
        try {
            String string7;
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(string6, false);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            ColumnMetaDataInfo columnMetaDataInfo = new ColumnMetaDataInfo();
            String string8 = resultSetMetaData.getCatalogName(1);
            String string9 = resultSetMetaData.getSchemaName(1);
            if (string8 != null && string8.trim().length() == 0) {
                string8 = null;
            }
            if (string9 != null && string9.trim().length() == 0) {
                string9 = null;
            }
            String[] stringArray3 = this.splitSchemaTable(string);
            if (string9 == null) {
                string9 = stringArray3[0];
            }
            if ((string7 = stringArray3[1]) != null && string7.endsWith(" m ")) {
                string7 = string7.substring(0, string7.length() - 3);
            }
            columnMetaDataInfo.setCatalog(string8 != null ? string8.trim() : null);
            columnMetaDataInfo.setSchema(string9 != null ? string9.trim() : this.sDefaultSchema);
            columnMetaDataInfo.setTable(string7 != null ? string7.trim() : null);
            ArrayUtil<ServerColumnMetaData> arrayUtil = new ArrayUtil<ServerColumnMetaData>();
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                int n;
                String string10;
                Name name = new Name(resultSetMetaData.getColumnName(i), this.quote(resultSetMetaData.getColumnName(i)));
                if (arrayUtil2.indexOf(name.getName()) >= 0) {
                    throw new DataSourceException("Duplicate definition of '" + name.getName() + "' in DBStorage " + string6 + "!");
                }
                ServerColumnMetaData serverColumnMetaData = new ServerColumnMetaData(name);
                if (stringArray != null) {
                    String string11 = stringArray[i - 1].toLowerCase();
                    string10 = serverColumnMetaData.getName().toLowerCase();
                    n = string11.length() - string10.length() - 1;
                    if (string11.endsWith(string10) && n > 0 && Character.isWhitespace(string11.charAt(n))) {
                        string11 = stringArray[i - 1].substring(0, n).trim();
                        n = string11.length() - 3;
                        if (string11.endsWith("as") && n > 0 && Character.isWhitespace(string11.charAt(n))) {
                            string11 = stringArray[i - 1].substring(0, n).trim();
                        }
                    } else {
                        string11 = stringArray[i - 1];
                    }
                    serverColumnMetaData.setRealQueryColumnName(string11);
                    logger.debug("Name=", serverColumnMetaData.getName(), "==", string11);
                } else {
                    serverColumnMetaData.setRealQueryColumnName(serverColumnMetaData.getColumnName().getRealName());
                }
                if (resultSetMetaData.isNullable(i) == 0) {
                    serverColumnMetaData.setNullable(false);
                } else {
                    serverColumnMetaData.setNullable(true);
                }
                serverColumnMetaData.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                int n2 = resultSetMetaData.getColumnType(i);
                serverColumnMetaData.setSQLType(n2);
                serverColumnMetaData.setSQLTypeName(resultSetMetaData.getColumnTypeName(i));
                if (!this.setDatabaseSpecificType(resultSetMetaData, i, serverColumnMetaData)) {
                    switch (n2) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            serverColumnMetaData.setDataType(12);
                            if (resultSetMetaData.getPrecision(i) > 0) {
                                serverColumnMetaData.setPrecision(resultSetMetaData.getPrecision(i));
                                break;
                            }
                            serverColumnMetaData.setPrecision(Integer.MAX_VALUE);
                            break;
                        }
                        case -7: 
                        case 16: {
                            serverColumnMetaData.setDataType(16);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            serverColumnMetaData.setDataType(3);
                            serverColumnMetaData.setPrecision(0);
                            serverColumnMetaData.setScale(-1);
                            serverColumnMetaData.setSigned(resultSetMetaData.isSigned(i));
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            serverColumnMetaData.setDataType(3);
                            if (resultSetMetaData.getPrecision(i) <= 0 || resultSetMetaData.getPrecision(i) > 30) {
                                serverColumnMetaData.setPrecision(0);
                                serverColumnMetaData.setScale(-1);
                            } else {
                                serverColumnMetaData.setPrecision(resultSetMetaData.getPrecision(i));
                                serverColumnMetaData.setScale(resultSetMetaData.getScale(i));
                            }
                            serverColumnMetaData.setSigned(resultSetMetaData.isSigned(i));
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            serverColumnMetaData.setDataType(93);
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            serverColumnMetaData.setDataType(-2);
                            if (resultSetMetaData.getPrecision(i) > 0) {
                                serverColumnMetaData.setPrecision(resultSetMetaData.getPrecision(i));
                                break;
                            }
                            serverColumnMetaData.setPrecision(Integer.MAX_VALUE);
                            break;
                        }
                        default: {
                            throw new DataSourceException(serverColumnMetaData.getName() + " :: SQL Type '" + n2 + "' is not support!");
                        }
                    }
                }
                serverColumnMetaData.setWritable(false);
                if (string5 != null && stringArray2 != null) {
                    string10 = serverColumnMetaData.getColumnName().getRealName();
                    for (n = 0; n < stringArray2.length; ++n) {
                        if (!stringArray2[n].toLowerCase().equals(string10.toLowerCase())) continue;
                        serverColumnMetaData.setWritable(true);
                        break;
                    }
                }
                arrayUtil.add(serverColumnMetaData);
                arrayUtil2.add(serverColumnMetaData.getName());
            }
            logger.debug("getMetaData(", string6, ") in ", System.currentTimeMillis() - l, "ms");
            columnMetaDataInfo.setColumnMetaData(arrayUtil.toArray(new ServerColumnMetaData[arrayUtil.size()]));
            ColumnMetaDataInfo columnMetaDataInfo2 = columnMetaDataInfo;
            return columnMetaDataInfo2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Meta data couldn't load from database! - " + string6, this.formatSQLException(sQLException));
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getWHEREClause(ICondition iCondition, ServerMetaData serverMetaData, boolean bl) throws DataSourceException {
        String string = this.getSQL(iCondition, serverMetaData, bl);
        if (string != null && string.length() > 0) {
            return " WHERE " + string;
        }
        return "";
    }

    protected void setFilterParameter(int n, PreparedStatement preparedStatement, ICondition iCondition) throws DataSourceException {
        Object[] objectArray = DBAccess.getParameter(iCondition);
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i] == null) continue;
                preparedStatement.setObject(n + n2, this.convertValueToDatabaseSpecificObject(objectArray[i]));
                ++n2;
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
    }

    protected int setColumnsToStore(PreparedStatement preparedStatement, ServerColumnMetaData[] serverColumnMetaDataArray, int[] nArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if ((objectArray2 != null || objectArray[n2] == null) && (objectArray2 == null || serverColumnMetaDataArray[n2].getDataType().compareTo(objectArray[n2], objectArray2[n2]) == 0)) continue;
            try {
                if (objectArray[n2] == null) {
                    preparedStatement.setNull(n, serverColumnMetaDataArray[n2].getSQLType());
                } else {
                    preparedStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]));
                }
                ++n;
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
        return --n;
    }

    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ResultSet resultSet = null;
        try {
            resultSet = this.cConnection.getMetaData().getColumns(string, string2, string3, null);
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_DEF");
                if (string4 == null) continue;
                String string5 = resultSet.getString("COLUMN_NAME");
                try {
                    Object object = this.translateDefaultValue(string5, resultSet.getInt("DATA_TYPE"), string4.trim());
                    if (object == null) continue;
                    hashtable.put(string5, object);
                }
                catch (Exception exception) {
                    logger.debug(string4, exception);
                }
            }
            Hashtable<String, Object> hashtable2 = hashtable;
            return hashtable2;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Get default values failed!", this.formatSQLException(sQLException));
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
    }

    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return this.translateValue(n, string2);
    }

    protected Object translateValue(int n, String string) throws Exception {
        if (string == null || string.equalsIgnoreCase("null")) {
            return null;
        }
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return string;
            }
            case -7: 
            case 16: {
                return Boolean.valueOf(string);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new BigDecimal(string);
            }
            case 91: 
            case 92: 
            case 93: {
                if (string.startsWith("0000-00-00")) {
                    return null;
                }
                return new Timestamp(this.dateUtil.parse(string).getTime());
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return null;
            }
        }
        throw new DataSourceException("SQL Type '" + n + "' is not support!");
    }

    public Hashtable<String, Object[]> getAllowedValues(String string, String string2, String string3) throws DataSourceException {
        return null;
    }

    public Object[] getDefaultAllowedValues(String string, String string2, String string3, ServerColumnMetaData serverColumnMetaData) {
        if (serverColumnMetaData.getDataType().getTypeIdentifier() == 16) {
            return new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRowCount(String string, ICondition iCondition, int n) throws DataSourceException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = this.getPreparedStatement(string.toString(), false);
        try {
            int n2;
            this.setFilterParameter(1, preparedStatement, iCondition);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                logger.debug("select (", string, ",...) in ", System.currentTimeMillis() - l, "ms");
                int n3 = 0;
                while (resultSet.next()) {
                    if (n < 0 || ++n3 <= n) continue;
                    throw new DataSourceException("Too many rows found! " + string);
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw new DataSourceException("Execute statement failed! " + string, this.formatSQLException(sQLException));
                }
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return n2;
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    String getSQL(ICondition iCondition, ServerMetaData serverMetaData, boolean bl) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder();
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            if (!compareCondition.isIgnoreNull() || object != null) {
                String string = null;
                if (serverMetaData != null) {
                    try {
                        string = bl ? serverMetaData.getServerColumnMetaData(compareCondition.getColumnName()).getRealQueryColumnName() : serverMetaData.getServerColumnMetaData(compareCondition.getColumnName()).getColumnName().getQuotedName();
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = compareCondition.getColumnName();
                }
                if ((compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) && compareCondition.getValue() != null) {
                    if (compareCondition instanceof LikeReverse) {
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                    } else if (compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("UPPER(");
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                        stringBuilder.append(")");
                    }
                } else if (compareCondition instanceof LikeIgnoreCase) {
                    stringBuilder.append("UPPER(");
                    stringBuilder.append(this.createWhereColumn(serverMetaData, compareCondition, string));
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(this.createWhereColumn(serverMetaData, compareCondition, string));
                }
                stringBuilder.append(' ');
                if (compareCondition.getValue() == null) {
                    stringBuilder.append("IS NULL");
                } else {
                    if (compareCondition instanceof Equals) {
                        stringBuilder.append("= ");
                    } else if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("LIKE UPPER(");
                    } else if (compareCondition instanceof Like || compareCondition instanceof LikeReverse) {
                        stringBuilder.append("LIKE ");
                    } else if (compareCondition instanceof Greater) {
                        stringBuilder.append("> ");
                    } else if (compareCondition instanceof GreaterEquals) {
                        stringBuilder.append(">= ");
                    } else if (compareCondition instanceof Less) {
                        stringBuilder.append("< ");
                    } else if (compareCondition instanceof LessEquals) {
                        stringBuilder.append("<= ");
                    } else {
                        stringBuilder.append(' ');
                    }
                    if (compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(this.createReplace(this.createReplace(this.createWhereColumn(serverMetaData, compareCondition, string), "*", "%"), "?", "_"));
                    } else {
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                    }
                    if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(")");
                    }
                }
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                String string = this.getSQL(iConditionArray[i], serverMetaData, bl);
                if (string == null || string.length() <= 0) continue;
                if (i > 0 && stringBuilder.length() > 0) {
                    if (operatorCondition instanceof And) {
                        stringBuilder.append(" AND ");
                    } else if (operatorCondition instanceof Or) {
                        stringBuilder.append(" OR ");
                    }
                }
                if (iConditionArray[i] instanceof OperatorCondition) {
                    stringBuilder.append("(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                    continue;
                }
                stringBuilder.append(string);
            }
        } else if (iCondition instanceof Not) {
            ICondition iCondition2 = ((Not)iCondition).getCondition();
            String string = this.getSQL(iCondition2, serverMetaData, bl);
            stringBuilder.append("NOT ");
            if (iCondition2 instanceof OperatorCondition) {
                stringBuilder.append("(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected String createReplace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("REPLACE(");
        stringBuilder.append(string);
        stringBuilder.append(",'");
        stringBuilder.append(string2);
        stringBuilder.append("','");
        stringBuilder.append(string3);
        stringBuilder.append("')");
        return stringBuilder.toString();
    }

    protected String createWhereParam(ServerMetaData serverMetaData, CompareCondition compareCondition) {
        return "?";
    }

    protected String createWhereColumn(ServerMetaData serverMetaData, CompareCondition compareCondition, String string) {
        return string;
    }

    public boolean isTypeEqual(ServerColumnMetaData serverColumnMetaData, CompareCondition compareCondition) {
        if (compareCondition instanceof Equals) {
            Object object = compareCondition.getValue();
            IDataType iDataType = serverColumnMetaData.getDataType();
            if (object instanceof String && !(iDataType instanceof StringDataType) || object instanceof Timestamp && !(iDataType instanceof TimestampDataType) || object instanceof BigDecimal && !(iDataType instanceof BigDecimalDataType) || object instanceof Boolean && !(iDataType instanceof BooleanDataType)) {
                return false;
            }
        }
        return true;
    }

    static Object[] getParameter(ICondition iCondition) {
        Object[] objectArray = null;
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            objectArray = object != null ? ((compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) && object instanceof String ? new Object[]{((String)object).replace('*', '%').replace('?', '_')} : new Object[]{object}) : new Object[]{};
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                Object[] objectArray2 = DBAccess.getParameter(iConditionArray[i]);
                if (objectArray == null) {
                    objectArray = new Object[]{};
                }
                objectArray = ArrayUtil.addAll(objectArray, objectArray2);
            }
        } else if (iCondition instanceof Not) {
            objectArray = DBAccess.getParameter(((Not)iCondition).getCondition());
        }
        return objectArray;
    }

    protected String[] splitSchemaTable(String string) {
        int n;
        int n2;
        boolean bl = false;
        if (string.indexOf(44) >= 0) {
            bl = true;
        }
        if (string.indexOf(this.sOpenQuote) >= 0) {
            bl = true;
        }
        if ((n2 = string.indexOf(32)) > 0 && (n = string.indexOf(32, n2 + 1)) > n2) {
            bl = true;
        }
        String[] stringArray = new String[2];
        if (!bl) {
            int n3;
            if (n2 < 0) {
                n2 = string.length();
            }
            if ((n3 = string.indexOf(46)) > 0) {
                stringArray[0] = string.substring(0, n3);
                stringArray[1] = string.substring(n3 + 1, n2);
            } else {
                stringArray[1] = string.substring(0, n2);
            }
        } else {
            stringArray[1] = string;
        }
        return stringArray;
    }

    public void setDefaultSchema(String string) {
        this.sDefaultSchema = string;
    }

    public String getDefaultSchema() {
        return this.sDefaultSchema;
    }

    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) {
        return object;
    }

    protected Object convertValueToDatabaseSpecificObject(Object object) {
        if (object instanceof Date && !(object instanceof Timestamp)) {
            return new Timestamp(((Date)object).getTime());
        }
        return object;
    }

    protected boolean setDatabaseSpecificType(ResultSetMetaData resultSetMetaData, int n, ServerColumnMetaData serverColumnMetaData) throws SQLException {
        return false;
    }

    static {
        DBAccess.registerDBAccessClass("jdbc:oracle:", OracleDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:db2:", DB2DBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:derby:", DerbyDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:jtds:sqlserver:", MSSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:mysql:", MySQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:postgresql:", PostgreSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:hsqldb:", HSQLDBAccess.class);
        tmpAutoLinkColumnNames.put("*_id*", "*0*1");
        tmpAutoLinkColumnNames.put("*_ID*", "*0*1");
    }

    public static final class ColumnMetaDataInfo {
        private ServerColumnMetaData[] scmMetaData;
        private String sCatalog = null;
        private String sSchema = null;
        private String sTable = null;

        public void setColumnMetaData(ServerColumnMetaData[] serverColumnMetaDataArray) {
            this.scmMetaData = serverColumnMetaDataArray;
        }

        public ServerColumnMetaData[] getColumnMetaData() {
            return this.scmMetaData;
        }

        public void setCatalog(String string) {
            this.sCatalog = string;
        }

        public String getCatalog() {
            return this.sCatalog;
        }

        public void setSchema(String string) {
            this.sSchema = string;
        }

        public String getSchema() {
            return this.sSchema;
        }

        public void setTable(String string) {
            this.sTable = string;
        }

        public String getTable() {
            return this.sTable;
        }
    }

    private static final class Select {
        private String sSelectStatement;
        private ICondition cFilter;
        private int iLastRow;

        private Select(String string, ICondition iCondition, int n) {
            this.sSelectStatement = string;
            this.cFilter = iCondition;
            this.iLastRow = n;
        }

        public int hashCode() {
            return this.sSelectStatement.hashCode() + this.iLastRow;
        }

        public boolean equals(Object object) {
            if (object instanceof Select) {
                Select select = (Select)object;
                if (this.sSelectStatement.equals(select.sSelectStatement) && this.iLastRow == select.iLastRow) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    if (this.cFilter == null && select.cFilter == null) {
                        return true;
                    }
                    if (this.cFilter != null && select.cFilter != null && (objectArray2 = DBAccess.getParameter(this.cFilter)).length == (objectArray = DBAccess.getParameter(select.cFilter)).length) {
                        for (int i = 0; i < objectArray2.length; ++i) {
                            if (objectArray2[i].equals(objectArray[i])) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
            return super.equals(object);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Select :: ");
            stringBuilder.append(this.sSelectStatement);
            stringBuilder.append(", Filter=");
            stringBuilder.append(this.cFilter);
            stringBuilder.append(", LastRow=");
            stringBuilder.append(this.iLastRow);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

