/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist;

import com.sibvisions.rad.model.DataBookCSVExporter;
import com.sibvisions.rad.persist.event.StorageEvent;
import com.sibvisions.rad.persist.event.StorageHandler;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.LocaleUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.IStorage;
import javax.rad.persist.MetaData;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;
import javax.rad.type.bean.IBean;
import javax.rad.util.INamedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStorage
implements IStorage,
INamedObject {
    private static ILogger logger = null;
    private HashMap<String, String> hmpPropertyNames = null;
    private StorageHandler eventCalculateRow;
    private StorageHandler eventBeforeInsert;
    private StorageHandler eventAfterInsert;
    private StorageHandler eventBeforeUpdate;
    private StorageHandler eventAfterUpdate;
    private StorageHandler eventBeforeDelete;
    private StorageHandler eventAfterDelete;
    private BeanType btColumns;
    private String[] sPropertyNames;
    private String sName;

    @Override
    public final MetaData getMetaData() throws DataSourceException {
        return this.executeGetMetaData();
    }

    @Override
    public final List<Object[]> fetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.fetch(false, iCondition, sortDefinition, n, n2);
    }

    @Override
    public final Object[] refetchRow(Object[] objectArray) throws DataSourceException {
        return this.refetchRow(false, objectArray);
    }

    @Override
    public final Object[] insert(Object[] objectArray) throws DataSourceException {
        return this.insert(false, objectArray);
    }

    @Override
    public final Object[] update(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        return this.update(false, objectArray, objectArray2);
    }

    @Override
    public final void delete(Object[] objectArray) throws DataSourceException {
        this.delete(false, objectArray);
    }

    public abstract void writeCSV(OutputStream var1, String[] var2, String[] var3, ICondition var4, SortDefinition var5, String var6) throws Exception;

    public abstract MetaData executeGetMetaData() throws DataSourceException;

    public abstract Object[] executeRefetchRow(Object[] var1) throws DataSourceException;

    public abstract List<Object[]> executeFetch(ICondition var1, SortDefinition var2, int var3, int var4) throws DataSourceException;

    public abstract Object[] executeInsert(Object[] var1) throws DataSourceException;

    public abstract Object[] executeUpdate(Object[] var1, Object[] var2) throws DataSourceException;

    public abstract void executeDelete(Object[] var1) throws DataSourceException;

    private List<Object[]> fetch(boolean bl, ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        List<Object[]> list = bl ? this.executeFetchAsBean(iCondition, sortDefinition, n, n2) : this.executeFetch(iCondition, sortDefinition, n, n2);
        if (this.eventCalculateRow != null) {
            for (int i = 0; i < list.size() && list.get(i) != null; ++i) {
                Object[] objectArray = list.get(i);
                StorageEvent storageEvent = new StorageEvent(this, StorageEvent.ChangedType.CALCULATE_ROW, null, this.createBean(objectArray));
                this.eventCalculateRow.dispatchEvent(storageEvent);
                if (!storageEvent.isNewModified()) continue;
                list.set(i, this.trimArray(this.createArray(storageEvent.getNew()), objectArray));
            }
        }
        return list;
    }

    private Object[] refetchRow(boolean bl, Object[] objectArray) throws DataSourceException {
        Object[] objectArray2 = bl ? this.executeRefetchRowAsBean(objectArray) : this.executeRefetchRow(objectArray);
        if (this.eventCalculateRow != null) {
            StorageEvent storageEvent = new StorageEvent(this, StorageEvent.ChangedType.CALCULATE_ROW, null, this.createBean(objectArray2));
            this.eventCalculateRow.dispatchEvent(storageEvent);
            if (storageEvent.isNewModified()) {
                objectArray2 = this.createArray(storageEvent.getNew());
            }
        }
        return this.trimArray(objectArray2, objectArray);
    }

    private Object[] insert(boolean bl, Object[] objectArray) throws DataSourceException {
        StorageEvent storageEvent;
        Object[] objectArray2 = objectArray;
        if (this.eventBeforeInsert != null) {
            StorageEvent storageEvent2 = new StorageEvent(this, StorageEvent.ChangedType.BEFORE_INSERT, null, this.createBean(objectArray2));
            this.eventBeforeInsert.dispatchEvent(storageEvent2);
            if (storageEvent2.isNewModified()) {
                objectArray2 = this.createArray(storageEvent2.getNew());
            }
        }
        objectArray2 = bl ? this.executeInsertAsBean(objectArray2) : this.executeInsert(objectArray2);
        boolean bl2 = false;
        IBean iBean = null;
        if (this.eventAfterInsert != null) {
            iBean = this.createBean(objectArray2);
            storageEvent = new StorageEvent(this, StorageEvent.ChangedType.AFTER_INSERT, null, iBean);
            this.eventAfterInsert.dispatchEvent(storageEvent);
            if (storageEvent.isNewModified()) {
                bl2 = true;
                iBean = storageEvent.getNew();
            }
        }
        if (this.eventCalculateRow != null) {
            if (iBean == null) {
                iBean = this.createBean(objectArray2);
            }
            storageEvent = new StorageEvent(this, StorageEvent.ChangedType.CALCULATE_ROW, null, iBean);
            this.eventCalculateRow.dispatchEvent(storageEvent);
            if (storageEvent.isNewModified()) {
                bl2 = true;
                iBean = storageEvent.getNew();
            }
        }
        if (bl2) {
            return this.trimArray(this.createArray(iBean), objectArray);
        }
        return this.trimArray(objectArray2, objectArray);
    }

    private Object[] update(boolean bl, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        StorageEvent storageEvent;
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray2;
        IBean iBean = null;
        if (this.eventBeforeUpdate != null) {
            StorageEvent storageEvent2 = new StorageEvent(this, StorageEvent.ChangedType.BEFORE_UPDATE, this.createBean(objectArray3), this.createBean(objectArray4));
            this.eventBeforeUpdate.dispatchEvent(storageEvent2);
            iBean = storageEvent2.getOld();
            if (storageEvent2.isOldModified()) {
                objectArray3 = this.createArray(iBean);
            }
            if (storageEvent2.isNewModified()) {
                objectArray4 = this.createArray(storageEvent2.getNew());
            }
        }
        objectArray4 = bl ? this.executeUpdateAsBean(objectArray3, objectArray4) : this.executeUpdate(objectArray3, objectArray4);
        boolean bl2 = false;
        IBean iBean2 = null;
        if (this.eventAfterUpdate != null) {
            if (iBean == null) {
                iBean = this.createBean(objectArray3);
            }
            iBean2 = this.createBean(objectArray4);
            storageEvent = new StorageEvent(this, StorageEvent.ChangedType.AFTER_UPDATE, iBean, iBean2);
            this.eventAfterUpdate.dispatchEvent(storageEvent);
            if (storageEvent.isNewModified()) {
                bl2 = true;
                iBean2 = storageEvent.getNew();
            }
        }
        if (this.eventCalculateRow != null) {
            if (iBean2 == null) {
                iBean2 = this.createBean(objectArray4);
            }
            storageEvent = new StorageEvent(this, StorageEvent.ChangedType.CALCULATE_ROW, null, iBean2);
            this.eventCalculateRow.dispatchEvent(storageEvent);
            if (storageEvent.isNewModified()) {
                bl2 = true;
                iBean2 = storageEvent.getNew();
            }
        }
        if (bl2) {
            return this.trimArray(this.createArray(iBean2), objectArray2);
        }
        return this.trimArray(objectArray4, objectArray2);
    }

    private void delete(boolean bl, Object[] objectArray) throws DataSourceException {
        StorageEvent storageEvent;
        Object[] objectArray2 = objectArray;
        IBean iBean = null;
        if (this.eventBeforeDelete != null) {
            iBean = this.createBean(objectArray2);
            storageEvent = new StorageEvent(this, StorageEvent.ChangedType.BEFORE_DELETE, iBean, null);
            this.eventBeforeDelete.dispatchEvent(storageEvent);
            if (storageEvent.isOldModified()) {
                iBean = storageEvent.getOld();
                objectArray2 = this.createArray(iBean);
            }
        }
        if (bl) {
            this.executeDeleteAsBean(objectArray2);
        } else {
            this.executeDelete(objectArray2);
        }
        if (this.eventAfterDelete != null) {
            if (iBean == null) {
                iBean = this.createBean(objectArray2);
            }
            storageEvent = new StorageEvent(this, StorageEvent.ChangedType.AFTER_DELETE, iBean, null);
            this.eventAfterDelete.dispatchEvent(storageEvent);
        }
    }

    @Override
    public void setName(String string) {
        this.sName = string;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    protected void debug(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(this.getClass());
        }
        logger.debug(objectArray);
    }

    protected void info(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(this.getClass());
        }
        logger.info(objectArray);
    }

    protected void error(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(this.getClass());
        }
        logger.error(objectArray);
    }

    public IFileHandle createCSV(String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition) throws Exception {
        SessionContext sessionContext = SessionContext.getCurrentInstance();
        String string = null;
        if (sessionContext != null) {
            string = sessionContext.getObjectName();
        }
        return this.createCSV(string, stringArray, stringArray2, iCondition, sortDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileHandle createCSV(String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        try {
            LocaleUtil.setThreadDefault(LocaleUtil.forLanguageTag(string));
            IFileHandle iFileHandle = this.createCSV(stringArray, stringArray2, iCondition, sortDefinition);
            return iFileHandle;
        }
        finally {
            LocaleUtil.setThreadDefault(null);
        }
    }

    public IFileHandle createCSV(String string, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition) throws Exception {
        String string2;
        Object object;
        RemoteFileHandle remoteFileHandle = new RemoteFileHandle(DataBookCSVExporter.formatCSVFileName(string));
        ISession iSession = SessionContext.getCurrentSession();
        if (iSession != null) {
            object = (String)iSession.getProperty("client.locale.language");
            String string3 = (String)iSession.getProperty("client.locale.country");
            String string4 = (String)iSession.getProperty("client.locale.variant");
            string2 = object != null ? LocaleUtil.getListSeparator(new Locale((String)object, string3, string4)) : LocaleUtil.getListSeparator();
        } else {
            string2 = LocaleUtil.getListSeparator();
        }
        object = remoteFileHandle.getOutputStream();
        this.writeCSV((OutputStream)object, stringArray, stringArray2, iCondition, sortDefinition, string2);
        ((OutputStream)object).close();
        return remoteFileHandle;
    }

    public StorageHandler eventCalculateRow() {
        if (this.eventCalculateRow == null) {
            this.eventCalculateRow = new StorageHandler();
        }
        return this.eventCalculateRow;
    }

    public StorageHandler eventBeforeInsert() {
        if (this.eventBeforeInsert == null) {
            this.eventBeforeInsert = new StorageHandler();
        }
        return this.eventBeforeInsert;
    }

    public StorageHandler eventAfterInsert() {
        if (this.eventAfterInsert == null) {
            this.eventAfterInsert = new StorageHandler();
        }
        return this.eventAfterInsert;
    }

    public StorageHandler eventBeforeUpdate() {
        if (this.eventBeforeUpdate == null) {
            this.eventBeforeUpdate = new StorageHandler();
        }
        return this.eventBeforeUpdate;
    }

    public StorageHandler eventAfterUpdate() {
        if (this.eventAfterUpdate == null) {
            this.eventAfterUpdate = new StorageHandler();
        }
        return this.eventAfterUpdate;
    }

    public StorageHandler eventBeforeDelete() {
        if (this.eventBeforeDelete == null) {
            this.eventBeforeDelete = new StorageHandler();
        }
        return this.eventBeforeDelete;
    }

    public StorageHandler eventAfterDelete() {
        if (this.eventAfterDelete == null) {
            this.eventAfterDelete = new StorageHandler();
        }
        return this.eventAfterDelete;
    }

    protected BeanType getAndInitBeanType() throws DataSourceException {
        if (this.btColumns == null) {
            this.btColumns = this.createBeanType(this.executeGetMetaData().getColumnNames());
        }
        return this.btColumns;
    }

    protected BeanType createBeanType(String[] stringArray) {
        BeanType beanType = new BeanType(stringArray);
        this.sPropertyNames = new String[stringArray.length];
        for (int i = 0; i < this.sPropertyNames.length; ++i) {
            String string = this.hmpPropertyNames != null ? this.hmpPropertyNames.get(stringArray[i]) : null;
            if (string == null) {
                string = StringUtil.convertToMemberName(stringArray[i]);
            }
            this.sPropertyNames[i] = string;
        }
        return beanType;
    }

    public IBean createEmptyBean() throws DataSourceException {
        return new Bean(this.getAndInitBeanType());
    }

    protected IBean createBean(Object[] objectArray) throws DataSourceException {
        BeanType beanType = this.getAndInitBeanType();
        Bean bean = new Bean(beanType);
        String[] stringArray = beanType.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (objectArray != null && i < objectArray.length) {
                bean.put(stringArray[i], objectArray[i]);
                continue;
            }
            if (objectArray != null) continue;
            bean.put(stringArray[i], (Object)null);
        }
        return bean;
    }

    private Object[] createArray(Object object) throws DataSourceException {
        String[] stringArray;
        IBean iBean;
        BeanType beanType = this.getAndInitBeanType();
        if (object == null) {
            return new Object[beanType.getPropertyCount()];
        }
        if (object instanceof IBean) {
            iBean = (IBean)object;
            stringArray = beanType.getPropertyNames();
        } else {
            iBean = new Bean(object);
            stringArray = this.sPropertyNames;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                objectArray[i] = iBean.get(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
        return objectArray;
    }

    private Object[] trimArray(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2 == null || objectArray == null || objectArray.length == objectArray2.length) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, Math.min(objectArray3.length, objectArray.length));
        return objectArray3;
    }

    protected <T> T createPOJO(Class<T> clazz, Object[] objectArray) throws DataSourceException {
        Bean bean = new Bean(clazz);
        this.getAndInitBeanType();
        for (int i = 0; i < this.sPropertyNames.length; ++i) {
            try {
                bean.put(this.sPropertyNames[i], objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
        return (T)bean.getObject();
    }

    public <T> T createPOJO(Class<T> clazz, IBean iBean) throws DataSourceException {
        Bean bean = new Bean(clazz);
        BeanType beanType = this.getAndInitBeanType();
        String[] stringArray = beanType.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                bean.put(this.sPropertyNames[i], iBean.get(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
        return (T)bean.getObject();
    }

    public void updateBean(IBean iBean, Object object) throws DataSourceException {
        Bean bean = new Bean(object);
        BeanType beanType = this.getAndInitBeanType();
        String[] stringArray = beanType.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                iBean.put(stringArray[i], bean.get(this.sPropertyNames[i]));
                continue;
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
    }

    public void setPropertyNameForColumn(String string, String string2) throws DataSourceException {
        if (string2 == null && this.hmpPropertyNames == null) {
            return;
        }
        MetaData metaData = this.executeGetMetaData();
        if (this.hmpPropertyNames == null) {
            this.hmpPropertyNames = new HashMap();
        }
        if (string2 == null) {
            int n;
            this.hmpPropertyNames.remove(string);
            if (metaData != null && (n = metaData.getColumnMetaDataIndex(string)) >= 0) {
                this.sPropertyNames[n] = StringUtil.convertToMemberName(string);
            }
        } else {
            int n;
            this.hmpPropertyNames.put(string, string2);
            if (metaData != null && (n = metaData.getColumnMetaDataIndex(string)) >= 0) {
                this.sPropertyNames[n] = string2;
            }
        }
    }

    public IBean fetchBean(ICondition iCondition) throws DataSourceException {
        return this.fetch(IBean.class, iCondition);
    }

    public <T> T fetch(Class<T> clazz, ICondition iCondition) throws DataSourceException {
        List<Object[]> list = this.fetch(true, iCondition, null, 0, 2);
        int n = list.size();
        if (n < 2) {
            return null;
        }
        if (n == 2 && list.get(1) == null) {
            if (IBean.class.isAssignableFrom(clazz)) {
                return (T)this.createBean(list.get(0));
            }
            return this.createPOJO(clazz, list.get(0));
        }
        throw new DataSourceException("More than one bean available!");
    }

    public List<IBean> fetchBean(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.fetch(IBean.class, iCondition, sortDefinition, n, n2);
    }

    public <T> List<T> fetch(Class<T> clazz, ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        List<Object[]> list = this.fetch(true, iCondition, sortDefinition, n, n2);
        ArrayUtil<IBean> arrayUtil = new ArrayUtil<IBean>(list.size());
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            Object[] objectArray = list.get(i);
            if (objectArray == null) continue;
            if (IBean.class.isAssignableFrom(clazz)) {
                arrayUtil.add(this.createBean(objectArray));
                continue;
            }
            arrayUtil.add((IBean)this.createPOJO(clazz, objectArray));
        }
        return arrayUtil;
    }

    public <T> T refetch(T t) throws DataSourceException {
        if (t instanceof IBean) {
            return (T)this.createBean(this.refetchRow(true, this.createArray(t)));
        }
        return (T)this.createPOJO(t.getClass(), this.refetchRow(true, this.createArray(t)));
    }

    public <T> T insert(T t) throws DataSourceException {
        if (t instanceof IBean) {
            return (T)this.createBean(this.insert(true, this.createArray(t)));
        }
        return (T)this.createPOJO(t.getClass(), this.insert(true, this.createArray(t)));
    }

    public <T> T update(T t) throws DataSourceException {
        BeanType beanType = this.getAndInitBeanType();
        MetaData metaData = this.executeGetMetaData();
        Object[] objectArray = this.createArray(t);
        Object[] objectArray2 = new Object[beanType.getPropertyCount()];
        String[] stringArray = metaData.getPrimaryKeyColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = metaData.getColumnMetaDataIndex(stringArray[i]);
            objectArray2[n] = objectArray[n];
        }
        if (t instanceof IBean) {
            return (T)this.createBean(this.update(true, objectArray2, objectArray));
        }
        return (T)this.createPOJO(t.getClass(), this.update(true, objectArray2, objectArray));
    }

    public <T> void delete(T t) throws DataSourceException {
        this.delete(true, this.createArray(t));
    }

    public Object[] executeRefetchRowAsBean(Object[] objectArray) throws DataSourceException {
        return this.executeRefetchRow(objectArray);
    }

    public List<Object[]> executeFetchAsBean(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.executeFetch(iCondition, sortDefinition, n, n2);
    }

    public Object[] executeInsertAsBean(Object[] objectArray) throws DataSourceException {
        return this.executeInsert(objectArray);
    }

    public Object[] executeUpdateAsBean(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        return this.executeUpdate(objectArray, objectArray2);
    }

    public void executeDeleteAsBean(Object[] objectArray) throws DataSourceException {
        this.executeDelete(objectArray);
    }
}

