/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.remote;

import com.sibvisions.rad.model.mem.MemDataSource;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.model.ModelException;
import javax.rad.persist.MetaData;
import javax.rad.remote.AbstractConnection;
import javax.rad.remote.SubConnection;

public class RemoteDataSource
extends MemDataSource {
    private AbstractConnection acConnection;
    private static WeakHashMap<AbstractConnection, Hashtable<String, MetaData>> hmpGlobalMetaDataCache = null;
    private Hashtable<String, MetaData> htLocalMetaDataCache = null;
    private static MetaDataCacheRole cacheRole = MetaDataCacheRole.DataSource;

    public RemoteDataSource() {
    }

    public RemoteDataSource(AbstractConnection abstractConnection) {
        this.acConnection = abstractConnection;
    }

    public void open() throws ModelException {
        if (!this.isOpen()) {
            if (this.acConnection == null) {
                throw new ModelException("Connection is null! -> open not possible");
            }
            super.open();
        }
    }

    public AbstractConnection getConnection() {
        return this.acConnection;
    }

    public void setConnection(AbstractConnection abstractConnection) {
        if (this.acConnection != abstractConnection) {
            this.clearMetaData();
        }
        this.acConnection = abstractConnection;
    }

    public MetaData getMetaData(String string) {
        MetaDataCacheOption metaDataCacheOption = this.getMetaDataCacheOption();
        if (metaDataCacheOption == MetaDataCacheOption.Default || metaDataCacheOption == MetaDataCacheOption.On) {
            if (cacheRole == MetaDataCacheRole.Global || metaDataCacheOption == MetaDataCacheOption.On) {
                return RemoteDataSource.getGlobalMetaData(this.acConnection, string);
            }
            if (cacheRole == MetaDataCacheRole.DataSource) {
                if (this.htLocalMetaDataCache == null) {
                    return null;
                }
                return this.htLocalMetaDataCache.get(string);
            }
        }
        return null;
    }

    public void putMetaData(String string, MetaData metaData) {
        MetaDataCacheOption metaDataCacheOption = this.getMetaDataCacheOption();
        if (metaDataCacheOption == MetaDataCacheOption.Default || metaDataCacheOption == MetaDataCacheOption.On) {
            if (cacheRole == MetaDataCacheRole.Global || metaDataCacheOption == MetaDataCacheOption.On) {
                RemoteDataSource.putGlobalMetaDataIntern(this.acConnection, string, metaData);
            } else if (cacheRole == MetaDataCacheRole.DataSource) {
                if (this.htLocalMetaDataCache == null) {
                    this.htLocalMetaDataCache = new Hashtable();
                }
                this.htLocalMetaDataCache.put(string, metaData);
            }
        }
    }

    public void clearMetaData() {
        if (this.htLocalMetaDataCache != null) {
            this.htLocalMetaDataCache.clear();
        }
    }

    public static MetaData getGlobalMetaData(AbstractConnection abstractConnection, String string) {
        if (hmpGlobalMetaDataCache == null) {
            return null;
        }
        if (abstractConnection == null) {
            return null;
        }
        Hashtable<String, MetaData> hashtable = hmpGlobalMetaDataCache.get(RemoteDataSource.getConnection(abstractConnection));
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(string);
    }

    public static void putGlobalMetaData(AbstractConnection abstractConnection, String string, MetaData metaData) {
        if (cacheRole == MetaDataCacheRole.Global) {
            RemoteDataSource.putGlobalMetaDataIntern(abstractConnection, string, metaData);
        }
    }

    private static void putGlobalMetaDataIntern(AbstractConnection abstractConnection, String string, MetaData metaData) {
        if (abstractConnection == null) {
            return;
        }
        if (hmpGlobalMetaDataCache == null) {
            hmpGlobalMetaDataCache = new WeakHashMap();
        }
        AbstractConnection abstractConnection2 = RemoteDataSource.getConnection(abstractConnection);
        Hashtable<String, MetaData> hashtable = hmpGlobalMetaDataCache.get(abstractConnection2);
        if (metaData.getColumnNames().length == 0) {
            if (hashtable != null) {
                hashtable.remove(string);
            }
        } else {
            if (hashtable == null) {
                hashtable = new Hashtable();
                hmpGlobalMetaDataCache.put(abstractConnection2, hashtable);
            }
            hashtable.put(string, metaData);
        }
    }

    public static void clearGlobalMetaData() {
        RemoteDataSource.clearGlobalMetaData(null);
    }

    public static void clearGlobalMetaData(AbstractConnection abstractConnection) {
        if (hmpGlobalMetaDataCache != null) {
            AbstractConnection abstractConnection2 = RemoteDataSource.getConnection(abstractConnection);
            if (abstractConnection2 == null) {
                hmpGlobalMetaDataCache.clear();
            } else {
                hmpGlobalMetaDataCache.remove(abstractConnection2);
            }
        }
    }

    public static void setMetaDataCacheRole(MetaDataCacheRole metaDataCacheRole) {
        cacheRole = metaDataCacheRole;
    }

    public static MetaDataCacheRole getMetaDataCacheRole() {
        return cacheRole;
    }

    private MetaDataCacheOption getMetaDataCacheOption() {
        Object object;
        try {
            object = this.acConnection.getProperty("server.client.metadatacache_option");
        }
        catch (Throwable throwable) {
            object = null;
        }
        if (object == null) {
            return MetaDataCacheOption.Default;
        }
        return MetaDataCacheOption.resolve((String)object);
    }

    private static AbstractConnection getConnection(AbstractConnection abstractConnection) {
        if (abstractConnection instanceof SubConnection) {
            return ((SubConnection)abstractConnection).getMasterConnection();
        }
        return abstractConnection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaDataCacheRole {
        Global,
        DataSource,
        Off;


        public static MetaDataCacheRole resolve(String string) {
            if (string != null) {
                String string2 = string.toUpperCase();
                if ("GLOBAL".equals(string2)) {
                    return Global;
                }
                if ("DATASOURCE".equals(string2)) {
                    return DataSource;
                }
                if ("OFF".equals(string2)) {
                    return Off;
                }
            }
            throw new IllegalArgumentException("Unknown enum: " + string);
        }
    }
}

