/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.remote;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.rad.model.remote.RemoteDataPage;
import com.sibvisions.rad.model.remote.RemoteDataSource;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UILinkedCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataRow;
import javax.rad.model.IDataSource;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.remote.AbstractConnection;

public class RemoteDataBook
extends MemDataBook {
    private static ILogger logger = LoggerFactory.getInstance(RemoteDataBook.class);
    private static Hashtable<String, Boolean> htCachingStorage = new Hashtable();
    private String[] saMetaDataColumnNames;
    private String[] saBlockFetchColumnNames;
    private String[] saBlockFetchReferencedColumnNames;
    private Hashtable<Object, Integer> htFetchedRowsForBlock = null;
    private MetaData mdMetaData;
    private int[] iaFetchColumnIndexes;
    private int[] iaMasterColumnIndexes;
    private boolean bCachingStorage = true;
    private boolean bMetaDataCacheEnabled = true;

    public RemoteDataBook() {
        this.setMemSort(false);
        this.setMemFilter(false);
        this.setDeleteCascade(false);
        this.setWritebackEnabled(true);
    }

    protected boolean isDataPageRefetchPossible() {
        return this.saBlockFetchColumnNames == null;
    }

    protected MemDataPage createDataPage(IDataRow iDataRow) {
        return new RemoteDataPage(this, iDataRow);
    }

    public void setDataSource(IDataSource iDataSource) throws ModelException {
        if (!(iDataSource instanceof RemoteDataSource)) {
            throw new ModelException("It's not an RemoteDataSource! -> it have to be one!");
        }
        super.setDataSource(iDataSource);
    }

    public RemoteDataSource getDataSource() {
        return (RemoteDataSource)super.getDataSource();
    }

    public void open() throws ModelException {
        if (!this.isOpen()) {
            Object object;
            Object[] objectArray;
            block26: {
                if (this.getConnection() == null) {
                    throw new ModelException("The remote connection to the server IStorage is null!");
                }
                if (this.getName() == null) {
                    throw new ModelException("DataBook Name is null!");
                }
                try {
                    this.initServerMetaData();
                }
                catch (DataSourceException dataSourceException) {
                    if (this.rdRowDefinition != null && this.rdRowDefinition.getColumnCount() != 0) break block26;
                    throw new ModelException("RowDefintion can't init with meta data from storage!", dataSourceException);
                }
            }
            if (this.mdMetaData != null) {
                int n;
                if (!this.mdMetaData.isSupported(MetaData.Feature.Filter)) {
                    this.setMemFilter(true);
                }
                if (!this.mdMetaData.isSupported(MetaData.Feature.Sort)) {
                    this.setMemSort(true);
                }
                if (!this.mdMetaData.isSupported(MetaData.Feature.WriteBack)) {
                    this.setWritebackEnabled(false);
                }
                objectArray = this.mdMetaData.getColumnMetaData();
                this.saMetaDataColumnNames = new String[objectArray.length];
                if (this.rdRowDefinition == null) {
                    this.rdRowDefinition = new RowDefinition();
                }
                object = this.getName();
                for (n = 0; n < objectArray.length; ++n) {
                    if (this.rdRowDefinition.getColumnDefinitionIndex(((ColumnMetaData)objectArray[n]).getName()) < 0) {
                        ColumnDefinition columnDefinition = ColumnMetaData.createColumnDefinition((ColumnMetaData)objectArray[n]);
                        columnDefinition.setWritable(true);
                        this.rdRowDefinition.addColumnDefinition(columnDefinition);
                        if (UIFactoryManager.getFactory() != null && ((ColumnMetaData)objectArray[n]).getLinkReference() != null) {
                            RemoteDataBook remoteDataBook = new RemoteDataBook();
                            remoteDataBook.setDataSource(this.getDataSource());
                            String string = ((ColumnMetaData)objectArray[n]).getLinkReference().getReferencedStorage();
                            if (string.startsWith(".")) {
                                string = (String)object + string;
                            }
                            remoteDataBook.setName(string);
                            remoteDataBook.open();
                            ReferenceDefinition referenceDefinition = new ReferenceDefinition();
                            referenceDefinition.setReferencedDataBook(remoteDataBook);
                            referenceDefinition.setReferencedColumnNames(((ColumnMetaData)objectArray[n]).getLinkReference().getReferencedColumnNames());
                            referenceDefinition.setColumnNames(((ColumnMetaData)objectArray[n]).getLinkReference().getColumnNames());
                            UILinkedCellEditor uILinkedCellEditor = new UILinkedCellEditor();
                            uILinkedCellEditor.setLinkReference(referenceDefinition);
                            uILinkedCellEditor.setValidationEnabled(!(columnDefinition.getDataType() instanceof StringDataType) || !((ColumnMetaData)objectArray[n]).isWritable());
                            if (columnDefinition.getDataType() instanceof BigDecimalDataType) {
                                uILinkedCellEditor.setHorizontalAlignment(2);
                            }
                            columnDefinition.getDataType().setCellEditor(uILinkedCellEditor);
                        }
                    }
                    this.saMetaDataColumnNames[n] = ((ColumnMetaData)objectArray[n]).getName();
                }
                this.iaFetchColumnIndexes = new int[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    this.iaFetchColumnIndexes[n] = this.rdRowDefinition.getColumnDefinitionIndex(((ColumnMetaData)objectArray[n]).getName());
                }
                if (this.rdRowDefinition.getPrimaryKeyColumnNames() == null) {
                    String[] stringArray = this.mdMetaData.getPrimaryKeyColumnNames();
                    if (stringArray == null) {
                        this.setWritebackEnabled(false);
                    } else {
                        this.rdRowDefinition.setPrimaryKeyColumnNames(stringArray);
                    }
                }
            }
            if (this.saBlockFetchColumnNames == null) {
                this.iaMasterColumnIndexes = null;
                this.saBlockFetchReferencedColumnNames = null;
            } else {
                if (this.getMasterReference() == null) {
                    throw new ModelException("Block fetch is only allowed if a master reference is set!");
                }
                if (ArrayUtil.containsAll(this.getMasterReference().getColumnNames(), this.saBlockFetchColumnNames)) {
                    int n;
                    objectArray = this.getMasterReference().getColumnNames();
                    object = this.getMasterReference().getReferencedColumnNames();
                    this.iaMasterColumnIndexes = new int[objectArray.length];
                    for (n = 0; n < this.iaMasterColumnIndexes.length; ++n) {
                        this.iaMasterColumnIndexes[n] = this.rdRowDefinition.getColumnDefinitionIndex((String)objectArray[n]);
                    }
                    this.saBlockFetchReferencedColumnNames = new String[this.saBlockFetchColumnNames.length];
                    for (n = 0; n < this.saBlockFetchColumnNames.length; ++n) {
                        this.saBlockFetchReferencedColumnNames[n] = object[ArrayUtil.indexOf(objectArray, this.saBlockFetchColumnNames[n])];
                    }
                } else {
                    throw new ModelException("Block fetch have to be a subset of the master reference columns!");
                }
            }
            super.open();
        }
    }

    public synchronized void close() {
        if (this.isOpen()) {
            super.close();
            this.htFetchedRowsForBlock = null;
        }
    }

    protected void executeLockAndRefetch() throws ModelException {
        if (this.isWritebackEnabled()) {
            try {
                IDataRow iDataRow = this.getOriginalRow();
                if (iDataRow == null) {
                    iDataRow = this.getDataRow(this.getSelectedRow());
                }
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "refetchRow", iDataRow.getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.refetchRow(", this.getName(), ",", iDataRow.getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
                if (objectArray != null) {
                    this.setValuesInternal(this.saMetaDataColumnNames, objectArray);
                }
            }
            catch (Throwable throwable) {
                throw new ModelException("Execute Lock and Refetch failed!", throwable);
            }
        }
    }

    protected void executeInsert() throws ModelException {
        if (this.isWritebackEnabled()) {
            int n = this.getSelectedRow();
            try {
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "insert", this.getDataRow(n).getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.insert(", this.getName(), ",", this.getDataRow(n), ") in ", System.currentTimeMillis() - l, "ms");
                if (objectArray != null) {
                    this.setValuesInternal(this.saMetaDataColumnNames, objectArray);
                }
            }
            catch (Throwable throwable) {
                this.setSelectedRow(n);
                throw new ModelException("Execute Insert failed!", throwable);
            }
        }
    }

    protected void executeUpdate() throws ModelException {
        if (this.isWritebackEnabled()) {
            int n = this.getSelectedRow();
            try {
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "update", this.getOriginalRow().getValues(this.saMetaDataColumnNames), this.getDataRow(n).getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.update(", this.getName(), ",", this.getOriginalRow(), ",", this.getDataRow(n), ") in ", System.currentTimeMillis() - l, "ms");
                if (objectArray != null) {
                    this.setValuesInternal(this.saMetaDataColumnNames, objectArray);
                }
            }
            catch (Throwable throwable) {
                this.setSelectedRow(n);
                throw new ModelException("Execute Update failed!", throwable);
            }
        }
    }

    protected void executeDelete() throws ModelException {
        if (this.isWritebackEnabled()) {
            int n = this.getSelectedRow();
            try {
                long l = System.currentTimeMillis();
                this.getConnection().call(this.getName(), "delete", this.getOriginalRow().getValues(this.saMetaDataColumnNames));
                logger.debug("acConnection.delete(", this.getName(), ",", this.getOriginalRow().getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
            }
            catch (Throwable throwable) {
                this.setSelectedRow(n);
                throw new ModelException("Execute Delete failed!", throwable);
            }
        }
    }

    protected void executeRefresh() throws ModelException {
        super.clear();
        this.htFetchedRowsForBlock = null;
    }

    public void setMemSort(boolean bl) {
        if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.Sort)) {
            return;
        }
        super.setMemSort(bl);
    }

    public boolean isMemSort() {
        return super.isMemSort();
    }

    public void setMemFilter(boolean bl) {
        if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.Filter)) {
            return;
        }
        super.setMemFilter(bl);
    }

    public boolean isMemFilter() {
        return super.isMemFilter();
    }

    public void setWritebackEnabled(boolean bl) {
        if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.WriteBack)) {
            return;
        }
        super.setWritebackEnabled(bl);
    }

    public boolean isWritebackEnabled() {
        return super.isWritebackEnabled();
    }

    public String[] getBlockFetchColumnNames() {
        return this.saBlockFetchColumnNames;
    }

    public void setBlockFetchColumnNames(String[] stringArray) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.saBlockFetchColumnNames = stringArray;
    }

    public void setMetaDataCacheEnabled(boolean bl) {
        this.bMetaDataCacheEnabled = bl;
    }

    public boolean isMetaDataCacheEnabled() {
        return this.bMetaDataCacheEnabled;
    }

    private void initServerMetaData() throws DataSourceException {
        block10: {
            try {
                RemoteDataSource remoteDataSource = this.getDataSource();
                String string = remoteDataSource.getConnection().getLifeCycleName();
                String string2 = this.getName();
                String string3 = string + "." + string2;
                this.mdMetaData = this.bMetaDataCacheEnabled ? remoteDataSource.getMetaData(string3) : null;
                if (this.mdMetaData == null) {
                    Boolean bl = htCachingStorage.get(string3);
                    this.bCachingStorage = bl != null ? bl : true;
                    long l = System.currentTimeMillis();
                    if (this.bCachingStorage) {
                        try {
                            Hashtable hashtable;
                            Object[] objectArray = this.getConnection().call(new String[]{string2, string2}, new String[]{"getMetaData", "getMetaDataFromCache"}, new Object[][]{{string, string2}, {string}});
                            this.mdMetaData = (MetaData)objectArray[0];
                            if (this.bMetaDataCacheEnabled && (hashtable = (Hashtable)objectArray[1]) != null) {
                                for (Map.Entry entry : hashtable.entrySet()) {
                                    remoteDataSource.putMetaData((String)entry.getKey(), (MetaData)entry.getValue());
                                }
                            }
                            logger.debug("getMetaDataFromCache(", string, ", ", string2, ") in ", System.currentTimeMillis() - l, "ms");
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            this.bCachingStorage = false;
                        }
                    }
                    if (!this.bCachingStorage) {
                        this.mdMetaData = (MetaData)this.getConnection().call(string2, "getMetaData");
                        if (this.bMetaDataCacheEnabled) {
                            remoteDataSource.putMetaData(string3, this.mdMetaData);
                        }
                        logger.debug("getMetaData(", string2, ") in ", System.currentTimeMillis() - l, "ms");
                    }
                    htCachingStorage.put(string3, this.bCachingStorage);
                    break block10;
                }
                logger.debug("use cached metadata: ", string2);
            }
            catch (Throwable throwable) {
                throw new DataSourceException("Init ServerMetaData failed!", throwable);
            }
        }
    }

    protected String[] getMetaDataColumnNames() {
        return this.saMetaDataColumnNames;
    }

    protected int[] getFetchColumnIndexes() {
        return this.iaFetchColumnIndexes;
    }

    protected int[] getMasterColumnIndexesForBlock() {
        return this.iaMasterColumnIndexes;
    }

    protected int getFetchedRowsForBlock(IDataRow iDataRow) throws ModelException {
        if (this.htFetchedRowsForBlock == null) {
            return 0;
        }
        Integer n = this.htFetchedRowsForBlock.get(iDataRow.createDataRow(this.saBlockFetchReferencedColumnNames));
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected void setFetchedRowsForBlock(IDataRow iDataRow, int n) throws ModelException {
        if (this.htFetchedRowsForBlock == null) {
            this.htFetchedRowsForBlock = new Hashtable();
        }
        this.htFetchedRowsForBlock.put(iDataRow.createDataRow(this.saBlockFetchReferencedColumnNames), n);
    }

    protected AbstractConnection getConnection() {
        RemoteDataSource remoteDataSource = this.getDataSource();
        if (remoteDataSource == null) {
            return null;
        }
        return remoteDataSource.getConnection();
    }

    protected boolean isCachingStorage() {
        return this.bCachingStorage;
    }
}

