/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.mem.ChangeableDataRow;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UIChoiceCellEditor;
import javax.rad.genui.celleditor.UILinkedCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IDataSource;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.TreePath;
import javax.rad.model.condition.Filter;
import javax.rad.model.condition.ICondition;
import javax.rad.model.event.DataBookEvent;
import javax.rad.model.event.DataBookHandler;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.IControl;
import javax.rad.ui.celleditor.IChoiceCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemDataBook
extends ChangeableDataRow
implements IDataBook {
    private static int iUID = 0;
    private TreePath treePath = new TreePath(new int[0]);
    private IDataBook.SelectionMode iSelectionMode = IDataBook.SelectionMode.CURRENT_ROW;
    private ICondition cFilter;
    private SortDefinition sSort;
    private ReferenceDefinition rdMasterReference;
    private ReferenceDefinition rdTreeRootReference;
    private String[] saTreeRootMasterColumnNames;
    private IDataBook.WriteBackIsolationLevel iWritebackIsolationLevel;
    private ArrayUtil<WeakReference<IDataBook>> auDetailDataBooks;
    private IDataSource dsDataSource;
    private ArrayUtil<IDataRow> auStoredSelection = new ArrayUtil();
    private MemDataPage dpCurrentDataPage;
    private MemDataPage dpEmptyDataPage;
    private Hashtable<Object, MemDataPage> htDataPagesCache = new Hashtable();
    private DataBookHandler eventBeforeRowSelected;
    private DataBookHandler eventAfterRowSelected;
    private DataBookHandler eventBeforeInserting;
    private DataBookHandler eventAfterInserting;
    private DataBookHandler eventBeforeInserted;
    private DataBookHandler eventAfterInserted;
    private DataBookHandler eventBeforeUpdating;
    private DataBookHandler eventAfterUpdating;
    private DataBookHandler eventBeforeUpdated;
    private DataBookHandler eventAfterUpdated;
    private DataBookHandler eventBeforeDeleting;
    private DataBookHandler eventAfterDeleting;
    private DataBookHandler eventBeforeDeleted;
    private DataBookHandler eventAfterDeleted;
    private DataBookHandler eventBeforeRestore;
    private DataBookHandler eventAfterRestore;
    private DataBookHandler eventBeforeReload;
    private DataBookHandler eventAfterReload;
    private DataBookHandler eventBeforeColumnSelected;
    private DataBookHandler eventAfterColumnSelected;
    private String sName;
    private String sSelectedColumn = null;
    private int iReadAheadRowCount = 10;
    private int iSelectedRowIndex = -1;
    private int iOldSelectedRowSaveAllRows;
    private IDataPage dpOldCurrentDataPageSaveAllRows;
    private boolean bMasterChanged = false;
    private boolean bInsertEnabled = true;
    private boolean bUpdateEnabled = true;
    private boolean bDeleteEnabled = true;
    private boolean bLockAndRefetchEnabled = false;
    private boolean bReadOnly = false;
    private boolean bDeleteCascade = true;
    private boolean bMemSort = true;
    private boolean bMemFilter = true;
    private boolean bWritebackEnabled = false;
    private boolean bIsOpen = false;
    private boolean bSaveAllRows = false;
    private boolean bRestoreAllRows = false;
    private boolean ignoreReload = false;

    public MemDataBook() {
    }

    public MemDataBook(RowDefinition rowDefinition) {
        super(rowDefinition);
    }

    @Override
    public IDataBook getDataBook() {
        return this;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public void setName(String string) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks! - " + this.getName());
        }
        this.sName = string;
    }

    @Override
    public void setWritebackIsolationLevel(IDataBook.WriteBackIsolationLevel writeBackIsolationLevel) {
        this.iWritebackIsolationLevel = writeBackIsolationLevel;
    }

    @Override
    public IDataBook.WriteBackIsolationLevel getWritebackIsolationLevel() {
        if (this.iWritebackIsolationLevel == null) {
            if (this.getDataSource() != null) {
                return this.getDataSource().getWritebackIsolationLevel();
            }
            return IDataBook.WriteBackIsolationLevel.DATA_ROW;
        }
        return this.iWritebackIsolationLevel;
    }

    @Override
    public void setRowDefinition(IRowDefinition iRowDefinition) throws ModelException {
        int n;
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        IControl[] iControlArray = null;
        if (this.rdRowDefinition != null) {
            iControlArray = this.getControls();
            for (n = 0; n < iControlArray.length; ++n) {
                this.rdRowDefinition.removeControl(iControlArray[n]);
            }
        }
        this.rdRowDefinition = iRowDefinition;
        if (this.rdRowDefinition == null) {
            this.rdRowDefinition = new RowDefinition();
        }
        if (this.rdRowDefinition != null) {
            if (iControlArray == null) {
                iControlArray = this.getControls();
            }
            for (n = 0; n < iControlArray.length; ++n) {
                this.rdRowDefinition.addControl(iControlArray[n]);
            }
        }
    }

    @Override
    public IDataSource getDataSource() {
        return this.dsDataSource;
    }

    @Override
    public void setDataSource(IDataSource iDataSource) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.dsDataSource = iDataSource;
    }

    @Override
    public ReferenceDefinition getMasterReference() {
        return this.rdMasterReference;
    }

    @Override
    public void setMasterReference(ReferenceDefinition referenceDefinition) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.rdMasterReference = referenceDefinition;
    }

    @Override
    public boolean isSelfJoined() {
        return this.rdMasterReference != null && this.rdMasterReference.getReferencedDataBook() == this;
    }

    @Override
    public IDataPage getDataPage(TreePath treePath) throws ModelException {
        if (this.rdTreeRootReference == null) {
            return this.getDataPage(null, treePath);
        }
        return this.getDataPage(this.rdTreeRootReference.getReferencedDataBook(), treePath);
    }

    private IDataRow getMasterDataRowFromRootDataRow(IDataRow iDataRow) throws ModelException {
        IDataRow iDataRow2 = this.rdMasterReference.getReferencedDataBook().createEmptyRow(this.rdMasterReference.getReferencedColumnNames());
        if (this.rdTreeRootReference != null && iDataRow != null) {
            iDataRow2.setValues(this.saTreeRootMasterColumnNames, iDataRow.getValues(this.rdTreeRootReference.getReferencedColumnNames()));
        }
        return iDataRow2;
    }

    @Override
    public IDataPage getDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataPage iDataPage = this.getDataPageWithRootRow(iDataRow);
        if (treePath != null) {
            for (int i = 0; i < treePath.length(); ++i) {
                IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(treePath.get(i));
                if (iChangeableDataRow == null) {
                    return null;
                }
                iDataPage = this.getDataPageIntern(iChangeableDataRow);
            }
        }
        return iDataPage;
    }

    @Override
    public synchronized IDataPage getDataPageWithRootRow(IDataRow iDataRow) throws ModelException {
        if (this.getMasterReference() == null) {
            this.sync();
            return this.dpCurrentDataPage;
        }
        return this.getDataPageIntern(this.getMasterDataRowFromRootDataRow(iDataRow));
    }

    @Override
    public ReferenceDefinition getRootReference() {
        return this.rdTreeRootReference;
    }

    @Override
    public void setRootReference(ReferenceDefinition referenceDefinition) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.rdTreeRootReference = referenceDefinition;
    }

    @Override
    public TreePath getTreePath() {
        try {
            this.sync();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return this.treePath;
    }

    @Override
    public void setTreePath(TreePath treePath) throws ModelException {
        if (!this.treePath.equals(treePath) || this.bMasterChanged) {
            this.invokeSaveEditingControls();
            this.sync();
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            this.saveDataRowLevel(null);
            if (this.eventBeforeRowSelected != null) {
                this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iChangeableDataRow));
            }
            this.treePath = treePath == null ? new TreePath(new int[0]) : treePath;
            this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
            if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                this.setSelectedRowInternal(-1);
            } else {
                this.setSelectedRowInternal(0);
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
    }

    private void setTreePathInternal(TreePath treePath) throws ModelException {
        if (!this.treePath.equals(treePath) || this.bMasterChanged) {
            this.sync();
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            if (this.eventBeforeRowSelected != null) {
                this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iChangeableDataRow));
            }
            this.treePath = treePath == null ? new TreePath(new int[0]) : treePath;
            this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
            if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                this.setSelectedRowInternal(-1);
            } else {
                this.setSelectedRowInternal(0);
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
    }

    protected boolean isDataPageRefetchPossible() {
        return false;
    }

    @Override
    public void notifyMasterChanged() {
        try {
            MemDataPage memDataPage;
            if (this.rdMasterReference != null && this.rdMasterReference.getReferencedDataBook().getUID() != null && !this.rdMasterReference.getReferencedDataBook().isInserting() && this.dpCurrentDataPage != null && this.rdMasterReference.getReferencedDataBook().getUID() != null && (memDataPage = this.htDataPagesCache.remove(this.rdMasterReference.getReferencedDataBook().getUID())) != null) {
                if (!this.isDataPageRefetchPossible() || memDataPage.getChangedDataRows().length > 0) {
                    IDataRow iDataRow = this.getMasterDataRow(this.rdMasterReference.getReferencedDataBook());
                    memDataPage.setMasterDataRow(iDataRow);
                    this.htDataPagesCache.put(iDataRow, memDataPage);
                } else if (memDataPage == this.dpCurrentDataPage) {
                    this.handleStoreSelection(this.iSelectionMode);
                    this.dpCurrentDataPage = null;
                    this.bMasterChanged = true;
                }
            }
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
        if (!this.bMasterChanged) {
            try {
                this.bMasterChanged = true;
                if (this.eventAfterReload != null) {
                    this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
                }
                this.invokeMasterChangedDetailsListeners();
            }
            catch (ModelException modelException) {
                throw new RuntimeException(modelException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        int n;
        int n2;
        IDataRow iDataRow2 = null;
        IDataPage iDataPage = null;
        if (this.isSelfJoined()) {
            if (treePath == null) {
                treePath = new TreePath(new int[0]);
            }
            IDataBook iDataBook = null;
            if (this.rdTreeRootReference != null) {
                iDataBook = this.rdTreeRootReference.getReferencedDataBook();
            }
            if (!this.hasDataPage(iDataBook, treePath)) return;
            iDataPage = this.getDataPage(iDataBook, treePath);
            iDataRow2 = iDataPage.getMasterDataRow();
            n2 = 0;
            int n3 = iDataPage.getRowCount();
            while (n2 < n3) {
                this.removeDataPage(null, treePath.getChildPath(n2++));
            }
        } else {
            if (!this.hasDataPage(iDataRow)) return;
            iDataPage = this.getDataPage(iDataRow);
            iDataRow2 = iDataPage.getMasterDataRow();
        }
        n2 = iDataPage.getRowCount();
        for (n = 0; n < n2; ++n) {
            IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(n);
            if (this.auDetailDataBooks == null) continue;
            int n4 = this.auDetailDataBooks.size();
            for (int i = 0; i < n4; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.removeDataPage(iChangeableDataRow, null);
            }
        }
        if (iDataRow2 instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow2).getUID() != null) {
            this.htDataPagesCache.remove(((IChangeableDataRow)iDataRow2).getUID());
        } else {
            this.htDataPagesCache.remove(iDataRow2);
        }
        if (this.isSelfJoined() && this.treePath != null && this.treePath.length() > 0 && this.treePath.length() >= treePath.length()) {
            n = 1;
            for (n2 = 0; n != 0 && n2 < this.treePath.length() && n2 < treePath.length(); ++n2) {
                if (this.treePath.get(n2) == treePath.get(n2)) continue;
                n = 0;
            }
            if (n != 0) {
                this.setTreePath(new TreePath(new int[0]));
            }
        }
        if (iDataPage != this.dpCurrentDataPage) return;
        this.dpCurrentDataPage = null;
        this.bMasterChanged = true;
        this.setDetailsChangedInMasterBook();
    }

    @Override
    public IDataBook.SelectionMode getSelectionMode() {
        return this.iSelectionMode;
    }

    @Override
    public void setSelectionMode(IDataBook.SelectionMode selectionMode) {
        this.iSelectionMode = selectionMode;
    }

    @Override
    public boolean isInsertAllowed() {
        return this.bInsertEnabled && !this.isReadonly() && this.dpCurrentDataPage != this.dpEmptyDataPage;
    }

    @Override
    public boolean isInsertEnabled() {
        return this.bInsertEnabled;
    }

    @Override
    public void setInsertEnabled(boolean bl) {
        this.bInsertEnabled = bl;
        this.invokeRepaintListeners();
    }

    @Override
    public boolean isUpdateAllowed() throws ModelException {
        return this.bUpdateEnabled && !this.isReadonly() && this.getSelectedRow() >= 0 && !this.isDeleting();
    }

    @Override
    public boolean isUpdateEnabled() throws ModelException {
        return this.bUpdateEnabled;
    }

    @Override
    public void setUpdateEnabled(boolean bl) {
        this.bUpdateEnabled = bl;
        this.invokeRepaintListeners();
    }

    public boolean isLockAndRefetchEnabled() {
        return this.bLockAndRefetchEnabled;
    }

    public void setLockAndRefetchEnabled(boolean bl) {
        this.bLockAndRefetchEnabled = bl;
    }

    @Override
    public boolean isDeleteAllowed() throws ModelException {
        return this.bDeleteEnabled && !this.isReadonly() && this.getSelectedRow() >= 0;
    }

    @Override
    public boolean isDeleteEnabled() throws ModelException {
        return this.bDeleteEnabled;
    }

    @Override
    public void setDeleteEnabled(boolean bl) {
        this.bDeleteEnabled = bl;
        this.invokeRepaintListeners();
    }

    @Override
    public boolean isReadonly() {
        return this.bReadOnly;
    }

    @Override
    public void setReadOnly(boolean bl) throws ModelException {
        if (this.isOpen() && !this.bReadOnly && bl) {
            this.saveAllRows();
        }
        this.setReadOnlyWithoutSave(bl);
    }

    public int getReadAhead() {
        return this.iReadAheadRowCount;
    }

    public void setReadAhead(int n) {
        if (n >= 0) {
            this.iReadAheadRowCount = n;
        }
    }

    @Override
    public boolean isOpen() {
        return this.bIsOpen;
    }

    @Override
    public synchronized void open() throws ModelException {
        if (!this.isOpen()) {
            Object[] objectArray;
            Object object;
            int n;
            if (this.getName() == null) {
                throw new ModelException("DataBook Name is null!");
            }
            if (this.rdRowDefinition.getColumnCount() == 0) {
                throw new ModelException("RowDefintion in DataBook contains no columns!");
            }
            if (UIFactoryManager.getFactory() != null) {
                int n2 = this.rdRowDefinition.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    object = this.rdRowDefinition.getColumnDefinition(n);
                    objectArray = ((ColumnDefinition)object).getAllowedValues();
                    if (((ColumnDefinition)object).getDataType().getCellEditor() != null || objectArray == null || objectArray.length <= 0) continue;
                    IChoiceCellEditor iChoiceCellEditor = UIChoiceCellEditor.getDefaultChoiceCellEditor(objectArray);
                    if (iChoiceCellEditor != null) {
                        ((ColumnDefinition)object).getDataType().setCellEditor(iChoiceCellEditor);
                        continue;
                    }
                    ColumnDefinition columnDefinition = ((ColumnDefinition)object).clone();
                    columnDefinition.setAllowedValues(null);
                    String string = columnDefinition.getName();
                    MemDataBook memDataBook = new MemDataBook();
                    memDataBook.setName("enum_" + string);
                    memDataBook.getRowDefinition().addColumnDefinition(columnDefinition);
                    memDataBook.open();
                    for (int i = 0; i < objectArray.length; ++i) {
                        memDataBook.insert(false);
                        memDataBook.setValue(string, objectArray[i]);
                    }
                    memDataBook.saveAllRows();
                    ((ColumnDefinition)object).getDataType().setCellEditor(new UILinkedCellEditor(new ReferenceDefinition(new String[]{string}, memDataBook, new String[]{string})));
                }
            }
            object = this.rdRowDefinition.getPrimaryKeyColumnNames();
            for (n = 0; object != null && n < ((String[])object).length; ++n) {
                if (this.rdRowDefinition.getColumnDefinitionIndex((String)object[n]) >= 0) continue;
                throw new ModelException("Primary key column '" + (String)object[n] + "' doesn't exist in RowDefinition of this DataBook!");
            }
            ReferenceDefinition referenceDefinition = this.getMasterReference();
            if (referenceDefinition != null) {
                IDataBook iDataBook = referenceDefinition.getReferencedDataBook();
                if (!this.isSelfJoined() && !iDataBook.isOpen()) {
                    throw new ModelException("The master DataBook has to be opened first! - " + iDataBook.getName());
                }
                objectArray = referenceDefinition.getColumnNames();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.rdRowDefinition.getColumnDefinitionIndex((String)objectArray[i]) >= 0) continue;
                    throw new ModelException("Column '" + (String)objectArray[i] + "' doesn't exist in detail DataBook '" + this.getName() + "' !");
                }
                String[] stringArray = referenceDefinition.getReferencedColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (iDataBook.getRowDefinition().getColumnDefinitionIndex(stringArray[i]) >= 0) continue;
                    throw new ModelException("Column '" + stringArray[i] + "' doesn't exist in master DataBook '" + iDataBook.getName() + "' !");
                }
                if (this.isSelfJoined()) {
                    if (this.getRootReference() != null) {
                        if (this.getRootReference().getReferencedDataBook() == iDataBook) {
                            throw new ModelException("The RootReference DataBook '" + this.getRootReference().getReferencedDataBook().getName() + "' must be != MasterReference DataBook '" + iDataBook.getName() + "' !");
                        }
                        String[] stringArray2 = this.getRootReference().getColumnNames();
                        this.saTreeRootMasterColumnNames = new String[stringArray2.length];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            int n3 = ArrayUtil.indexOf(this.getMasterReference().getColumnNames(), stringArray2[i]);
                            if (n3 < 0) {
                                throw new ModelException("Column name " + stringArray2[i] + " of root reference is not in master reference!");
                            }
                            this.saTreeRootMasterColumnNames[i] = this.getMasterReference().getReferencedColumnNames()[n3];
                        }
                        this.getRootReference().getReferencedDataBook().addDetailDataBook(this);
                    } else {
                        this.saTreeRootMasterColumnNames = null;
                    }
                } else {
                    referenceDefinition.getReferencedDataBook().addDetailDataBook(this);
                    referenceDefinition.setConnected();
                }
            }
            if (this.getDataSource() != null) {
                if (!this.getDataSource().isOpen()) {
                    throw new ModelException("DataSource is not open!");
                }
                this.getDataSource().addDataBook(this);
            }
            this.rdRowDefinition.addDataBook(this);
            this.iSelectedRowIndex = -1;
            this.bMasterChanged = true;
            this.bIsOpen = true;
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            this.bIsOpen = false;
            this.dpCurrentDataPage = null;
            this.htDataPagesCache.clear();
            this.iSelectedRowIndex = -1;
            this.oaStorage = null;
            if (this.getMasterReference() != null) {
                this.getMasterReference().getReferencedDataBook().removeDetailDataBook(this);
            }
            if (this.dsDataSource != null) {
                this.dsDataSource.removeDataBook(this);
            }
            if (this.rdRowDefinition != null) {
                this.rdRowDefinition.removeDataBook(this);
            }
        }
    }

    @Override
    public synchronized int getRowCount() throws ModelException {
        if (this.isOpen()) {
            this.sync();
            return this.dpCurrentDataPage.getRowCount();
        }
        return 0;
    }

    @Override
    public synchronized int getSelectedRow() throws ModelException {
        if (!this.isOpen()) {
            return -1;
        }
        this.sync();
        return this.iSelectedRowIndex;
    }

    @Override
    public synchronized void setSelectedRow(int n) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex != n) {
            this.invokeSaveEditingControls();
            this.sync();
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                this.saveDataRowLevelDetails(null);
            }
            if (this.eventBeforeRowSelected != null) {
                this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iChangeableDataRow));
            }
            this.setSelectedRowInternal(n);
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
    }

    @Override
    public synchronized String getSelectedColumn() throws ModelException {
        return this.sSelectedColumn;
    }

    @Override
    public synchronized void setSelectedColumn(String string) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (string != null) {
            this.rdRowDefinition.getColumnDefinition(string);
        }
        if (this.sSelectedColumn == null && string != null || this.sSelectedColumn != null && !this.sSelectedColumn.equals(string)) {
            if (this.eventBeforeColumnSelected != null) {
                this.eventBeforeColumnSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_COLUMN_SELECTED, null));
            }
            this.sSelectedColumn = string;
            this.invokeRepaintListeners();
            if (this.eventAfterColumnSelected != null) {
                this.eventAfterColumnSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_COLUMN_SELECTED, null));
            }
        }
    }

    @Override
    public boolean isDeleteCascade() {
        return this.bDeleteCascade;
    }

    @Override
    public void setDeleteCascade(boolean bl) {
        this.bDeleteCascade = bl;
    }

    @Override
    public synchronized int insert(boolean bl) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.dpCurrentDataPage == this.dpEmptyDataPage) {
            throw new ModelException("Master DataBook has no selected row! - " + this.getMasterReference().getReferencedDataBook().getName());
        }
        if (!this.isInsertAllowed()) {
            throw new ModelException("Insert isn't allowed!");
        }
        this.invokeSaveEditingControls();
        this.saveDataRowLevel(null);
        this.sync();
        if (!this.dpCurrentDataPage.isAllFetched() && this.dpCurrentDataPage.getRowCount() == 0) {
            this.getDataRow(0);
        }
        IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
        if (this.eventBeforeInserting != null) {
            this.eventBeforeInserting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_INSERTING, null));
        }
        int n = this.insertInternal(bl);
        this.setSelectedRowInternal(n);
        this.copyMasterColumnsToCurrentDetail(false);
        if (this.eventAfterInserting != null) {
            this.eventAfterInserting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_INSERTING, null));
        }
        if (this.eventAfterRowSelected != null) {
            this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
        }
        return n;
    }

    @Override
    public synchronized void update() throws ModelException {
        if (!(this.isUpdating() || this.isInserting() || this.isDeleting())) {
            if (!this.isOpen()) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (!this.isUpdateAllowed()) {
                throw new ModelException("Update isn't allowed!");
            }
            this.saveDataRowLevel(this);
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            if (this.eventBeforeUpdating != null) {
                this.eventBeforeUpdating.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_UPDATING, iChangeableDataRow));
            }
            if (this.isLockAndRefetchEnabled()) {
                this.executeLockAndRefetch();
            }
            this.dpCurrentDataPage.update(this.iSelectedRowIndex);
            this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
            this.setDetailsChangedInMasterBook();
            if (this.eventAfterUpdating != null) {
                this.eventAfterUpdating.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_UPDATING, iChangeableDataRow));
            }
        }
    }

    @Override
    public synchronized void delete() throws ModelException {
        boolean bl;
        boolean bl2;
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            return;
        }
        if (!this.isDeleteAllowed()) {
            throw new ModelException("Delete isn't allowed!");
        }
        IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
        if (this.eventBeforeDeleting != null) {
            this.eventBeforeDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_DELETING, iChangeableDataRow));
        }
        if (bl2 = this.isInserting()) {
            if (this.eventAfterDeleting != null) {
                this.eventAfterDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETING, iChangeableDataRow));
            }
            if (this.eventBeforeRestore != null) {
                this.eventBeforeRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RESTORE, iChangeableDataRow));
            }
        }
        this.restoreSaveAllDetails();
        if (!this.isInserting()) {
            this.restoreSelectedRow();
        } else {
            this.invokeCancelEditingControls();
        }
        if (!this.isInserting() && this.isLockAndRefetchEnabled()) {
            this.executeLockAndRefetch();
        }
        if (bl = this.deleteInternal()) {
            this.correctSelectedRowAfterDelete();
            if (this.eventAfterRestore != null) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iChangeableDataRow));
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
        if (!bl2 && this.eventAfterDeleting != null) {
            this.eventAfterDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETING, iChangeableDataRow));
        }
        if (!bl && IDataBook.WriteBackIsolationLevel.DATA_ROW.equals((Object)this.getWritebackIsolationLevel())) {
            try {
                this.saveSelectedRow();
            }
            catch (ModelException modelException) {
                if (this.isDeleting()) {
                    this.restoreRow();
                }
                throw modelException;
            }
        }
    }

    @Override
    public synchronized void deleteAllDataRows() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        this.fetchAll();
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.setSelectedRow(i);
            this.delete();
        }
    }

    @Override
    public void notifyDetailChanged() {
        try {
            if (this.iSelectedRowIndex < this.dpCurrentDataPage.getRowCount()) {
                boolean bl = false;
                for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                    if (this.auDetailDataBooks.get(i).get() == null) continue;
                    IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                    int[] nArray = iDataBook.getChangedDataRows();
                    if (nArray != null && nArray.length > 0) {
                        bl = true;
                        break;
                    }
                    if (!iDataBook.isSelfJoined()) continue;
                    bl = iDataBook.getDataPage(new TreePath(new int[0])).getChangedDataRows().length > 0;
                }
                this.dpCurrentDataPage.setDetailChanged(this.iSelectedRowIndex, bl);
                this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
            }
            this.setDetailsChangedInMasterBook();
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    @Override
    public synchronized IChangeableDataRow getDataRow(int n) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        if (n < 0) {
            return null;
        }
        this.sync();
        return this.getDataRowInternal(n);
    }

    @Override
    public IDataRow getOriginalRow() throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        return super.getOriginalRow();
    }

    @Override
    public boolean isWritableColumnChanged() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        this.sync();
        return super.isWritableColumnChanged();
    }

    @Override
    public synchronized boolean isDeleting() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.getSelectedRow() < 0) {
            return false;
        }
        return super.isDeleting();
    }

    @Override
    public synchronized boolean isUpdating() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.getSelectedRow() < 0) {
            return false;
        }
        return super.isUpdating();
    }

    @Override
    public synchronized boolean isInserting() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.getSelectedRow() < 0) {
            return false;
        }
        return super.isInserting();
    }

    @Override
    public synchronized boolean isDetailChanged() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        this.sync();
        return super.isDetailChanged();
    }

    @Override
    public Object getUID() throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        return super.getUID();
    }

    @Override
    public ICondition getFilter() {
        return this.cFilter;
    }

    @Override
    public synchronized void setFilter(ICondition iCondition) throws ModelException {
        if (this.isOpen()) {
            if (!this.isMemFilter() || this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                this.saveAllRows();
            } else {
                this.invokeSaveEditingControls();
            }
        }
        this.cFilter = iCondition != null ? iCondition.clone() : null;
        if (this.isOpen()) {
            if (this.isMemFilter()) {
                this.clearFilterSortInMemDataPages();
                this.invokeRepaintListeners();
            } else if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                this.reload();
            } else {
                this.reload(IDataBook.SelectionMode.FIRST_ROW);
            }
        }
    }

    @Override
    public SortDefinition getSort() {
        return this.sSort;
    }

    @Override
    public synchronized void setSort(SortDefinition sortDefinition) throws ModelException {
        if (this.isOpen() && (!this.isMemSort() || this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW)) {
            this.saveAllRows();
        }
        this.sSort = sortDefinition != null ? sortDefinition.clone() : null;
        if (this.isOpen()) {
            if (this.isMemSort()) {
                this.handleStoreSelection(this.iSelectionMode);
                this.clearFilterSortInMemDataPages();
                this.invokeRepaintListeners();
            } else {
                this.reload();
            }
        }
    }

    @Override
    public synchronized void reload() throws ModelException {
        this.reload(this.getSelectionMode());
    }

    @Override
    public synchronized void reload(IDataBook.SelectionMode selectionMode) throws ModelException {
        if (this.isOpen() && !this.ignoreReload) {
            this.handleStoreSelection(selectionMode);
            if (this.eventBeforeReload != null) {
                this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
            }
            if (!this.htDataPagesCache.isEmpty() || this.dpCurrentDataPage != null) {
                this.restoreAllRows();
            }
            this.executeRefresh();
            this.invokeMasterChangedDetailsListeners();
            if (this.eventAfterReload != null) {
                this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
            }
        }
    }

    public synchronized void reloadDataPage(IDataBook.SelectionMode selectionMode) throws ModelException {
        if (this.isOpen()) {
            this.handleStoreSelection(selectionMode);
            if (this.eventBeforeReload != null) {
                this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
            }
            if (!this.htDataPagesCache.isEmpty() || this.dpCurrentDataPage != null) {
                this.restoreDataPageIntern();
            }
            if (!this.isOutOfSync()) {
                this.dpCurrentDataPage.clear();
            }
            if (!this.isOutOfSync()) {
                this.correctSelectedRow();
            }
            this.invokeRepaintListeners();
            this.notifyMasterChanged();
            if (this.eventAfterReload != null) {
                this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
            }
        }
    }

    @Override
    public synchronized void restoreSelectedRow() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.getSelectedRow() < 0) {
            return;
        }
        this.invokeCancelEditingControls();
        if (this.isInserting() || this.isUpdating() || this.isDeleting()) {
            this.restoreRow();
        }
        this.invokeRepaintListeners();
    }

    private synchronized void restoreTopDownAllRows(IDataBook iDataBook, IDataBook iDataBook2) throws ModelException {
        if (iDataBook == iDataBook2) {
            iDataBook.restoreAllRows();
        } else {
            int n;
            int n2;
            int n3;
            int n4 = iDataBook.getSelectedRow();
            IDataBook[] iDataBookArray = iDataBook.getDetailDataBooks();
            ArrayUtil<TreePath> arrayUtil = new ArrayUtil<TreePath>();
            if (iDataBookArray != null) {
                n3 = iDataBookArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (!iDataBookArray[i].isSelfJoined()) continue;
                    arrayUtil.add(iDataBookArray[i].getTreePath());
                }
            }
            int[] nArray = iDataBook.getChangedDataRows();
            int n5 = nArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                iDataBook.setSelectedRow(nArray[n3]);
                if (!iDataBook.isDetailChanged()) continue;
                if (iDataBookArray != null) {
                    n2 = iDataBookArray.length;
                    for (n = 0; n < n2 && iDataBook.isDetailChanged(); ++n) {
                        if (iDataBookArray[n].isSelfJoined()) {
                            iDataBookArray[n].setTreePath(null);
                        }
                        this.restoreTopDownAllRows(iDataBookArray[n], iDataBook2);
                    }
                }
                if (!iDataBook.isSelfJoined() || !iDataBook.isDetailChanged() || !iDataBook.hasDataPage(iDataBook)) continue;
                TreePath treePath = iDataBook.getTreePath();
                iDataBook.setTreePath(treePath.getChildPath(iDataBook.getSelectedRow()));
                this.restoreTopDownAllRows(iDataBook, iDataBook2);
                iDataBook.setTreePath(treePath);
            }
            iDataBook.setSelectedRow(n4);
            if (iDataBookArray != null) {
                n3 = 0;
                n = iDataBookArray.length;
                n2 = arrayUtil.size();
                for (n5 = 0; n5 < n && n3 < n2; ++n5) {
                    if (!iDataBookArray[n5].isSelfJoined()) continue;
                    iDataBookArray[n5].setTreePath((TreePath)arrayUtil.get(n3));
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void restoreAllRows() throws ModelException {
        ArrayUtil<TreePath> arrayUtil;
        int n;
        block16: {
            if (!this.isOpen()) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            if (this.dpCurrentDataPage == null) {
                return;
            }
            this.sync();
            this.invokeCancelEditingControls();
            if (this.getSelectedRow() >= 0 && (this.isInserting() || this.isUpdating() || this.isDeleting())) {
                this.restoreRow();
            }
            n = this.iSelectedRowIndex;
            arrayUtil = this.getAllDetailsTreePath();
            ICondition iCondition = null;
            try {
                if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                    iCondition = this.getFilter();
                    this.setFilter(null);
                }
                this.restoreDataPageIntern();
                if (!this.bRestoreAllRows && this.getMasterReference() != null) {
                    Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
                    boolean bl = false;
                    while (enumeration.hasMoreElements() && !bl) {
                        MemDataPage memDataPage = enumeration.nextElement();
                        if (memDataPage.getChangedDataRows().length <= 0) continue;
                        bl = true;
                    }
                    if (bl) {
                        ReferenceDefinition referenceDefinition;
                        IDataBook iDataBook = this;
                        ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                        while (referenceDefinition != null) {
                            iDataBook = referenceDefinition.getReferencedDataBook();
                            referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                        }
                        TreePath treePath = null;
                        if (iDataBook.isSelfJoined()) {
                            treePath = iDataBook.getTreePath();
                            iDataBook.setTreePath(null);
                        }
                        this.bRestoreAllRows = true;
                        try {
                            this.restoreTopDownAllRows(iDataBook, this);
                            Object var11_10 = null;
                            this.bRestoreAllRows = false;
                        }
                        catch (Throwable throwable) {
                            Object var11_11 = null;
                            this.bRestoreAllRows = false;
                            throw throwable;
                        }
                        if (iDataBook.isSelfJoined() && treePath != null) {
                            iDataBook.setTreePath(treePath);
                        }
                    }
                }
                Object var13_13 = null;
                if (iCondition == null) break block16;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (iCondition != null) {
                    this.setFilter(iCondition);
                }
                throw throwable;
            }
            this.setFilter(iCondition);
        }
        if (this.iSelectedRowIndex != n) {
            this.setSelectedRow(n);
        }
        this.setAllDetailsTreePath(arrayUtil);
        this.invokeRepaintListeners();
    }

    public synchronized void restoreDataPage() throws ModelException {
        int n = this.iSelectedRowIndex;
        ArrayUtil<TreePath> arrayUtil = this.getAllDetailsTreePath();
        this.restoreDataPageIntern();
        if (n >= this.getRowCount()) {
            this.iSelectedRowIndex = n;
            this.correctSelectedRowAfterDelete();
        } else {
            if (this.iSelectedRowIndex != n) {
                this.setSelectedRow(n);
            }
            this.setAllDetailsTreePath(arrayUtil);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void restoreDataPageIntern() throws ModelException {
        int[] nArray = this.dpCurrentDataPage.getChangedDataRows();
        if (nArray.length <= 0) return;
        ICondition iCondition = null;
        try {
            if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                iCondition = this.getFilter();
                this.setFilter(null);
            }
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.setSelectedRow(nArray[i]);
                this.restoreRow();
            }
            Object var5_4 = null;
            if (iCondition == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (iCondition == null) throw throwable;
            this.setFilter(iCondition);
            throw throwable;
        }
        this.setFilter(iCondition);
    }

    @Override
    public synchronized void saveSelectedRow() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        if (this.getSelectedRow() < 0) {
            return;
        }
        this.invokeSaveEditingControls();
        this.sync();
        if (this.isDeleting() || this.isUpdating() || this.isInserting()) {
            ArrayUtil<TreePath> arrayUtil = this.getAllDetailsTreePath();
            this.saveSelectedRowInternIncludeDetails();
            this.setAllDetailsTreePath(arrayUtil);
        }
    }

    private synchronized void saveSelectedRowInternIncludeDetails() throws ModelException {
        this.saveSelectedRowIntern();
        if (this.isSelfJoined()) {
            this.saveSelfJoinedDetailRows();
        }
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.saveAllRows();
            }
        }
    }

    private synchronized void repositionCurrentDataRow() throws ModelException {
        if (this.getSort() != null) {
            int n;
            ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.getRowDefinition(), (Object[])this.oaStorage.clone(), this.dpCurrentDataPage, this.iSelectedRowIndex);
            if (!this.dpCurrentDataPage.delete(this.iSelectedRowIndex) && !this.dpCurrentDataPage.store(this.iSelectedRowIndex)) {
                this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
            }
            int n2 = this.dpCurrentDataPage.getRowCount();
            for (n = 0; n < n2 && this.dpCurrentDataPage.getDataRow(n).compareTo(changeableDataRow, this.sSort) < 0; ++n) {
            }
            this.dpCurrentDataPage.insert(n);
            this.dpCurrentDataPage.setDataRow(n, changeableDataRow);
            this.dpCurrentDataPage.store(n);
            if (this.dpOldCurrentDataPageSaveAllRows == this.dpCurrentDataPage) {
                if (this.iOldSelectedRowSaveAllRows == this.iSelectedRowIndex) {
                    this.iOldSelectedRowSaveAllRows = n;
                } else if (this.iSelectedRowIndex > this.iOldSelectedRowSaveAllRows && n <= this.iOldSelectedRowSaveAllRows) {
                    ++this.iOldSelectedRowSaveAllRows;
                } else if (this.iSelectedRowIndex < this.iOldSelectedRowSaveAllRows && n > this.iOldSelectedRowSaveAllRows) {
                    --this.iOldSelectedRowSaveAllRows;
                }
            }
            this.setSelectedRowInternal(n);
            this.setDetailsChangedInMasterBook();
        }
    }

    private synchronized int addDataRowAtRightPosition(ChangeableDataRow changeableDataRow, MemDataPage memDataPage, int n) throws ModelException {
        boolean bl = true;
        if (this.isDataPageRefetchPossible()) {
            if (this.getFilter() != null && !this.isMemFilter() && !this.getFilter().isFulfilled(changeableDataRow)) {
                bl = false;
            }
            if (bl && this.getSort() != null && !this.isMemSort()) {
                int n2 = memDataPage.getRowCount();
                while (n < n2 && memDataPage.getDataRow(n).compareTo(changeableDataRow, this.sSort) <= 0) {
                    ++n;
                }
            }
        }
        if (bl) {
            int n3;
            memDataPage.insert(n);
            memDataPage.setDataRow(n, changeableDataRow);
            memDataPage.store(n);
            if (this.dpOldCurrentDataPageSaveAllRows == memDataPage && n <= this.iOldSelectedRowSaveAllRows) {
                ++this.iOldSelectedRowSaveAllRows;
            }
            IDataBook iDataBook = null;
            if (this.rdTreeRootReference != null) {
                iDataBook = this.rdTreeRootReference.getReferencedDataBook();
            }
            IDataPage iDataPage = this.getDataPageWithRootRow(iDataBook);
            for (n3 = 0; memDataPage != iDataPage && iDataPage != null && n3 < this.treePath.length() - 1; ++n3) {
                IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(this.treePath.get(n3));
                iDataPage = iChangeableDataRow == null ? null : this.getDataPageIntern(iChangeableDataRow);
            }
            if (memDataPage == iDataPage && n <= this.treePath.get(n3)) {
                this.treePath = this.treePath.set(n3, this.treePath.get(n3) + 1);
            }
        }
        if (!this.isDataPageRefetchPossible()) {
            memDataPage.clear();
            String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
            if (stringArray == null) {
                stringArray = this.rdRowDefinition.getColumnNames();
            }
            n = memDataPage.searchNext(Filter.createEqualsFilter(changeableDataRow, stringArray));
        }
        return n;
    }

    private synchronized void moveDataRowToCorrectMaster() throws ModelException {
        String[] stringArray = this.rdMasterReference.getColumnNames();
        IDataRow iDataRow = this.rdMasterReference.getReferencedDataBook().createEmptyRow(this.getMasterReference().getReferencedColumnNames());
        iDataRow.setValues(this.getMasterReference().getReferencedColumnNames(), this.getValues(stringArray));
        MemDataPage memDataPage = null;
        int n = 0;
        if (this.hasDataPage(iDataRow)) {
            memDataPage = (MemDataPage)this.getDataPage(iDataRow);
            ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.getRowDefinition(), (Object[])this.oaStorage.clone(), memDataPage, n);
            this.addDataRowAtRightPosition(changeableDataRow, memDataPage, 0);
        } else if (!this.isDataPageRefetchPossible()) {
            memDataPage = (MemDataPage)this.getDataPage(iDataRow);
            ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.getRowDefinition(), (Object[])this.oaStorage.clone(), memDataPage, n);
            memDataPage.insert(n);
            memDataPage.setDataRow(n, changeableDataRow);
            memDataPage.store(n);
        }
        if (this.dpOldCurrentDataPageSaveAllRows == this.dpCurrentDataPage && this.iSelectedRowIndex < this.iOldSelectedRowSaveAllRows) {
            --this.iOldSelectedRowSaveAllRows;
        }
        if (!this.dpCurrentDataPage.delete(this.iSelectedRowIndex) && !this.dpCurrentDataPage.store(this.iSelectedRowIndex)) {
            this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
        }
        this.setDetailsChangedInMasterBook();
        this.correctSelectedRowAfterDelete();
    }

    private synchronized void saveSelectedRowIntern() throws ModelException {
        this.sync();
        if (this.isDeleting() || this.isUpdating() || this.isInserting()) {
            if (this.isDeleting()) {
                IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
                if (this.eventBeforeDeleted != null) {
                    this.eventBeforeDeleted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_DELETED, iChangeableDataRow));
                }
                if (this.isSelfJoined() && this.hasDataPage(this)) {
                    if (this.isDeleteCascade()) {
                        TreePath treePath = this.getTreePath();
                        this.setTreePath(treePath.getChildPath(this.iSelectedRowIndex));
                        this.deleteAllDataRows();
                        this.setTreePath(treePath);
                        this.saveSelfJoinedDetailRows();
                    } else if (this.treePath != null) {
                        this.removeDataPage(null, this.treePath.getChildPath(this.getSelectedRow()));
                    } else {
                        this.removeDataPage(null, null);
                    }
                }
                if (this.auDetailDataBooks != null) {
                    int n = this.auDetailDataBooks.size();
                    for (int i = 0; i < n; ++i) {
                        IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                        if (iDataBook == null) continue;
                        if (iDataBook.isDeleteCascade()) {
                            iDataBook.deleteAllDataRows();
                            iDataBook.saveAllRows();
                            continue;
                        }
                        iDataBook.restoreAllRows();
                        iDataBook.removeDataPage(this, null);
                    }
                }
                this.executeDelete();
                this.store();
                this.correctSelectedRowAfterDelete();
                if (this.eventAfterDeleted != null) {
                    this.eventAfterDeleted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETED, iChangeableDataRow));
                }
                if (this.eventAfterRowSelected != null) {
                    this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
                }
            } else if (this.isUpdating()) {
                IDataRow iDataRow = this.getOriginalRow();
                if (this.eventBeforeUpdated != null) {
                    this.eventBeforeUpdated.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_UPDATED, iDataRow));
                }
                if (this.isWritableColumnChanged()) {
                    this.executeUpdate();
                }
                this.store();
                this.invokeMasterChangedDetailsListeners();
                if (this.getMasterReference() != null) {
                    String[] stringArray = this.rdMasterReference.getColumnNames();
                    if (!iDataRow.equals(this, stringArray)) {
                        this.moveDataRowToCorrectMaster();
                    } else {
                        this.repositionCurrentDataRow();
                    }
                } else {
                    this.repositionCurrentDataRow();
                }
                if (this.eventAfterUpdated != null) {
                    this.eventAfterUpdated.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_UPDATED, iDataRow));
                }
            } else if (this.isInserting()) {
                String[] stringArray;
                if (this.eventBeforeInserted != null) {
                    this.eventBeforeInserted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_INSERTED, null));
                }
                if (this.getMasterReference() != null) {
                    String[] stringArray2 = stringArray = this.isSelfJoined() ? this.getRootReference() : this.getMasterReference();
                    if (stringArray != null && stringArray.getReferencedDataBook().isInserting()) {
                        IDataBook iDataBook = stringArray.getReferencedDataBook();
                        if (iDataBook instanceof MemDataBook) {
                            ((MemDataBook)stringArray.getReferencedDataBook()).saveSelectedRowIntern();
                        } else {
                            ((MemDataBook)stringArray.getReferencedDataBook()).saveSelectedRowIntern();
                        }
                        this.syncDetails();
                    }
                }
                if (this.isSelfJoined()) {
                    stringArray = this.getTreePath();
                    int n = this.iSelectedRowIndex;
                    if (stringArray != null && stringArray.length() > 0) {
                        this.setTreePathInternal(stringArray.getParentPath());
                        this.setSelectedRow(stringArray.getLast());
                        this.saveSelectedRowIntern();
                        this.setTreePathInternal((TreePath)stringArray);
                        this.setSelectedRowInternal(n);
                    }
                }
                this.copyMasterColumnsToCurrentDetail(true);
                this.executeInsert();
                this.store();
                if (this.isSelfJoined() && this.hasDataPage(this)) {
                    this.notifyMasterChanged();
                }
                this.invokeMasterChangedDetailsListeners();
                this.setUID(null);
                if (this.getMasterReference() != null) {
                    boolean bl;
                    stringArray = this.rdMasterReference.getColumnNames();
                    IDataRow iDataRow = this.createDataRow(stringArray);
                    IDataRow iDataRow2 = this.createDataRow(stringArray);
                    iDataRow2.setValues(stringArray, this.dpCurrentDataPage.getMasterDataRow().getValues(this.rdMasterReference.getReferencedColumnNames()));
                    boolean bl2 = bl = iDataRow2.compareTo(iDataRow) == 0;
                    if (!bl) {
                        this.moveDataRowToCorrectMaster();
                    } else {
                        this.repositionCurrentDataRow();
                    }
                } else {
                    this.repositionCurrentDataRow();
                }
                if (this.eventAfterInserted != null) {
                    this.eventAfterInserted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_INSERTED, null));
                }
            }
        }
    }

    private synchronized void saveSelfJoinedDetailRows() throws ModelException {
        if (this.isSelfJoined() && this.hasDataPage(this) && this.iSelectedRowIndex >= 0) {
            TreePath treePath = this.getTreePath();
            int n = this.iSelectedRowIndex;
            if (this.isDetailChanged()) {
                this.setTreePathInternal(treePath.getChildPath(this.iSelectedRowIndex));
                this.saveDataPageIntern();
                this.setTreePathInternal(treePath);
                if (n != this.iSelectedRowIndex) {
                    this.setSelectedRow(n);
                }
            }
        }
    }

    @Override
    public synchronized void saveDataPage() throws ModelException {
        int n = this.iSelectedRowIndex;
        ArrayUtil<TreePath> arrayUtil = this.getAllDetailsTreePath();
        this.saveDataPageIntern();
        if (n >= this.getRowCount()) {
            this.iSelectedRowIndex = n;
            this.correctSelectedRowAfterDelete();
        } else {
            if (this.iSelectedRowIndex != n) {
                this.setSelectedRow(n);
            }
            this.setAllDetailsTreePath(arrayUtil);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void saveDataPageIntern() throws ModelException {
        int[] nArray = this.dpCurrentDataPage.getChangedDataRows();
        if (nArray.length <= 0) return;
        ICondition iCondition = null;
        try {
            int n;
            if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                iCondition = this.getFilter();
                this.setFilter(null);
            }
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                if (!this.getDataRow(nArray[n]).isDeleting()) continue;
                this.setSelectedRow(nArray[n]);
                this.saveSelectedRowInternIncludeDetails();
            }
            nArray = this.dpCurrentDataPage.getChangedDataRows();
            for (n = nArray.length - 1; n >= 0; --n) {
                if (!this.getDataRow(nArray[n]).isUpdating()) continue;
                this.setSelectedRow(nArray[n]);
                this.saveSelectedRowInternIncludeDetails();
                nArray = this.dpCurrentDataPage.getChangedDataRows();
                if (n <= nArray.length) continue;
                n = nArray.length;
            }
            nArray = this.dpCurrentDataPage.getChangedDataRows();
            for (n = nArray.length - 1; n >= 0; --n) {
                if (!this.getDataRow(nArray[n]).isInserting()) continue;
                this.setSelectedRow(nArray[n]);
                this.saveSelectedRowInternIncludeDetails();
                nArray = this.dpCurrentDataPage.getChangedDataRows();
                if (n <= nArray.length) continue;
                n = nArray.length;
            }
            Object var5_4 = null;
            if (iCondition == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (iCondition == null) throw throwable;
            this.setFilter(iCondition);
            throw throwable;
        }
        this.setFilter(iCondition);
    }

    private synchronized void saveTopDownAllRows(IDataBook iDataBook, IDataBook iDataBook2) throws ModelException {
        if (iDataBook == iDataBook2) {
            iDataBook.saveAllRows();
        } else {
            int n;
            int n2;
            int n3;
            int n4 = iDataBook.getSelectedRow();
            IDataBook[] iDataBookArray = iDataBook.getDetailDataBooks();
            ArrayUtil<TreePath> arrayUtil = new ArrayUtil<TreePath>();
            if (iDataBookArray != null) {
                n3 = iDataBookArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (!iDataBookArray[i].isSelfJoined()) continue;
                    arrayUtil.add(iDataBookArray[i].getTreePath());
                }
            }
            int[] nArray = iDataBook.getChangedDataRows();
            int n5 = nArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                iDataBook.setSelectedRow(nArray[n3]);
                if (!iDataBook.isDetailChanged()) continue;
                if (iDataBookArray != null) {
                    n2 = iDataBookArray.length;
                    for (n = 0; n < n2 && iDataBook.isDetailChanged(); ++n) {
                        if (iDataBookArray[n].isSelfJoined()) {
                            iDataBookArray[n].setTreePath(null);
                        }
                        this.saveTopDownAllRows(iDataBookArray[n], iDataBook2);
                    }
                }
                if (!iDataBook.isSelfJoined() || !iDataBook.isDetailChanged() || !iDataBook.hasDataPage(iDataBook)) continue;
                TreePath treePath = iDataBook.getTreePath();
                iDataBook.setTreePath(treePath.getChildPath(iDataBook.getSelectedRow()));
                this.saveTopDownAllRows(iDataBook, iDataBook2);
                iDataBook.setTreePath(treePath);
            }
            iDataBook.setSelectedRow(n4);
            if (iDataBookArray != null) {
                n3 = 0;
                n = iDataBookArray.length;
                n2 = arrayUtil.size();
                for (n5 = 0; n5 < n && n3 < n2; ++n5) {
                    if (!iDataBookArray[n5].isSelfJoined()) continue;
                    iDataBookArray[n5].setTreePath((TreePath)arrayUtil.get(n3));
                    ++n3;
                }
            }
        }
    }

    private ArrayUtil<TreePath> getAllDetailsTreePath() {
        ArrayUtil<TreePath> arrayUtil = new ArrayUtil<TreePath>();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                if (!((IDataBook)this.auDetailDataBooks.get(i).get()).isSelfJoined()) continue;
                arrayUtil.add(((IDataBook)this.auDetailDataBooks.get(i).get()).getTreePath());
            }
        }
        return arrayUtil;
    }

    private void setAllDetailsTreePath(ArrayUtil<TreePath> arrayUtil) throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = 0;
            int n2 = this.auDetailDataBooks.size();
            int n3 = arrayUtil.size();
            for (int i = 0; i < n2 && n < n3; ++i) {
                if (!((IDataBook)this.auDetailDataBooks.get(i).get()).isSelfJoined()) continue;
                ((IDataBook)this.auDetailDataBooks.get(i).get()).setTreePath(arrayUtil.get(n));
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void saveAllRows() throws ModelException {
        ArrayUtil<TreePath> arrayUtil;
        block20: {
            if (!this.isOpen()) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            if (this.htDataPagesCache.isEmpty() && this.dpCurrentDataPage == null) {
                return;
            }
            this.invokeSaveEditingControls();
            this.sync();
            if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                this.saveSelectedRow();
                return;
            }
            this.iOldSelectedRowSaveAllRows = this.iSelectedRowIndex;
            this.dpOldCurrentDataPageSaveAllRows = this.dpCurrentDataPage;
            arrayUtil = this.getAllDetailsTreePath();
            ICondition iCondition = null;
            try {
                int n;
                Object object;
                if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                    iCondition = this.getFilter();
                    this.setFilter(null);
                }
                this.saveDataPageIntern();
                if (this.isSelfJoined()) {
                    object = this.getTreePath();
                    if (object != null && ((TreePath)object).length() > 0) {
                        this.setTreePathInternal(null);
                    }
                    n = this.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        this.setSelectedRow(i);
                        this.saveSelfJoinedDetailRows();
                    }
                    if (object != null && ((TreePath)object).length() > 0) {
                        this.setTreePathInternal((TreePath)object);
                    }
                }
                if (!this.bSaveAllRows && this.getMasterReference() != null) {
                    object = this.htDataPagesCache.elements();
                    n = 0;
                    while (object.hasMoreElements() && n == 0) {
                        MemDataPage memDataPage = (MemDataPage)object.nextElement();
                        if (memDataPage.getChangedDataRows().length <= 0) continue;
                        n = 1;
                    }
                    if (n != 0) {
                        ReferenceDefinition referenceDefinition;
                        IDataBook iDataBook = this;
                        ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                        while (referenceDefinition != null) {
                            iDataBook = referenceDefinition.getReferencedDataBook();
                            referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                        }
                        TreePath treePath = null;
                        if (iDataBook.isSelfJoined()) {
                            treePath = iDataBook.getTreePath();
                            iDataBook.setTreePath(null);
                        }
                        this.bSaveAllRows = true;
                        try {
                            this.saveTopDownAllRows(iDataBook, this);
                            Object var10_10 = null;
                            this.bSaveAllRows = false;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            this.bSaveAllRows = false;
                            throw throwable;
                        }
                        if (iDataBook.isSelfJoined() && treePath != null) {
                            iDataBook.setTreePath(treePath);
                        }
                    }
                }
                Object var12_13 = null;
                if (iCondition == null) break block20;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (iCondition == null) throw throwable;
                this.setFilter(iCondition);
                throw throwable;
            }
            this.setFilter(iCondition);
        }
        if (this.iOldSelectedRowSaveAllRows >= this.getRowCount()) {
            this.iSelectedRowIndex = this.iOldSelectedRowSaveAllRows;
            this.correctSelectedRowAfterDelete();
            return;
        }
        if (this.iSelectedRowIndex != this.iOldSelectedRowSaveAllRows) {
            this.setSelectedRow(this.iOldSelectedRowSaveAllRows);
        }
        this.setAllDetailsTreePath(arrayUtil);
    }

    @Override
    public synchronized boolean isOutOfSync() {
        return this.dpCurrentDataPage == null || this.rdMasterReference != null && this.bMasterChanged;
    }

    @Override
    public synchronized boolean isAllFetched() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        return this.dpCurrentDataPage.isAllFetched();
    }

    @Override
    public synchronized void fetchAll() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.dpCurrentDataPage == this.dpEmptyDataPage) {
            return;
        }
        this.dpCurrentDataPage.fetchAll();
    }

    @Override
    public synchronized IDataRow getMasterDataRow() throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        return this.dpCurrentDataPage.getMasterDataRow();
    }

    @Override
    public void addDetailDataBook(IDataBook iDataBook) {
        if (this.auDetailDataBooks == null) {
            this.auDetailDataBooks = new ArrayUtil();
        } else {
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                if (this.auDetailDataBooks.get(i).get() != null) continue;
                this.auDetailDataBooks.remove(i);
            }
        }
        this.auDetailDataBooks.add(new WeakReference<IDataBook>(iDataBook));
    }

    @Override
    public void removeDetailDataBook(IDataBook iDataBook) {
        if (this.auDetailDataBooks != null) {
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 != null && iDataBook2 != iDataBook) continue;
                this.auDetailDataBooks.remove(i);
            }
        }
    }

    @Override
    public IDataBook[] getDetailDataBooks() {
        ArrayUtil<IDataBook> arrayUtil = new ArrayUtil<IDataBook>();
        if (this.auDetailDataBooks != null) {
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) {
                    this.auDetailDataBooks.remove(i);
                    continue;
                }
                arrayUtil.add(0, iDataBook);
            }
        }
        return arrayUtil.toArray(new IDataBook[arrayUtil.size()]);
    }

    public synchronized int[] getOnlyIUDChangedDataRows() throws ModelException {
        int[] nArray = this.getChangedDataRows();
        int n = 0;
        while (nArray != null && n < nArray.length) {
            IChangeableDataRow iChangeableDataRow = this.getDataRow(nArray[n]);
            if (!(iChangeableDataRow.isDeleting() || iChangeableDataRow.isUpdating() || iChangeableDataRow.isInserting())) {
                nArray = ArrayUtil.remove(nArray, n);
                continue;
            }
            ++n;
        }
        if (nArray == null) {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public synchronized int[] getChangedDataRows() throws ModelException {
        IDataBook iDataBook;
        IDataRow iDataRow;
        if (!this.isOpen()) {
            return null;
        }
        if (this.dpCurrentDataPage == null) {
            return null;
        }
        if (this.getMasterReference() != null && !this.isSelfJoined() && this.htDataPagesCache.get(iDataRow = this.getMasterDataRow(iDataBook = this.getMasterReference().getReferencedDataBook())) == null) {
            if (iDataBook.getUID() != null) {
                if (this.htDataPagesCache.get(iDataBook.getUID()) == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        this.sync();
        return this.dpCurrentDataPage.getChangedDataRows();
    }

    @Override
    public synchronized IDataPage getDataPage(IDataRow iDataRow) throws ModelException {
        if (this.getMasterReference() == null) {
            this.sync();
            return this.dpCurrentDataPage;
        }
        return this.getDataPageIntern(iDataRow);
    }

    @Override
    public synchronized boolean hasDataPage(IDataRow iDataRow) throws ModelException {
        if (this.getMasterReference() == null) {
            return iDataRow == null;
        }
        IDataRow iDataRow2 = this.getMasterDataRow(iDataRow);
        MemDataPage memDataPage = this.htDataPagesCache.get(iDataRow2);
        if (memDataPage == null && iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
            memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow).getUID());
        }
        return memDataPage != null;
    }

    public synchronized boolean hasDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataRow iDataRow2 = this.getMasterDataRowFromRootDataRow(iDataRow);
        MemDataPage memDataPage = this.htDataPagesCache.get(iDataRow2);
        if (memDataPage == null && iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
            memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow).getUID());
        }
        if (treePath == null) {
            return memDataPage != null;
        }
        for (int i = 0; i < treePath.length(); ++i) {
            int n = treePath.get(i);
            if (n < memDataPage.getRowCount()) {
                iDataRow2 = this.getMasterDataRow(memDataPage.getDataRow(n));
                if ((memDataPage = this.htDataPagesCache.get(iDataRow2)) == null && iDataRow2 instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow2).getUID() != null) {
                    memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow2).getUID());
                }
                if (memDataPage != null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public DataBookHandler eventBeforeRowSelected() {
        if (this.eventBeforeRowSelected == null) {
            this.eventBeforeRowSelected = new DataBookHandler();
        }
        return this.eventBeforeRowSelected;
    }

    @Override
    public DataBookHandler eventAfterRowSelected() {
        if (this.eventAfterRowSelected == null) {
            this.eventAfterRowSelected = new DataBookHandler();
        }
        return this.eventAfterRowSelected;
    }

    @Override
    public DataBookHandler eventBeforeInserting() {
        if (this.eventBeforeInserting == null) {
            this.eventBeforeInserting = new DataBookHandler();
        }
        return this.eventBeforeInserting;
    }

    @Override
    public DataBookHandler eventAfterInserting() {
        if (this.eventAfterInserting == null) {
            this.eventAfterInserting = new DataBookHandler();
        }
        return this.eventAfterInserting;
    }

    @Override
    public DataBookHandler eventBeforeInserted() {
        if (this.eventBeforeInserted == null) {
            this.eventBeforeInserted = new DataBookHandler();
        }
        return this.eventBeforeInserted;
    }

    @Override
    public DataBookHandler eventAfterInserted() {
        if (this.eventAfterInserted == null) {
            this.eventAfterInserted = new DataBookHandler();
        }
        return this.eventAfterInserted;
    }

    @Override
    public DataBookHandler eventBeforeUpdating() {
        if (this.eventBeforeUpdating == null) {
            this.eventBeforeUpdating = new DataBookHandler();
        }
        return this.eventBeforeUpdating;
    }

    @Override
    public DataBookHandler eventAfterUpdating() {
        if (this.eventAfterUpdating == null) {
            this.eventAfterUpdating = new DataBookHandler();
        }
        return this.eventAfterUpdating;
    }

    @Override
    public DataBookHandler eventBeforeUpdated() {
        if (this.eventBeforeUpdated == null) {
            this.eventBeforeUpdated = new DataBookHandler();
        }
        return this.eventBeforeUpdated;
    }

    @Override
    public DataBookHandler eventAfterUpdated() {
        if (this.eventAfterUpdated == null) {
            this.eventAfterUpdated = new DataBookHandler();
        }
        return this.eventAfterUpdated;
    }

    @Override
    public DataBookHandler eventBeforeDeleting() {
        if (this.eventBeforeDeleting == null) {
            this.eventBeforeDeleting = new DataBookHandler();
        }
        return this.eventBeforeDeleting;
    }

    @Override
    public DataBookHandler eventAfterDeleting() {
        if (this.eventAfterDeleting == null) {
            this.eventAfterDeleting = new DataBookHandler();
        }
        return this.eventAfterDeleting;
    }

    @Override
    public DataBookHandler eventBeforeDeleted() {
        if (this.eventBeforeDeleted == null) {
            this.eventBeforeDeleted = new DataBookHandler();
        }
        return this.eventBeforeDeleted;
    }

    @Override
    public DataBookHandler eventAfterDeleted() {
        if (this.eventAfterDeleted == null) {
            this.eventAfterDeleted = new DataBookHandler();
        }
        return this.eventAfterDeleted;
    }

    @Override
    public DataBookHandler eventBeforeRestore() {
        if (this.eventBeforeRestore == null) {
            this.eventBeforeRestore = new DataBookHandler();
        }
        return this.eventBeforeRestore;
    }

    @Override
    public DataBookHandler eventAfterRestore() {
        if (this.eventAfterRestore == null) {
            this.eventAfterRestore = new DataBookHandler();
        }
        return this.eventAfterRestore;
    }

    @Override
    public DataBookHandler eventBeforeReload() {
        if (this.eventBeforeReload == null) {
            this.eventBeforeReload = new DataBookHandler();
        }
        return this.eventBeforeReload;
    }

    @Override
    public DataBookHandler eventAfterReload() {
        if (this.eventAfterReload == null) {
            this.eventAfterReload = new DataBookHandler();
        }
        return this.eventAfterReload;
    }

    @Override
    public DataBookHandler eventBeforeColumnSelected() {
        if (this.eventBeforeColumnSelected == null) {
            this.eventBeforeColumnSelected = new DataBookHandler();
        }
        return this.eventBeforeColumnSelected;
    }

    @Override
    public DataBookHandler eventAfterColumnSelected() {
        if (this.eventAfterColumnSelected == null) {
            this.eventAfterColumnSelected = new DataBookHandler();
        }
        return this.eventAfterColumnSelected;
    }

    @Override
    public int searchNext(ICondition iCondition) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchNext(iCondition);
    }

    @Override
    public int searchNext(ICondition iCondition, int n) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchNext(iCondition, n);
    }

    @Override
    public int searchPrevious(ICondition iCondition) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchPrevious(iCondition);
    }

    @Override
    public int searchPrevious(ICondition iCondition, int n) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchPrevious(iCondition, n);
    }

    @Override
    public int getRowIndex() {
        try {
            this.sync();
            return this.iSelectedRowIndex;
        }
        catch (ModelException modelException) {
            return -1;
        }
    }

    @Override
    public IDataPage getDataPage() {
        try {
            this.sync();
            return this.dpCurrentDataPage;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    @Override
    public synchronized Object getValue(String string) throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            return null;
        }
        return super.getValue(string);
    }

    @Override
    public synchronized void setValue(String string, Object object) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            throw new ModelException("No selected row!");
        }
        if (this.isDeleting()) {
            throw new ModelException("Row is already deleted!");
        }
        this.update();
        super.setValue(string, object);
    }

    @Override
    public synchronized Object[] getValues(String[] stringArray) throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            return null;
        }
        return super.getValues(stringArray);
    }

    @Override
    public synchronized void setValues(String[] stringArray, Object[] objectArray) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            throw new ModelException("No selected row!");
        }
        if (this.isDeleting()) {
            throw new ModelException("Row is already deleted!");
        }
        this.update();
        if (stringArray == null) {
            stringArray = this.rdRowDefinition.getColumnNames();
        }
        super.setValues(stringArray, objectArray);
    }

    @Override
    public synchronized String toString() {
        IDataPage iDataPage;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Class           = ");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("\nName            = ");
        stringBuilder.append(this.sName);
        stringBuilder.append("\nisOpen          = ");
        stringBuilder.append(this.isOpen());
        if (this.rdRowDefinition != null) {
            stringBuilder.append("\nRowDefinition   = ");
            stringBuilder.append(this.rdRowDefinition);
        }
        if (this.rdMasterReference != null) {
            stringBuilder.append("\nMasterReference = ");
            stringBuilder.append(this.rdMasterReference);
        }
        if (this.cFilter != null) {
            stringBuilder.append("\nFilter          = ");
            stringBuilder.append(this.cFilter);
        }
        if (this.sSort != null) {
            stringBuilder.append("\nSortDefinition  = ");
            stringBuilder.append(this.sSort);
        }
        if (this.auDetailDataBooks != null && this.auDetailDataBooks.size() > 0) {
            stringBuilder.append("\nDetailBooks     = [");
            int n2 = 0;
            n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                iDataPage = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataPage == null) continue;
                if (n2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(iDataPage.getName());
                ++n2;
            }
            stringBuilder.append("]");
        }
        if (this.isOpen()) {
            try {
                this.sync();
            }
            catch (ModelException modelException) {
                stringBuilder.append("\n");
                stringBuilder.append(CommonUtil.dump(modelException, true));
                return stringBuilder.toString();
            }
            if (this.treePath != null && this.treePath.length() > 0) {
                stringBuilder.append("\nTreePath        = ");
                stringBuilder.append(this.treePath);
            }
            stringBuilder.append("\nSelectedRow     = ");
            stringBuilder.append(this.iSelectedRowIndex);
            stringBuilder.append("\n\n== CURRENT DataPage ==\n\n");
            stringBuilder.append(this.dpCurrentDataPage);
            Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
            Enumeration<Object> enumeration2 = this.htDataPagesCache.keys();
            n = 1;
            while (enumeration.hasMoreElements()) {
                if (n != 0) {
                    stringBuilder.append("\n\n== DataPage CACHE ==\n");
                    n = 0;
                }
                stringBuilder.append("\n");
                iDataPage = enumeration.nextElement();
                Object object = enumeration2.nextElement();
                stringBuilder.append("Key      = ");
                stringBuilder.append(object);
                if (iDataPage != this.dpCurrentDataPage) {
                    stringBuilder.append(", Class = ");
                    stringBuilder.append(object.getClass().getName());
                    stringBuilder.append("\n");
                    stringBuilder.append(((MemDataPage)iDataPage).toString("           "));
                    continue;
                }
                stringBuilder.append(" => (CURRENT DataPage)");
                stringBuilder.append(", Class = ");
                stringBuilder.append(object.getClass().getName());
            }
        }
        return stringBuilder.toString();
    }

    protected MemDataPage createDataPage(IDataRow iDataRow) {
        return new MemDataPage(this, iDataRow);
    }

    protected boolean isMemSort() {
        return this.bMemSort;
    }

    protected void setMemSort(boolean bl) {
        this.bMemSort = bl;
    }

    protected boolean isMemFilter() {
        return this.bMemFilter;
    }

    protected void setMemFilter(boolean bl) {
        this.bMemFilter = bl;
    }

    protected boolean isWritebackEnabled() {
        return this.bWritebackEnabled;
    }

    protected void setWritebackEnabled(boolean bl) {
        this.bWritebackEnabled = bl;
    }

    private ArrayUtil<IDataRow> getStoredSelection() {
        return this.auStoredSelection;
    }

    private void setStoredSelection(IDataRow iDataRow) throws ModelException {
        if (iDataRow == null) {
            this.auStoredSelection.clear();
            return;
        }
        this.auStoredSelection.add(iDataRow);
        if (this.isSelfJoined() && this.treePath != null) {
            String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
            if (stringArray == null) {
                stringArray = this.rdRowDefinition.getColumnNames();
            }
            TreePath treePath = this.treePath;
            for (int i = treePath.length() - 1; i >= 0; --i) {
                this.setTreePath(treePath.getParentPath());
                if (stringArray == null || stringArray.length <= 0) continue;
                this.auStoredSelection.add(this.getDataRow(treePath.get(i)).createDataRow(stringArray));
            }
        }
    }

    public synchronized int getEstimatedRowCount() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        return this.dpCurrentDataPage.getEstimatedRowCount();
    }

    protected void executeInsert() throws ModelException {
    }

    protected void executeUpdate() throws ModelException {
    }

    protected void executeDelete() throws ModelException {
    }

    protected void executeLockAndRefetch() throws ModelException {
    }

    private void invokeMasterChangedDetailsListeners() {
        this.invokeRepaintListeners();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.notifyMasterChanged();
            }
        }
    }

    private void syncDetails() throws ModelException {
        this.sync();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.getSelectedRow();
            }
        }
    }

    private IDataRow getMasterDataRow(IDataRow iDataRow) throws ModelException {
        return iDataRow.createDataRow(this.getMasterReference().getReferencedColumnNames());
    }

    private MemDataPage getDataPageIntern(IDataRow iDataRow) throws ModelException {
        Object object;
        MemDataPage memDataPage = null;
        if (iDataRow instanceof ChangeableDataRow && (object = ((ChangeableDataRow)iDataRow).getUID()) != null && (memDataPage = this.htDataPagesCache.get(object)) != null) {
            return memDataPage;
        }
        object = this.getMasterDataRow(iDataRow);
        memDataPage = this.htDataPagesCache.get(object);
        if (memDataPage == null) {
            IChangeableDataRow iChangeableDataRow = null;
            if (iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
                iChangeableDataRow = (IChangeableDataRow)iDataRow;
                memDataPage = this.htDataPagesCache.get(iChangeableDataRow.getUID());
            }
            if (memDataPage == null) {
                memDataPage = this.createDataPage((IDataRow)object);
                if (iChangeableDataRow != null && iChangeableDataRow.getUID() != null) {
                    ReferenceDefinition referenceDefinition = this.getMasterReference();
                    if (referenceDefinition != null && referenceDefinition.getReferencedDataBook().getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATASOURCE) {
                        memDataPage.setAllFetched(true);
                    }
                    this.htDataPagesCache.put(iChangeableDataRow.getUID(), memDataPage);
                } else {
                    this.htDataPagesCache.put(object, memDataPage);
                }
            }
        }
        return memDataPage;
    }

    private synchronized IChangeableDataRow getDataRowInternal(int n) throws ModelException {
        if (n < 0 || this.dpCurrentDataPage == this.dpEmptyDataPage) {
            return null;
        }
        return this.dpCurrentDataPage.getDataRow(n);
    }

    private void correctSelectedRow() throws ModelException {
        ArrayUtil<IDataRow> arrayUtil = this.getStoredSelection();
        if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
            this.setSelectedRowInternal(-1);
        } else if (this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW && arrayUtil != null && arrayUtil.size() > 0) {
            if (arrayUtil.size() > 0 && arrayUtil.get(0) == this) {
                this.setSelectedRowInternal(-1);
            } else {
                String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
                if (stringArray == null) {
                    stringArray = this.rdRowDefinition.getColumnNames();
                }
                if (this.isSelfJoined() && arrayUtil.size() > 0) {
                    this.setTreePath(null);
                }
                int n = 0;
                IChangeableDataRow iChangeableDataRow = this.getDataRow(n);
                for (int i = arrayUtil.size() - 1; i >= 0; --i) {
                    IDataRow iDataRow = arrayUtil.get(i);
                    while (iChangeableDataRow != null && !iDataRow.equals(iChangeableDataRow, stringArray)) {
                        iChangeableDataRow = this.getDataRow(++n);
                    }
                    if (iChangeableDataRow == null) {
                        n = 0;
                    }
                    this.setSelectedRowInternal(n);
                    if (this.isSelfJoined() && i - 1 >= 0) {
                        this.setTreePath(this.getTreePath().getChildPath(n));
                    }
                    n = 0;
                    iChangeableDataRow = this.getDataRow(n);
                }
            }
        } else {
            this.setSelectedRowInternal(0);
        }
        this.setStoredSelection(null);
        if (this.eventAfterRowSelected != null) {
            this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, null));
        }
    }

    private void correctSelectedRowAfterDelete() throws ModelException {
        int n = this.iSelectedRowIndex;
        if (this.iSelectedRowIndex >= this.getRowCount()) {
            n = this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED ? -1 : this.getRowCount() - 1;
        }
        this.setSelectedRowInternal(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() throws ModelException {
        if (this.dpEmptyDataPage == null) {
            this.dpEmptyDataPage = new MemDataPage(null, null);
        }
        if (this.rdMasterReference == null) {
            if (this.dpCurrentDataPage == null) {
                this.ignoreReload = true;
                try {
                    this.dpCurrentDataPage = this.dpEmptyDataPage;
                    this.iSelectedRowIndex = -1;
                    this.dpCurrentDataPage = this.createDataPage(null);
                    this.correctSelectedRow();
                    Object var2_1 = null;
                    this.ignoreReload = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.ignoreReload = false;
                    throw throwable;
                }
            }
        } else if (this.bMasterChanged) {
            this.bMasterChanged = false;
            this.ignoreReload = true;
            try {
                ReferenceDefinition referenceDefinition;
                if (this.dpCurrentDataPage == null) {
                    this.dpCurrentDataPage = this.dpEmptyDataPage;
                    this.iSelectedRowIndex = -1;
                    this.treePath = new TreePath(new int[0]);
                }
                ReferenceDefinition referenceDefinition2 = referenceDefinition = this.isSelfJoined() ? this.getRootReference() : this.getMasterReference();
                if (referenceDefinition != null && referenceDefinition.getReferencedDataBook().getSelectedRow() < 0) {
                    if (this.dpCurrentDataPage != this.dpEmptyDataPage) {
                        this.dpCurrentDataPage = this.dpEmptyDataPage;
                        this.iSelectedRowIndex = -1;
                        this.treePath = new TreePath(new int[0]);
                        this.setSelectedRowInternal(-1);
                    }
                } else if (this.isSelfJoined()) {
                    IDataPage iDataPage;
                    if (this.dpCurrentDataPage != this.dpEmptyDataPage && referenceDefinition != null && !this.getMasterDataRowFromRootDataRow(referenceDefinition.getReferencedDataBook()).equals(this.dpCurrentDataPage.getMasterDataRow(), this.saTreeRootMasterColumnNames)) {
                        this.treePath = new TreePath(new int[0]);
                    }
                    if ((iDataPage = this.getDataPage(this.treePath)) == null) {
                        this.treePath = new TreePath(new int[0]);
                        iDataPage = this.getDataPage(this.treePath);
                    }
                    if (iDataPage != this.dpCurrentDataPage) {
                        this.dpCurrentDataPage = (MemDataPage)iDataPage;
                        this.iSelectedRowIndex = -1;
                        if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                            this.setSelectedRowInternal(-1);
                        } else {
                            this.setSelectedRowInternal(0);
                        }
                    }
                } else {
                    MemDataPage memDataPage = this.getDataPageIntern(this.getMasterReference().getReferencedDataBook());
                    if (memDataPage != this.dpCurrentDataPage) {
                        this.dpCurrentDataPage = memDataPage;
                        this.iSelectedRowIndex = -1;
                        this.treePath = new TreePath(new int[0]);
                        this.correctSelectedRow();
                    }
                }
                Object var4_7 = null;
                this.ignoreReload = false;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.ignoreReload = false;
                throw throwable;
            }
        }
    }

    protected void executeRefresh() throws ModelException {
        this.clearFilterSortInMemDataPages();
        this.invokeRepaintListeners();
    }

    protected void clear() {
        this.dpCurrentDataPage = null;
        this.bMasterChanged = true;
        this.htDataPagesCache.clear();
        this.iSelectedRowIndex = -1;
        this.oaStorage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setSelectedRowInternal(int n) throws ModelException {
        block4: {
            block3: {
                IChangeableDataRow iChangeableDataRow = null;
                try {
                    iChangeableDataRow = this.getDataRow(n);
                    Object var4_3 = null;
                    if (iChangeableDataRow == null) break block3;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (iChangeableDataRow != null) {
                        this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(n);
                        this.iSelectedRowIndex = n;
                        throw throwable;
                    }
                    this.oaStorage = new Object[this.rdRowDefinition.getColumnCount()];
                    this.iSelectedRowIndex = -1;
                    throw throwable;
                }
                this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(n);
                this.iSelectedRowIndex = n;
                break block4;
            }
            this.oaStorage = new Object[this.rdRowDefinition.getColumnCount()];
            this.iSelectedRowIndex = -1;
        }
        this.invokeMasterChangedDetailsListeners();
    }

    static int getNextUID() {
        return ++iUID;
    }

    private int insertInternal(boolean bl) throws ModelException {
        int n = this.getSelectedRow();
        if (!bl && this.getRowCount() > 0) {
            ++n;
        }
        if (n < 0) {
            n = 0;
        }
        this.dpCurrentDataPage.insert(n);
        this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(n);
        this.setDetailsChangedInMasterBook();
        this.invokeMasterChangedDetailsListeners();
        return n;
    }

    private boolean deleteInternal() throws ModelException {
        boolean bl = this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
        if (!bl) {
            this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
        }
        this.setDetailsChangedInMasterBook();
        this.invokeRepaintListeners();
        return bl;
    }

    protected void setValuesInternal(String[] stringArray, Object[] objectArray) throws ModelException {
        if (stringArray.length != objectArray.length) {
            throw new ModelException("Number of columns and values are different!");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            super.setValueDRInternal(stringArray[i], objectArray[i]);
        }
    }

    private void setDetailsChangedInMasterBook() throws ModelException {
        if (this.rdMasterReference != null) {
            ReferenceDefinition referenceDefinition;
            Object object;
            if (this.isSelfJoined() && this.getTreePath().length() > 0) {
                boolean bl = this.dpCurrentDataPage.getChangedDataRows().length > 0;
                object = this.getTreePath();
                while (((TreePath)object).length() > 0) {
                    MemDataPage memDataPage = (MemDataPage)this.getDataPage(((TreePath)object).getParentPath());
                    memDataPage.setDetailChanged(((TreePath)object).getLast(), bl);
                    object = ((TreePath)object).getParentPath();
                    bl = memDataPage.getChangedDataRows().length > 0;
                }
            }
            ReferenceDefinition referenceDefinition2 = referenceDefinition = this.isSelfJoined() ? this.getRootReference() : this.getMasterReference();
            if (referenceDefinition != null) {
                object = referenceDefinition.getReferencedDataBook();
                object.notifyDetailChanged();
            }
        }
    }

    private void copyMasterColumnsToCurrentDetail(boolean bl) throws ModelException {
        if (this.rdMasterReference != null) {
            Object[] objectArray = this.getValues(this.rdMasterReference.getColumnNames());
            boolean bl2 = true;
            if (bl && objectArray != null) {
                int n = objectArray.length;
                for (int i = 0; bl2 && i < n; ++i) {
                    if (objectArray[i] == null) continue;
                    bl2 = false;
                }
            }
            if (!bl || bl & bl2) {
                Object[] objectArray2 = this.dpCurrentDataPage.getMasterDataRow().getValues(this.rdMasterReference.getReferencedColumnNames());
                this.setValuesInternal(this.rdMasterReference.getColumnNames(), objectArray2);
                if (this.isSelfJoined() && this.rdTreeRootReference != null) {
                    objectArray2 = this.rdTreeRootReference.getReferencedDataBook().getValues(this.rdTreeRootReference.getReferencedColumnNames());
                    this.setValuesInternal(this.rdTreeRootReference.getColumnNames(), objectArray2);
                }
            }
        }
    }

    private void saveDataRowLevel(IDataBook iDataBook) throws ModelException {
        ReferenceDefinition referenceDefinition;
        IDataBook iDataBook2 = this;
        ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
        while (iDataBook2.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW && referenceDefinition != null) {
            iDataBook2 = referenceDefinition.getReferencedDataBook();
            referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
        }
        ((MemDataBook)iDataBook2).saveDataRowLevelDetails(iDataBook);
    }

    private void saveDataRowLevelDetails(IDataBook iDataBook) throws ModelException {
        if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
            this.saveDetails(iDataBook);
        } else if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 == null) continue;
                ((MemDataBook)iDataBook2).saveDataRowLevelDetails(iDataBook);
            }
        }
    }

    private void saveDetails(IDataBook iDataBook) throws ModelException {
        if (this != iDataBook) {
            this.saveSelectedRowIntern();
        }
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 == null) continue;
                ((MemDataBook)iDataBook2).saveDetails(iDataBook);
            }
        }
    }

    private void restoreSaveAllDetails() throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                if (iDataBook.isDeleteCascade()) {
                    iDataBook.restoreAllRows();
                    ((MemDataBook)iDataBook).restoreSaveAllDetails();
                    continue;
                }
                if (iDataBook.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    iDataBook.saveAllRows();
                }
                ((MemDataBook)iDataBook).restoreSaveAllDetails();
            }
        }
    }

    private void handleStoreSelection(IDataBook.SelectionMode selectionMode) throws ModelException {
        if (this.dpCurrentDataPage != null) {
            if (selectionMode == IDataBook.SelectionMode.CURRENT_ROW) {
                if (this.getSelectedRow() < 0) {
                    if (this.dpCurrentDataPage.getRowCount() == 0) {
                        this.setStoredSelection(null);
                    } else {
                        this.setStoredSelection(this);
                    }
                } else {
                    String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
                    if (stringArray == null) {
                        stringArray = this.rdRowDefinition.getColumnNames();
                    }
                    if (stringArray != null && stringArray.length > 0) {
                        this.setStoredSelection(this.getDataRow(this.iSelectedRowIndex).createDataRow(stringArray));
                    }
                }
            } else {
                this.setStoredSelection(null);
            }
        }
    }

    private void restoreAllDetails() throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.restoreAllRows();
            }
        }
        if (this.isSelfJoined()) {
            if (this.treePath != null) {
                this.removeDataPage(null, this.treePath.getChildPath(this.getSelectedRow()));
            } else {
                this.removeDataPage(null, null);
            }
        }
    }

    private void restoreRow() throws ModelException {
        IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
        if (this.eventBeforeRestore != null) {
            this.eventBeforeRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RESTORE, iChangeableDataRow));
        }
        if (this.isInserting()) {
            this.restoreAllDetails();
            this.dpCurrentDataPage.restore(this.iSelectedRowIndex);
            this.setSelectedRowInternal(this.iSelectedRowIndex - 1);
            this.setDetailsChangedInMasterBook();
            if (this.eventAfterRestore != null) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iChangeableDataRow));
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        } else {
            this.dpCurrentDataPage.restore(this.iSelectedRowIndex);
            this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
            this.setDetailsChangedInMasterBook();
            if (this.eventAfterRestore != null) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iChangeableDataRow));
            }
        }
    }

    @Override
    protected void store() throws ModelException {
        if (!this.dpCurrentDataPage.store(this.iSelectedRowIndex)) {
            this.oaStorage = this.dpCurrentDataPage.getDataRowStorage(this.iSelectedRowIndex);
        }
        this.setDetailsChangedInMasterBook();
    }

    protected void clearFilterSortInMemDataPages() throws ModelException {
        if (this.eventBeforeReload != null) {
            this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
        }
        if (this.getMasterReference() != null) {
            Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().clear();
            }
        } else if (!this.isOutOfSync()) {
            this.dpCurrentDataPage.clear();
        }
        if (!this.isOutOfSync()) {
            this.correctSelectedRow();
        }
        if (this.eventAfterReload != null) {
            this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
        }
    }

    public void setReadOnlyWithoutSave(boolean bl) {
        this.bReadOnly = bl;
        this.invokeRepaintListeners();
    }
}

