/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [HM] - creation
 */
package javax.rad.ui;

/**
 * Platform and technology independent Cursor definition.
 * 
 * @author Martin Handsteiner
 * @see	java.awt.Cursor
 */
public interface ICursor extends IResource
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Constants
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** The default cursor type (gets set if no cursor is defined). */
    public static final int	DEFAULT_CURSOR   		= 0;

    /** The crosshair cursor type. */
    public static final int	CROSSHAIR_CURSOR 		= 1;

    /** The text cursor type. */
    public static final int	TEXT_CURSOR 	 		= 2;

    /** The wait cursor type. */
    public static final int	WAIT_CURSOR	 			= 3;

    /** The south-west-resize cursor type. */
    public static final int	SW_RESIZE_CURSOR	 	= 4;

    /** The south-east-resize cursor type. */
    public static final int	SE_RESIZE_CURSOR	 	= 5;

    /** The north-west-resize cursor type. */
    public static final int	NW_RESIZE_CURSOR		= 6;

    /** The north-east-resize cursor type. */
    public static final int	NE_RESIZE_CURSOR	 	= 7;

    /** The north-resize cursor type. */
    public static final int	N_RESIZE_CURSOR 		= 8;

    /** The south-resize cursor type. */
    public static final int	S_RESIZE_CURSOR 		= 9;

    /** The west-resize cursor type. */
    public static final int	W_RESIZE_CURSOR	 		= 10;

    /** The east-resize cursor type. */
    public static final int	E_RESIZE_CURSOR			= 11;

    /** The hand cursor type. */
    public static final int	HAND_CURSOR				= 12;

    /** The move cursor type. */
    public static final int	MOVE_CURSOR				= 13;

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Method definitions
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * Returns the type for this cursor.
     * 
     * @return the cursor type.
     */
    public int getType();

    /**
     * Returns the name of this cursor.
     * 
     * @return a localized description of this cursor.
     */
    public String getName();

}	// ICursor
