/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 22.04.2008 - [HM] - creation
 */
package javax.rad.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * The <code>IFileHandle</code> is a storage independent file handle.
 * 
 * @author Martin Handsteiner
 */
public interface IFileHandle
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Gets the file name of this file handle.
	 * 
	 * @return the file name of this file handle.
	 */
	public String getFileName();
	
	/**
	 * Gets the InputStream of this file handle.
	 * 
	 * @return the InputStream of this file handle.
	 * @throws IOException if an exception occurs.
	 */
	public InputStream getInputStream() throws IOException;
	
	/**
	 * Gets the length of the InputStream in bytes.
	 * -1 is returned if getInputStream is null.
	 * 
	 * @return the length of the InputStream in bytes.
	 * @throws IOException if an exception occurs.
	 */
	public long getLength() throws IOException;
	
}	// IFileHandle
