/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [HM] - creation
 */
package com.sibvisions.rad.ui.swing.impl.menu;

import javax.rad.ui.IComponent;
import javax.rad.ui.menu.IPopupMenu;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

import com.sibvisions.rad.ui.swing.impl.SwingComponent;

/**
 * The <code>SwingPopupMenu</code> is the <code>IPopupMenu</code>
 * implementation for swing.
 * 
 * @author Martin Handsteiner
 * @see	javax.swing.JPopupMenu
 * @see javax.rad.ui.menu.IPopupMenu
 */
public class SwingPopupMenu extends SwingComponent<JPopupMenu> 
                            implements IPopupMenu
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Initialization
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>SwingPopupMenu</code>.
	 */
	public SwingPopupMenu()
	{
		super(new JPopupMenu());
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	public void addSeparator()
	{
		addSeparator(-1);
	}

	/**
	 * {@inheritDoc}
	 */
    public void addSeparator(int pIndex)
    {
		add(new SwingSeparator(), null, pIndex);
    }

	/**
	 * {@inheritDoc}
	 */
	public void show(IComponent pOrigin, int pX, int pY)
	{
		resource.show((JComponent)pOrigin.getResource(), pX, pY);
	}
	
}	// SwingPopupMenu
